/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.support.service.BaseService;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.manager.system.HealthCheckResultMixin;
import org.openremote.model.Container;
import org.openremote.model.system.HealthStatusProvider;
import org.openremote.model.util.ValueUtil;

public class CamelHealthStatusProvider
implements HealthStatusProvider {
    public static final String NAME = "camel";
    protected MessageBrokerService brokerService;

    public void init(Container container) throws Exception {
        this.brokerService = (MessageBrokerService)container.getService(MessageBrokerService.class);
    }

    public void start(Container container) throws Exception {
        ValueUtil.JSON.addMixIn(HealthCheck.Result.class, HealthCheckResultMixin.class);
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public Object getHealthStatus() {
        HashMap<String, Collection> result = new HashMap<String, Collection>();
        ArrayList endpointInfos = new ArrayList();
        for (Endpoint endpoint : this.brokerService.getContext().getEndpoints()) {
            HashMap<String, Object> endpointInfo = new HashMap<String, Object>();
            endpointInfo.put("uri", endpoint.getEndpointUri());
            if (endpoint instanceof BaseService) {
                BaseService baseService = (BaseService)endpoint;
                endpointInfo.put("status", baseService.getStatus().name());
            }
            if (endpoint instanceof SedaEndpoint) {
                SedaEndpoint sedaEndpoint = (SedaEndpoint)endpoint;
                endpointInfo.put("queueSize", sedaEndpoint.getCurrentQueueSize());
                endpointInfo.put("queueMax", sedaEndpoint.getSize());
            }
            endpointInfos.add(endpointInfo);
        }
        result.put("healthChecks", HealthCheckHelper.invoke((CamelContext)this.brokerService.getContext()));
        result.put("endpoints", endpointInfos);
        return result;
    }
}

