/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.syslog;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.openremote.container.web.WebResource;
import org.openremote.manager.syslog.SyslogService;
import org.openremote.model.http.RequestParams;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.syslog.SyslogConfig;
import org.openremote.model.syslog.SyslogEvent;
import org.openremote.model.syslog.SyslogLevel;
import org.openremote.model.syslog.SyslogResource;
import org.openremote.model.util.Pair;

public class SyslogResourceImpl
extends WebResource
implements SyslogResource {
    protected final SyslogService syslogService;

    public SyslogResourceImpl(SyslogService syslogService) {
        this.syslogService = syslogService;
    }

    public Response getEvents(@BeanParam RequestParams requestParams, SyslogLevel level, Integer perPage, Integer page, Long from, Long to, List<SyslogCategory> categories, List<String> subCategories) {
        perPage = perPage != null ? perPage : 50;
        page = page != null ? page : 1;
        Pair<Long, List<SyslogEvent>> result = this.syslogService.getEvents(level, perPage, page, from != null ? Instant.ofEpochMilli(from) : null, to != null ? Instant.ofEpochMilli(to) : null, categories, subCategories);
        if (result == null) {
            return Response.ok(Collections.emptyList()).build();
        }
        long lastPage = (Long)result.key / (long)perPage.intValue() + 1L;
        Response.ResponseBuilder rb = Response.ok((Object)((List)result.value).toArray(new SyslogEvent[0]));
        UriBuilder requestUriBuilder = requestParams.getExternalBaseUriBuilder();
        if ((long)page.intValue() != lastPage) {
            rb.link(requestUriBuilder.replaceQueryParam("page", new Object[]{page + 1}).build(new Object[0]), "next");
        }
        rb.link(requestUriBuilder.replaceQueryParam("page", new Object[]{lastPage}).build(new Object[0]), "last");
        return rb.build();
    }

    public void clearEvents(@BeanParam RequestParams requestParams) {
        this.syslogService.clearStoredEvents();
    }

    public SyslogConfig getConfig(@BeanParam RequestParams requestParams) {
        return this.syslogService.getConfig();
    }

    public void updateConfig(@BeanParam RequestParams requestParams, SyslogConfig config) {
        this.syslogService.setConfig(config);
    }
}

