/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.simulator;

import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.simulator.SimulatorAgent;
import org.openremote.agent.protocol.simulator.SimulatorProtocol;
import org.openremote.manager.agent.AgentService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.asset.agent.Protocol;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.simulator.RequestSimulatorState;
import org.openremote.model.simulator.SimulatorAttributeInfo;
import org.openremote.model.simulator.SimulatorState;

public class SimulatorService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(SimulatorService.class.getName());
    protected AgentService agentService;
    protected ManagerIdentityService managerIdentityService;
    protected AssetStorageService assetStorageService;
    protected ClientEventService clientEventService;

    public int getPriority() {
        return 1000;
    }

    public void init(Container container) throws Exception {
        this.agentService = (AgentService)container.getService(AgentService.class);
        this.managerIdentityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.clientEventService.addSubscriptionAuthorizer((realm, auth, subscription) -> {
            if (!subscription.isEventType(SimulatorState.class)) {
                return false;
            }
            if (auth == null) {
                return false;
            }
            return auth.isSuperUser();
        });
        this.clientEventService.addEventAuthorizer((realm, auth, event) -> {
            if (event instanceof RequestSimulatorState) {
                return auth.isSuperUser();
            }
            return false;
        });
        this.clientEventService.addSubscription(RequestSimulatorState.class, this::onRequestSimulatorState);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    protected void onRequestSimulatorState(RequestSimulatorState event) {
        LOG.finest("Handling from client: " + String.valueOf(event));
        if (event.getResponseConsumer() == null) {
            LOG.warning("Requested simulator state but no response consumer provided");
            return;
        }
        String agentId = event.getAgentId();
        LOG.finest("Attempting to publish simulator state: Agent ID=" + agentId);
        Protocol<?> protocol = this.agentService.getProtocolInstance(agentId);
        if (!(protocol instanceof SimulatorProtocol)) {
            LOG.warning("Failed to publish simulator state, agent is not a simulator agent: Agent ID=" + agentId);
            return;
        }
        SimulatorProtocol simulatorProtocol = (SimulatorProtocol)protocol;
        SimulatorState simulatorState = this.getSimulatorState(simulatorProtocol);
        simulatorState.setMessageID(event.getMessageID());
        event.getResponseConsumer().accept(simulatorState);
    }

    protected SimulatorState getSimulatorState(SimulatorProtocol protocolInstance) {
        LOG.info("Getting simulator info for protocol instance: " + String.valueOf(protocolInstance));
        List<String> linkedAssetIds = protocolInstance.getLinkedAttributes().keySet().stream().map(AttributeRef::getId).distinct().toList();
        List<String> assetNames = this.assetStorageService.findNames(linkedAssetIds.toArray(new String[0]));
        if (assetNames.size() != linkedAssetIds.size()) {
            LOG.warning("Retrieved asset names don't match requested asset IDs");
            return null;
        }
        SimulatorAttributeInfo[] attributeInfos = (SimulatorAttributeInfo[])protocolInstance.getLinkedAttributes().entrySet().stream().map(refAttributeEntry -> {
            String assetName = (String)assetNames.get(linkedAssetIds.indexOf(((AttributeRef)refAttributeEntry.getKey()).getId()));
            return new SimulatorAttributeInfo(assetName, ((AttributeRef)refAttributeEntry.getKey()).getId(), (Attribute)refAttributeEntry.getValue(), protocolInstance.getReplayMap().containsKey(refAttributeEntry.getKey()));
        }).toArray(SimulatorAttributeInfo[]::new);
        return new SimulatorState(((SimulatorAgent)protocolInstance.getAgent()).getId(), attributeInfos);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

