/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.setup.KeycloakCleanSetup;
import org.openremote.manager.setup.KeycloakInitSetup;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.setup.Setup;
import org.openremote.model.setup.SetupTasks;

public class SetupService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(SetupService.class.getName());
    protected final List<Setup> tasks = new ArrayList<Setup>();

    public int getPriority() {
        return -2147483528;
    }

    public void init(Container container) throws Exception {
        boolean isClean = ((PersistenceService)container.getService(PersistenceService.class)).isCleanInstall();
        if (!isClean) {
            LOG.info("Setup service disabled, clean install = false");
            return;
        }
        boolean keycloakEnabled = ((ManagerIdentityService)container.getService(ManagerIdentityService.class)).isKeycloakEnabled();
        String setupType = (String)container.getConfig().get("OR_SETUP_TYPE");
        LOG.info("OR_SETUP_TYPE value: " + setupType);
        if (keycloakEnabled) {
            this.tasks.add(new KeycloakCleanSetup(container));
            this.tasks.add(new KeycloakInitSetup(container));
        }
        this.tasks.addAll(ServiceLoader.load(SetupTasks.class).stream().map(ServiceLoader.Provider::get).flatMap(discoveredSetupTasks -> {
            LOG.info("Found custom SetupTasks provider on classpath: " + discoveredSetupTasks.getClass().getName());
            List tasks = discoveredSetupTasks.createTasks(container, setupType, keycloakEnabled);
            return tasks != null ? tasks.stream() : null;
        }).toList());
        try {
            if (!this.tasks.isEmpty()) {
                LOG.info("--- EXECUTING INIT TASKS ---");
                for (Setup setup : this.tasks) {
                    LOG.info("Executing setup task '" + setup.getClass().getName() + "'");
                    setup.onInit();
                }
                LOG.info("--- INIT TASKS COMPLETED SUCCESSFULLY ---");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting up application", ex);
        }
    }

    public void start(Container container) {
        try {
            if (!this.tasks.isEmpty()) {
                LOG.info("--- EXECUTING START TASKS ---");
                for (Setup setup : this.tasks) {
                    LOG.info("Executing setup task '" + setup.getClass().getName() + "'");
                    setup.onStart();
                }
                LOG.info("--- START TASKS COMPLETED SUCCESSFULLY ---");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting up application", ex);
        }
    }

    public void stop(Container container) {
        this.tasks.clear();
    }

    public <S extends Setup> S getTaskOfType(Class<S> setupType) {
        for (Setup task : this.tasks) {
            if (!setupType.isAssignableFrom(task.getClass())) continue;
            return (S)task;
        }
        throw new IllegalStateException("No setup task found of type: " + String.valueOf(setupType));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

