/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import jakarta.persistence.Persistence;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.openremote.container.persistence.Database;
import org.openremote.manager.persistence.ManagerPersistenceService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;

public class SchemaExporter {
    private static final Logger LOG = Logger.getLogger(SchemaExporter.class.getName());

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("Missing target file path argument");
        }
        final File schemaFile = new File(args[0]);
        org.openremote.container.Container container = new org.openremote.container.Container(new ContainerService[]{new ManagerPersistenceService(){

            protected void openDatabase(Container container, Database database, String username, String password, String connectionUrl) {
            }

            public void start(Container container) throws Exception {
                Properties createSchemaProperties = new Properties(this.persistenceUnitProperties);
                createSchemaProperties.put("javax.persistence.schema-generation.scripts.action", "create");
                createSchemaProperties.put("javax.persistence.schema-generation.scripts.create-target", schemaFile.getAbsolutePath());
                if (schemaFile.exists()) {
                    LOG.info("Deleting existing schema file: " + schemaFile.getAbsolutePath());
                    schemaFile.delete();
                }
                LOG.info("Exporting database schema for persistence unit: " + this.persistenceUnitName);
                Persistence.generateSchema((String)this.persistenceUnitName, (Map)createSchemaProperties);
                LOG.fine("Schema export complete: " + schemaFile.getAbsolutePath());
            }
        }});
        container.start();
    }
}

