/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetDatapointService;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.persistence.ManagerPersistenceService;
import org.openremote.manager.rules.RulesetStorageService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.setup.SetupService;
import org.openremote.model.Constants;
import org.openremote.model.Container;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.impl.BuildingAsset;
import org.openremote.model.asset.impl.ElectricityBatteryAsset;
import org.openremote.model.asset.impl.ElectricityChargerAsset;
import org.openremote.model.asset.impl.ElectricityConsumerAsset;
import org.openremote.model.asset.impl.ElectricityProducerSolarAsset;
import org.openremote.model.asset.impl.ElectricityStorageAsset;
import org.openremote.model.asset.impl.EnvironmentSensorAsset;
import org.openremote.model.asset.impl.GroundwaterSensorAsset;
import org.openremote.model.asset.impl.LightAsset;
import org.openremote.model.asset.impl.MicrophoneAsset;
import org.openremote.model.asset.impl.ParkingAsset;
import org.openremote.model.asset.impl.PeopleCounterAsset;
import org.openremote.model.asset.impl.RoomAsset;
import org.openremote.model.asset.impl.ShipAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.geo.GeoJSONPoint;
import org.openremote.model.setup.Setup;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AbstractNameValueHolder;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.ValueFormat;
import org.openremote.model.value.ValueType;

public class ManagerSetup
implements Setup {
    public static final String OR_PROVISIONING_DOCROOT = "OR_PROVISIONING_DOCROOT";
    public static final String OR_PROVISIONING_DOCROOT_DEFAULT = "deployment/manager/provisioning";
    protected static final System.Logger LOG = System.getLogger(ManagerSetup.class.getName());
    protected Path provisionDocRoot;
    protected final TimerService timerService;
    protected final ManagerPersistenceService persistenceService;
    protected final ManagerIdentityService identityService;
    protected final AssetStorageService assetStorageService;
    protected final AssetProcessingService assetProcessingService;
    protected final AssetDatapointService assetDatapointService;
    protected final AssetPredictedDatapointService assetPredictedDatapointService;
    protected final RulesetStorageService rulesetStorageService;
    protected final SetupService setupService;
    protected final MetaItem<?>[] EMPTY_META = new MetaItem[0];

    public ManagerSetup(Container container) {
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.persistenceService = (ManagerPersistenceService)container.getService(ManagerPersistenceService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.assetDatapointService = (AssetDatapointService)container.getService(AssetDatapointService.class);
        this.assetPredictedDatapointService = (AssetPredictedDatapointService)container.getService(AssetPredictedDatapointService.class);
        this.rulesetStorageService = (RulesetStorageService)container.getService(RulesetStorageService.class);
        this.setupService = (SetupService)container.getService(SetupService.class);
        this.provisionDocRoot = Paths.get(MapAccess.getString((Map)container.getConfig(), (String)OR_PROVISIONING_DOCROOT, (String)OR_PROVISIONING_DOCROOT_DEFAULT), new String[0]);
    }

    public void onStart() throws Exception {
        if (!Files.exists(Paths.get(this.provisionDocRoot.toString(), new String[0]), new LinkOption[0])) {
            return;
        }
        this.provisionAssets();
    }

    public void onInit() throws Exception {
    }

    protected BuildingAsset createDemoApartment(Asset<?> parent, String name, GeoJSONPoint location) {
        BuildingAsset apartment = new BuildingAsset(name);
        apartment.setParent(parent);
        apartment.addOrReplaceAttributes(new Attribute[]{new Attribute("alarmEnabled", ValueType.BOOLEAN).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Alarm enabled"), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("presenceDetected", ValueType.BOOLEAN).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Presence detected"), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.STORE_DATA_POINTS, (Object)true)}), new Attribute("vacationUntil", ValueType.TIMESTAMP).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Vacation until"), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("lastExecutedScene", ValueType.TEXT).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Last executed scene"), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute(Asset.LOCATION, (Object)location).addMeta(new MetaItem[]{new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true)})});
        return apartment;
    }

    protected RoomAsset createDemoApartmentRoom(Asset<?> apartment, String name) {
        RoomAsset room = new RoomAsset(name);
        room.setParent(apartment);
        return room;
    }

    protected void addDemoApartmentRoomMotionSensor(RoomAsset room, boolean shouldBeLinked, Supplier<AgentLink<?>> agentLinker) {
        room.getAttributes().addOrReplace((AbstractNameValueHolder[])new Attribute[]{new Attribute("motionSensor", ValueType.INTEGER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Motion sensor"), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.STORE_DATA_POINTS), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE)}), new Attribute("presenceDetected", ValueType.BOOLEAN).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Presence detected"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.STORE_DATA_POINTS, (Object)true)}), new Attribute("firstPresenceDetected", ValueType.TIMESTAMP).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"First time movement was detected"), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("lastPresenceDetected", ValueType.TIMESTAMP).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Last time movement was detected"), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)})});
        if (shouldBeLinked) {
            room.getAttribute("motionSensor").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
            room.getAttribute("presenceDetected").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
        }
    }

    protected void addDemoApartmentRoomCO2Sensor(RoomAsset room, boolean shouldBeLinked, Supplier<AgentLink<?>> agentLinker) {
        room.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute("co2Level", ValueType.POSITIVE_INTEGER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.UNITS, (Object)Constants.units((String[])new String[]{"ppm"})), new MetaItem(MetaItemType.LABEL, (Object)"CO2 level"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.STORE_DATA_POINTS)}));
        if (shouldBeLinked) {
            room.getAttribute("co2Level").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
        }
    }

    protected void addDemoApartmentRoomHumiditySensor(RoomAsset room, boolean shouldBeLinked, Supplier<AgentLink<?>> agentLinker) {
        room.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute("humidity", ValueType.POSITIVE_INTEGER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Humidity"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.UNITS, (Object)Constants.units((String[])new String[]{"percentage"})), new MetaItem(MetaItemType.STORE_DATA_POINTS)}));
        if (shouldBeLinked) {
            room.getAttribute("humidity").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
        }
    }

    protected void addDemoApartmentRoomThermometer(RoomAsset room, boolean shouldBeLinked, Supplier<AgentLink<?>> agentLinker) {
        room.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute("currentTemperature", ValueType.NUMBER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Current temperature"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.UNITS, (Object)Constants.units((String[])new String[]{"celsius"})), new MetaItem(MetaItemType.FORMAT, (Object)ValueFormat.NUMBER_1_DP()), new MetaItem(MetaItemType.STORE_DATA_POINTS)}));
        if (shouldBeLinked) {
            room.getAttribute("currentTemperature").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
        }
    }

    protected void addDemoApartmentTemperatureControl(RoomAsset room, boolean shouldBeLinked, Supplier<AgentLink<?>> agentLinker) {
        room.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute("targetTemperature", ValueType.NUMBER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Target temperature"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true), new MetaItem(MetaItemType.UNITS, (Object)Constants.units((String[])new String[]{"celsius"})), new MetaItem(MetaItemType.FORMAT, (Object)ValueFormat.NUMBER_1_DP()), new MetaItem(MetaItemType.STORE_DATA_POINTS)}));
        if (shouldBeLinked) {
            room.getAttribute("targetTemperature").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
        }
    }

    protected void addDemoApartmentSmartSwitch(RoomAsset room, String switchName, boolean shouldBeLinked, Function<Integer, MetaItem[]> agentLinker) {
        room.getAttributes().addOrReplace((AbstractNameValueHolder[])new Attribute[]{new Attribute("smartSwitchMode" + switchName, ValueType.TEXT).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)("Smart Switch mode " + switchName)), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("smartSwitchBeginEnd" + switchName, ValueType.TIMESTAMP).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)("Smart Switch begin/end cycle " + switchName)), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("smartSwitchStartTime" + switchName, ValueType.TIMESTAMP).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)("Smart Switch actuator earliest start time " + switchName)), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.UNITS, (Object)Constants.units((String[])new String[]{"second"})), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("smartSwitchStopTime" + switchName, ValueType.TIMESTAMP).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)("Smart Switch actuator latest stop time " + switchName)), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.UNITS, (Object)Constants.units((String[])new String[]{"second"})), new MetaItem(MetaItemType.RULE_STATE, (Object)true)}), new Attribute("smartSwitchEnabled" + switchName, ValueType.NUMBER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)("Smart Switch actuator enabled " + switchName)), new MetaItem(MetaItemType.READ_ONLY, (Object)true), new MetaItem(MetaItemType.RULE_STATE, (Object)true)})});
        if (shouldBeLinked) {
            room.getAttribute("smartSwitchBeginEnd").ifPresent(attr -> attr.addMeta((MetaItem[])agentLinker.apply(0)));
            room.getAttribute("smartSwitchBeginEnd").ifPresent(attr -> attr.addMeta((MetaItem[])agentLinker.apply(1)));
            room.getAttribute("smartSwitchStartTime").ifPresent(attr -> attr.addMeta((MetaItem[])agentLinker.apply(2)));
            room.getAttribute("smartSwitchStopTime").ifPresent(attr -> attr.addMeta((MetaItem[])agentLinker.apply(3)));
            room.getAttribute("smartSwitchEnabled").ifPresent(attr -> attr.addMeta((MetaItem[])agentLinker.apply(4)));
        }
    }

    protected void addDemoApartmentVentilation(BuildingAsset apartment, boolean shouldBeLinked, Supplier<AgentLink<?>> agentLinker) {
        apartment.getAttributes().addOrReplace((AbstractNameValueHolder[])new Attribute[]{new Attribute("ventilationLevel", ValueType.POSITIVE_INTEGER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Ventilation level"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true), new MetaItem(MetaItemType.STORE_DATA_POINTS)}), new Attribute("ventilationAuto", ValueType.BOOLEAN).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Ventilation auto"), new MetaItem(MetaItemType.RULE_STATE, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true), new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true)})});
        if (shouldBeLinked) {
            apartment.getAttribute("ventilationLevel").ifPresent(attr -> attr.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))}));
        }
    }

    protected PeopleCounterAsset createDemoPeopleCounterAsset(String name, Asset<?> area, GeoJSONPoint location, Supplier<AgentLink<?>> agentLinker) {
        PeopleCounterAsset peopleCounterAsset = new PeopleCounterAsset(name);
        peopleCounterAsset.setParent(area);
        peopleCounterAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        peopleCounterAsset.getAttribute("peopleCountIn").ifPresent(assetAttribute -> {
            assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
            if (agentLinker != null) {
                assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))});
            }
        });
        peopleCounterAsset.getAttribute("peopleCountOut").ifPresent(assetAttribute -> {
            assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
            if (agentLinker != null) {
                assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))});
            }
        });
        peopleCounterAsset.getAttribute("peopleCountInMinute").ifPresent(assetAttribute -> {
            assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
            if (agentLinker != null) {
                assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))});
            }
        });
        peopleCounterAsset.getAttribute("peopleCountOutMinute").ifPresent(assetAttribute -> {
            assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
            if (agentLinker != null) {
                assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))});
            }
        });
        peopleCounterAsset.getAttribute("peopleCountTotal").ifPresent(assetAttribute -> {
            assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
            if (agentLinker != null) {
                assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))});
            }
        });
        return peopleCounterAsset;
    }

    protected MicrophoneAsset createDemoMicrophoneAsset(String name, Asset<?> area, GeoJSONPoint location, Supplier<AgentLink<?>> agentLinker) {
        MicrophoneAsset microphoneAsset = new MicrophoneAsset(name);
        microphoneAsset.setParent(area);
        microphoneAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        microphoneAsset.getAttribute(MicrophoneAsset.SOUND_LEVEL).ifPresent(assetAttribute -> {
            assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.READ_ONLY), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
            if (agentLinker != null) {
                assetAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)((AgentLink)agentLinker.get()))});
            }
        });
        return microphoneAsset;
    }

    protected EnvironmentSensorAsset createDemoEnvironmentAsset(String name, Asset<?> area, GeoJSONPoint location, Supplier<AgentLink<?>> agentLinker) {
        EnvironmentSensorAsset environmentAsset = new EnvironmentSensorAsset(name);
        environmentAsset.setParent(area);
        environmentAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        environmentAsset.getAttributes().getOrCreate(EnvironmentSensorAsset.TEMPERATURE).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, agentLinker.get())});
        environmentAsset.getAttributes().getOrCreate(EnvironmentSensorAsset.NO2).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, agentLinker.get())});
        environmentAsset.getAttributes().getOrCreate(EnvironmentSensorAsset.RELATIVE_HUMIDITY).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, agentLinker.get())});
        environmentAsset.getAttributes().getOrCreate(EnvironmentSensorAsset.PM1).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, agentLinker.get())});
        environmentAsset.getAttributes().getOrCreate(EnvironmentSensorAsset.PM2_5).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, agentLinker.get())});
        environmentAsset.getAttributes().getOrCreate(EnvironmentSensorAsset.PM10).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, agentLinker.get())});
        return environmentAsset;
    }

    protected LightAsset createDemoLightAsset(String name, Asset<?> area, GeoJSONPoint location) {
        LightAsset lightAsset = new LightAsset(name);
        lightAsset.setParent(area);
        lightAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        lightAsset.getAttributes().getOrCreate(LightAsset.ON_OFF).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate(LightAsset.BRIGHTNESS).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate(LightAsset.COLOUR_RGB).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate("groupNumber", ValueType.POSITIVE_INTEGER).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate("scenario", ValueType.TEXT).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE)});
        return lightAsset;
    }

    protected LightAsset createDemoLightControllerAsset(String name, Asset<?> area, GeoJSONPoint location) {
        LightAsset lightAsset = new LightAsset(name);
        lightAsset.setParent(area);
        lightAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        lightAsset.getAttributes().getOrCreate(LightAsset.ON_OFF).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate(LightAsset.BRIGHTNESS).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate(LightAsset.COLOUR_RGB).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE), new MetaItem(MetaItemType.STORE_DATA_POINTS)});
        lightAsset.getAttributes().getOrCreate("scenario", ValueType.TEXT).addMeta(new MetaItem[]{new MetaItem(MetaItemType.RULE_STATE)});
        return lightAsset;
    }

    protected ElectricityStorageAsset createDemoElectricityStorageAsset(String name, Asset<?> area, GeoJSONPoint location) {
        ElectricityBatteryAsset electricityStorageAsset = new ElectricityBatteryAsset(name);
        electricityStorageAsset.setParent(area);
        electricityStorageAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return electricityStorageAsset;
    }

    protected ElectricityProducerSolarAsset createDemoElectricitySolarProducerAsset(String name, Asset<?> area, GeoJSONPoint location) {
        ElectricityProducerSolarAsset electricityProducerAsset = new ElectricityProducerSolarAsset(name);
        electricityProducerAsset.setParent(area);
        electricityProducerAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return electricityProducerAsset;
    }

    protected ElectricityConsumerAsset createDemoElectricityConsumerAsset(String name, Asset<?> area, GeoJSONPoint location) {
        ElectricityConsumerAsset electricityConsumerAsset = new ElectricityConsumerAsset(name);
        electricityConsumerAsset.setParent(area);
        electricityConsumerAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return electricityConsumerAsset;
    }

    protected ElectricityChargerAsset createDemoElectricityChargerAsset(String name, Asset<?> area, GeoJSONPoint location) {
        ElectricityChargerAsset electricityChargerAsset = new ElectricityChargerAsset(name);
        electricityChargerAsset.setParent(area);
        electricityChargerAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return electricityChargerAsset;
    }

    protected GroundwaterSensorAsset createDemoGroundwaterAsset(String name, Asset<?> area, GeoJSONPoint location) {
        GroundwaterSensorAsset groundwaterAsset = new GroundwaterSensorAsset(name);
        groundwaterAsset.setParent(area);
        groundwaterAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return groundwaterAsset;
    }

    protected ParkingAsset createDemoParkingAsset(String name, Asset<?> area, GeoJSONPoint location) {
        ParkingAsset parkingAsset = new ParkingAsset(name);
        parkingAsset.setParent(area);
        parkingAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return parkingAsset;
    }

    protected ShipAsset createDemoShipAsset(String name, Asset<?> area, GeoJSONPoint location) {
        ShipAsset shipAsset = new ShipAsset(name);
        shipAsset.setParent(area);
        shipAsset.getAttributes().addOrReplace((AbstractNameValueHolder)new Attribute(Asset.LOCATION, (Object)location));
        return shipAsset;
    }

    protected void provisionAssets() throws IOException {
        if (!Files.exists(Paths.get(this.provisionDocRoot.toString(), "assets"), new LinkOption[0])) {
            return;
        }
        LOG.log(System.Logger.Level.INFO, "Provisioning assets");
        Files.list(Paths.get(this.provisionDocRoot.toString(), "assets")).sorted().forEach(file -> {
            try {
                Asset asset = (Asset)ValueUtil.JSON.readValue(file.toFile(), Asset.class);
                asset = this.assetStorageService.merge(asset);
                LOG.log(System.Logger.Level.INFO, "Asset merged: " + String.valueOf(asset));
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.INFO, "Processing of file " + String.valueOf(file.getFileName()) + " went wrong", (Throwable)e);
            }
        });
    }
}

