/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import java.util.logging.Logger;
import org.openremote.manager.setup.AbstractKeycloakSetup;
import org.openremote.model.Container;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Realm;
import org.openremote.model.security.User;

public class KeycloakInitSetup
extends AbstractKeycloakSetup {
    private static final Logger LOG = Logger.getLogger(KeycloakInitSetup.class.getName());

    public KeycloakInitSetup(Container container) {
        super(container);
    }

    public void onStart() throws Exception {
        super.onStart();
        Realm masterRealm = this.keycloakProvider.getRealm("master");
        masterRealm.setDisplayName("Master");
        masterRealm.setRealmRoles(null);
        this.keycloakProvider.updateRealm(masterRealm);
        this.keycloakProvider.createUpdateClient(masterRealm.getName(), this.keycloakProvider.generateOpenRemoteClientRepresentation());
        User adminUser = this.keycloakProvider.getUserByUsername("master", "admin");
        adminUser.setFirstName("System");
        adminUser.setLastName("Administrator");
        this.keycloakProvider.createUpdateUser("master", adminUser, null, true);
        this.keycloakProvider.updateUserClientRoles("master", adminUser.getId(), "openremote", ClientRole.READ.getValue(), ClientRole.WRITE.getValue());
    }
}

