/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.openremote.container.security.keycloak.KeycloakResource;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebClient;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.util.TextUtil;

public class KeycloakInitService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(KeycloakInitService.class.getName());
    private static final int PRIORITY = -2147483558;

    public void init(Container container) throws Exception {
        String identityProviderType = MapAccess.getString((Map)container.getConfig(), (String)"OR_IDENTITY_PROVIDER", (String)"keycloak");
        if (!identityProviderType.equalsIgnoreCase("keycloak")) {
            return;
        }
        KeycloakInitService.waitForKeycloak(container);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public int getPriority() {
        return -2147483558;
    }

    public static void waitForKeycloak(Container container) {
        UriBuilder keycloakServiceUri = UriBuilder.fromPath((String)"/").scheme("http").host(MapAccess.getString((Map)container.getConfig(), (String)"OR_KEYCLOAK_HOST", (String)"127.0.0.1")).port(MapAccess.getInteger((Map)container.getConfig(), (String)"OR_KEYCLOAK_PORT", (int)8081));
        String keycloakPath = MapAccess.getString((Map)container.getConfig(), (String)"OR_KEYCLOAK_PATH", (String)"auth");
        if (!TextUtil.isNullOrEmpty((String)keycloakPath)) {
            keycloakServiceUri.path(keycloakPath);
        }
        ResteasyClientBuilderImpl clientBuilder = new ResteasyClientBuilderImpl().connectTimeout((long)MapAccess.getInteger((Map)container.getConfig(), (String)"KEYCLOAK_CONNECT_TIMEOUT", (int)2000), TimeUnit.MILLISECONDS).readTimeout((long)MapAccess.getInteger((Map)container.getConfig(), (String)"KEYCLOAK_REQUEST_TIMEOUT", (int)10000), TimeUnit.MILLISECONDS).connectionPoolSize(MapAccess.getInteger((Map)container.getConfig(), (String)"KEYCLOAK_CLIENT_POOL_SIZE", (int)20));
        ResteasyClient httpClient = WebClient.registerDefaults((ResteasyClientBuilderImpl)clientBuilder).build();
        boolean keycloakAvailable = false;
        WebTargetBuilder targetBuilder = new WebTargetBuilder(httpClient, keycloakServiceUri.build(new Object[0]));
        ResteasyWebTarget target = targetBuilder.build();
        KeycloakResource keycloakResource = (KeycloakResource)target.proxy(KeycloakResource.class);
        while (!keycloakAvailable) {
            LOG.info("Connecting to Keycloak server: " + String.valueOf(keycloakServiceUri.build(new Object[0])));
            try {
                KeycloakInitService.pingKeycloak(keycloakResource);
                keycloakAvailable = true;
                LOG.info("Successfully connected to Keycloak server: " + String.valueOf(keycloakServiceUri.build(new Object[0])));
            }
            catch (Exception ex) {
                LOG.info("Keycloak server not available, waiting...");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected static void pingKeycloak(KeycloakResource resource) throws Exception {
        try (Response response = null;){
            response = resource.getWelcomePage();
            if (response != null && (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL || response.getStatusInfo().getFamily() == Response.Status.Family.REDIRECTION)) {
                return;
            }
            throw new Exception();
        }
    }
}

