/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import java.util.Arrays;
import java.util.logging.Logger;
import org.openremote.container.security.keycloak.KeycloakIdentityProvider;
import org.openremote.manager.setup.AbstractKeycloakSetup;
import org.openremote.model.Container;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.RealmPredicate;

public class KeycloakCleanSetup
extends AbstractKeycloakSetup {
    private static final Logger LOG = Logger.getLogger(KeycloakCleanSetup.class.getName());

    public KeycloakCleanSetup(Container container) {
        super(container);
    }

    public void onStart() throws Exception {
        super.onStart();
        this.doClean();
    }

    protected void doClean() throws Exception {
        LOG.info("Deleting all non-master realms");
        Arrays.stream(this.keycloakProvider.getRealms()).forEach(realm -> {
            if (!realm.getName().equals("master")) {
                this.keycloakProvider.deleteRealm(realm.getName());
            }
        });
        LOG.info("Deleting all non-master admin users");
        Arrays.stream(this.keycloakProvider.queryUsers(new UserQuery().realm(new RealmPredicate("master")).serviceUsers(Boolean.valueOf(false)))).forEach(user -> {
            if (!user.getUsername().equals("admin") && !user.getUsername().equals("manager-keycloak")) {
                LOG.info("Deleting user: " + String.valueOf(user));
                this.keycloakProvider.deleteUser("master", user.getId());
            }
        });
        LOG.info("Deleting all non default clients");
        Arrays.stream(this.keycloakProvider.getClients("master")).forEach(client -> {
            if (!KeycloakIdentityProvider.DEFAULT_CLIENTS.contains(client.getClientId())) {
                LOG.info("Deleting client: " + client.getClientId());
                this.keycloakProvider.deleteClient("master", client.getClientId());
            }
        });
    }
}

