/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.setup;

import java.util.Arrays;
import java.util.Collections;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.security.ManagerKeycloakIdentityProvider;
import org.openremote.manager.setup.SetupService;
import org.openremote.model.Container;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Realm;
import org.openremote.model.security.User;
import org.openremote.model.setup.Setup;

public abstract class AbstractKeycloakSetup
implements Setup {
    public static final ClientRole[] PUBLIC_USER_ROLES = new ClientRole[]{ClientRole.READ_ASSETS, ClientRole.READ_MAP, ClientRole.READ_INSIGHTS};
    public static final ClientRole[] REGULAR_USER_ROLES = new ClientRole[]{ClientRole.WRITE_USER, ClientRole.READ_MAP, ClientRole.READ_ASSETS, ClientRole.READ_USERS, ClientRole.READ_RULES, ClientRole.READ_INSIGHTS, ClientRole.READ_ALARMS, ClientRole.WRITE_ASSETS, ClientRole.WRITE_ATTRIBUTES, ClientRole.WRITE_RULES, ClientRole.WRITE_INSIGHTS, ClientRole.WRITE_ALARMS};
    protected final Container container;
    protected final ManagerIdentityService identityService;
    protected final ManagerKeycloakIdentityProvider keycloakProvider;
    protected final SetupService setupService;

    public AbstractKeycloakSetup(Container container) {
        this.container = container;
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.keycloakProvider = (ManagerKeycloakIdentityProvider)this.identityService.getIdentityProvider();
        this.setupService = (SetupService)container.getService(SetupService.class);
    }

    public ManagerKeycloakIdentityProvider getKeycloakProvider() {
        return this.keycloakProvider;
    }

    public Realm createRealm(String realmName, String displayName, boolean rememberMe) {
        Realm realm = new Realm();
        realm.setName(realmName);
        realm.setDisplayName(displayName);
        realm.setEnabled(Boolean.valueOf(true));
        realm.setDuplicateEmailsAllowed(Boolean.valueOf(true));
        realm.setRememberMe(Boolean.valueOf(rememberMe));
        realm = this.keycloakProvider.createRealm(realm);
        return realm;
    }

    public User createUser(String realm, String username, String password, String firstName, String lastName, String email, boolean enabled, ClientRole[] roles) {
        return this.createUser(realm, username, password, firstName, lastName, email, enabled, false, false, roles);
    }

    public User createUser(String realm, String username, String password, String firstName, String lastName, String email, boolean enabled, boolean emailNotificationsDisabled, boolean pushNotificationsDisabled, ClientRole[] roles) {
        User user = new User();
        user.setUsername(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        user.setEnabled(Boolean.valueOf(enabled));
        if (emailNotificationsDisabled) {
            user.setAttribute("emailNotificationsDisabled", "true");
        }
        if (pushNotificationsDisabled) {
            user.setAttribute("pushNotificationsDisabled", "true");
        }
        if ((user = this.keycloakProvider.createUpdateUser(realm, user, password, true)) == null) {
            return null;
        }
        if (roles != null && roles.length > 0) {
            this.keycloakProvider.updateUserClientRoles(realm, user.getId(), "openremote", (String[])Arrays.stream(roles).map(ClientRole::getValue).toArray(String[]::new));
        }
        return user;
    }

    public void removeManageAccount(String realm) {
        this.keycloakProvider.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            ClientRepresentation clientRepresentation = this.keycloakProvider.getClient(realm, "account");
            RoleResource roleResource = realmResource.roles().get("default-roles-" + realm);
            roleResource.getClientRoleComposites(clientRepresentation.getId()).stream().filter(role -> role.getName().equals("manage-account")).findFirst().ifPresent(manageAccountRole -> roleResource.deleteComposites(Collections.singletonList(manageAccountRole)));
            return null;
        });
    }
}

