/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Subject;
import org.openremote.container.security.AuthContext;
import org.openremote.container.security.keycloak.KeycloakIdentityProvider;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.mqtt.MQTTBrokerService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.http.RequestParams;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Credential;
import org.openremote.model.security.Role;
import org.openremote.model.security.User;
import org.openremote.model.security.UserResource;
import org.openremote.model.security.UserSession;
import org.openremote.model.util.TextUtil;

public class UserResourceImpl
extends ManagerWebResource
implements UserResource {
    protected MQTTBrokerService mqttBrokerService;

    public UserResourceImpl(TimerService timerService, ManagerIdentityService identityService, MQTTBrokerService mqttBrokerService) {
        super(timerService, identityService);
        this.mqttBrokerService = mqttBrokerService;
    }

    public User[] query(RequestParams requestParams, UserQuery query) {
        boolean isRestricted;
        AuthContext authContext = this.getAuthContext();
        boolean isAdmin = authContext.hasResourceRole(ClientRole.READ_ADMIN.getValue(), "openremote");
        boolean bl = isRestricted = !isAdmin && authContext.hasResourceRole(ClientRole.READ_USERS.getValue(), "openremote");
        if (!isAdmin && !isRestricted) {
            throw new ForbiddenException("Insufficient permissions to read users");
        }
        if (query == null) {
            query = new UserQuery();
        }
        if (isRestricted) {
            if (query.select == null) {
                query.select = new UserQuery.Select();
            }
            query.select.basic(true);
        }
        if (!authContext.isSuperUser()) {
            query.realm(new RealmPredicate(authContext.getAuthenticatedRealmName()));
            if (query.attributes == null) {
                query.attributes(new UserQuery.AttributeValuePredicate[]{new UserQuery.AttributeValuePredicate(true, new StringPredicate("systemAccount"), null)});
            } else {
                ArrayList<UserQuery.AttributeValuePredicate> attributeValuePredicates = new ArrayList<UserQuery.AttributeValuePredicate>(Arrays.asList(query.attributes));
                attributeValuePredicates.add(new UserQuery.AttributeValuePredicate(true, new StringPredicate("systemAccount"), null));
                query.attributes((UserQuery.AttributeValuePredicate[])attributeValuePredicates.toArray(UserQuery.AttributeValuePredicate[]::new));
            }
        }
        try {
            return this.identityService.getIdentityProvider().queryUsers(query);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public User get(RequestParams requestParams, String realm, String userId) {
        boolean hasAdminReadRole = this.hasResourceRole(ClientRole.READ_ADMIN.getValue(), "openremote");
        if (!hasAdminReadRole && !Objects.equals(this.getUserId(), userId)) {
            throw new ForbiddenException("Can only retrieve own user info unless you have role '" + String.valueOf(ClientRole.READ_ADMIN) + "'");
        }
        try {
            return this.identityService.getIdentityProvider().getUser(userId);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public User getCurrent(RequestParams requestParams) {
        if (!this.isAuthenticated()) {
            throw new ForbiddenException("Must be authenticated");
        }
        return this.get(requestParams, this.getRequestRealmName(), this.getUserId());
    }

    public User update(RequestParams requestParams, String realm, User user) {
        this.throwIfIllegalMasterAdminUserMutation(requestParams, realm, user);
        try {
            return this.identityService.getIdentityProvider().createUpdateUser(realm, user, null, true);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public User create(RequestParams requestParams, String realm, User user) {
        try {
            return this.identityService.getIdentityProvider().createUpdateUser(realm, user, null, false);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void delete(RequestParams requestParams, String realm, String userId) {
        this.throwIfIllegalMasterAdminUserDeletion(requestParams, realm, userId);
        try {
            this.identityService.getIdentityProvider().deleteUser(realm, userId);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void resetPassword(@BeanParam RequestParams requestParams, String realm, String userId, Credential credential) {
        try {
            this.identityService.getIdentityProvider().resetPassword(realm, userId, credential);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public String resetSecret(RequestParams requestParams, String realm, String userId) {
        try {
            return this.identityService.getIdentityProvider().resetSecret(realm, userId, null);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public String[] getCurrentUserClientRoles(RequestParams requestParams, String clientId) {
        if (!this.isAuthenticated()) {
            throw new ForbiddenException("Must be authenticated");
        }
        return this.getUserClientRoles(requestParams, this.getRequestRealmName(), this.getUserId(), clientId);
    }

    public String[] getCurrentUserRealmRoles(RequestParams requestParams) {
        if (!this.isAuthenticated()) {
            throw new ForbiddenException("Must be authenticated");
        }
        return this.getUserRealmRoles(requestParams, this.getRequestRealmName(), this.getUserId());
    }

    public String[] getUserClientRoles(@BeanParam RequestParams requestParams, String realm, String userId, String clientId) {
        boolean hasAdminReadRole = this.hasResourceRole(ClientRole.READ_ADMIN.getValue(), "openremote");
        if (!hasAdminReadRole && !Objects.equals(this.getUserId(), userId)) {
            throw new ForbiddenException("Can only retrieve own user roles unless you have role '" + String.valueOf(ClientRole.READ_ADMIN) + "'");
        }
        try {
            return this.identityService.getIdentityProvider().getUserClientRoles(realm, userId, clientId);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public String[] getUserRealmRoles(RequestParams requestParams, String realm, String userId) {
        boolean hasAdminReadRole = this.hasResourceRole(ClientRole.READ_ADMIN.getValue(), "openremote");
        if (!hasAdminReadRole && !Objects.equals(this.getUserId(), userId)) {
            throw new ForbiddenException("Can only retrieve own user roles unless you have role '" + String.valueOf(ClientRole.READ_ADMIN) + "'");
        }
        try {
            return this.identityService.getIdentityProvider().getUserRealmRoles(realm, userId);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void updateUserClientRoles(@BeanParam RequestParams requestParams, String realm, String userId, String[] roles, String clientId) {
        try {
            this.identityService.getIdentityProvider().updateUserClientRoles(realm, userId, clientId, roles);
        }
        catch (ClientErrorException ex) {
            ex.printStackTrace(System.out);
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void updateUserRealmRoles(RequestParams requestParams, String realm, String userId, String[] roles) {
        try {
            this.identityService.getIdentityProvider().updateUserRealmRoles(realm, userId, roles);
        }
        catch (ClientErrorException ex) {
            ex.printStackTrace(System.out);
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public Role[] getClientRoles(RequestParams requestParams, String realm, String clientId) {
        try {
            return this.identityService.getIdentityProvider().getClientRoles(realm, clientId);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void updateRoles(RequestParams requestParams, String realm, Role[] roles) {
        this.updateClientRoles(requestParams, realm, roles, "openremote");
    }

    public void updateClientRoles(RequestParams requestParams, String realm, Role[] roles, String clientId) {
        try {
            this.identityService.getIdentityProvider().updateClientRoles(realm, clientId, roles);
        }
        catch (ClientErrorException ex) {
            ex.printStackTrace(System.out);
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new NotFoundException((Throwable)ex);
        }
    }

    public void updateCurrentUserLocale(RequestParams requestParams, String locale) {
        String parsed = locale.replaceAll("\"", "");
        if (TextUtil.isNullOrEmpty((String)parsed)) {
            throw new BadRequestException("Locale cannot be empty");
        }
        User user = this.getCurrent(requestParams);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        user.setAttribute("locale", parsed);
        this.update(requestParams, this.getRequestRealmName(), user);
    }

    public UserSession[] getUserSessions(RequestParams requestParams, String realm, String userId) {
        boolean hasAdminReadRole = this.hasResourceRole(ClientRole.READ_ADMIN.getValue(), "openremote");
        if (!hasAdminReadRole && !Objects.equals(this.getUserId(), userId)) {
            throw new ForbiddenException("Can only retrieve own user sessions unless you have role '" + String.valueOf(ClientRole.READ_ADMIN) + "'");
        }
        return (UserSession[])this.mqttBrokerService.getUserConnections(userId).stream().map(connection -> new UserSession(MQTTBrokerService.getConnectionIDString(connection), connection.getSubject() != null ? KeycloakIdentityProvider.getSubjectName((Subject)connection.getSubject()) : userId, connection.getCreationTime(), connection.getRemoteAddress())).toArray(UserSession[]::new);
    }

    public void disconnectUserSession(RequestParams requestParams, String realm, String sessionID) {
        if (!this.mqttBrokerService.disconnectSession(sessionID)) {
            throw new NotFoundException("User session not found");
        }
    }

    protected void throwIfIllegalMasterAdminUserDeletion(RequestParams requestParams, String realm, String userId) throws WebApplicationException {
        if (!realm.equals("master")) {
            return;
        }
        if (!this.identityService.getIdentityProvider().isMasterRealmAdmin(userId)) {
            return;
        }
        throw new NotAllowedException("The master realm admin user cannot be deleted", new String[0]);
    }

    protected void throwIfIllegalMasterAdminUserMutation(RequestParams requestParams, String realm, User user) throws WebApplicationException {
        if (!realm.equals("master")) {
            return;
        }
        if (!this.identityService.getIdentityProvider().isMasterRealmAdmin(user.getId())) {
            return;
        }
        if (user.getEnabled() == null || !user.getEnabled().booleanValue()) {
            throw new NotAllowedException("The master realm admin user cannot be disabled", new String[0]);
        }
    }
}

