/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.logging.Logger;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.Container;
import org.openremote.model.http.RequestParams;
import org.openremote.model.security.Realm;
import org.openremote.model.security.RealmResource;

public class RealmResourceImpl
extends ManagerWebResource
implements RealmResource {
    private static final Logger LOG = Logger.getLogger(RealmResourceImpl.class.getName());
    protected Container container;

    public RealmResourceImpl(TimerService timerService, ManagerIdentityService identityService, Container container) {
        super(timerService, identityService);
        this.container = container;
    }

    public Realm[] getAll(RequestParams requestParams) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            return this.identityService.getIdentityProvider().getRealms();
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public Realm[] getAccessible(RequestParams requestParams) {
        try {
            Realm[] realms = this.isSuperUser() ? this.identityService.getIdentityProvider().getRealms() : new Realm[]{this.isAuthenticated() ? this.getAuthenticatedRealm() : this.getRequestRealm()};
            return (Realm[])Arrays.stream(realms).map(realm -> new Realm().setName(realm.getName()).setDisplayName(realm.getDisplayName())).toArray(Realm[]::new);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public Realm get(RequestParams requestParams, String realmName) {
        Realm realm = this.identityService.getIdentityProvider().getRealm(realmName);
        if (realm == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.isRealmActiveAndAccessible(realm)) {
            LOG.info("Forbidden access for user '" + this.getUsername() + "': " + String.valueOf(realm));
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return realm;
    }

    public void update(RequestParams requestParams, String realmName, Realm realm) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.throwIfIllegalMasterRealmMutation(realmName, realm);
        try {
            this.identityService.getIdentityProvider().updateRealm(realm);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (IllegalArgumentException ex) {
            throw new WebApplicationException(ex.getCause(), 409);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void create(RequestParams requestParams, Realm realm) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            this.identityService.getIdentityProvider().createRealm(realm);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public void delete(RequestParams requestParams, String realm) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.throwIfIllegalMasterRealmDeletion(realm);
        try {
            this.identityService.getIdentityProvider().deleteRealm(realm);
        }
        catch (ClientErrorException ex) {
            throw new WebApplicationException(ex.getCause(), ex.getResponse().getStatus());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected void throwIfIllegalMasterRealmDeletion(String realm) throws WebApplicationException {
        if (!realm.equals("master")) {
            return;
        }
        throw new NotAllowedException("The master realm cannot be deleted", new String[0]);
    }

    protected void throwIfIllegalMasterRealmMutation(String realmName, Realm realm) throws WebApplicationException {
        if (!realmName.equals("master")) {
            return;
        }
        if (realm.getEnabled() == null || !realm.getEnabled().booleanValue()) {
            throw new NotAllowedException("The master realmName cannot be disabled", new String[0]);
        }
        if (realm.getName() == null || !realm.getName().equals("master")) {
            throw new NotAllowedException("The master realmName identifier cannot be changed", new String[0]);
        }
    }
}

