/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalsCallback;
import org.keycloak.adapters.KeycloakDeployment;
import org.openremote.manager.security.KeycloakDeploymentCallback;

public class MultiTenantJaasCallbackHandler
implements CallbackHandler {
    protected final String username;
    protected final String password;
    final RemotingConnection remotingConnection;
    protected final String realm;
    protected final Function<String, KeycloakDeployment> deploymentResolver;

    public MultiTenantJaasCallbackHandler(Function<String, KeycloakDeployment> deploymentResolver, String realm, String username, String password, RemotingConnection remotingConnection) {
        this.username = username;
        this.password = password;
        this.remotingConnection = remotingConnection;
        this.realm = realm;
        this.deploymentResolver = deploymentResolver;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (this.password == null) {
                    passwordCallback.setPassword(null);
                    continue;
                }
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                if (this.username == null) {
                    nameCallback.setName(null);
                    continue;
                }
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof CertificateCallback) {
                CertificateCallback certCallback = (CertificateCallback)callback;
                certCallback.setCertificates(CertificateUtil.getCertsFromConnection((RemotingConnection)this.remotingConnection));
                continue;
            }
            if (callback instanceof PrincipalsCallback) {
                Principal peerPrincipalFromConnection;
                PrincipalsCallback principalsCallback = (PrincipalsCallback)callback;
                Subject peerSubject = this.remotingConnection.getSubject();
                if (peerSubject != null) {
                    Iterator<KerberosPrincipal> iterator = peerSubject.getPrivateCredentials(KerberosPrincipal.class).iterator();
                    if (iterator.hasNext()) {
                        KerberosPrincipal principal = iterator.next();
                        principalsCallback.setPeerPrincipals(new Principal[]{principal});
                        return;
                    }
                    Set<Principal> principals = peerSubject.getPrincipals();
                    if (principals.size() > 0) {
                        principalsCallback.setPeerPrincipals(principals.toArray(new Principal[0]));
                        return;
                    }
                }
                if ((peerPrincipalFromConnection = CertificateUtil.getPeerPrincipalFromConnection((RemotingConnection)this.remotingConnection)) == null) continue;
                principalsCallback.setPeerPrincipals(new Principal[]{peerPrincipalFromConnection});
                continue;
            }
            if (callback instanceof KeycloakDeploymentCallback) {
                KeycloakDeploymentCallback keycloakDeploymentCallback = (KeycloakDeploymentCallback)callback;
                keycloakDeploymentCallback.setDeployment(this.deploymentResolver.apply(this.realm));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

