/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.jaas.AbstractKeycloakLoginModule;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.util.JsonSerialization;
import org.openremote.manager.security.KeycloakDeploymentCallback;

public class MultiTenantClientCredentialsGrantsLoginModule
extends AbstractKeycloakLoginModule {
    public static final String INCLUDE_REALM_ROLES_OPTION = "includeRealmRoles";
    public static final String SCOPE_OPTION = "scope";
    private static final Logger log = Logger.getLogger(MultiTenantClientCredentialsGrantsLoginModule.class);
    protected boolean includeRealmRoles;
    protected String scope;
    protected String refreshToken;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.scope = (String)options.get(SCOPE_OPTION);
        Iterator<RefreshTokenHolder> iterator = subject.getPrivateCredentials(RefreshTokenHolder.class).iterator();
        if (iterator.hasNext()) {
            this.refreshToken = iterator.next().refreshToken;
        }
        this.includeRealmRoles = Boolean.parseBoolean((String)options.get(INCLUDE_REALM_ROLES_OPTION));
    }

    public boolean login() throws LoginException {
        boolean hasDeployment = this.deployment != null;
        Callback[] callbacks = new Callback[hasDeployment ? 2 : 3];
        callbacks[0] = new NameCallback("username");
        callbacks[1] = new PasswordCallback("password", false);
        if (!hasDeployment) {
            callbacks[2] = new KeycloakDeploymentCallback();
        }
        try {
            AbstractKeycloakLoginModule.Auth auth;
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            String password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            if (!hasDeployment) {
                this.deployment = ((KeycloakDeploymentCallback)callbacks[2]).getDeployment();
                if (this.deployment == null) {
                    this.getLogger().warn((Object)"Unable to resolve keycloak deployment");
                    return false;
                }
            }
            if ((auth = this.doAuth(username, password)) != null) {
                this.auth = auth;
                return true;
            }
            return false;
        }
        catch (UnsupportedCallbackException uce) {
            this.getLogger().warn((Object)("Error: " + uce.getCallback().toString() + " not available to gather authentication information from the user"));
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            throw le;
        }
    }

    protected Logger getLogger() {
        return log;
    }

    protected AbstractKeycloakLoginModule.Auth doAuth(String username, String password) throws IOException, VerificationException {
        return this.clientCredentialsAuth(username, password);
    }

    public boolean commit() throws LoginException {
        boolean superCommit = super.commit();
        if (this.refreshToken != null) {
            RefreshTokenHolder refreshTokenHolder = new RefreshTokenHolder();
            refreshTokenHolder.refreshToken = this.refreshToken;
            this.subject.getPrivateCredentials().add(refreshTokenHolder);
        }
        return superCommit;
    }

    protected AbstractKeycloakLoginModule.Auth clientCredentialsAuth(String username, String password) throws IOException, VerificationException {
        String authServerBaseUrl = this.deployment.getAuthServerBaseUrl();
        HttpPost post = new HttpPost(this.deployment.getTokenUrl());
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("grant_type", "client_credentials"));
        formparams.add(new BasicNameValuePair("client_id", username));
        formparams.add(new BasicNameValuePair("client_secret", password));
        if (this.scope != null) {
            formparams.add(new BasicNameValuePair(SCOPE_OPTION, this.scope));
        }
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpClient client = this.deployment.getClient();
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            StringBuilder errorBuilder = new StringBuilder("Login failed. Invalid status: " + status);
            if (entity != null) {
                InputStream is = entity.getContent();
                OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((InputStream)is, OAuth2ErrorRepresentation.class);
                errorBuilder.append(", OAuth2 error. Error: " + errorRep.getError()).append(", Error description: " + errorRep.getErrorDescription());
            }
            String error = errorBuilder.toString();
            log.warn((Object)error);
            throw new IOException(error);
        }
        if (entity == null) {
            throw new IOException("No Entity");
        }
        InputStream is = entity.getContent();
        AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((InputStream)is, AccessTokenResponse.class);
        this.refreshToken = tokenResponse.getRefreshToken();
        AdapterTokenVerifier.VerifiedTokens tokens = AdapterTokenVerifier.verifyTokens((String)tokenResponse.getToken(), (String)tokenResponse.getIdToken(), (KeycloakDeployment)this.deployment);
        return this.postTokenVerification(tokenResponse.getToken(), tokens.getAccessToken());
    }

    protected AbstractKeycloakLoginModule.Auth postTokenVerification(String tokenString, AccessToken token) {
        boolean verifyCaller = this.deployment.isUseResourceRoleMappings() ? token.isVerifyCaller(this.deployment.getResourceName()) : token.isVerifyCaller();
        if (verifyCaller) {
            throw new IllegalStateException("VerifyCaller not supported yet in login module");
        }
        RefreshableKeycloakSecurityContext skSession = new RefreshableKeycloakSecurityContext(this.deployment, null, tokenString, token, null, null, null);
        String principalName = AdapterUtils.getPrincipalName((KeycloakDeployment)this.deployment, (AccessToken)token);
        KeycloakPrincipal principal = new KeycloakPrincipal(principalName, (KeycloakSecurityContext)skSession);
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)skSession);
        if (this.includeRealmRoles && !this.deployment.isUseResourceRoleMappings()) {
            AccessToken accessToken = skSession.getToken();
            roles = Sets.union((Set)roles, (Set)accessToken.getRealmAccess().getRoles());
        }
        return new AbstractKeycloakLoginModule.Auth(principal, roles, tokenString);
    }

    public boolean logout() throws LoginException {
        if (this.refreshToken != null) {
            try {
                URI logoutUri = this.deployment.getLogoutUrl().clone().build(new Object[0]);
                HttpPost post = new HttpPost(logoutUri);
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                AdapterUtils.setClientCredentials((KeycloakDeployment)this.deployment, (HttpPost)post, formparams);
                formparams.add(new BasicNameValuePair("refresh_token", this.refreshToken));
                UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
                post.setEntity((HttpEntity)form);
                HttpClient client = this.deployment.getClient();
                HttpResponse response = client.execute((HttpUriRequest)post);
                int status = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (status != 204) {
                    StringBuilder errorBuilder = new StringBuilder("Logout of refreshToken failed. Invalid status: " + status);
                    if (entity != null) {
                        InputStream is = entity.getContent();
                        if (status == 400) {
                            OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((InputStream)is, OAuth2ErrorRepresentation.class);
                            errorBuilder.append(", OAuth2 error. Error: " + errorRep.getError()).append(", Error description: " + errorRep.getErrorDescription());
                        } else if (is != null) {
                            is.close();
                        }
                    }
                    log.warn((Object)errorBuilder.toString());
                }
            }
            catch (IOException ioe) {
                log.warn((Object)ioe);
            }
        }
        return super.logout();
    }

    private static class RefreshTokenHolder
    implements Serializable {
        private String refreshToken;

        private RefreshTokenHolder() {
        }
    }
}

