/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import jakarta.persistence.Query;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.security.AuthContext;
import org.openremote.container.security.keycloak.KeycloakIdentityProvider;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebService;
import org.openremote.manager.apps.ConsoleAppService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.security.ManagerIdentityProvider;
import org.openremote.model.Container;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.auth.OAuthPasswordGrant;
import org.openremote.model.event.shared.RealmFilter;
import org.openremote.model.gateway.GatewayConnection;
import org.openremote.model.provisioning.ProvisioningConfig;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Credential;
import org.openremote.model.security.Realm;
import org.openremote.model.security.RealmRole;
import org.openremote.model.security.Role;
import org.openremote.model.security.User;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.UniqueIdentifierGenerator;
import org.openremote.model.util.ValueUtil;

public class ManagerKeycloakIdentityProvider
extends KeycloakIdentityProvider
implements ManagerIdentityProvider {
    private static final Logger LOG = Logger.getLogger(ManagerKeycloakIdentityProvider.class.getName());
    public static final String REALM_KEYCLOAK_THEME_SUFFIX = "_REALM_KEYCLOAK_THEME";
    public static final String DEFAULT_REALM_KEYCLOAK_THEME = "DEFAULT_REALM_KEYCLOAK_THEME";
    public static final String DEFAULT_REALM_KEYCLOAK_THEME_DEFAULT = "openremote";
    public static final String OR_KEYCLOAK_GRANT_FILE = "OR_KEYCLOAK_GRANT_FILE";
    public static final String OR_KEYCLOAK_GRANT_FILE_DEFAULT = "manager/keycloak-credentials.json";
    public static final String OR_KEYCLOAK_PUBLIC_URI = "OR_KEYCLOAK_PUBLIC_URI";
    public static final String OR_KEYCLOAK_PUBLIC_URI_DEFAULT = "/auth";
    public static final String OR_KEYCLOAK_ENABLE_DIRECT_ACCESS_GRANT = "OR_KEYCLOAK_ENABLE_DIRECT_ACCESS_GRANT";
    public static final List<String> BUILT_IN_REALM_ROLES = List.of("admin", "create-realm", "offline_access", "uma_authorization");
    protected PersistenceService persistenceService;
    protected AssetStorageService assetStorageService;
    protected TimerService timerService;
    protected MessageBrokerService messageBrokerService;
    protected ClientEventService clientEventService;
    protected ConsoleAppService consoleAppService;
    protected String keycloakAdminPassword;
    protected Container container;
    protected String frontendURI;
    protected List<String> validRedirectUris;
    protected Map<String, Realm> realmCache = new ConcurrentHashMap<String, Realm>();

    public void init(Container container) {
        super.init(container);
        this.container = container;
        String keycloakPublicUri = MapAccess.getString((Map)container.getConfig(), (String)OR_KEYCLOAK_PUBLIC_URI, (String)OR_KEYCLOAK_PUBLIC_URI_DEFAULT);
        try {
            URIBuilder uriBuilder = new URIBuilder(keycloakPublicUri);
            this.frontendURI = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.SEVERE, "Failed to build Keycloak public URI", e);
            throw new RuntimeException(e);
        }
        this.keycloakAdminPassword = container.getConfig().getOrDefault("OR_ADMIN_PASSWORD", "secret");
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.messageBrokerService = (MessageBrokerService)container.getService(MessageBrokerService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.consoleAppService = (ConsoleAppService)container.getService(ConsoleAppService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.validRedirectUris = new ArrayList<String>();
        this.validRedirectUris.add("/*");
        this.validRedirectUris.addAll(WebService.getExternalHostnames((Container)container).stream().map(host -> "https://" + host + "/*").toList());
    }

    public void start(Container container) {
        super.start(container);
        if (container.isDevMode()) {
            String keycloakPath = MapAccess.getString((Map)container.getConfig(), (String)"OR_KEYCLOAK_PATH", (String)"auth");
            this.enableAuthProxy((WebService)container.getService(WebService.class), keycloakPath);
        }
    }

    protected OAuthGrant getStoredCredentials(Container container) {
        String grantFile = MapAccess.getString((Map)container.getConfig(), (String)OR_KEYCLOAK_GRANT_FILE, (String)OR_KEYCLOAK_GRANT_FILE_DEFAULT);
        Path grantPath = TextUtil.isNullOrEmpty((String)grantFile) ? null : this.persistenceService.resolvePath(grantFile);
        OAuthGrant grant = null;
        if (grantPath != null && Files.isReadable(grantPath)) {
            LOG.info("Loading OR_KEYCLOAK_GRANT_FILE: " + String.valueOf(grantPath));
            try (InputStream is = Files.newInputStream(grantPath, new OpenOption[0]);){
                String grantJson = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                grant = ValueUtil.parse((String)grantJson, OAuthGrant.class).orElseGet(() -> {
                    LOG.warning("Failed to load OR_KEYCLOAK_GRANT_FILE: " + String.valueOf(grantPath));
                    return null;
                });
            }
            catch (Exception ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        return grant;
    }

    protected OAuthGrant generateStoredCredentials(Container container) {
        String grantFile = MapAccess.getString((Map)container.getConfig(), (String)OR_KEYCLOAK_GRANT_FILE, (String)OR_KEYCLOAK_GRANT_FILE_DEFAULT);
        if (TextUtil.isNullOrEmpty((String)grantFile)) {
            return null;
        }
        Path grantPath = this.persistenceService.resolvePath(grantFile);
        User keycloakProxyUser = new User().setUsername("manager-keycloak").setEnabled(Boolean.valueOf(true)).setSystemAccount(true);
        String password = UniqueIdentifierGenerator.generateId() + "$*#@$";
        try {
            keycloakProxyUser = this.createUpdateUser("master", keycloakProxyUser, password, true);
            this.updateUserRealmRoles("master", keycloakProxyUser.getId(), this.addUserRealmRoles("master", keycloakProxyUser.getId(), new String[]{"admin"}));
            OAuthPasswordGrant grant = this.getDefaultKeycloakGrant(container);
            grant.setUsername(keycloakProxyUser.getUsername()).setPassword(password);
            grantPath.getParent().toFile().mkdirs();
            Files.write(grantPath, ValueUtil.asJSON((Object)grant).orElse("null").getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            return grant;
        }
        catch (Exception e) {
            LOG.info("Failed to write OR_KEYCLOAK_GRANT_FILE: " + String.valueOf(grantPath));
            return null;
        }
    }

    protected void addClientRedirectUris(String client, List<String> redirectUrls, boolean devMode) {
        String realmManagerCallbackUrl = UriBuilder.fromUri((String)"/").path(client).path("*").build(new Object[0]).toString();
        redirectUrls.add(realmManagerCallbackUrl);
    }

    protected <T> T withClientResource(String realm, String client, RealmsResource realmsResource, BiFunction<ClientRepresentation, ClientResource, T> clientResourceConsumer, Supplier<T> notFoundProvider) {
        ClientRepresentation clientRepresentation = null;
        ClientResource clientResource = null;
        try {
            ClientsResource clientsResource = realmsResource.realm(realm).clients();
            List clientRepresentations = clientsResource.findByClientId(client);
            if (clientRepresentations != null && !clientRepresentations.isEmpty()) {
                if (clientRepresentations.size() > 1) {
                    throw new IllegalStateException("More than one matching client found realm=" + realm + ", client=" + client);
                }
                clientRepresentation = (ClientRepresentation)clientRepresentations.get(0);
                clientResource = clientsResource.get(clientRepresentation.getId());
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "withClientResource failed", e);
        }
        if (clientResource != null) {
            return clientResourceConsumer.apply(clientRepresentation, clientResource);
        }
        if (notFoundProvider != null) {
            return notFoundProvider.get();
        }
        return null;
    }

    @Override
    public User[] queryUsers(UserQuery userQuery) {
        return ManagerIdentityProvider.getUsersFromDb(this.persistenceService, userQuery);
    }

    @Override
    public User getUser(String userId) {
        return ManagerIdentityProvider.getUserByIdFromDb(this.persistenceService, userId);
    }

    @Override
    public User getUserByUsername(String realm, String username) {
        if (username.length() > 255) {
            username = username.substring(0, 254);
        }
        username = username.toLowerCase();
        return ManagerIdentityProvider.getUserByUsernameFromDb(this.persistenceService, realm, username);
    }

    @Override
    public User createUpdateUser(String realm, User user, String passwordSecret, boolean allowUpdate) throws WebApplicationException {
        return (User)this.getRealms(realmsResource -> {
            User updatedUser;
            UserRepresentation userRepresentation;
            User existingUser;
            if (user.getUsername() != null) {
                user.setUsername(user.getUsername().toLowerCase(Locale.ROOT));
            }
            if (user.getUsername().length() > 255) {
                user.setUsername(user.getUsername().substring(0, 254));
            }
            if (!user.isServiceAccount() && allowUpdate && (this.getRealm(realm).getRegistrationEmailAsUsername() != false ? user.getEmail() == null : user.getUsername() == null)) {
                throw new BadRequestException("Attempt to create/update user but no username or email provided: User=" + String.valueOf(user));
            }
            boolean isUpdate = false;
            User user2 = existingUser = user.getId() != null ? this.getUser(user.getId()) : this.getUserByUsername(realm, user.getUsername());
            if (existingUser != null && !allowUpdate) {
                String msg = "Attempt to create user but it already exists: User=" + String.valueOf(user);
                LOG.warning(msg);
                throw new ForbiddenException(msg);
            }
            if (existingUser == null && user.isServiceAccount() && (userRepresentation = this.withClientResource(realm, user.getUsername(), (RealmsResource)realmsResource, (clientRep, clientResource) -> {
                UserRepresentation userRep = clientResource.getServiceAccountUser();
                if (userRep == null) {
                    String msg = "Attempt to update/create service user but a regular client with same client ID as this username already exists: User=" + String.valueOf(user);
                    LOG.warning(msg);
                    throw new NotAllowedException(msg, new String[0]);
                }
                return userRep;
            }, null)) != null) {
                existingUser = (User)ValueUtil.convert((Object)userRepresentation, User.class);
            }
            if (existingUser != null && user.getId() != null && !existingUser.getId().equals(user.getId())) {
                String msg = "Attempt to update user but retrieved user ID doesn't match supplied so ignoring: User=" + String.valueOf(user);
                LOG.warning(msg);
                throw new BadRequestException(msg);
            }
            if (existingUser != null) {
                isUpdate = true;
                if (existingUser.isServiceAccount() != user.isServiceAccount()) {
                    String msg = "Attempt to update user service account flag not allowed: User=" + String.valueOf(user);
                    LOG.warning(msg);
                    throw new NotAllowedException(msg, new String[0]);
                }
                if (existingUser.isServiceAccount() && !existingUser.getUsername().equals(user.getUsername())) {
                    String msg = "Attempt to update username of service user not allowed: User=" + String.valueOf(user);
                    LOG.warning(msg);
                    throw new NotAllowedException(msg, new String[0]);
                }
            }
            if (isUpdate) {
                UserResource userResource = realmsResource.realm(realm).users().get(existingUser.getId());
                userRepresentation = userResource.toRepresentation();
                userRepresentation.setFirstName(user.getFirstName());
                userRepresentation.setLastName(user.getLastName());
                userRepresentation.setEmail(user.getEmail());
                userRepresentation.setEnabled(user.getEnabled());
                userRepresentation.setAttributes(user.getAttributeMap());
                userResource.update(userRepresentation);
            } else if (user.isServiceAccount()) {
                ClientRepresentation clientRepresentation = new ClientRepresentation();
                clientRepresentation.setStandardFlowEnabled(Boolean.valueOf(false));
                clientRepresentation.setImplicitFlowEnabled(Boolean.valueOf(false));
                clientRepresentation.setDirectAccessGrantsEnabled(Boolean.valueOf(false));
                clientRepresentation.setServiceAccountsEnabled(Boolean.valueOf(true));
                clientRepresentation.setClientAuthenticatorType("client-secret");
                clientRepresentation.setClientId(user.getUsername());
                clientRepresentation.setSecret(passwordSecret);
                clientRepresentation = this.createUpdateClient(realm, clientRepresentation);
                userRepresentation = realmsResource.realm(realm).clients().get(clientRepresentation.getId()).getServiceAccountUser();
                userRepresentation.setEnabled(user.getEnabled());
                realmsResource.realm(realm).users().get(userRepresentation.getId()).update(userRepresentation);
            } else {
                userRepresentation = (UserRepresentation)ValueUtil.convert((Object)user, UserRepresentation.class);
                RealmResource realmResource = realmsResource.realm(realm);
                Response response = realmResource.users().create(userRepresentation);
                String location = response.getHeaderString("Location");
                response.close();
                if (!response.getStatusInfo().equals((Object)Response.Status.CREATED) || TextUtil.isNullOrEmpty((String)location)) {
                    throw new BadRequestException("Failed to create user: User=" + String.valueOf(user));
                }
                String[] locationArr = location.split("/");
                String userId = locationArr.length > 0 ? locationArr[locationArr.length - 1] : null;
                userRepresentation = realmResource.users().get(userId).toRepresentation();
            }
            if (passwordSecret != null || !isUpdate && user.isServiceAccount()) {
                if (user.isServiceAccount()) {
                    this.resetSecret(realm, userRepresentation.getId(), passwordSecret);
                } else {
                    Credential credential = new Credential(passwordSecret, Boolean.valueOf(false));
                    this.resetPassword(realm, userRepresentation.getId(), credential);
                }
            }
            if ((updatedUser = (User)ValueUtil.convert((Object)userRepresentation, User.class)) != null) {
                updatedUser.setRealm(realm);
                if (updatedUser.isServiceAccount()) {
                    updatedUser.setSecret(passwordSecret);
                }
                if (existingUser != null) {
                    updatedUser.setRealmId(existingUser.getRealmId());
                }
            }
            this.persistenceService.publishPersistenceEvent(isUpdate ? PersistenceEvent.Cause.UPDATE : PersistenceEvent.Cause.CREATE, (Object)updatedUser, (Object)existingUser, User.class, Collections.singletonList("attributes"), null);
            return updatedUser;
        });
    }

    @Override
    public void deleteUser(String realm, String userId) {
        User user = this.getUser(userId);
        if (user == null) {
            return;
        }
        if (user.getUsername().equals("admin") && user.getRealm().equals("master")) {
            throw new IllegalStateException("Cannot delete master realm admin user");
        }
        this.getRealms(realmsResource -> {
            if (user.isServiceAccount()) {
                this.deleteClient(realm, user.getUsername());
            } else {
                Response response = realmsResource.realm(realm).users().delete(userId);
                response.close();
                if (!response.getStatusInfo().equals((Object)Response.Status.NO_CONTENT)) {
                    throw new IllegalStateException("Failed to delete user: " + userId);
                }
            }
            return null;
        });
        this.persistenceService.publishPersistenceEvent(PersistenceEvent.Cause.DELETE, null, (Object)user, User.class, Collections.singletonList("attributes"), null);
    }

    @Override
    public void resetPassword(String realm, String userId, Credential credential) {
        this.getRealms(realmsResource -> {
            realmsResource.realm(realm).users().get(userId).resetPassword((CredentialRepresentation)ValueUtil.convert((Object)credential, CredentialRepresentation.class));
            return null;
        });
    }

    @Override
    public String resetSecret(String realm, String userId, String secret) {
        return (String)this.getRealms(realmsResource -> {
            UserRepresentation userRepresentation = null;
            try {
                userRepresentation = realmsResource.realm(realm).users().get(userId).toRepresentation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (userRepresentation == null) {
                return null;
            }
            return this.withClientResource(realm, userRepresentation.getUsername().substring("service-account-".length()), (RealmsResource)realmsResource, (clientRep, clientResource) -> {
                if (TextUtil.isNullOrEmpty((String)secret)) {
                    CredentialRepresentation credentialRepresentation = clientResource.generateNewSecret();
                    return credentialRepresentation.getValue();
                }
                clientRep.setSecret(secret);
                clientResource.update(clientRep);
                return secret;
            }, null);
        });
    }

    @Override
    public Role[] getClientRoles(String realm, String client) {
        return (Role[])this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            ClientsResource clientsResource = realmResource.clients();
            ClientResource clientResource = null;
            if (client != null) {
                ClientRepresentation clientRepresentation = this.getClient(realm, client);
                if (clientRepresentation == null) {
                    throw new IllegalStateException("Cannot find specified client: " + client);
                }
                clientResource = clientsResource.get(clientRepresentation.getId());
            }
            List roleRepresentations = clientResource != null ? clientResource.roles().list() : realmResource.roles().list();
            ArrayList<Role> roles = new ArrayList<Role>();
            for (RoleRepresentation clientRole : roleRepresentations) {
                String[] composites = clientRole.isComposite() ? (String[])realmResource.rolesById().getRoleComposites(clientRole.getId()).stream().map(RoleRepresentation::getId).toArray(String[]::new) : null;
                roles.add(new Role(clientRole.getId(), clientRole.getName(), clientRole.isComposite(), null, composites).setDescription(clientRole.getDescription()));
            }
            return roles.toArray(new Role[0]);
        });
    }

    @Override
    public void updateClientRoles(String realm, String clientId, Role[] roles) {
        this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            ClientsResource clientsResource = realmResource.clients();
            ClientRepresentation clientRepresentation = this.getClient(realm, clientId);
            if (clientRepresentation == null) {
                throw new IllegalStateException("Cannot find specified client: " + clientId);
            }
            ClientResource clientResource = clientsResource.get(clientRepresentation.getId());
            ArrayList existingRoles = new ArrayList(clientResource.roles().list());
            List<RoleRepresentation> removedRoles = existingRoles.stream().filter(existingRole -> Arrays.stream(roles).noneMatch(r -> existingRole.getId().equals(r.getId()))).collect(Collectors.toList());
            removedRoles.forEach(removedRole -> {
                realmResource.rolesById().deleteRole(removedRole.getId());
                existingRoles.remove(removedRole);
            });
            Arrays.stream(roles).forEach(role -> {
                RoleRepresentation existingRole;
                boolean compositesModified = false;
                HashSet existingComposites = new HashSet();
                HashSet requestedComposites = new HashSet();
                if (role.getId() == null) {
                    existingRole = this.saveClientRole(realmResource, clientResource, (Role)role, null);
                    existingRoles.add(existingRole);
                    boolean bl = compositesModified = role.getCompositeRoleIds() != null && role.getCompositeRoleIds().length > 0;
                    if (compositesModified) {
                        requestedComposites.addAll(Arrays.stream(role.getCompositeRoleIds()).map(id -> existingRoles.stream().filter(er -> er.getId().equals(id)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()));
                    }
                } else {
                    boolean rolePropertiesModified;
                    existingRole = existingRoles.stream().filter(r -> r.getId().equals(role.getId())).findFirst().orElseThrow(() -> new IllegalStateException("One or more supplied roles have an ID that doesn't exist"));
                    boolean isComposite = role.isComposite() && role.getCompositeRoleIds() != null && role.getCompositeRoleIds().length > 0;
                    boolean bl = rolePropertiesModified = !Objects.equals(existingRole.getName(), role.getName()) || !Objects.equals(existingRole.getDescription(), role.getDescription());
                    if (isComposite || existingRole.isComposite()) {
                        existingComposites.addAll(Optional.ofNullable(realmResource.rolesById().getClientRoleComposites(existingRole.getId(), clientRepresentation.getId())).orElse(new HashSet()));
                        requestedComposites.addAll(Arrays.stream(role.getCompositeRoleIds()).map(id -> existingRoles.stream().filter(er -> er.getId().equals(id)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()));
                        if (requestedComposites.size() != role.getCompositeRoleIds().length) {
                            throw new IllegalStateException("One or more composite roles contain an invalid role ID");
                        }
                        boolean bl2 = compositesModified = !Objects.equals(existingComposites, requestedComposites);
                    }
                    if (rolePropertiesModified) {
                        this.saveClientRole(realmResource, clientResource, (Role)role, existingRole);
                    }
                }
                if (compositesModified) {
                    List removed = existingComposites.stream().filter(existing -> !requestedComposites.contains(existing)).collect(Collectors.toList());
                    List added = requestedComposites.stream().filter(existing -> !existingComposites.contains(existing)).collect(Collectors.toList());
                    if (!removed.isEmpty()) {
                        realmResource.rolesById().deleteComposites(existingRole.getId(), removed);
                    }
                    if (!added.isEmpty()) {
                        realmResource.rolesById().addComposites(existingRole.getId(), added);
                    }
                }
            });
            return null;
        });
    }

    protected RoleRepresentation saveClientRole(RealmResource realmResource, ClientResource clientResource, Role role, RoleRepresentation representation) {
        if (representation == null) {
            representation = new RoleRepresentation();
        }
        representation.setName(role.getName());
        representation.setDescription(role.getDescription());
        representation.setClientRole(Boolean.valueOf(true));
        if (representation.getId() == null) {
            clientResource.roles().create(representation);
        } else {
            realmResource.rolesById().updateRole(representation.getId(), representation);
        }
        return clientResource.roles().get(representation.getName()).toRepresentation();
    }

    @Override
    public String[] getUserClientRoles(String realm, String userId, String client) {
        return (String[])this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            RoleMappingResource roleMappingResource = realmResource.users().get(userId).roles();
            return this.withClientResource(realm, client, (RealmsResource)realmsResource, (clientRepresentation, clientResource) -> (String[])roleMappingResource.clientLevel(clientRepresentation.getId()).listEffective().stream().map(RoleRepresentation::getName).toArray(String[]::new), () -> new String[0]);
        });
    }

    @Override
    public String[] getUserRealmRoles(String realm, String userId) {
        return (String[])this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            RoleMappingResource roleMappingResource = realmResource.users().get(userId).roles();
            return (String[])roleMappingResource.realmLevel().listEffective().stream().filter(rr -> "master".equals(realm) && "admin".equals(rr.getName()) || !ManagerKeycloakIdentityProvider.isBuiltInRealmRole(rr.getName())).map(RoleRepresentation::getName).toArray(String[]::new);
        });
    }

    @Override
    public void updateUserClientRoles(@NotNull String realm, @NotNull String userId, @NotNull String client, String ... roles) {
        this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            UserRepresentation user = realmResource.users().get(userId).toRepresentation();
            if (user == null) {
                throw new IllegalStateException("Multiple users with the same username found");
            }
            RoleMappingResource roleMappingResource = realmResource.users().get(user.getId()).roles();
            ClientRepresentation clientRepresentation = this.getClient(realm, client);
            if (clientRepresentation == null) {
                throw new IllegalStateException("Invalid client: " + client);
            }
            ClientResource clientResource = realmResource.clients().get(clientRepresentation.getId());
            List<Object> assignedRoles = roles != null ? Arrays.asList(roles) : Collections.emptyList();
            List availableRoles = clientResource.roles().list();
            availableRoles.stream().collect(Collectors.partitioningBy(rr -> assignedRoles.contains(rr.getName()))).forEach((isAssigned, realmRoles) -> {
                if (isAssigned.booleanValue()) {
                    if (!realmRoles.isEmpty()) {
                        roleMappingResource.clientLevel(clientRepresentation.getId()).add(realmRoles.stream().map(v -> {
                            RoleRepresentation rr = new RoleRepresentation();
                            rr.setId(v.getId());
                            rr.setName(v.getName());
                            return rr;
                        }).toList());
                    }
                } else if (!realmRoles.isEmpty()) {
                    roleMappingResource.clientLevel(clientRepresentation.getId()).remove(realmRoles.stream().map(v -> {
                        RoleRepresentation rr = new RoleRepresentation();
                        rr.setId(v.getId());
                        rr.setName(v.getName());
                        return rr;
                    }).toList());
                }
            });
            return null;
        });
    }

    @Override
    public void updateUserRealmRoles(String realm, String userId, String ... roles) {
        this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            UserRepresentation user = realmResource.users().get(userId).toRepresentation();
            if (user == null) {
                throw new IllegalStateException("Multiple users with the same username found");
            }
            RoleMappingResource roleMappingResource = realmResource.users().get(user.getId()).roles();
            List<Object> assignedRoles = roles != null ? Arrays.asList(roles) : Collections.emptyList();
            Set availableRealmRoles = this.getRealm(realm).getRealmRoles();
            availableRealmRoles.stream().collect(Collectors.partitioningBy(rr -> assignedRoles.contains(rr.getName()))).forEach((isAssigned, realmRoles) -> {
                if (isAssigned.booleanValue()) {
                    if (!realmRoles.isEmpty()) {
                        roleMappingResource.realmLevel().add(realmRoles.stream().map(v -> {
                            RoleRepresentation rr = new RoleRepresentation();
                            rr.setId(v.getId());
                            rr.setName(v.getName());
                            return rr;
                        }).toList());
                    }
                } else if (!realmRoles.isEmpty()) {
                    roleMappingResource.realmLevel().remove(realmRoles.stream().map(v -> {
                        RoleRepresentation rr = new RoleRepresentation();
                        rr.setId(v.getId());
                        rr.setName(v.getName());
                        return rr;
                    }).toList());
                }
            });
            return null;
        });
    }

    @Override
    public boolean isMasterRealmAdmin(String userId) {
        Optional<UserRepresentation> adminUser = ((List)this.getRealms(realmsResource -> realmsResource.realm("master").users().search("admin", null, null))).stream().filter(user -> user.getUsername().equals("admin")).findFirst();
        if (adminUser.isEmpty()) {
            throw new IllegalStateException("Can't load master realm admin user");
        }
        return adminUser.map(UserRepresentation::getId).map(id -> id.equals(userId)).orElse(false);
    }

    @Override
    public Realm[] getRealms() {
        return ManagerIdentityProvider.getRealmsFromDb(this.persistenceService);
    }

    @Override
    public Realm getRealm(String name) {
        return this.realmCache.computeIfAbsent(name, k -> {
            try {
                Realm realm = ManagerIdentityProvider.getRealmFromDb(this.persistenceService, name);
                realm.setRealmRoles(realm.getRealmRoles().stream().filter(rr -> "master".equals(name) && "admin".equals(rr.getName()) || !ManagerKeycloakIdentityProvider.isBuiltInRealmRole(rr.getName())).collect(Collectors.toSet()));
                return realm;
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "Failed to get realm by name: " + name, ex);
                return null;
            }
        });
    }

    @Override
    public void updateRealm(Realm realm) {
        LOG.fine("Update realm: " + String.valueOf(realm));
        this.realmCache.remove(realm.getName());
        this.getRealms(realmsResource -> {
            if (TextUtil.isNullOrEmpty((String)realm.getId())) {
                throw new IllegalStateException("Realm must already exist, ID does not match an existing realm");
            }
            RealmResource realmResource = realmsResource.realm(realm.getName());
            RealmRepresentation realmRepresentation = realmResource.toRepresentation();
            Set<RoleRepresentation> existingRealmRoles = realmResource.roles().list().stream().filter(rr -> !ManagerKeycloakIdentityProvider.isBuiltInRealmRole(rr.getName())).collect(Collectors.toSet());
            if (realmRepresentation == null) {
                throw new IllegalStateException("Realm does not exist: " + realm.getName());
            }
            Realm existingRealm = (Realm)ValueUtil.convert((Object)realmRepresentation, Realm.class);
            existingRealm.setName(realmRepresentation.getRealm());
            existingRealm.setRealmRoles(existingRealmRoles.stream().map(err -> new RealmRole(err.getId(), err.getName(), err.getDescription())).collect(Collectors.toSet()));
            realmRepresentation.setDisplayName(realm.getDisplayName());
            realmRepresentation.setAccountTheme(realm.getAccountTheme());
            realmRepresentation.setAdminTheme(realm.getAdminTheme());
            realmRepresentation.setEmailTheme(realm.getEmailTheme());
            realmRepresentation.setLoginTheme(realm.getLoginTheme());
            realmRepresentation.setRememberMe(realm.getRememberMe());
            realmRepresentation.setVerifyEmail(realm.getVerifyEmail());
            realmRepresentation.setLoginWithEmailAllowed(realm.getLoginWithEmail());
            realmRepresentation.setRegistrationAllowed(realm.getRegistrationAllowed());
            realmRepresentation.setRegistrationEmailAsUsername(realm.getRegistrationEmailAsUsername());
            realmRepresentation.setEnabled(realm.getEnabled());
            realmRepresentation.setDuplicateEmailsAllowed(realm.getDuplicateEmailsAllowed());
            realmRepresentation.setResetPasswordAllowed(realm.getResetPasswordAllowed());
            realmRepresentation.setPasswordPolicy(realm.getPasswordPolicyString());
            realmRepresentation.setNotBefore(realm.getNotBefore() != null ? Integer.valueOf(realm.getNotBefore().intValue()) : null);
            this.configureRealm(realmRepresentation);
            realmResource.update(realmRepresentation);
            Set<RealmRole> realmRoles = (realm.getRealmRoles() != null ? realm.getRealmRoles() : new HashSet()).stream().filter(rr -> !ManagerKeycloakIdentityProvider.isBuiltInRealmRole(rr.getName())).collect(Collectors.toSet());
            realmRoles = new HashSet(realmRoles);
            realmRoles.addAll(Realm.DEFAULT_REALM_ROLES);
            Set<RealmRole> finalRealmRoles = realmRoles;
            existingRealmRoles.forEach(existingRealmRole -> {
                if (finalRealmRoles.stream().noneMatch(realmRole -> realmRole.getName().equals(existingRealmRole.getName()))) {
                    realmResource.roles().deleteRole(existingRealmRole.getName());
                }
            });
            realmRoles.forEach(realmRole -> {
                if (existingRealmRoles.stream().noneMatch(existingRealmRole -> existingRealmRole.getName().equals(realmRole.getName()))) {
                    realmResource.roles().create(new RoleRepresentation(realmRole.getName(), realmRole.getDescription(), false));
                }
            });
            Realm updatedRealm = (Realm)ValueUtil.convert((Object)realmRepresentation, Realm.class);
            updatedRealm.setName(realmRepresentation.getRealm());
            updatedRealm.setRealmRoles(realmRoles);
            this.persistenceService.publishPersistenceEvent(PersistenceEvent.Cause.UPDATE, (Object)updatedRealm, (Object)existingRealm, Realm.class, null, null);
            return null;
        });
    }

    @Override
    public Realm createRealm(Realm realm) {
        LOG.fine("Create realm: " + String.valueOf(realm));
        return (Realm)this.getRealms(realmsResource -> {
            RealmRepresentation realmRepresentation = (RealmRepresentation)ValueUtil.convert((Object)realm, RealmRepresentation.class);
            realmRepresentation.setRealm(realm.getName());
            try {
                realmsResource.create(realmRepresentation);
                RealmResource realmResource = realmsResource.realm(realm.getName());
                realmRepresentation = realmResource.toRepresentation();
                this.configureRealm(realmRepresentation);
                realmResource.update(realmRepresentation);
                Set<RealmRole> realmRoles = (realm.getRealmRoles() != null ? realm.getRealmRoles() : new HashSet()).stream().filter(rr -> !ManagerKeycloakIdentityProvider.isBuiltInRealmRole(rr.getName())).collect(Collectors.toSet());
                realmRoles = new HashSet(realmRoles);
                realmRoles.addAll(Realm.DEFAULT_REALM_ROLES);
                realmRoles.forEach(realmRole -> {
                    LOG.finest("Adding realm role + " + String.valueOf(realmRole));
                    realmResource.roles().create(new RoleRepresentation(realmRole.getName(), realmRole.getDescription(), false));
                });
                ClientRepresentation clientRepresentation = this.generateOpenRemoteClientRepresentation();
                this.createUpdateClient(realm.getName(), clientRepresentation);
                Realm createdRealm = (Realm)ValueUtil.convert((Object)realmRepresentation, Realm.class);
                createdRealm.setName(realmRepresentation.getRealm());
                createdRealm.setRealmRoles(realm.getRealmRoles());
                this.persistenceService.publishPersistenceEvent(PersistenceEvent.Cause.CREATE, (Object)realm, null, Realm.class, null, null);
                return createdRealm;
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Failed to create realm: " + String.valueOf(realm), e);
                throw e;
            }
        });
    }

    @Override
    public void deleteRealm(String realmName) {
        Realm realm = this.getRealm(realmName);
        if (realm == null) {
            throw new NotFoundException("Realm does not exist: " + realmName);
        }
        this.realmCache.remove(realmName);
        this.persistenceService.doTransaction(entityManager -> {
            Query query = entityManager.createQuery("delete from " + GatewayConnection.class.getSimpleName() + " gc where gc.localRealm = ?1");
            query.setParameter(1, (Object)realmName);
            query.executeUpdate();
            query = entityManager.createQuery("delete from " + ProvisioningConfig.class.getSimpleName() + " pc where pc.realm = ?1");
            query.setParameter(1, (Object)realmName);
            query.executeUpdate();
            query = entityManager.createQuery("delete from " + RealmRuleset.class.getSimpleName() + " rs where rs.realm = ?1");
            query.setParameter(1, (Object)realmName);
            query.executeUpdate();
            List<String> assetIds = this.assetStorageService.findAll(new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).realm(new RealmPredicate(realmName))).stream().map(Asset::getId).toList();
            this.assetStorageService.delete(assetIds);
        });
        LOG.fine("Deleting realm: " + realmName);
        this.getRealms(realmsResource -> {
            realmsResource.realm(realmName).remove();
            return null;
        });
        this.persistenceService.publishPersistenceEvent(PersistenceEvent.Cause.DELETE, null, (Object)realm, Realm.class, null, null);
    }

    public ClientRepresentation generateOpenRemoteClientRepresentation() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(DEFAULT_REALM_KEYCLOAK_THEME_DEFAULT);
        client.setName("OpenRemote");
        client.setPublicClient(Boolean.valueOf(true));
        boolean enableDirectAccessGrant = MapAccess.getBoolean((Map)this.container.getConfig(), (String)OR_KEYCLOAK_ENABLE_DIRECT_ACCESS_GRANT, (boolean)this.container.isDevMode());
        if (enableDirectAccessGrant) {
            LOG.info("### Allowing direct access grants for client id '" + client.getClientId() + "', this must NOT be used in production! ###");
            client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        }
        if (this.container.isDevMode()) {
            client.setWebOrigins(Collections.singletonList("*"));
            client.setRedirectUris(Collections.singletonList("*"));
        } else {
            client.setWebOrigins(Collections.singletonList("+"));
            client.setRedirectUris(this.validRedirectUris);
        }
        return client;
    }

    public ClientRepresentation getClient(String realm, String client) {
        return (ClientRepresentation)this.getRealms(realmsResource -> this.withClientResource(realm, client, (RealmsResource)realmsResource, (clientRepresentation, clientResource) -> clientRepresentation, null));
    }

    public ClientRepresentation[] getClients(String realm) {
        return (ClientRepresentation[])this.getRealms(realmsResource -> realmsResource.realm(realm).clients().findAll().toArray(new ClientRepresentation[0]));
    }

    public ClientRepresentation createUpdateClient(String realm, ClientRepresentation client) {
        if (client == null || client.getClientId() == null) {
            throw new IllegalArgumentException("Client is null or clientId is missing");
        }
        return (ClientRepresentation)this.getRealms(realmsResource -> this.withClientResource(realm, client.getClientId(), (RealmsResource)realmsResource, (clientRepresentation, clientResource) -> {
            clientResource.update(client);
            return client;
        }, () -> {
            ClientsResource clientsResource = realmsResource.realm(realm).clients();
            Response response = clientsResource.create(client);
            response.close();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                LOG.fine("Failed to create client response=" + response.getStatusInfo().getStatusCode() + ": " + String.valueOf(client));
                return null;
            }
            ClientRepresentation newClient = (ClientRepresentation)clientsResource.findByClientId(client.getClientId()).get(0);
            ClientResource clientResource = clientsResource.get(newClient.getId());
            this.addDefaultRoles(clientResource.roles());
            return newClient;
        }));
    }

    public void deleteClient(String realm, String clientId) {
        if (TextUtil.isNullOrEmpty((String)realm) || TextUtil.isNullOrEmpty((String)clientId)) {
            throw new IllegalArgumentException("Invalid client credentials realm and client ID must be specified");
        }
        this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            if (realmResource == null) {
                LOG.fine("Invalid realm provided for deleteClient call: " + realm);
                return null;
            }
            LOG.fine("Deleting client: realm=" + realm + ", client ID=" + clientId);
            return this.withClientResource(realm, clientId, (RealmsResource)realmsResource, (clientRepresentation, clientResource) -> {
                clientResource.remove();
                return null;
            }, () -> null);
        });
    }

    @Override
    public boolean isRealmActiveAndAccessible(AuthContext authContext, Realm realm) {
        if (realm == null) {
            return false;
        }
        boolean isSuperUser = authContext != null && authContext.isSuperUser();
        boolean isUsersRealm = isSuperUser || authContext == null || authContext.isRealmAccessibleByUser(realm.getName());
        return isSuperUser || isUsersRealm && realm.isActive((double)this.timerService.getCurrentTimeMillis());
    }

    @Override
    public boolean isRealmActiveAndAccessible(AuthContext authContext, String realm) {
        return this.isRealmActiveAndAccessible(authContext, this.getRealm(realm));
    }

    @Override
    public boolean realmExists(String realm) {
        return ManagerIdentityProvider.realmExistsFromDb(this.persistenceService, realm);
    }

    @Override
    public boolean isRestrictedUser(AuthContext authContext) {
        return authContext != null && authContext.hasRealmRole("restricted_user");
    }

    @Override
    public boolean isUserInRealm(String userId, String realm) {
        return ManagerIdentityProvider.userInRealmFromDb(this.persistenceService, userId, realm);
    }

    @Override
    public boolean canSubscribeWith(AuthContext auth, RealmFilter<?> filter, ClientRole ... requiredRoles) {
        if (auth.isSuperUser()) {
            return true;
        }
        if (this.isRestrictedUser(auth)) {
            return false;
        }
        if (requiredRoles != null) {
            for (ClientRole requiredRole : requiredRoles) {
                if (auth.hasResourceRole(requiredRole.getValue(), DEFAULT_REALM_KEYCLOAK_THEME_DEFAULT)) continue;
                return false;
            }
        }
        if (filter != null) {
            String authenticatedRealm = auth.getAuthenticatedRealmName();
            if (TextUtil.isNullOrEmpty((String)authenticatedRealm)) {
                return false;
            }
            if (authenticatedRealm.equals(filter.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getFrontendURI() {
        return this.frontendURI;
    }

    protected void configureRealm(RealmRepresentation realmRepresentation) {
        HashMap<String, String> headers;
        realmRepresentation.setAccessTokenLifespan(Integer.valueOf(60));
        String themeName = MapAccess.getString((Map)this.container.getConfig(), (String)(realmRepresentation.getRealm().toUpperCase(Locale.ROOT) + REALM_KEYCLOAK_THEME_SUFFIX), (String)MapAccess.getString((Map)this.container.getConfig(), (String)DEFAULT_REALM_KEYCLOAK_THEME, (String)DEFAULT_REALM_KEYCLOAK_THEME_DEFAULT));
        if (TextUtil.isNullOrEmpty((String)realmRepresentation.getLoginTheme())) {
            realmRepresentation.setLoginTheme(themeName);
        }
        if (TextUtil.isNullOrEmpty((String)realmRepresentation.getAccountTheme())) {
            realmRepresentation.setAccountTheme(themeName);
        }
        if (TextUtil.isNullOrEmpty((String)realmRepresentation.getEmailTheme())) {
            realmRepresentation.setEmailTheme(themeName);
        }
        realmRepresentation.setDisplayNameHtml(realmRepresentation.getDisplayName().replaceAll("[^A-Za-z0-9]", ""));
        realmRepresentation.setSsoSessionIdleTimeout(Integer.valueOf(this.sessionTimeoutSeconds));
        realmRepresentation.setSsoSessionMaxLifespan(Integer.valueOf(this.sessionMaxSeconds));
        realmRepresentation.setOfflineSessionIdleTimeout(Integer.valueOf(this.sessionOfflineTimeoutSeconds));
        realmRepresentation.setSslRequired(SslRequired.NONE.toString());
        String host = this.container.getConfig().getOrDefault("OR_EMAIL_HOST", null);
        if (!TextUtil.isNullOrEmpty((String)host) && (realmRepresentation.getSmtpServer() == null || realmRepresentation.getSmtpServer().isEmpty())) {
            LOG.info("Configuring Keycloak SMTP settings for realm: " + realmRepresentation.getRealm());
            HashMap<String, String> emailConfig = new HashMap<String, String>();
            emailConfig.put("host", host);
            emailConfig.put("port", this.container.getConfig().getOrDefault("OR_EMAIL_PORT", Integer.toString(587)));
            emailConfig.put("user", this.container.getConfig().getOrDefault("OR_EMAIL_USER", null));
            emailConfig.put("password", this.container.getConfig().getOrDefault("OR_EMAIL_PASSWORD", null));
            emailConfig.put("auth", this.container.getConfig().containsKey("OR_EMAIL_USER") ? "true" : "false");
            emailConfig.put("starttls", Boolean.toString(MapAccess.getBoolean((Map)this.container.getConfig(), (String)"OR_EMAIL_TLS", (boolean)true)));
            emailConfig.put("ssl", Boolean.toString(!MapAccess.getBoolean((Map)this.container.getConfig(), (String)"OR_EMAIL_TLS", (boolean)true) && MapAccess.getString((Map)this.container.getConfig(), (String)"OR_EMAIL_PROTOCOL", (String)"smtp").equals("smtps")));
            emailConfig.put("from", MapAccess.getString((Map)this.container.getConfig(), (String)"OR_EMAIL_FROM", (String)"no-reply@localhost"));
            realmRepresentation.setSmtpServer(emailConfig);
        }
        if ((headers = realmRepresentation.getBrowserSecurityHeaders()) == null) {
            headers = new HashMap<String, String>();
            realmRepresentation.setBrowserSecurityHeaders(headers);
        }
        if (this.container.isDevMode()) {
            headers.computeIfPresent("contentSecurityPolicy", (hdrName, hdrValue) -> "frame-src *; frame-ancestors *; object-src 'none'");
        } else {
            String allowedOriginsStr = String.join((CharSequence)" ", WebService.getAllowedOrigins((Container)this.container));
            if (!TextUtil.isNullOrEmpty((String)allowedOriginsStr)) {
                headers.compute("contentSecurityPolicy", (hdrName, hdrValue) -> "frame-src 'self' " + allowedOriginsStr.replace(';', ' ') + "; frame-ancestors 'self' " + allowedOriginsStr.replace(';', ' ') + "; object-src 'none'");
            }
        }
    }

    protected void addDefaultRoles(RolesResource rolesResource) {
        for (ClientRole clientRole : ClientRole.values()) {
            rolesResource.create(clientRole.getRepresentation());
        }
        for (ClientRole clientRole : ClientRole.values()) {
            if (clientRole.getComposites() == null) continue;
            ArrayList<RoleRepresentation> composites = new ArrayList<RoleRepresentation>();
            for (ClientRole composite : clientRole.getComposites()) {
                composites.add(rolesResource.get(composite.getValue()).toRepresentation());
            }
            rolesResource.get(clientRole.getValue()).addComposites(composites);
        }
    }

    public String addLDAPConfiguration(String realm, ComponentRepresentation componentRepresentation) {
        return (String)this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            Response response = realmResource.components().add(componentRepresentation);
            response.close();
            if (!response.getStatusInfo().equals((Object)Response.Status.CREATED)) {
                throw new IllegalStateException("Failed to add LDAP configuration");
            }
            ComponentRepresentation newComponentRepresentation = (ComponentRepresentation)realmResource.components().query(componentRepresentation.getParentId(), componentRepresentation.getProviderType(), componentRepresentation.getName()).get(0);
            this.syncUsers(newComponentRepresentation.getId(), realm, "triggerFullSync");
            return newComponentRepresentation.getId();
        });
    }

    public String addLDAPMapper(String realm, ComponentRepresentation componentRepresentation) {
        return (String)this.getRealms(realmsResource -> {
            RealmResource realmResource = realmsResource.realm(realm);
            Response response = realmResource.components().add(componentRepresentation);
            response.close();
            if (!response.getStatusInfo().equals((Object)Response.Status.CREATED)) {
                throw new IllegalStateException("Failed to add LDAP mapper");
            }
            ComponentRepresentation newComponentRepresentation = (ComponentRepresentation)realmResource.components().query(componentRepresentation.getParentId(), componentRepresentation.getProviderType(), componentRepresentation.getName()).get(0);
            realmResource.userStorage().syncMapperData(newComponentRepresentation.getParentId(), newComponentRepresentation.getId(), "fedToKeycloak");
            return newComponentRepresentation.getId();
        });
    }

    public static boolean isBuiltInRealmRole(String realmRole) {
        return realmRole.startsWith("default-roles-") || BUILT_IN_REALM_ROLES.contains(realmRole);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

