/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.openremote.container.security.IdentityService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.mqtt.MQTTBrokerService;
import org.openremote.manager.security.ManagerBasicIdentityProvider;
import org.openremote.manager.security.ManagerIdentityProvider;
import org.openremote.manager.security.ManagerKeycloakIdentityProvider;
import org.openremote.manager.security.RealmResourceImpl;
import org.openremote.manager.security.UserResourceImpl;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;

public class ManagerIdentityService
extends IdentityService {
    private static final Logger LOG = Logger.getLogger(ManagerIdentityService.class.getName());
    protected ManagerIdentityProvider identityProvider;

    public void init(Container container) throws Exception {
        super.init(container);
        MQTTBrokerService mqttBrokerService = (MQTTBrokerService)container.getService(MQTTBrokerService.class);
        ManagerWebService managerWebService = (ManagerWebService)container.getService(ManagerWebService.class);
        managerWebService.addApiSingleton((Object)new RealmResourceImpl((TimerService)container.getService(TimerService.class), this, container));
        managerWebService.addApiSingleton((Object)new UserResourceImpl((TimerService)container.getService(TimerService.class), this, mqttBrokerService));
    }

    public ManagerIdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public ManagerIdentityProvider createIdentityProvider(Container container) {
        if (this.identityProvider == null) {
            String identityProviderType = MapAccess.getString((Map)container.getConfig(), (String)"OR_IDENTITY_PROVIDER", (String)"keycloak");
            switch (identityProviderType.toLowerCase(Locale.ROOT)) {
                case "keycloak": {
                    LOG.info("Enabling Keycloak identity provider");
                    this.identityProvider = new ManagerKeycloakIdentityProvider();
                    break;
                }
                case "basic": {
                    LOG.info("Enabling basic identity provider");
                    this.identityProvider = new ManagerBasicIdentityProvider();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown identity provider: " + identityProviderType);
                }
            }
        }
        return this.identityProvider;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{identityProvider=" + String.valueOf(this.identityProvider) + "}";
    }
}

