/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.security.AuthContext;
import org.openremote.container.security.IdentityProvider;
import org.openremote.model.event.shared.RealmFilter;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Credential;
import org.openremote.model.security.Realm;
import org.openremote.model.security.Role;
import org.openremote.model.security.User;
import org.openremote.model.security.UserAttribute;
import org.openremote.model.util.TextUtil;

public interface ManagerIdentityProvider
extends IdentityProvider {
    public User[] queryUsers(UserQuery var1);

    public User getUser(String var1);

    public User getUserByUsername(String var1, String var2);

    public User createUpdateUser(String var1, User var2, String var3, boolean var4);

    public void deleteUser(String var1, String var2);

    public void resetPassword(String var1, String var2, Credential var3);

    public String resetSecret(String var1, String var2, String var3);

    public Role[] getClientRoles(String var1, String var2);

    public void updateClientRoles(String var1, String var2, Role[] var3);

    public String[] getUserClientRoles(String var1, String var2, String var3);

    public String[] getUserRealmRoles(String var1, String var2);

    public void updateUserClientRoles(String var1, String var2, String var3, String ... var4);

    public void updateUserRealmRoles(String var1, String var2, String ... var3);

    public boolean isMasterRealmAdmin(String var1);

    public boolean isRestrictedUser(AuthContext var1);

    public boolean isUserInRealm(String var1, String var2);

    public Realm[] getRealms();

    public Realm getRealm(String var1);

    public void updateRealm(Realm var1);

    public Realm createRealm(Realm var1);

    public void deleteRealm(String var1);

    public boolean isRealmActiveAndAccessible(AuthContext var1, Realm var2);

    public boolean isRealmActiveAndAccessible(AuthContext var1, String var2);

    public boolean realmExists(String var1);

    public boolean canSubscribeWith(AuthContext var1, RealmFilter<?> var2, ClientRole ... var3);

    public String getFrontendURI();

    default public String[] addUserRealmRoles(String realm, String userId, String ... roles) {
        ArrayList<String> existingRoles = new ArrayList<String>(Arrays.asList(this.getUserRealmRoles(realm, userId)));
        existingRoles.addAll(Arrays.asList(roles));
        return existingRoles.toArray(new String[0]);
    }

    public static User[] getUsersFromDb(PersistenceService persistenceService, UserQuery query) {
        boolean hasRealmRoles;
        UserQuery userQuery;
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        UserQuery userQuery2 = userQuery = query != null ? query : new UserQuery();
        if (userQuery.serviceUsers != null) {
            if (userQuery.usernames == null) {
                userQuery.usernames = new StringPredicate[1];
                userQuery.usernames(new StringPredicate[]{new StringPredicate(AssetQuery.Match.BEGIN, "service-account-").negate(userQuery.serviceUsers == false)});
            } else {
                (userQuery.usernames = Arrays.copyOf(userQuery.usernames, (int)(userQuery.usernames.length + 1)))[userQuery.usernames.length - 1] = new StringPredicate(AssetQuery.Match.BEGIN, "service-account-").negate(userQuery.serviceUsers == false);
            }
        }
        sb.append("SELECT u.*, (SELECT C.SECRET FROM PUBLIC.CLIENT C WHERE C.ID = SERVICE_ACCOUNT_CLIENT_LINK) as secret, r.name as realm");
        sb.append(" FROM public.user_entity u join PUBLIC.REALM r on r.ID = u.REALM_ID");
        if (userQuery.assets != null || userQuery.pathPredicate != null) {
            sb.append(" join user_asset_link ua on ua.user_id = u.id");
        }
        sb.append(" WHERE TRUE");
        if (userQuery.realmPredicate != null && !TextUtil.isNullOrEmpty((String)userQuery.realmPredicate.name)) {
            sb.append(" AND r.name = ?").append(parameters.size() + 1);
            parameters.add(userQuery.realmPredicate.name);
        }
        if (userQuery.assets != null) {
            sb.append(" AND ua.asset_id IN (?").append(parameters.size() + 1).append(")");
            parameters.add(Arrays.asList(userQuery.assets));
        }
        if (userQuery.pathPredicate != null && userQuery.pathPredicate.path != null && userQuery.pathPredicate.path.length > 0) {
            sb.append(" AND ?").append(parameters.size() + 1).append("\\:\\:text[] <@ get_asset_tree_path(ua.asset_id)");
            parameters.add("{" + String.join((CharSequence)",", userQuery.pathPredicate.path) + "}");
        }
        if (userQuery.ids != null && userQuery.ids.length > 0) {
            sb.append(" AND u.id IN (?").append(parameters.size() + 1).append(")");
            parameters.add(Arrays.asList(userQuery.ids));
        }
        if (userQuery.usernames != null && userQuery.usernames.length > 0) {
            sb.append(" and (FALSE");
            for (StringPredicate pred : userQuery.usernames) {
                int pos = parameters.size() + 1;
                pred.caseSensitive = false;
                sb.append(" or upper(u.username)");
                sb.append(StringPredicate.toSQLParameter((StringPredicate)pred, (int)pos, (boolean)false));
                parameters.add(pred.prepareValue());
            }
            sb.append(")");
        }
        boolean hasClientRoles = userQuery.clientRoles != null && userQuery.clientRoles.length > 0;
        boolean bl = hasRealmRoles = userQuery.realmRoles != null && userQuery.realmRoles.length > 0;
        if (hasClientRoles || hasRealmRoles) {
            sb.append(" and (FALSE");
            BiConsumer<StringPredicate[], Boolean> appendRolePredicates = (rolePredicates, clientRolePredicates) -> Arrays.stream(rolePredicates).forEach(rolePredicate -> {
                sb.append(" OR ");
                if (rolePredicate.negate) {
                    sb.append("NOT ");
                }
                sb.append("EXISTS (SELECT urm.user_id from public.user_role_mapping urm join public.keycloak_role kr on urm.role_id = kr.id where urm.user_id = u.id and ");
                if (!clientRolePredicates.booleanValue()) {
                    sb.append("not ");
                }
                sb.append("kr.client_role and");
                sb.append(rolePredicate.caseSensitive ? " kr.name" : " upper(kr.name)");
                sb.append(StringPredicate.toSQLParameter((StringPredicate)rolePredicate, (int)(parameters.size() + 1), (boolean)rolePredicate.negate));
                parameters.add(rolePredicate.prepareValue());
                sb.append(")");
            });
            if (hasClientRoles) {
                appendRolePredicates.accept(userQuery.clientRoles, true);
            }
            if (hasRealmRoles) {
                appendRolePredicates.accept(userQuery.realmRoles, false);
            }
            sb.append(")");
        }
        if (userQuery.attributes != null && userQuery.attributes.length > 0) {
            sb.append(" AND (TRUE");
            Arrays.stream(userQuery.attributes).forEach(attributePredicate -> {
                sb.append(" AND ");
                if (attributePredicate.negated) {
                    sb.append("NOT ");
                }
                sb.append("EXISTS (SELECT att.user_id from public.user_attribute att where att.user_id = u.id and");
                sb.append(attributePredicate.name.caseSensitive ? " att.name" : " upper(att.name)");
                sb.append(StringPredicate.toSQLParameter((StringPredicate)attributePredicate.name, (int)(parameters.size() + 1), (boolean)attributePredicate.negated));
                parameters.add(attributePredicate.name.prepareValue());
                if (attributePredicate.value != null) {
                    sb.append(" and ");
                    sb.append(attributePredicate.name.caseSensitive ? "att.value" : "upper(att.value)");
                    sb.append(StringPredicate.toSQLParameter((StringPredicate)attributePredicate.value, (int)(parameters.size() + 1), (boolean)attributePredicate.negated));
                    parameters.add(attributePredicate.value.prepareValue());
                }
                sb.append(")");
            });
            sb.append(")");
        }
        if (userQuery.orderBy != null && userQuery.orderBy.property != null) {
            sb.append(" ORDER BY");
            switch (userQuery.orderBy.property) {
                case CREATED_ON: {
                    sb.append(" u.created_on");
                    break;
                }
                case FIRST_NAME: {
                    sb.append(" u.first_name");
                    break;
                }
                case LAST_NAME: {
                    sb.append(" u.last_name");
                    break;
                }
                case USERNAME: {
                    sb.append(" replace(u.username, '").append("service-account-").append("', '')");
                    break;
                }
                case EMAIL: {
                    sb.append(" u.email");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported order by value: " + String.valueOf(userQuery.orderBy.property));
                }
            }
            if (userQuery.orderBy.descending) {
                sb.append(" DESC");
            }
        }
        List users = (List)persistenceService.doReturningTransaction(entityManager -> {
            Query sqlQuery = entityManager.createNativeQuery(sb.toString(), User.class);
            IntStream.rangeClosed(1, parameters.size()).forEach(i -> sqlQuery.setParameter(i, parameters.get(i - 1)));
            if (userQuery.limit != null && userQuery.limit > 0) {
                sqlQuery.setMaxResults(userQuery.limit.intValue());
            }
            if (userQuery.offset != null && userQuery.offset > 0) {
                sqlQuery.setFirstResult(query.offset.intValue());
            }
            List userList = sqlQuery.getResultList();
            return userList;
        });
        if (userQuery.select != null && userQuery.select.basic) {
            users.forEach(user -> {
                user.setAttributes((UserAttribute[])null);
                user.setEmail(null);
                user.setRealmId(null);
                user.setSecret(null);
            });
        }
        return users.toArray(new User[0]);
    }

    public static User getUserByUsernameFromDb(PersistenceService persistenceService, String realm, String username) {
        return (User)persistenceService.doReturningTransaction(em -> {
            List result = em.createQuery("select u from User u where u.realm = :realm and u.username = :username", User.class).setParameter("realm", (Object)realm).setParameter("username", (Object)username).getResultList();
            return result.size() > 0 ? (User)result.get(0) : null;
        });
    }

    public static User getUserByIdFromDb(PersistenceService persistenceService, String userId) {
        return (User)persistenceService.doReturningTransaction(em -> {
            List result = em.createQuery("select u from User u where u.id = :userId", User.class).setParameter("userId", (Object)userId).getResultList();
            return result.size() > 0 ? (User)result.get(0) : null;
        });
    }

    public static List<String> getUserIds(PersistenceService persistenceService, String realm, List<String> usernames) {
        List<String> CIUsernames = usernames.stream().map(String::toLowerCase).toList();
        return (List)persistenceService.doReturningTransaction(em -> {
            Map<String, String> usernameIdMap = em.createQuery("select u.username, u.id from User u join Realm r on r.id = u.realmId where u.username in :usernames and r.name = :realm", Tuple.class).setParameter("usernames", (Object)CIUsernames).setParameter("realm", (Object)realm).getResultList().stream().collect(Collectors.toMap(tuple -> (String)tuple.get(0), tuple -> (String)tuple.get(1)));
            return CIUsernames.stream().map(usernameIdMap::get).collect(Collectors.toList());
        });
    }

    public static Realm[] getRealmsFromDb(PersistenceService persistenceService) {
        return (Realm[])persistenceService.doReturningTransaction(entityManager -> {
            List realms = entityManager.createNativeQuery("select *, (select ra.VALUE from PUBLIC.REALM_ATTRIBUTE ra where ra.REALM_ID = r.ID and ra.name = 'displayName') as displayName from public.realm r  where r.not_before is null or r.not_before = 0 or r.not_before <= extract('epoch' from now())", Realm.class).getResultList();
            realms.sort((o1, o2) -> {
                if (o1.getName().equals("master")) {
                    return -1;
                }
                if (o2.getName().equals("master")) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            });
            return realms.toArray(new Realm[0]);
        });
    }

    public static Realm getRealmFromDb(PersistenceService persistenceService, String name) {
        return (Realm)persistenceService.doReturningTransaction(em -> (Realm)em.createQuery("select r from Realm r where r.name = :realm", Realm.class).setParameter("realm", (Object)name).getSingleResult());
    }

    public static boolean realmExistsFromDb(PersistenceService persistenceService, String realm) {
        return (Boolean)persistenceService.doReturningTransaction(em -> {
            long count = (Long)em.createNativeQuery("select count(*) from public.realm r where r.name = :realm and r.enabled = true and (r.not_before is null or r.not_before = 0 or r.not_before <= extract('epoch' from now()))", Long.class).setParameter("realm", (Object)realm).getSingleResult();
            return count > 0L;
        });
    }

    public static boolean userInRealmFromDb(PersistenceService persistenceService, String userId, String realm) {
        return (Boolean)persistenceService.doReturningTransaction(em -> {
            User user = (User)em.find(User.class, (Object)userId);
            return user != null && realm.equals(user.getRealm());
        });
    }
}

