/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import java.sql.PreparedStatement;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.openremote.container.security.AuthContext;
import org.openremote.container.security.basic.BasicIdentityProvider;
import org.openremote.container.security.basic.PasswordStorage;
import org.openremote.manager.security.ManagerIdentityProvider;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.event.shared.RealmFilter;
import org.openremote.model.query.UserQuery;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Credential;
import org.openremote.model.security.Realm;
import org.openremote.model.security.Role;
import org.openremote.model.security.User;
import org.openremote.model.util.TextUtil;

public class ManagerBasicIdentityProvider
extends BasicIdentityProvider
implements ManagerIdentityProvider {
    private static final Logger LOG = Logger.getLogger(ManagerBasicIdentityProvider.class.getName());
    protected ManagerIdentityService identityService;
    protected String adminPassword;

    public void init(Container container) {
        super.init(container);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.adminPassword = container.getConfig().getOrDefault("OR_ADMIN_PASSWORD", "secret");
    }

    public void start(Container container) {
        super.start(container);
        if (!this.realmExists("master")) {
            LOG.info("Creating master realm and admin user");
            this.persistenceService.doTransaction(em -> ((Session)em.unwrap(Session.class)).doWork(connection -> {
                String sql = "insert into PUBLIC.REALM(ID, NAME, ENABLED) values ('master', 'master', true)";
                PreparedStatement st = connection.prepareStatement(sql);
                st.executeUpdate();
                st.close();
                sql = "insert into PUBLIC.REALM_ATTRIBUTE(REALM_ID, NAME, VALUE) values ('master', 'displayName', 'Master')";
                st = connection.prepareStatement(sql);
                st.executeUpdate();
                st.close();
            }));
            User adminUser = new User();
            adminUser.setUsername("admin");
            this.createUpdateUser("master", adminUser, this.adminPassword, true);
        }
    }

    protected Set<String> getDefaultRoles() {
        return ClientRole.ALL_ROLES;
    }

    @Override
    public User[] queryUsers(UserQuery userQuery) {
        return ManagerIdentityProvider.getUsersFromDb(this.persistenceService, userQuery);
    }

    @Override
    public User getUser(String userId) {
        return ManagerIdentityProvider.getUserByIdFromDb(this.persistenceService, userId);
    }

    @Override
    public User getUserByUsername(String realm, String username) {
        return ManagerIdentityProvider.getUserByUsernameFromDb(this.persistenceService, realm, username);
    }

    @Override
    public User createUpdateUser(String realm, User user, String password, boolean allowUpdate) {
        if (!realm.equals("master")) {
            throw new UnsupportedOperationException("This provider does not support realms other than master");
        }
        if (TextUtil.isNullOrEmpty((String)password)) {
            throw new IllegalStateException("Password must be specified for basic identity provider");
        }
        LOG.info("Creating user: " + String.valueOf(user));
        user.setId(UUID.randomUUID().toString());
        this.persistenceService.doTransaction(em -> ((Session)em.unwrap(Session.class)).doWork(connection -> {
            Object sql = "insert into PUBLIC.USER_ENTITY(ID, REALM_ID, USERNAME, PASSWORD, FIRST_NAME, LAST_NAME, EMAIL, ENABLED) values (?, ?, ?, ?, ?, ?, ?, ?)";
            if (allowUpdate) {
                sql = (String)sql + " ON CONFLICT (ID, USERNAME) DO UPDATE";
            }
            sql = (String)sql + " SET username = excluded.username, password = excluded.password, first_name = excluded.first_name, last_name = excluded.last_name, email = excluded.email, enabled = excluded.enabled";
            try (PreparedStatement st = connection.prepareStatement((String)sql);){
                st.setString(1, UUID.randomUUID().toString());
                st.setString(2, "master");
                st.setString(3, user.getUsername());
                st.setString(4, PasswordStorage.createHash((String)password));
                st.setString(5, user.getFirstName());
                st.setString(6, user.getLastName());
                st.setString(7, user.getEmail());
                st.setBoolean(8, user.getEnabled() != null ? user.getEnabled() : true);
                st.executeUpdate();
            }
        }));
        return user;
    }

    @Override
    public void deleteUser(String realm, String userId) {
        LOG.info("Deleting user: " + userId);
        this.persistenceService.doTransaction(em -> {
            User user = (User)em.find(User.class, (Object)userId);
            if (user != null) {
                em.remove((Object)user);
            } else {
                LOG.info("Cannot delete user as ID not found: " + userId);
            }
        });
    }

    @Override
    public void resetPassword(String realm, String userId, Credential credential) {
        throw new UnsupportedOperationException("This provider does not support password reset");
    }

    @Override
    public String resetSecret(String realm, String userId, String secret) {
        throw new UnsupportedOperationException("This provider does not support secret reset");
    }

    @Override
    public Role[] getClientRoles(String realm, String client) {
        if (client != null && !"master".equals(client)) {
            throw new IllegalStateException("This provider only has a single master realm");
        }
        return (Role[])ClientRole.ALL_ROLES.stream().map(role -> new Role(UUID.randomUUID().toString(), role, false, Boolean.valueOf(true), null)).toArray(Role[]::new);
    }

    @Override
    public void updateClientRoles(String realm, String client, Role[] roles) {
        throw new UnsupportedOperationException("This provider does not support updating roles");
    }

    @Override
    public String[] getUserClientRoles(String realm, String userId, String client) {
        if ("openremote".equals(client)) {
            return ClientRole.ALL_ROLES.toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public String[] getUserRealmRoles(String realm, String userId) {
        throw new UnsupportedOperationException("This provider does not support user realm roles");
    }

    @Override
    public void updateUserClientRoles(String realm, String userId, String client, String ... roles) {
        throw new UnsupportedOperationException("This provider does not support updating user roles");
    }

    @Override
    public void updateUserRealmRoles(String realm, String userId, String ... roles) {
        throw new UnsupportedOperationException("This provider does not support updating user realm roles");
    }

    @Override
    public boolean isMasterRealmAdmin(String userId) {
        return true;
    }

    @Override
    public boolean isRestrictedUser(AuthContext authContext) {
        return false;
    }

    @Override
    public boolean isUserInRealm(String userId, String realm) {
        return ManagerIdentityProvider.userInRealmFromDb(this.persistenceService, userId, realm);
    }

    @Override
    public Realm[] getRealms() {
        return ManagerIdentityProvider.getRealmsFromDb(this.persistenceService);
    }

    @Override
    public Realm getRealm(String realm) {
        return ManagerIdentityProvider.getRealmFromDb(this.persistenceService, realm);
    }

    @Override
    public void updateRealm(Realm realm) {
        throw new UnsupportedOperationException("This provider does not support modifying realms");
    }

    @Override
    public Realm createRealm(Realm realm) {
        throw new UnsupportedOperationException("This provider does not support multiple realms");
    }

    @Override
    public void deleteRealm(String realm) {
        throw new UnsupportedOperationException("This provider does not support multiple realms");
    }

    @Override
    public boolean isRealmActiveAndAccessible(AuthContext authContext, Realm realm) {
        return Objects.equals(realm.getId(), "master");
    }

    @Override
    public boolean isRealmActiveAndAccessible(AuthContext authContext, String realm) {
        return Objects.equals(realm, "master");
    }

    @Override
    public boolean realmExists(String realm) {
        return ManagerIdentityProvider.realmExistsFromDb(this.persistenceService, realm);
    }

    @Override
    public boolean canSubscribeWith(AuthContext auth, RealmFilter<?> filter, ClientRole ... requiredRoles) {
        return auth.isSuperUser();
    }

    @Override
    public String getFrontendURI() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

