/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ComponentRepresentation;

public class LDAPComponentBuilder {
    private String name;
    private ProviderId providerId;
    private String parentId;
    private ProviderType providerType;
    private MultivaluedHashMap<String, String> ldapConfig = new MultivaluedHashMap();

    public LDAPComponentBuilder setProviderType(ProviderType providerType) {
        this.providerType = providerType;
        return this;
    }

    public LDAPComponentBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LDAPComponentBuilder setProviderId(ProviderId providerId) {
        this.providerId = providerId;
        return this;
    }

    public LDAPComponentBuilder setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public LDAPComponentBuilder setVendor(Vendor vendor) {
        this.ldapConfig.add((Object)"vendor", (Object)vendor.toString());
        return this;
    }

    public LDAPComponentBuilder setEditMode(EditMode editMode) {
        this.ldapConfig.add((Object)"editMode", (Object)editMode.toString());
        return this;
    }

    public LDAPComponentBuilder setUserNameLDAPAttribute(String usernameLDAPAttribute) {
        this.ldapConfig.add((Object)"usernameLDAPAttribute", (Object)usernameLDAPAttribute);
        return this;
    }

    public LDAPComponentBuilder setRDNLDAPAttribute(String rdnLDAPAttribute) {
        this.ldapConfig.add((Object)"rdnLDAPAttribute", (Object)rdnLDAPAttribute);
        return this;
    }

    public LDAPComponentBuilder setUUIDLDAPAttribute(String uuidLDAPAttribute) {
        this.ldapConfig.add((Object)"uuidLDAPAttribute", (Object)uuidLDAPAttribute);
        return this;
    }

    public LDAPComponentBuilder setUserObjectClasses(String userObjectClasses) {
        this.ldapConfig.add((Object)"userObjectClasses", (Object)userObjectClasses);
        return this;
    }

    public LDAPComponentBuilder setConnectionUrl(String connectionUrl) {
        this.ldapConfig.add((Object)"connectionUrl", (Object)connectionUrl);
        return this;
    }

    public LDAPComponentBuilder setUsersDn(String usersDn) {
        this.ldapConfig.add((Object)"usersDn", (Object)usersDn);
        return this;
    }

    public LDAPComponentBuilder setAuthType(AuthType authType) {
        this.ldapConfig.add((Object)"authType", (Object)authType.toString());
        return this;
    }

    public LDAPComponentBuilder setBindDn(String bindDn) {
        this.ldapConfig.add((Object)"bindDn", (Object)bindDn);
        return this;
    }

    public LDAPComponentBuilder setBindCredential(String bindCredential) {
        this.ldapConfig.add((Object)"bindCredential", (Object)bindCredential);
        return this;
    }

    public LDAPComponentBuilder setCustomUserSearchFilter(String customUserSearchFilter) {
        this.ldapConfig.add((Object)"customUserSearchFilter", (Object)customUserSearchFilter);
        return this;
    }

    public LDAPComponentBuilder setSearchScope(int searchScope) {
        this.ldapConfig.add((Object)"searchScope", (Object)String.valueOf(searchScope));
        return this;
    }

    public LDAPComponentBuilder setUseTrustStoreSPI(UseTrustStoreSpi useTruststoreSpi) {
        this.ldapConfig.add((Object)"useTruststoreSpi", (Object)useTruststoreSpi.toString());
        return this;
    }

    public LDAPComponentBuilder setConnectionPooling(boolean connectionPooling) {
        this.ldapConfig.add((Object)"connectionPooling", (Object)String.valueOf(connectionPooling));
        return this;
    }

    public LDAPComponentBuilder setPagination(boolean pagination) {
        this.ldapConfig.add((Object)"pagination", (Object)String.valueOf(pagination));
        return this;
    }

    public LDAPComponentBuilder setBatchSizeForSync(int batchSizeForSync) {
        this.ldapConfig.add((Object)"batchSizeForSync", (Object)String.valueOf(batchSizeForSync));
        return this;
    }

    public LDAPComponentBuilder setFullSyncPeriod(int periodInSeconds) {
        this.ldapConfig.add((Object)"fullSyncPeriod", (Object)String.valueOf(periodInSeconds));
        return this;
    }

    public LDAPComponentBuilder setChangedSyncPeriod(int periodInSeconds) {
        this.ldapConfig.add((Object)"changedSyncPeriod", (Object)String.valueOf(periodInSeconds));
        return this;
    }

    public LDAPComponentBuilder setAllowKerberosAuthentication(boolean allowKerberosAuthentication) {
        this.ldapConfig.add((Object)"allowKerberosAuthentication", (Object)String.valueOf(allowKerberosAuthentication));
        return this;
    }

    public LDAPComponentBuilder setKerberosServerPrincipal(String kerberosServerPrincipal) {
        this.ldapConfig.add((Object)"serverPrincipal", (Object)kerberosServerPrincipal);
        return this;
    }

    public LDAPComponentBuilder setUseKerberosForPasswordAuthentication(boolean useKerberosForPasswordAuthentication) {
        this.ldapConfig.add((Object)"useKerberosForPasswordAuthentication", (Object)String.valueOf(useKerberosForPasswordAuthentication));
        return this;
    }

    public LDAPComponentBuilder setKerberosKeyTabPath(String kerberosKeyTabPath) {
        this.ldapConfig.add((Object)"keyTab", (Object)kerberosKeyTabPath);
        return this;
    }

    public LDAPComponentBuilder setKerberosRealm(String kerberosRealm) {
        this.ldapConfig.add((Object)"kerberosRealm", (Object)kerberosRealm);
        return this;
    }

    public LDAPComponentBuilder setDebug(boolean debug) {
        this.ldapConfig.add((Object)"debug", (Object)String.valueOf(debug));
        return this;
    }

    public LDAPComponentBuilder setPriority(int priority) {
        this.ldapConfig.add((Object)"priority", (Object)String.valueOf(priority));
        return this;
    }

    public LDAPComponentBuilder setClientId(String clientId) {
        this.ldapConfig.add((Object)"client.id", (Object)clientId);
        return this;
    }

    public LDAPComponentBuilder setMemberShipAttributeType(MemberShipAttributeType memberShipAttributeType) {
        this.ldapConfig.add((Object)"membership.attribute.type", (Object)memberShipAttributeType.toString());
        return this;
    }

    public LDAPComponentBuilder setMemberShipLDAPAttribute(String ldapAttribute) {
        this.ldapConfig.add((Object)"membership.ldap.attribute", (Object)ldapAttribute);
        return this;
    }

    public LDAPComponentBuilder setMemberShipUserLDAPAttribute(String userLDAPAttribute) {
        this.ldapConfig.add((Object)"membership.user.ldap.attribute", (Object)userLDAPAttribute);
        return this;
    }

    public LDAPComponentBuilder setRoleNameLDAPAttribute(String nameLDAPAttribute) {
        this.ldapConfig.add((Object)"role.name.ldap.attribute", (Object)nameLDAPAttribute);
        return this;
    }

    public LDAPComponentBuilder setRoleObjectClasses(String roleObjectClasses) {
        this.ldapConfig.add((Object)"role.object.classes", (Object)roleObjectClasses);
        return this;
    }

    public LDAPComponentBuilder setRolesDn(String rolesDn) {
        this.ldapConfig.add((Object)"roles.dn", (Object)rolesDn);
        return this;
    }

    public LDAPComponentBuilder setUseRealmsRoleMapping(boolean useRealmsRoleMapping) {
        this.ldapConfig.add((Object)"use.realm.roles.mapping", (Object)String.valueOf(useRealmsRoleMapping));
        return this;
    }

    public LDAPComponentBuilder setMapperMode(MapperMode mapperMode) {
        this.ldapConfig.add((Object)"mode", (Object)mapperMode.toString());
        return this;
    }

    public LDAPComponentBuilder setUserRolesRetrieveStrategy(UserRolesRetrieveStrategy userRolesRetrieveStrategy) {
        this.ldapConfig.add((Object)"user.roles.retrieve.strategy", (Object)userRolesRetrieveStrategy.toString());
        return this;
    }

    public LDAPComponentBuilder setRolesLDAPFilter(String filter) {
        this.ldapConfig.add((Object)"roles.ldap.filter", (Object)filter);
        return this;
    }

    public LDAPComponentBuilder setGroupNameLDAPAttribute(String groupNameLDAPAttribute) {
        this.ldapConfig.add((Object)"group.name.ldap.attribute", (Object)groupNameLDAPAttribute);
        return this;
    }

    public LDAPComponentBuilder setGroupObjectClasses(String groupObjectClasses) {
        this.ldapConfig.add((Object)"group.object.classes", (Object)groupObjectClasses);
        return this;
    }

    public LDAPComponentBuilder setGroupsDn(String groupsDn) {
        this.ldapConfig.add((Object)"groups.dn", (Object)groupsDn);
        return this;
    }

    public LDAPComponentBuilder setPreserveGroupInheritance(boolean preserveGroupInheritance) {
        this.ldapConfig.add((Object)"preserve.group.inheritance", (Object)String.valueOf(preserveGroupInheritance));
        return this;
    }

    public LDAPComponentBuilder setDropNonExistingGroupsDuringSync(boolean dropNonExistingGroupsDuringSync) {
        this.ldapConfig.add((Object)"drop.non.existing.groups.during.sync", (Object)String.valueOf(dropNonExistingGroupsDuringSync));
        return this;
    }

    public LDAPComponentBuilder setGroupsLDAPFilter(String filter) {
        this.ldapConfig.add((Object)"groups.ldap.filter", (Object)filter);
        return this;
    }

    public ComponentRepresentation build() {
        ComponentRepresentation componentRepresentation = new ComponentRepresentation();
        componentRepresentation.setName(this.name);
        componentRepresentation.setParentId(this.parentId);
        componentRepresentation.setProviderType(this.providerType.toString());
        componentRepresentation.setProviderId(this.providerId.toString());
        componentRepresentation.setConfig(this.ldapConfig);
        return componentRepresentation;
    }

    public static enum ProviderType {
        USER_STORAGE_PROVIDER_TYPE("org.keycloak.storage.UserStorageProvider"),
        LDAP_STORAGE_MAPPER_TYPE("org.keycloak.storage.ldap.mappers.LDAPStorageMapper");

        private String value;

        private ProviderType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ProviderId {
        LDAP_PROVIDER("ldap"),
        LDAP_ROLE_PROVIDER("role-ldap-mapper"),
        LDAP_GROUP_PROVIDER("group-ldap-mapper");

        private String value;

        private ProviderId(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public class LDAPConstants {
        public static final String VENDOR = "vendor";
        public static final String USERNAME_LDAP_ATTRIBUTE = "usernameLDAPAttribute";
        public static final String RDN_LDAP_ATTRIBUTE = "rdnLDAPAttribute";
        public static final String UUID_LDAP_ATTRIBUTE = "uuidLDAPAttribute";
        public static final String USER_OBJECT_CLASSES = "userObjectClasses";
        public static final String UID = "uid";
        public static final String CN = "cn";
        public static final String OBJECT_GUID = "objectGUID";
        public static final String CONNECTION_URL = "connectionUrl";
        public static final String USERS_DN = "usersDn";
        public static final String BIND_DN = "bindDn";
        public static final String BIND_CREDENTIAL = "bindCredential";
        public static final String AUTH_TYPE = "authType";
        public static final String USE_TRUSTSTORE_SPI = "useTruststoreSpi";
        public static final String SEARCH_SCOPE = "searchScope";
        public static final String CONNECTION_POOLING = "connectionPooling";
        public static final String PAGINATION = "pagination";
        public static final String EDIT_MODE = "editMode";
        public static final String BATCH_SIZE_FOR_SYNC = "batchSizeForSync";
        public static final String CUSTOM_USER_SEARCH_FILTER = "customUserSearchFilter";

        public LDAPConstants(LDAPComponentBuilder this$0) {
        }
    }

    public static enum Vendor {
        AD("ad"),
        RHDS("rhds"),
        TIVOLI("tivoli"),
        NOVELL_EDIRECTORY("edirectory"),
        OTHER("other");

        private String value;

        private Vendor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EditMode {
        READ_ONLY,
        WRITEABLE,
        UNSYNCED;

    }

    public static enum AuthType {
        NONE("none"),
        SIMPLE("simple");

        private String value;

        private AuthType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum UseTrustStoreSpi {
        ALWAYS("always"),
        NEVER("never"),
        LDAPS_ONLY("ldapsOnly");

        private String value;

        private UseTrustStoreSpi(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum MemberShipAttributeType {
        UID,
        DN;

    }

    public static enum MapperMode {
        LDAP_ONLY,
        IMPORT,
        READ_ONLY;

    }

    public static enum UserRolesRetrieveStrategy {
        LOAD_ROLES_BY_MEMBER_ATTRIBUTE,
        GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE,
        LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY,
        LOAD_GROUPS_BY_MEMBER_ATTRIBUTE,
        GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE,
        LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY;

    }
}

