/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.security;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.openremote.agent.protocol.mqtt.CustomKeyManagerFactory;
import org.openremote.agent.protocol.mqtt.CustomX509TrustManagerFactory;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.security.KeyStoreService;

public class KeyStoreServiceImpl
implements KeyStoreService {
    protected PersistenceService persistenceService;
    protected ManagerIdentityService identityService;
    private KeyStore keyStore = null;
    private KeyStore trustStore = null;
    private static final String OR_SSL_CLIENT_KEYSTORE_FILE = "OR_SSL_CLIENT_KEYSTORE_FILE";
    private static final String OR_SSL_CLIENT_TRUSTSTORE_FILE = "OR_SSL_CLIENT_TRUSTSTORE_FILE";
    private static final String OR_SSL_CLIENT_KEYSTORE_PASSWORD = "OR_SSL_CLIENT_KEYSTORE_PASSWORD";
    private static final String OR_SSL_CLIENT_TRUSTSTORE_PASSWORD = "OR_SSL_CLIENT_TRUSTSTORE_PASSWORD";
    private static final String OR_KEYSTORE_PASSWORD = "OR_KEYSTORE_PASSWORD";
    protected Path keyStorePath;
    protected Path trustStorePath;
    private String keyStorePassword;

    public int getPriority() {
        return -2147483528;
    }

    public void init(Container container) throws Exception {
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        String defaultPassword = MapAccess.getString((Map)container.getConfig(), (String)"OR_ADMIN_PASSWORD", (String)"secret");
        this.keyStorePassword = MapAccess.getString((Map)container.getConfig(), (String)OR_KEYSTORE_PASSWORD, (String)defaultPassword);
    }

    public void start(Container container) throws Exception {
        String keyStoreEnv = MapAccess.getString((Map)container.getConfig(), (String)OR_SSL_CLIENT_KEYSTORE_FILE, null);
        String trustStoreEnv = MapAccess.getString((Map)container.getConfig(), (String)OR_SSL_CLIENT_TRUSTSTORE_FILE, null);
        Optional keyStorePath = keyStoreEnv != null ? Optional.of(Paths.get(keyStoreEnv, new String[0])) : Optional.empty();
        Optional trustStorePath = trustStoreEnv != null ? Optional.of(Paths.get(trustStoreEnv, new String[0])) : Optional.empty();
        String keyStorePassword = MapAccess.getString((Map)container.getConfig(), (String)OR_SSL_CLIENT_KEYSTORE_PASSWORD, (String)String.valueOf(this.getKeyStorePassword()));
        String trustStorePassword = MapAccess.getString((Map)container.getConfig(), (String)OR_SSL_CLIENT_TRUSTSTORE_PASSWORD, (String)String.valueOf(this.getKeyStorePassword()));
        if (keyStorePath.isPresent()) {
            this.keyStore = KeyStore.getInstance(((Path)keyStorePath.get()).toFile(), keyStorePassword.toCharArray());
        } else {
            Path defaultKeyStorePath = this.persistenceService.resolvePath(Paths.get("keystores", new String[0]).resolve("client_keystore.p12"));
            if (new File(defaultKeyStorePath.toUri()).exists()) {
                this.keyStorePath = defaultKeyStorePath;
                this.keyStore = KeyStore.getInstance(new File(defaultKeyStorePath.toUri()), this.getKeyStorePassword());
            } else {
                this.keyStore = this.createKeyStore(defaultKeyStorePath);
            }
            this.keyStorePath = defaultKeyStorePath;
        }
        if (trustStorePath.isPresent()) {
            this.trustStore = KeyStore.getInstance(((Path)trustStorePath.get()).toFile(), trustStorePassword.toCharArray());
        } else {
            Path defaultTrustStorePath = this.persistenceService.resolvePath(Paths.get("keystores", new String[0]).resolve("client_truststore.p12"));
            if (new File(defaultTrustStorePath.toUri()).exists()) {
                this.trustStorePath = defaultTrustStorePath;
                this.trustStore = KeyStore.getInstance(new File(defaultTrustStorePath.toUri()), this.getKeyStorePassword());
            } else {
                this.trustStore = this.createKeyStore(defaultTrustStorePath);
            }
            this.trustStorePath = defaultTrustStorePath;
        }
    }

    private KeyStore getKeyStore() {
        try {
            return KeyStore.getInstance(this.keyStorePath.toAbsolutePath().toFile(), this.getKeyStorePassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore getTrustStore() {
        try {
            return KeyStore.getInstance(this.trustStorePath.toAbsolutePath().toFile(), this.getKeyStorePassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void storeKeyStore(KeyStore keystore) {
        try {
            this.keyStore = keystore;
            keystore.store(new FileOutputStream(this.keyStorePath.toFile()), this.getKeyStorePassword());
        }
        catch (Exception saveException) {
            this.getLogger().severe("Couldn't store KeyStore to Storage! " + saveException.getMessage());
        }
    }

    private void storeTrustStore(KeyStore truststore) {
        try {
            this.trustStore = truststore;
            truststore.store(new FileOutputStream(this.trustStorePath.toFile()), this.getKeyStorePassword());
        }
        catch (Exception saveException) {
            this.getLogger().severe("Couldn't store TrustStore to Storage! " + saveException.getMessage());
        }
    }

    private char[] getKeyStorePassword() {
        return this.keyStorePassword.toCharArray();
    }

    public KeyManagerFactory getKeyManagerFactory(String alias) throws Exception {
        CustomKeyManagerFactory keyManagerFactory = new CustomKeyManagerFactory(alias);
        try {
            keyManagerFactory.init(this.keyStore, this.getKeyStorePassword());
        }
        catch (Exception e) {
            throw new Exception("Could not retrieve KeyManagerFactory: " + e.getMessage());
        }
        return keyManagerFactory;
    }

    public TrustManagerFactory getTrustManagerFactory() throws Exception {
        CustomX509TrustManagerFactory tmf = new CustomX509TrustManagerFactory(new KeyStore[]{this.trustStore, null});
        try {
            tmf.init((KeyStore)null);
        }
        catch (Exception e) {
            throw new Exception("Could not retrieve KeyManagerFactory: " + e.getMessage());
        }
        return tmf;
    }

    protected KeyStore createKeyStore(Path path) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null, this.getKeyStorePassword());
        File keyStoreFile = path.toAbsolutePath().toFile();
        if (keyStoreFile.getParentFile() != null && !keyStoreFile.getParentFile().exists()) {
            keyStoreFile.getParentFile().mkdirs();
        }
        keyStoreFile.createNewFile();
        try (FileOutputStream os = new FileOutputStream(keyStoreFile);){
            keystore.store(os, this.getKeyStorePassword());
        }
        catch (Exception saveException) {
            this.getLogger().severe("Couldn't store KeyStore to Storage! " + saveException.getMessage());
            throw saveException;
        }
        return keystore;
    }

    public void stop(Container container) throws Exception {
    }

    private Logger getLogger() {
        return LOG;
    }
}

