/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.geofence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.notification.NotificationService;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.geofence.GeofenceAssetAdapter;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetResource;
import org.openremote.model.asset.impl.ConsoleAsset;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.console.ConsoleProvider;
import org.openremote.model.notification.AbstractNotificationMessage;
import org.openremote.model.notification.Notification;
import org.openremote.model.notification.PushNotificationMessage;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.filter.AttributePredicate;
import org.openremote.model.query.filter.GeofencePredicate;
import org.openremote.model.query.filter.NameValuePredicate;
import org.openremote.model.query.filter.RadialGeofencePredicate;
import org.openremote.model.query.filter.ValueEmptyPredicate;
import org.openremote.model.query.filter.ValuePredicate;
import org.openremote.model.rules.geofence.GeofenceDefinition;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.value.NameHolder;

public class ORConsoleGeofenceAssetAdapter
extends RouteBuilder
implements GeofenceAssetAdapter {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.RULES, (String)ORConsoleGeofenceAssetAdapter.class.getName());
    public static final String NAME = "ORConsole";
    public static int NOTIFY_ASSETS_DEBOUNCE_MILLIS = 60000;
    public static int NOTIFY_ASSETS_BATCH_MILLIS = 10000;
    protected Map<String, RulesEngine.AssetLocationPredicates> assetLocationPredicatesMap = new HashMap<String, RulesEngine.AssetLocationPredicates>();
    protected NotificationService notificationService;
    protected AssetStorageService assetStorageService;
    protected GatewayService gatewayService;
    protected ManagerIdentityService identityService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected ConcurrentMap<String, String> consoleIdRealmMap = new ConcurrentHashMap<String, String>();
    protected ScheduledFuture<?> notifyAssetsScheduledFuture;
    protected final Set<String> notifyAssets = new HashSet<String>();

    public int getPriority() {
        return 2147482847;
    }

    public void init(Container container) throws Exception {
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.notificationService = (NotificationService)container.getService(NotificationService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.scheduledExecutorService = container.getScheduledExecutor();
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
    }

    public void start(Container container) throws Exception {
        this.assetStorageService.findAll(new AssetQuery().select(new AssetQuery.Select().attributes(new String[]{ConsoleAsset.CONSOLE_PROVIDERS.getName()})).types(ConsoleAsset.class).attributes(new AttributePredicate[]{new AttributePredicate((NameHolder)ConsoleAsset.CONSOLE_PROVIDERS, (ValuePredicate)new ValueEmptyPredicate().negate(true), false, new NameValuePredicate.Path(new String[]{"geofence"}))})).stream().map(asset -> (ConsoleAsset)asset).filter(ORConsoleGeofenceAssetAdapter::isLinkedToORConsoleGeofenceAdapter).forEach(asset -> this.consoleIdRealmMap.put(asset.getId(), asset.getRealm()));
    }

    public void stop(Container container) throws Exception {
    }

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-GeofenceAdapterConsoleAsset").filter(PersistenceService.isPersistenceEventForEntityType(ConsoleAsset.class)).filter(GatewayService.isNotForGateway(this.gatewayService)).process(exchange -> {
            PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
            this.processConsoleAssetChange((PersistenceEvent<ConsoleAsset>)persistenceEvent);
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLocationPredicates(List<RulesEngine.AssetLocationPredicates> modifiedAssetLocationPredicates) {
        AtomicBoolean notifierDebounce = new AtomicBoolean(false);
        Set<String> set = this.notifyAssets;
        synchronized (set) {
            modifiedAssetLocationPredicates.removeIf(assetStateLocationPredicates -> {
                boolean remove = this.consoleIdRealmMap.containsKey(assetStateLocationPredicates.getAssetId());
                if (remove) {
                    assetStateLocationPredicates.getLocationPredicates().removeIf(locationPredicate -> !(locationPredicate instanceof RadialGeofencePredicate));
                    RulesEngine.AssetLocationPredicates existingPredicates = this.assetLocationPredicatesMap.get(assetStateLocationPredicates.getAssetId());
                    if (existingPredicates == null || !existingPredicates.getLocationPredicates().equals(assetStateLocationPredicates.getLocationPredicates())) {
                        this.notifyAssets.add(assetStateLocationPredicates.getAssetId());
                        notifierDebounce.set(true);
                    }
                    if (assetStateLocationPredicates.getLocationPredicates().isEmpty()) {
                        if (this.assetLocationPredicatesMap.remove(assetStateLocationPredicates.getAssetId()) != null) {
                            LOG.fine("Clearing location predicates for asset: " + assetStateLocationPredicates.getAssetId());
                            this.notifyAssets.add(assetStateLocationPredicates.getAssetId());
                            notifierDebounce.set(true);
                        }
                    } else {
                        LOG.fine("Setting " + assetStateLocationPredicates.getLocationPredicates().size() + " location predicate(s) for asset: " + assetStateLocationPredicates.getAssetId());
                        this.assetLocationPredicatesMap.put(assetStateLocationPredicates.getAssetId(), (RulesEngine.AssetLocationPredicates)assetStateLocationPredicates);
                    }
                } else if (this.assetLocationPredicatesMap.remove(assetStateLocationPredicates.getAssetId()) != null) {
                    LOG.fine("Clearing location predicates for asset: " + assetStateLocationPredicates.getAssetId());
                    this.notifyAssets.add(assetStateLocationPredicates.getAssetId());
                    notifierDebounce.set(true);
                }
                return remove;
            });
            if (notifierDebounce.get() && (this.notifyAssetsScheduledFuture == null || this.notifyAssetsScheduledFuture.cancel(false))) {
                this.notifyAssetsScheduledFuture = this.scheduledExecutorService.schedule(() -> {
                    Set<String> set = this.notifyAssets;
                    synchronized (set) {
                        this.notifyAssetGeofencesChanged(this.notifyAssets);
                        this.notifyAssets.clear();
                        this.notifyAssetsScheduledFuture = null;
                    }
                }, (long)NOTIFY_ASSETS_DEBOUNCE_MILLIS, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public GeofenceDefinition[] getAssetGeofences(String assetId) {
        String realm = (String)this.consoleIdRealmMap.get(assetId);
        if (realm == null) {
            LOG.fine("Console ID not found in map so cannot retrieve geofences");
            return null;
        }
        RulesEngine.AssetLocationPredicates assetStateLocationPredicates = this.assetLocationPredicatesMap.get(assetId);
        if (assetStateLocationPredicates == null) {
            LOG.finest("Request for console '" + assetId + "' geofences: 0 found");
            return new GeofenceDefinition[0];
        }
        GeofenceDefinition[] geofences = (GeofenceDefinition[])assetStateLocationPredicates.getLocationPredicates().stream().map(locationPredicate -> this.locationPredicateToGeofenceDefinition(assetStateLocationPredicates.getAssetId(), (GeofencePredicate)locationPredicate)).toArray(GeofenceDefinition[]::new);
        LOG.finest("Request for console '" + assetId + "' geofences: " + geofences.length + " found");
        return geofences;
    }

    protected GeofenceDefinition locationPredicateToGeofenceDefinition(String assetId, GeofencePredicate geofencePredicate) {
        RadialGeofencePredicate radialLocationPredicate = (RadialGeofencePredicate)geofencePredicate;
        String id = assetId + "_" + radialLocationPredicate.hashCode();
        String url = AssetResource.Util.getWriteAttributeUrl((AttributeRef)new AttributeRef(assetId, Asset.LOCATION.getName()));
        return new GeofenceDefinition(id, radialLocationPredicate.getLat(), radialLocationPredicate.getLng(), radialLocationPredicate.getRadius(), "PUT", url);
    }

    protected void notifyAssetGeofencesChanged(Set<String> assetIds) {
        if (assetIds == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(assetIds);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("action", "GEOFENCE_REFRESH");
        int rows = (int)Math.ceil((float)ids.size() / 10.0f);
        IntStream.range(0, rows).forEach(i -> {
            List subTargets = ids.subList(10 * i, Math.min(10 + 10 * i, ids.size())).stream().map(id -> new Notification.Target(Notification.TargetType.ASSET, id)).collect(Collectors.toList());
            Notification notification = new Notification("GeofenceRefresh", (AbstractNotificationMessage)new PushNotificationMessage().setData(data), null, null, null);
            notification.setTargets(subTargets);
            this.scheduledExecutorService.schedule(() -> {
                LOG.fine("Notifying consoles that geofences have changed: " + String.valueOf(notification.getTargets()));
                this.notificationService.sendNotification(notification);
            }, (long)i * (long)NOTIFY_ASSETS_BATCH_MILLIS, TimeUnit.MILLISECONDS);
        });
    }

    protected void processConsoleAssetChange(PersistenceEvent<ConsoleAsset> persistenceEvent) {
        ConsoleAsset asset = (ConsoleAsset)persistenceEvent.getEntity();
        switch (persistenceEvent.getCause()) {
            case CREATE: 
            case UPDATE: {
                if (ORConsoleGeofenceAssetAdapter.isLinkedToORConsoleGeofenceAdapter(asset)) {
                    this.consoleIdRealmMap.put(asset.getId(), asset.getRealm());
                    break;
                }
                this.consoleIdRealmMap.remove(asset.getId());
                break;
            }
            case DELETE: {
                this.consoleIdRealmMap.remove(asset.getId());
            }
        }
    }

    protected static boolean isLinkedToORConsoleGeofenceAdapter(ConsoleAsset asset) {
        return asset.getConsoleProviders().flatMap(consoleProviders -> Optional.ofNullable((ConsoleProvider)consoleProviders.get((Object)"geofence")).map(ConsoleProvider::getVersion).map(NAME::equals)).orElse(false);
    }
}

