/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.flow;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.IntStream;
import org.openremote.manager.rules.flow.NodeImplementation;
import org.openremote.manager.rules.flow.NodeTriggerFunction;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.datapoint.ValueDatapoint;
import org.openremote.model.datapoint.query.AssetDatapointNearestQuery;
import org.openremote.model.datapoint.query.AssetDatapointQuery;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.rules.flow.AttributeInternalValue;
import org.openremote.model.rules.flow.Node;
import org.openremote.model.rules.flow.NodeDataType;
import org.openremote.model.rules.flow.NodeInternal;
import org.openremote.model.rules.flow.NodeSocket;
import org.openremote.model.rules.flow.NodeType;
import org.openremote.model.rules.flow.Option;
import org.openremote.model.rules.flow.Picker;
import org.openremote.model.rules.flow.PickerType;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueHolder;

public enum NodeModel {
    READ_ATTRIBUTE(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("Attribute", new Picker(PickerType.ASSET_ATTRIBUTE))}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.ANY)}), info -> {
        AttributeInternalValue assetAttributePair = (AttributeInternalValue)ValueUtil.JSON.convertValue(info.getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = assetAttributePair.getAssetId();
        String attributeName = assetAttributePair.getAttributeName();
        Optional<AttributeInfo> readValue = info.getFacts().matchFirstAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName));
        return readValue.flatMap(ValueHolder::getValue).orElse(null);
    }, params -> {
        AttributeInternalValue internal = (AttributeInternalValue)ValueUtil.JSON.convertValue(params.getNode().getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = internal.getAssetId();
        String attributeName = internal.getAttributeName();
        List<AttributeInfo> allAssets = params.getFacts().matchAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName)).toList();
        return allAssets.stream().anyMatch(state -> {
            long timestamp = state.getTimestamp();
            long triggerStamp = params.getBuilder().getTriggerMap().getOrDefault(params.getRuleName(), -1L);
            if (triggerStamp == -1L) {
                return true;
            }
            return timestamp > triggerStamp && !Objects.equals(state.getValue().orElse(null), state.getOldValue().orElse(null));
        });
    }),
    DERIVATIVE(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("Attribute", new Picker(PickerType.ASSET_ATTRIBUTE))}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}), info -> {
        AttributeInternalValue assetAttributePair = (AttributeInternalValue)ValueUtil.JSON.convertValue(info.getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = assetAttributePair.getAssetId();
        String attributeName = assetAttributePair.getAttributeName();
        Optional<AttributeInfo> attr = info.getFacts().matchFirstAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName));
        if (attr.isPresent()) {
            AttributeInfo attributeInfo = attr.get();
            Optional currentValueOpt = attributeInfo.getValue();
            Optional oldValueOpt = attributeInfo.getOldValue();
            long currentTimestamp = attributeInfo.getTimestamp();
            long oldTimestamp = attributeInfo.getOldValueTimestamp();
            if (currentValueOpt.isPresent() && oldValueOpt.isPresent()) {
                double currentValue = ((Number)currentValueOpt.get()).doubleValue();
                double oldValue = ((Number)oldValueOpt.get()).doubleValue();
                double timeDifference = (double)(currentTimestamp - oldTimestamp) / 1000.0;
                if (timeDifference != 0.0) {
                    return (currentValue - oldValue) / timeDifference;
                }
            }
        }
        return null;
    }, params -> {
        AttributeInternalValue internal = (AttributeInternalValue)ValueUtil.JSON.convertValue(params.getNode().getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = internal.getAssetId();
        String attributeName = internal.getAttributeName();
        Optional<AttributeInfo> x = params.getFacts().getAssetStates().stream().filter(assetState -> Objects.equals(assetState.getId(), assetId) && Objects.equals(assetState.getName(), attributeName)).findFirst();
        List<AttributeInfo> allAssets = params.getFacts().matchAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName)).toList();
        return allAssets.stream().anyMatch(state -> {
            long timestamp = state.getTimestamp();
            long triggerStamp = params.getBuilder().getTriggerMap().getOrDefault(params.getRuleName(), -1L);
            if (triggerStamp == -1L) {
                return true;
            }
            return timestamp > triggerStamp && !Objects.equals(state.getValue().orElse(null), state.getOldValue().orElse(null));
        });
    }),
    INTEGRAL(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("Attribute", new Picker(PickerType.ASSET_ATTRIBUTE))}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}), info -> {
        AttributeInternalValue assetAttributePair = (AttributeInternalValue)ValueUtil.JSON.convertValue(info.getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = assetAttributePair.getAssetId();
        String attributeName = assetAttributePair.getAttributeName();
        Optional<AttributeInfo> attr = info.getFacts().matchAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName)).findFirst();
        double integral = 0.0;
        if (attr.isPresent()) {
            AttributeInfo attributeInfo = attr.get();
            Optional currentValueOpt = attributeInfo.getValue();
            Optional oldValueOpt = attributeInfo.getOldValue();
            long currentTimestamp = attributeInfo.getTimestamp();
            long oldTimestamp = attributeInfo.getOldValueTimestamp();
            if (currentValueOpt.isPresent() && oldValueOpt.isPresent()) {
                double currentValue = ((Number)currentValueOpt.get()).doubleValue();
                double previousValue = ((Number)oldValueOpt.get()).doubleValue();
                double timeDifference = (double)(currentTimestamp - oldTimestamp) / 1000.0;
                integral += (currentValue + previousValue) * timeDifference / 2.0;
            }
        }
        return integral;
    }, params -> {
        AttributeInternalValue internal = (AttributeInternalValue)ValueUtil.JSON.convertValue(params.getNode().getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = internal.getAssetId();
        String attributeName = internal.getAttributeName();
        List<AttributeInfo> allAssets = params.getFacts().matchAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName)).toList();
        return allAssets.stream().anyMatch(state -> {
            long timestamp = state.getTimestamp();
            long triggerStamp = params.getBuilder().getTriggerMap().getOrDefault(params.getRuleName(), -1L);
            if (triggerStamp == -1L) {
                return true;
            }
            return timestamp > triggerStamp && !Objects.equals(state.getValue().orElse(null), state.getOldValue().orElse(null));
        });
    }),
    HISTORIC_VALUE(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("attribute", new Picker(PickerType.ASSET_ATTRIBUTE), NodeInternal.BreakType.NEW_LINE), new NodeInternal("time_period", new Picker(PickerType.DATE), NodeInternal.BreakType.SPACER), new NodeInternal("time_unit", new Picker(PickerType.DROPDOWN, (Option[])Arrays.stream(TimePeriod.values()).map(it -> new Option(it.label, (Object)it.name())).toArray(Option[]::new)), NodeInternal.BreakType.SPACER)}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.ANY)}), info -> {
        AttributeInternalValue assetAttributePair = (AttributeInternalValue)ValueUtil.JSON.convertValue(info.getInternals()[0].getValue(), AttributeInternalValue.class);
        AttributeRef ref = new AttributeRef(assetAttributePair.getAssetId(), assetAttributePair.getAttributeName());
        Long timePeriod = TimePeriod.valueOf(info.getInternals()[2].getValue().toString()).getMillis();
        Long timeUnit = Long.parseLong(info.getInternals()[1].getValue().toString());
        if (timePeriod == null) {
            return null;
        }
        long currentMillis = info.getFacts().getClock().getCurrentTimeMillis();
        Instant pastInstant = Instant.ofEpochMilli(currentMillis - timePeriod * timeUnit);
        ValueDatapoint[] valueDatapoints = info.getHistoricDatapoints().getValueDatapoints(ref, (AssetDatapointQuery)new AssetDatapointNearestQuery(pastInstant.toEpochMilli()));
        return valueDatapoints.length > 0 ? valueDatapoints[0].getValue() : null;
    }, params -> {
        AttributeInternalValue internal = (AttributeInternalValue)ValueUtil.JSON.convertValue(params.getNode().getInternals()[0].getValue(), AttributeInternalValue.class);
        String assetId = internal.getAssetId();
        String attributeName = internal.getAttributeName();
        List<AttributeInfo> allAssets = params.getFacts().matchAssetState(new AssetQuery().ids(new String[]{assetId}).attributeName(attributeName)).toList();
        return allAssets.stream().anyMatch(state -> {
            long timestamp = state.getTimestamp();
            long triggerStamp = params.getBuilder().getTriggerMap().getOrDefault(params.getRuleName(), -1L);
            if (triggerStamp == -1L) {
                return true;
            }
            return timestamp > triggerStamp && !Objects.equals(state.getValue().orElse(null), state.getOldValue().orElse(null));
        });
    }),
    LOG_OUTPUT(new Node(NodeType.OUTPUT, new NodeInternal[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.ANY)}, new NodeSocket[0]), info -> facts -> {
        info.setFacts(facts);
        Object obj = info.getValueFromInput(0);
        info.LOG.log(Level.INFO, ValueUtil.asJSON((Object)obj).orElseGet(() -> "Couldn't parse JSON"));
    }),
    WRITE_ATTRIBUTE(new Node(NodeType.OUTPUT, new NodeInternal[]{new NodeInternal("Attribute", new Picker(PickerType.ASSET_ATTRIBUTE))}, new NodeSocket[]{new NodeSocket("value", NodeDataType.ANY)}, new NodeSocket[0]), info -> facts -> {
        info.setFacts(facts);
        Object value = info.getValueFromInput(0);
        if (value == null) {
            return;
        }
        AttributeInternalValue assetAttributePair = (AttributeInternalValue)ValueUtil.JSON.convertValue(info.getInternals()[0].getValue(), AttributeInternalValue.class);
        Optional<AttributeInfo> existingValue = info.getFacts().matchFirstAssetState(new AssetQuery().ids(new String[]{assetAttributePair.getAssetId()}).attributeName(assetAttributePair.getAttributeName()));
        if (existingValue.isPresent() && existingValue.get().getValue().isPresent() && existingValue.get().getValue().get().equals(value)) {
            return;
        }
        info.getAssets().dispatch(assetAttributePair.getAssetId(), assetAttributePair.getAttributeName(), value);
    }),
    BOOLEAN_INPUT(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("value", new Picker(PickerType.CHECKBOX))}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.BOOLEAN)}), info -> {
        Object value = info.getInternals()[0].getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof Boolean)) {
            return false;
        }
        return value;
    }),
    AND_GATE(new Node(NodeType.PROCESSOR, "&", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.BOOLEAN), new NodeSocket("b", NodeDataType.BOOLEAN)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.BOOLEAN)}), info -> {
        boolean a = (Boolean)info.getValueFromInput(0);
        boolean b = (Boolean)info.getValueFromInput(1);
        return a && b;
    }),
    OR_GATE(new Node(NodeType.PROCESSOR, "\u2225", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.BOOLEAN), new NodeSocket("b", NodeDataType.BOOLEAN)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.BOOLEAN)}), info -> {
        boolean a = (Boolean)info.getValueFromInput(0);
        boolean b = (Boolean)info.getValueFromInput(1);
        return a || b;
    }),
    NOT_GATE(new Node(NodeType.PROCESSOR, "!", new NodeInternal[0], new NodeSocket[]{new NodeSocket("i", NodeDataType.BOOLEAN)}, new NodeSocket[]{new NodeSocket("o", NodeDataType.BOOLEAN)}), info -> {
        boolean a = (Boolean)info.getValueFromInput(0);
        return !a;
    }),
    NUMBER_INPUT(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("value", new Picker(PickerType.NUMBER))}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}), info -> ValueUtil.convert((Object)info.getInternals()[0].getValue(), Double.class)),
    ADD_OPERATOR(new Node(NodeType.PROCESSOR, 1, "+", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        return a != null && b != null ? Double.valueOf(a.doubleValue() + b.doubleValue()) : null;
    }),
    SUBTRACT_OPERATOR(new Node(NodeType.PROCESSOR, 2, "-", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        return a != null && b != null ? Double.valueOf(a.doubleValue() - b.doubleValue()) : null;
    }),
    MULTIPLY_OPERATOR(new Node(NodeType.PROCESSOR, 3, "\u00d7", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        return a != null && b != null ? Double.valueOf(a.doubleValue() * b.doubleValue()) : null;
    }),
    DIVIDE_OPERATOR(new Node(NodeType.PROCESSOR, 4, "\u00f7", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        if (a == null || b == null) {
            return null;
        }
        if (b.doubleValue() == 0.0) {
            return 0.0;
        }
        return a.doubleValue() / b.doubleValue();
    }),
    EQUALS_COMPARATOR(new Node(NodeType.PROCESSOR, "=", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.ANY), new NodeSocket("b", NodeDataType.ANY)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.BOOLEAN)}), info -> {
        Object a = info.getValueFromInput(0);
        Object b = info.getValueFromInput(1);
        return a != null && b != null && Objects.equals(a, b);
    }),
    SUM_PROCESSOR(new Node(NodeType.PROCESSOR, 5, "\u03a3", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER_ARRAY)}, new NodeSocket[]{new NodeSocket("b", NodeDataType.NUMBER)}), info -> IntStream.range(0, info.getInputs().length).mapToObj(info::getValueFromInput).mapToDouble(value -> ((Number)value).doubleValue()).sum()),
    MAX_PROCESSOR(new Node(NodeType.PROCESSOR, "max", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER_ARRAY)}, new NodeSocket[]{new NodeSocket("b", NodeDataType.NUMBER)}), info -> IntStream.range(0, info.getInputs().length).mapToObj(info::getValueFromInput).mapToDouble(value -> ((Number)value).doubleValue()).max().orElseThrow()),
    MIN_PROCESSOR(new Node(NodeType.PROCESSOR, "min", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER_ARRAY)}, new NodeSocket[]{new NodeSocket("b", NodeDataType.NUMBER)}), info -> IntStream.range(0, info.getInputs().length).mapToObj(info::getValueFromInput).mapToDouble(value -> ((Number)value).doubleValue()).min().orElseThrow()),
    AVERAGE_PROCESSOR(new Node(NodeType.PROCESSOR, "avg", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER_ARRAY)}, new NodeSocket[]{new NodeSocket("b", NodeDataType.NUMBER)}), info -> IntStream.range(0, info.getInputs().length).mapToObj(info::getValueFromInput).mapToDouble(value -> ((Number)value).doubleValue()).average().orElseThrow()),
    MEDIAN_PROCESSOR(new Node(NodeType.PROCESSOR, "med", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER_ARRAY)}, new NodeSocket[]{new NodeSocket("b", NodeDataType.NUMBER)}), info -> {
        double[] sortedDoubles = IntStream.range(0, info.getInputs().length).mapToObj(info::getValueFromInput).mapToDouble(value -> ((Number)value).doubleValue()).sorted().toArray();
        if (sortedDoubles.length == 0) {
            return 0.0;
        }
        if (sortedDoubles.length % 2 == 0) {
            return (sortedDoubles[sortedDoubles.length / 2 - 1] + sortedDoubles[sortedDoubles.length / 2]) / 2.0;
        }
        return sortedDoubles[sortedDoubles.length / 2];
    }),
    GREATER_THAN(new Node(NodeType.PROCESSOR, ">", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.BOOLEAN)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        return a != null && b != null && a.doubleValue() > b.doubleValue();
    }),
    LESS_THAN(new Node(NodeType.PROCESSOR, "<", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.BOOLEAN)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        return a != null && b != null && a.doubleValue() < b.doubleValue();
    }),
    ROUND_NODE(new Node(NodeType.PROCESSOR, new NodeInternal[]{new NodeInternal("Rounding method", new Picker(PickerType.DROPDOWN, new Option[]{new Option("Round", (Object)"round"), new Option("Ceiling", (Object)"ceil"), new Option("Floor", (Object)"floor")}))}, new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        if (a == null) {
            return null;
        }
        return switch ((String)info.getInternals()[0].getValue()) {
            case "round" -> Math.round(a.doubleValue());
            case "ceil" -> Math.ceil(a.doubleValue());
            case "floor" -> Math.floor(a.doubleValue());
            default -> a;
        };
    }),
    ABS_OPERATOR(new Node(NodeType.PROCESSOR, "|x|", new NodeInternal[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("absolute", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        return a != null ? Double.valueOf(Math.abs(a.doubleValue())) : null;
    }),
    POW_OPERATOR(new Node(NodeType.PROCESSOR, "^", new NodeInternal[0], new NodeSocket[]{new NodeSocket("base", NodeDataType.NUMBER), new NodeSocket("exponent", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("value", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        Number b = (Number)info.getValueFromInput(1);
        return a != null && b != null ? Double.valueOf(Math.pow(a.doubleValue(), b.doubleValue())) : null;
    }),
    NUMBER_SWITCH(new Node(NodeType.PROCESSOR, new NodeInternal[0], new NodeSocket[]{new NodeSocket("when", NodeDataType.BOOLEAN), new NodeSocket("then", NodeDataType.NUMBER), new NodeSocket("else", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("output", NodeDataType.NUMBER)}), info -> {
        boolean condition = (Boolean)ValueUtil.convert((Object)info.getValueFromInput(0), Boolean.class);
        Number a = (Number)info.getValueFromInput(1);
        Number b = (Number)info.getValueFromInput(2);
        return condition ? (a != null ? Double.valueOf(a.doubleValue()) : null) : (b != null ? Double.valueOf(b.doubleValue()) : null);
    }),
    TEXT_INPUT(new Node(NodeType.INPUT, new NodeInternal[]{new NodeInternal("value", new Picker(PickerType.MULTILINE))}, new NodeSocket[0], new NodeSocket[]{new NodeSocket("value", NodeDataType.STRING)}), info -> {
        Object value = info.getInternals()[0].getValue();
        if (!(value instanceof CharSequence)) {
            return null;
        }
        CharSequence charSequence = (CharSequence)value;
        return charSequence.toString();
    }),
    COMBINE_TEXT(new Node(NodeType.PROCESSOR, new NodeInternal[]{new NodeInternal("joiner", new Picker(PickerType.TEXT))}, new NodeSocket[]{new NodeSocket("a", NodeDataType.STRING), new NodeSocket("b", NodeDataType.STRING)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.STRING)}), info -> {
        Object joiner = ValueUtil.convert((Object)info.getInternals()[0].getValue(), String.class);
        Object a = ValueUtil.convert((Object)info.getValueFromInput(0), String.class);
        Object b = ValueUtil.convert((Object)info.getValueFromInput(1), String.class);
        joiner = joiner == null ? "" : joiner;
        return String.valueOf(a != null ? a : "") + String.valueOf(joiner) + String.valueOf(b != null ? b : "");
    }),
    TEXT_SWITCH(new Node(NodeType.PROCESSOR, new NodeInternal[0], new NodeSocket[]{new NodeSocket("when", NodeDataType.BOOLEAN), new NodeSocket("then", NodeDataType.STRING), new NodeSocket("else", NodeDataType.STRING)}, new NodeSocket[]{new NodeSocket("output", NodeDataType.STRING)}), info -> {
        boolean condition = (Boolean)ValueUtil.convert((Object)info.getValueFromInput(0), Boolean.class);
        String a = (String)ValueUtil.convert((Object)info.getValueFromInput(1), String.class);
        String b = (String)ValueUtil.convert((Object)info.getValueFromInput(2), String.class);
        return condition ? a : b;
    }),
    SIN(new Node(NodeType.PROCESSOR, "sin", new NodeInternal[0], new NodeSocket[]{new NodeSocket("in", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("out", NodeDataType.NUMBER)}), info -> {
        try {
            Number a = (Number)info.getValueFromInput(0);
            return a != null ? Double.valueOf(Math.sin(a.doubleValue())) : null;
        }
        catch (Exception e) {
            return 0;
        }
    }),
    COS(new Node(NodeType.PROCESSOR, "cos", new NodeInternal[0], new NodeSocket[]{new NodeSocket("in", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("out", NodeDataType.NUMBER)}), info -> {
        Number a = (Number)info.getValueFromInput(0);
        return a != null ? Double.valueOf(Math.cos(a.doubleValue())) : null;
    }),
    TAN(new Node(NodeType.PROCESSOR, "tan", new NodeInternal[0], new NodeSocket[]{new NodeSocket("in", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("out", NodeDataType.NUMBER)}), info -> {
        try {
            Number a = (Number)info.getValueFromInput(0);
            return a != null ? Double.valueOf(Math.tan(a.doubleValue())) : null;
        }
        catch (Exception e) {
            return 0;
        }
    }),
    SQRT(new Node(NodeType.PROCESSOR, "\u221a", new NodeInternal[0], new NodeSocket[]{new NodeSocket("in", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("out", NodeDataType.NUMBER)}), info -> {
        try {
            Number a = (Number)info.getValueFromInput(0);
            return a != null ? Double.valueOf(Math.sqrt(a.doubleValue())) : null;
        }
        catch (Exception e) {
            return 0;
        }
    }),
    MOD(new Node(NodeType.PROCESSOR, "%", new NodeInternal[0], new NodeSocket[]{new NodeSocket("a", NodeDataType.NUMBER), new NodeSocket("b", NodeDataType.NUMBER)}, new NodeSocket[]{new NodeSocket("c", NodeDataType.NUMBER)}), info -> {
        try {
            Number a = (Number)info.getValueFromInput(0);
            Number b = (Number)info.getValueFromInput(1);
            return a != null && b != null ? Double.valueOf(a.doubleValue() % b.doubleValue()) : null;
        }
        catch (Exception e) {
            return 0;
        }
    });

    private Node definition;
    private NodeImplementation implementation;
    private NodeTriggerFunction triggerFunction;

    private NodeModel(Node definition, NodeImplementation implementation) {
        this.definition = definition;
        definition.setName(this.name());
        this.implementation = implementation;
        this.triggerFunction = params -> false;
    }

    private NodeModel(Node definition, NodeImplementation implementation, NodeTriggerFunction triggerFunction) {
        this.definition = definition;
        definition.setName(this.name());
        this.implementation = implementation;
        this.triggerFunction = triggerFunction;
    }

    public Node getDefinition() {
        return this.definition;
    }

    public NodeImplementation getImplementation() {
        return this.implementation;
    }

    public NodeTriggerFunction getTriggerFunction() {
        return this.triggerFunction;
    }

    public static NodeImplementation getImplementationFor(String name) {
        return NodeModel.valueOf((String)name).implementation;
    }

    public static NodeTriggerFunction getTriggerFunctionFor(String name) {
        return NodeModel.valueOf((String)name).triggerFunction;
    }

    public static Node getDefinitionFor(String name) {
        return NodeModel.valueOf((String)name).definition;
    }

    private static enum TimePeriod {
        SECONDS("seconds ago", 1000L),
        MINUTES("minutes ago", TimePeriod.SECONDS.millis * 60L),
        HOURS("hours ago", TimePeriod.MINUTES.millis * 24L),
        DAYS("days ago", TimePeriod.HOURS.millis * 30L),
        MONTHS("months ago", TimePeriod.DAYS.millis * 12L);

        private final String label;
        private final Long millis;

        private TimePeriod(String label, Long millis) {
            this.label = label;
            this.millis = millis;
        }

        public String getLabel() {
            return this.label;
        }

        public Long getMillis() {
            return this.millis;
        }
    }
}

