/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openremote.manager.rules.RulesFacts;
import org.openremote.manager.rules.flow.NodeModel;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.HistoricDatapoints;
import org.openremote.model.rules.Notifications;
import org.openremote.model.rules.PredictedDatapoints;
import org.openremote.model.rules.Users;
import org.openremote.model.rules.flow.Node;
import org.openremote.model.rules.flow.NodeCollection;
import org.openremote.model.rules.flow.NodeDataType;
import org.openremote.model.rules.flow.NodeInternal;
import org.openremote.model.rules.flow.NodeSocket;

public class NodeExecutionRequestInfo {
    private NodeCollection collection;
    private int outputSocketIndex;
    private NodeSocket outputSocket;
    private Node node;
    private NodeSocket[] inputs;
    private NodeSocket[] outputs;
    private NodeInternal[] internals;
    private RulesFacts facts;
    private Assets assets;
    private Users users;
    private Notifications notifications;
    private HistoricDatapoints historicDatapoints;
    private PredictedDatapoints predictedDatapoints;
    protected Logger LOG;

    public NodeExecutionRequestInfo() {
        this.collection = new NodeCollection();
        this.outputSocketIndex = -1;
        this.outputSocket = null;
        this.node = null;
        this.inputs = new NodeSocket[0];
        this.outputs = new NodeSocket[0];
        this.internals = new NodeInternal[0];
        this.facts = null;
        this.assets = null;
        this.users = null;
        this.notifications = null;
        this.historicDatapoints = null;
        this.predictedDatapoints = null;
    }

    public NodeExecutionRequestInfo(NodeCollection collection, int outputSocketIndex, NodeSocket outputSocket, Node node, NodeSocket[] inputs, NodeSocket[] outputs, NodeInternal[] internals, RulesFacts facts, Assets assets, Users users, Notifications notifications, HistoricDatapoints historicDatapoints, PredictedDatapoints predictedDatapoints) {
        this.collection = collection;
        this.outputSocketIndex = outputSocketIndex;
        this.outputSocket = outputSocket;
        this.node = node;
        this.inputs = inputs;
        this.outputs = outputs;
        this.internals = internals;
        this.facts = facts;
        this.assets = assets;
        this.users = users;
        this.notifications = notifications;
        this.historicDatapoints = historicDatapoints;
        this.predictedDatapoints = predictedDatapoints;
    }

    public NodeExecutionRequestInfo(NodeCollection collection, Node node, NodeSocket socket, RulesFacts facts, Assets assets, Users users, Notifications notifications, HistoricDatapoints historicDatapoints, PredictedDatapoints predictedDatapoints, Logger log) {
        if (socket != null && Arrays.stream(node.getOutputs()).noneMatch(c -> c.getNodeId().equals(node.getId()))) {
            throw new IllegalArgumentException("Given socket does not belong to given node");
        }
        this.collection = collection;
        this.outputSocketIndex = Arrays.asList(node.getOutputs()).indexOf(socket);
        this.outputSocket = socket;
        this.node = node;
        ArrayList inputs = new ArrayList();
        for (NodeSocket s : node.getInputs()) {
            inputs.addAll(Arrays.stream(collection.getConnections()).filter(c -> c.getTo().equals(s.getId())).map(c -> collection.getSocketById(c.getFrom())).collect(Collectors.toList()));
        }
        this.inputs = inputs.toArray(new NodeSocket[0]);
        ArrayList outputs = new ArrayList();
        for (NodeSocket s : node.getOutputs()) {
            outputs.addAll(Arrays.stream(collection.getConnections()).filter(c -> c.getFrom().equals(s.getId())).map(c -> collection.getSocketById(c.getTo())).collect(Collectors.toList()));
        }
        this.outputs = outputs.toArray(new NodeSocket[0]);
        this.internals = node.getInternals();
        this.facts = facts;
        this.assets = assets;
        this.users = users;
        this.notifications = notifications;
        this.historicDatapoints = historicDatapoints;
        this.predictedDatapoints = predictedDatapoints;
        this.LOG = log;
    }

    public Object getValueFromInput(int index) {
        NodeSocket aSocket = this.getInputs()[index];
        Node aNode = this.getCollection().getNodeById(aSocket.getNodeId());
        return NodeModel.getImplementationFor(aNode.getName()).execute(new NodeExecutionRequestInfo(this.getCollection(), aNode, aSocket, this.getFacts(), this.getAssets(), this.getUsers(), this.getNotifications(), this.getHistoricDatapoints(), this.getPredictedDatapoints(), this.LOG));
    }

    public NodeDataType getTypeFromInput(int index) {
        NodeSocket aSocket = this.getInputs()[index];
        return aSocket.getType();
    }

    public NodeCollection getCollection() {
        return this.collection;
    }

    public void setCollection(NodeCollection collection) {
        this.collection = collection;
    }

    public int getOutputSocketIndex() {
        return this.outputSocketIndex;
    }

    public void setOutputSocketIndex(int outputSocketIndex) {
        this.outputSocketIndex = outputSocketIndex;
    }

    public NodeSocket getOutputSocket() {
        return this.outputSocket;
    }

    public void setOutputSocket(NodeSocket outputSocket) {
        this.outputSocket = outputSocket;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodeSocket[] getInputs() {
        return this.inputs;
    }

    public void setInputs(NodeSocket[] inputs) {
        this.inputs = inputs;
    }

    public NodeSocket[] getOutputs() {
        return this.outputs;
    }

    public void setOutputs(NodeSocket[] outputs) {
        this.outputs = outputs;
    }

    public NodeInternal[] getInternals() {
        return this.internals;
    }

    public void setInternals(NodeInternal[] internals) {
        this.internals = internals;
    }

    public Assets getAssets() {
        return this.assets;
    }

    public void setAssets(Assets assets) {
        this.assets = assets;
    }

    public Users getUsers() {
        return this.users;
    }

    public void setUsers(Users users) {
        this.users = users;
    }

    public Notifications getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    public HistoricDatapoints getHistoricDatapoints() {
        return this.historicDatapoints;
    }

    public PredictedDatapoints getPredictedDatapoints() {
        return this.predictedDatapoints;
    }

    public void setPredictedDatapoints(PredictedDatapoints predictedDatapoints) {
        this.predictedDatapoints = predictedDatapoints;
    }

    public RulesFacts getFacts() {
        return this.facts;
    }

    public void setFacts(RulesFacts facts) {
        this.facts = facts;
    }
}

