/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.flow;

import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.rules.flow.NodeModel;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.http.RequestParams;
import org.openremote.model.rules.flow.FlowResource;
import org.openremote.model.rules.flow.Node;
import org.openremote.model.rules.flow.NodeType;

public class FlowResourceImpl
extends ManagerWebResource
implements FlowResource {
    private static final Logger LOG = Logger.getLogger(FlowResourceImpl.class.getName());
    private final Node[] nodes;

    public FlowResourceImpl(TimerService timerService, ManagerIdentityService identityService) {
        super(timerService, identityService);
        Arrays.stream(NodeModel.values()).map(NodeModel::getDefinition).forEach(n -> LOG.finest("Node found: " + n.getName()));
        this.nodes = (Node[])Arrays.stream(NodeModel.values()).map(NodeModel::getDefinition).filter(definition -> !Objects.equals(definition.getName(), "LOG_OUTPUT")).toArray(Node[]::new);
    }

    public Node[] getAllNodeDefinitions(RequestParams requestParams) {
        return this.nodes;
    }

    public Node[] getAllNodeDefinitionsByType(RequestParams requestParams, NodeType type) {
        return (Node[])Arrays.stream(this.nodes).filter(n -> n.getType() == type).toArray(Node[]::new);
    }

    public Node getNodeDefinition(RequestParams requestParams, String name) {
        return NodeModel.getDefinitionFor(name);
    }
}

