/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.facade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.notification.NotificationService;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.PathPredicate;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.rules.Users;
import org.openremote.model.security.User;

public class UsersFacade<T extends Ruleset>
extends Users {
    protected final RulesEngineId<T> rulesEngineId;
    protected final AssetStorageService assetStorageService;
    protected final NotificationService notificationService;
    protected final ManagerIdentityService identityService;

    public UsersFacade(RulesEngineId<T> rulesEngineId, AssetStorageService assetStorageService, NotificationService notificationService, ManagerIdentityService identityService) {
        this.rulesEngineId = rulesEngineId;
        this.assetStorageService = assetStorageService;
        this.notificationService = notificationService;
        this.identityService = identityService;
    }

    public Stream<String> getResults(UserQuery userQuery) {
        if (RealmRuleset.class.isAssignableFrom(this.rulesEngineId.getScope())) {
            userQuery.realmPredicate = new RealmPredicate(this.rulesEngineId.getRealm().orElseThrow(() -> new IllegalArgumentException("Realm ID missing: " + String.valueOf(this.rulesEngineId))));
        } else if (AssetRuleset.class.isAssignableFrom(this.rulesEngineId.getScope())) {
            userQuery.realmPredicate = null;
            String assetId = this.rulesEngineId.getAssetId().orElseThrow(() -> new IllegalArgumentException("Asset ID missing: " + String.valueOf(this.rulesEngineId)));
            if (userQuery.pathPredicate == null || userQuery.pathPredicate.path == null) {
                userQuery.pathPredicate = new PathPredicate(new String[]{assetId});
            } else {
                ArrayList<String> path = new ArrayList<String>(Arrays.asList(userQuery.pathPredicate.path));
                path.add(assetId);
                userQuery.pathPredicate.path = path.toArray(new String[0]);
            }
        }
        userQuery.attributes(new UserQuery.AttributeValuePredicate[]{new UserQuery.AttributeValuePredicate(true, new StringPredicate("systemAccount"), null)});
        userQuery.serviceUsers(Boolean.valueOf(false));
        return Arrays.stream(this.identityService.getIdentityProvider().queryUsers(userQuery)).map(User::getId);
    }
}

