/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.facade;

import java.time.LocalDateTime;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.datapoint.ValueDatapoint;
import org.openremote.model.datapoint.query.AssetDatapointQuery;
import org.openremote.model.rules.PredictedDatapoints;
import org.openremote.model.rules.Ruleset;

public class PredictedFacade<T extends Ruleset>
extends PredictedDatapoints {
    protected final RulesEngineId<T> rulesEngineId;
    protected final AssetPredictedDatapointService assetPredictedDatapointService;

    public PredictedFacade(RulesEngineId<T> rulesEngineId, AssetPredictedDatapointService assetPredictedDatapointService) {
        this.rulesEngineId = rulesEngineId;
        this.assetPredictedDatapointService = assetPredictedDatapointService;
    }

    public ValueDatapoint<?>[] getValueDatapoints(AttributeRef attributeRef, AssetDatapointQuery query) {
        return (ValueDatapoint[])this.assetPredictedDatapointService.queryDatapoints(attributeRef.getId(), attributeRef.getName(), query).toArray(ValueDatapoint[]::new);
    }

    public void updateValue(String assetId, String attributeName, Object value, LocalDateTime timestamp) {
        this.assetPredictedDatapointService.updateValue(assetId, attributeName, value, timestamp);
    }

    public void updateValue(AttributeRef attributeRef, Object value, LocalDateTime timestamp) {
        this.updateValue(attributeRef.getId(), attributeRef.getName(), value, timestamp);
    }
}

