/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.facade;

import org.openremote.manager.notification.NotificationService;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.model.notification.Notification;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.Notifications;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;

public class NotificationsFacade<T extends Ruleset>
extends Notifications {
    protected final RulesEngineId<T> rulesEngineId;
    protected final NotificationService notificationService;

    public NotificationsFacade(RulesEngineId<T> rulesEngineId, NotificationService notificationService) {
        this.rulesEngineId = rulesEngineId;
        this.notificationService = notificationService;
    }

    public void send(Notification notification) {
        Notification.Source source;
        String sourceId = null;
        if (this.rulesEngineId.getScope() == GlobalRuleset.class) {
            source = Notification.Source.GLOBAL_RULESET;
        } else if (this.rulesEngineId.getScope() == RealmRuleset.class) {
            source = Notification.Source.REALM_RULESET;
            sourceId = this.rulesEngineId.getRealm().orElseThrow(() -> new IllegalStateException("Realm ruleset must have a realm ID"));
        } else {
            source = Notification.Source.ASSET_RULESET;
            sourceId = this.rulesEngineId.getAssetId().orElseThrow(() -> new IllegalStateException("Asset ruleset must have an asset ID"));
        }
        this.notificationService.sendNotificationAsync(notification, source, sourceId);
    }
}

