/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.facade;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.filter.PathPredicate;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;

public class AssetsFacade<T extends Ruleset>
extends Assets {
    private static final Logger LOG = Logger.getLogger(AssetsFacade.class.getName());
    protected final RulesEngineId<T> rulesEngineId;
    protected final AssetStorageService assetStorageService;
    protected final Consumer<AttributeEvent> eventConsumer;

    public AssetsFacade(RulesEngineId<T> rulesEngineId, AssetStorageService assetStorageService, Consumer<AttributeEvent> eventConsumer) {
        this.rulesEngineId = rulesEngineId;
        this.assetStorageService = assetStorageService;
        this.eventConsumer = eventConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Asset<?>> getResults(AssetQuery assetQuery) {
        if (RealmRuleset.class.isAssignableFrom(this.rulesEngineId.getScope())) {
            assetQuery.realm = new RealmPredicate(this.rulesEngineId.getRealm().orElseThrow(() -> new IllegalArgumentException("Realm missing: " + String.valueOf(this.rulesEngineId))));
        } else if (AssetRuleset.class.isAssignableFrom(this.rulesEngineId.getScope())) {
            assetQuery.realm = new RealmPredicate(this.rulesEngineId.getRealm().orElseThrow(() -> new IllegalArgumentException("Realm missing: " + String.valueOf(this.rulesEngineId))));
            Asset<?> restrictedAsset = this.assetStorageService.find(this.rulesEngineId.getAssetId().orElseThrow(() -> new IllegalStateException("Asset ID missing: " + String.valueOf(this.rulesEngineId))), true);
            if (restrictedAsset == null) {
                throw new IllegalStateException("Asset is no longer available: " + String.valueOf(this.rulesEngineId));
            }
            assetQuery.paths(new PathPredicate[]{new PathPredicate(restrictedAsset.getPath())});
        }
        AssetQuery.Select oldValue = assetQuery.select;
        assetQuery.select = new AssetQuery.Select().excludeAttributes();
        try {
            Stream<Asset<?>> stream = this.assetStorageService.findAll(assetQuery).stream();
            return stream;
        }
        finally {
            assetQuery.select = oldValue;
        }
    }

    public AssetsFacade<T> dispatch(AttributeEvent ... events) {
        AssetQuery query;
        long count;
        if (events == null || events.length == 0) {
            return this;
        }
        CharSequence[] ids = (String[])Arrays.stream(events).map(AttributeEvent::getId).toArray(String[]::new);
        if ((long)ids.length != (count = this.getResults(query = new AssetQuery().ids((String[])ids)).count())) {
            LOG.warning("Access to asset(s) not allowed for this rule engine scope " + String.valueOf(this.rulesEngineId) + " for asset IDs: " + String.join((CharSequence)", ", ids));
            return this;
        }
        for (AttributeEvent event : events) {
            this.eventConsumer.accept(event);
        }
        return this;
    }

    public AssetsFacade<T> dispatch(String assetId, String attributeName, Object value) {
        return this.dispatch(new AttributeEvent[]{new AttributeEvent(assetId, attributeName, value)});
    }

    public AssetsFacade<T> dispatch(String assetId, String attributeName) {
        return this.dispatch(new AttributeEvent[]{new AttributeEvent(assetId, attributeName, null)});
    }
}

