/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules.facade;

import java.util.List;
import org.openremote.manager.alarm.AlarmService;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.model.alarm.Alarm;
import org.openremote.model.rules.Alarms;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;

public class AlarmFacade<T extends Ruleset>
extends Alarms {
    protected final RulesEngineId<T> rulesEngineId;
    protected final AlarmService alarmService;

    public AlarmFacade(RulesEngineId<T> rulesEngineId, AlarmService alarmService) {
        this.rulesEngineId = rulesEngineId;
        this.alarmService = alarmService;
    }

    public Long create(Alarm alarm, List<String> assetIds) {
        Alarm.Source source = this.rulesEngineId.getScope() == GlobalRuleset.class ? Alarm.Source.GLOBAL_RULESET : (this.rulesEngineId.getScope() == RealmRuleset.class ? Alarm.Source.REALM_RULESET : Alarm.Source.ASSET_RULESET);
        alarm.setRealm(this.rulesEngineId.getRealm().orElseThrow());
        alarm.setSource(source);
        return this.alarmService.sendAlarm(alarm, assetIds).getId();
    }

    public void linkAssets(List<String> assetIds, Long alarmId) {
        if (assetIds != null && !assetIds.isEmpty()) {
            String realmId = this.rulesEngineId.getRealm().orElseThrow(() -> new IllegalStateException("Realm ruleset must have a realm ID"));
            this.alarmService.linkAssets(assetIds, realmId, alarmId);
        }
    }
}

