/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.ReturningWork;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.RulesResourceImpl;
import org.openremote.manager.rules.RulesService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.query.RulesetQuery;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.util.ValueUtil;

public class RulesetStorageService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(RulesetStorageService.class.getName());
    public static final int PRIORITY = 200;
    protected PersistenceService persistenceService;
    protected ManagerIdentityService identityService;

    public int getPriority() {
        return 200;
    }

    public void init(Container container) throws Exception {
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new RulesResourceImpl((TimerService)container.getService(TimerService.class), (ManagerIdentityService)container.getService(ManagerIdentityService.class), this, (AssetStorageService)container.getService(AssetStorageService.class), (RulesService)container.getService(RulesService.class)));
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public <T extends Ruleset> T find(Class<T> rulesetType, Long id) {
        return this.find(rulesetType, id, true);
    }

    public <T extends Ruleset> T find(Class<T> rulesetType, Long id, boolean loadComplete) {
        if (id == null) {
            throw new IllegalArgumentException("Can't query null ruleset identifier");
        }
        return this.find(rulesetType, new RulesetQuery().setFullyPopulate(loadComplete).setIds(new long[]{id}));
    }

    public <T extends Ruleset> T find(Class<T> rulesetType, RulesetQuery query) {
        List<T> result = this.findAll(rulesetType, query);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("Query returned more than one ruleset");
        }
        return (T)((Ruleset)result.get(0));
    }

    public <T extends Ruleset> List<T> findAll(final Class<T> rulesetType, final RulesetQuery query) {
        return (List)this.persistenceService.doReturningTransaction(em -> {
            LOG.finest("Building: " + String.valueOf(query));
            StringBuilder sb = new StringBuilder();
            final ArrayList<ParameterBinder> binders = new ArrayList<ParameterBinder>();
            this.appendSelectString(sb, rulesetType, query);
            this.appendFromString(sb, rulesetType, query);
            this.appendWhereString(sb, rulesetType, query, binders);
            this.appendOrder(sb, query);
            this.appendLimit(sb, query);
            final String sqlQuery = sb.toString();
            return (List)((Session)em.unwrap(Session.class)).doReturningWork((ReturningWork)new AbstractReturningWork<List<T>>(){

                public List<T> execute(Connection connection) throws SQLException {
                    LOG.finest("Executing: " + sqlQuery);
                    try (PreparedStatement st = connection.prepareStatement(sqlQuery);){
                        ArrayList arrayList;
                        block13: {
                            binders.forEach(parameterBinder -> parameterBinder.accept(st));
                            ResultSet rs = st.executeQuery();
                            try {
                                ArrayList result = new ArrayList();
                                while (rs.next()) {
                                    result.add(RulesetStorageService.this.mapResultTuple(rulesetType, query, rs));
                                }
                                arrayList = result;
                                if (rs == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return arrayList;
                    }
                }
            });
        });
    }

    public <T extends Ruleset> T merge(T ruleset) {
        return (T)((Ruleset)this.persistenceService.doReturningTransaction(entityManager -> (Ruleset)entityManager.merge((Object)ruleset)));
    }

    public <T extends Ruleset> void delete(Class<T> rulesetType, Long id) {
        this.persistenceService.doTransaction(entityManager -> {
            Ruleset ruleset = (Ruleset)entityManager.find(rulesetType, (Object)id);
            if (ruleset != null) {
                entityManager.remove((Object)ruleset);
            }
        });
    }

    protected <T extends Ruleset> void appendSelectString(StringBuilder sb, Class<T> rulesetType, RulesetQuery query) {
        sb.append("SELECT R.ID, R.VERSION, R.RULES_LANG, R.ENABLED, R.LAST_MODIFIED, R.CREATED_ON, R.NAME, R.META");
        if (query.fullyPopulate) {
            sb.append(", R.RULES");
        }
        if (rulesetType == RealmRuleset.class) {
            sb.append(", R.ACCESS_PUBLIC_READ, R.REALM");
        } else if (rulesetType == AssetRuleset.class) {
            sb.append(", R.ACCESS_PUBLIC_READ, R.ASSET_ID, A.REALM AS REALM");
        }
    }

    protected <T extends Ruleset> void appendFromString(StringBuilder sb, Class<T> rulesetType, RulesetQuery query) {
        if (rulesetType == GlobalRuleset.class) {
            sb.append(" FROM GLOBAL_RULESET R");
        } else if (rulesetType == RealmRuleset.class) {
            sb.append(" FROM REALM_RULESET R");
        } else if (rulesetType == AssetRuleset.class) {
            sb.append(" FROM ASSET_RULESET R JOIN ASSET A ON (R.ASSET_ID = A.ID)");
        } else {
            throw new UnsupportedOperationException("Ruleset type not supported: " + String.valueOf(rulesetType));
        }
    }

    protected <T extends Ruleset> void appendWhereString(StringBuilder sb, Class<T> rulesetType, RulesetQuery query, List<ParameterBinder> binders) {
        int index;
        int pos2;
        int i;
        int pos;
        sb.append(" WHERE 1=1");
        if (query.publicOnly) {
            sb.append(" AND R.ACCESS_PUBLIC_READ");
        }
        if (query.enabledOnly) {
            sb.append(" AND R.ENABLED");
        }
        if (query.languages != null && query.languages.length > 0) {
            sb.append(" AND R.RULES_LANG IN (?");
            pos = binders.size() + 1;
            binders.add(st -> st.setString(pos, query.languages[0].toString()));
            i = 1;
            while (i < query.languages.length) {
                sb.append(",?");
                pos2 = binders.size() + 1;
                index = i++;
                binders.add(st -> st.setString(pos2, query.languages[index].toString()));
            }
            sb.append(")");
        }
        if (query.ids != null && query.ids.length > 0) {
            sb.append(" AND R.ID IN (?");
            pos = binders.size() + 1;
            binders.add(st -> st.setLong(pos, query.ids[0]));
            i = 1;
            while (i < query.ids.length) {
                sb.append(",?");
                pos2 = binders.size() + 1;
                index = i++;
                binders.add(st -> st.setLong(pos2, query.ids[index]));
            }
            sb.append(")");
        }
        if (query.meta != null) {
            // empty if block
        }
        if (query.realm != null && (rulesetType == RealmRuleset.class || rulesetType == AssetRuleset.class)) {
            sb.append(" AND REALM = ?");
            pos = binders.size() + 1;
            binders.add(st -> st.setString(pos, query.realm));
        }
        if (query.assetIds != null && query.assetIds.length > 0 && rulesetType == AssetRuleset.class) {
            sb.append(" AND R.ASSET_ID IN (?");
            pos = binders.size() + 1;
            binders.add(st -> st.setString(pos, query.assetIds[0]));
            i = 1;
            while (i < query.assetIds.length) {
                sb.append(",?");
                pos2 = binders.size() + 1;
                index = i++;
                binders.add(st -> st.setString(pos2, query.assetIds[index]));
            }
            sb.append(")");
        }
    }

    protected void appendOrder(StringBuilder sb, RulesetQuery query) {
        sb.append(" ORDER BY CREATED_ON ASC");
    }

    protected void appendLimit(StringBuilder sb, RulesetQuery query) {
        if (query.limit > 0) {
            sb.append(" LIMIT ").append(query.limit);
        }
    }

    protected <T extends Ruleset> T mapResultTuple(Class<T> rulesetType, RulesetQuery query, ResultSet rs) throws SQLException {
        GlobalRuleset ruleset;
        if (rulesetType == GlobalRuleset.class) {
            ruleset = new GlobalRuleset();
        } else if (rulesetType == RealmRuleset.class) {
            RealmRuleset realmRuleset = new RealmRuleset();
            realmRuleset.setRealm(rs.getString("REALM"));
            realmRuleset.setAccessPublicRead(rs.getBoolean("ACCESS_PUBLIC_READ"));
            ruleset = realmRuleset;
        } else if (rulesetType == AssetRuleset.class) {
            AssetRuleset assetRuleset = new AssetRuleset();
            assetRuleset.setAssetId(rs.getString("ASSET_ID"));
            assetRuleset.setRealm(rs.getString("REALM"));
            assetRuleset.setAccessPublicRead(rs.getBoolean("ACCESS_PUBLIC_READ"));
            ruleset = assetRuleset;
        } else {
            throw new UnsupportedOperationException("Ruleset type not supported: " + String.valueOf(rulesetType));
        }
        ruleset.setName(rs.getString("NAME"));
        ruleset.setId(Long.valueOf(rs.getLong("ID")));
        ruleset.setVersion(rs.getLong("VERSION"));
        ruleset.setLang(Ruleset.Lang.valueOf((String)rs.getString("RULES_LANG")));
        ruleset.setEnabled(rs.getBoolean("ENABLED"));
        ruleset.setLastModified((Date)rs.getTimestamp("LAST_MODIFIED"));
        ruleset.setCreatedOn((Date)rs.getTimestamp("CREATED_ON"));
        if (rs.getString("META") != null) {
            ruleset.setMeta((Map)ValueUtil.parse((String)rs.getString("META"), Map.class).orElse(null));
        }
        if (query.fullyPopulate) {
            ruleset.setRules(rs.getString("RULES"));
        }
        return (T)ruleset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }

    protected static interface ParameterBinder
    extends Consumer<PreparedStatement> {
        @Override
        default public void accept(PreparedStatement st) {
            try {
                this.acceptStatement(st);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void acceptStatement(PreparedStatement var1) throws SQLException;
    }
}

