/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jeasy.rules.api.Action;
import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.core.RuleBuilder;
import org.kohsuke.groovy.sandbox.GroovyValueFilter;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.FlowRulesBuilder;
import org.openremote.manager.rules.JsonRulesBuilder;
import org.openremote.manager.rules.RulesBuilder;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.RulesFacts;
import org.openremote.model.calendar.CalendarEvent;
import org.openremote.model.rules.Alarms;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.HistoricDatapoints;
import org.openremote.model.rules.Notifications;
import org.openremote.model.rules.PredictedDatapoints;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.rules.RulesetStatus;
import org.openremote.model.rules.Users;
import org.openremote.model.rules.Webhooks;
import org.openremote.model.rules.flow.NodeCollection;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;

public class RulesetDeployment {
    public static final int DEFAULT_RULE_PRIORITY = 1000;
    protected static final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    protected static final GroovyShell groovyShell = new GroovyShell(new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()}));
    protected static final Pair<Long, Long> ALWAYS_ACTIVE = new Pair((Object)0L, (Object)Long.MAX_VALUE);
    protected static final Pair<Long, Long> EXPIRED = new Pair((Object)0L, (Object)0L);
    protected final Ruleset ruleset;
    protected final Rules rules = new Rules(new Rule[0]);
    protected final AssetStorageService assetStorageService;
    protected final TimerService timerService;
    protected final ExecutorService executorService;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final Assets assetsFacade;
    protected final Users usersFacade;
    protected final Notifications notificationsFacade;
    protected final Webhooks webhooksFacade;
    protected final Alarms alarmsFacade;
    protected final HistoricDatapoints historicDatapointsFacade;
    protected final PredictedDatapoints predictedDatapointsFacade;
    protected final List<ScheduledFuture<?>> scheduledRuleActions = Collections.synchronizedList(new ArrayList());
    protected final RulesEngine<?> rulesEngine;
    protected final Logger LOG;
    protected boolean running;
    protected RulesetStatus status = RulesetStatus.READY;
    protected Throwable error;
    protected JsonRulesBuilder jsonRulesBuilder;
    protected FlowRulesBuilder flowRulesBuilder;
    protected CalendarEvent validity;
    protected Pair<Long, Long> nextValidity;

    public RulesetDeployment(Ruleset ruleset, RulesEngine<?> rulesEngine, TimerService timerService, AssetStorageService assetStorageService, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, Assets assetsFacade, Users usersFacade, Notifications notificationsFacade, Webhooks webhooksFacade, Alarms alarmsFacade, HistoricDatapoints historicDatapointsFacade, PredictedDatapoints predictedDatapointsFacade) {
        this.ruleset = ruleset;
        this.rulesEngine = rulesEngine;
        this.timerService = timerService;
        this.assetStorageService = assetStorageService;
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.assetsFacade = assetsFacade;
        this.usersFacade = usersFacade;
        this.notificationsFacade = notificationsFacade;
        this.webhooksFacade = webhooksFacade;
        this.alarmsFacade = alarmsFacade;
        this.historicDatapointsFacade = historicDatapointsFacade;
        this.predictedDatapointsFacade = predictedDatapointsFacade;
        String ruleCategory = ruleset.getClass().getSimpleName() + "-" + ruleset.getId();
        this.LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.RULES, (String)(RulesEngine.class.getName() + "." + ruleCategory));
    }

    protected void init() throws IllegalStateException {
        if (this.ruleset.getMeta().containsKey("validity")) {
            this.validity = this.ruleset.getValidity();
            if (this.validity == null) {
                this.LOG.log(Level.WARNING, "Ruleset '" + this.ruleset.getName() + "' has invalid validity value: " + String.valueOf(this.ruleset.getMeta().get("validity")));
                this.status = RulesetStatus.VALIDITY_PERIOD_ERROR;
                return;
            }
        }
        if (TextUtil.isNullOrEmpty((String)this.ruleset.getRules())) {
            this.LOG.finest("Ruleset is empty so no rules to deploy: " + this.ruleset.getName());
            this.status = RulesetStatus.EMPTY;
            return;
        }
        if (!this.ruleset.isEnabled()) {
            this.LOG.finest("Ruleset is disabled: " + this.ruleset.getName());
            this.status = RulesetStatus.DISABLED;
        }
        if (!this.compile()) {
            this.LOG.log(Level.SEVERE, "Ruleset compilation error: " + this.ruleset.getName(), this.getError());
            this.status = RulesetStatus.COMPILATION_ERROR;
        }
    }

    public long getId() {
        return this.ruleset.getId();
    }

    public String getName() {
        return this.ruleset.getName();
    }

    public long getVersion() {
        return this.ruleset.getVersion();
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }

    public Rules getRules() {
        return this.rules;
    }

    protected void updateValidity() {
        Pair fromTo = this.validity.getNextOrActiveFromTo(new Date(this.timerService.getCurrentTimeMillis()));
        if (fromTo == null) {
            this.nextValidity = EXPIRED;
            this.LOG.log(Level.INFO, "Ruleset deployment '" + this.getName() + "' has expired");
        } else {
            this.nextValidity = fromTo;
            this.LOG.log(Level.INFO, "Ruleset deployment '" + this.getName() + "' paused until: " + String.valueOf(new Date((Long)fromTo.key)));
        }
    }

    public Pair<Long, Long> getNextOrActiveFromTo() {
        if (this.validity == null) {
            return ALWAYS_ACTIVE;
        }
        if (this.nextValidity == EXPIRED) {
            return this.nextValidity;
        }
        if (this.nextValidity == null || (Long)this.nextValidity.value <= this.timerService.getCurrentTimeMillis()) {
            this.updateValidity();
        }
        return this.nextValidity;
    }

    public boolean compile() {
        this.LOG.info("Compiling ruleset deployment: " + String.valueOf(this.ruleset));
        if (this.error != null) {
            return false;
        }
        switch (this.ruleset.getLang()) {
            case JAVASCRIPT: {
                return this.compileRulesJavascript(this.ruleset, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.historicDatapointsFacade, this.predictedDatapointsFacade);
            }
            case GROOVY: {
                return this.compileRulesGroovy(this.ruleset, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.historicDatapointsFacade, this.predictedDatapointsFacade);
            }
            case JSON: {
                return this.compileRulesJson(this.ruleset);
            }
            case FLOW: {
                return this.compileRulesFlow(this.ruleset, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.historicDatapointsFacade, this.predictedDatapointsFacade);
            }
        }
        return false;
    }

    public boolean canStart() {
        return this.status != RulesetStatus.COMPILATION_ERROR && this.status != RulesetStatus.DISABLED && this.status != RulesetStatus.EXPIRED;
    }

    public boolean start(RulesFacts facts) {
        if (!this.canStart()) {
            return false;
        }
        if (this.jsonRulesBuilder != null) {
            this.jsonRulesBuilder.start(facts);
        }
        this.running = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(RulesFacts facts) {
        if (!this.running) {
            return false;
        }
        this.running = false;
        List<ScheduledFuture<?>> list = this.scheduledRuleActions;
        synchronized (list) {
            this.scheduledRuleActions.removeIf(scheduledFuture -> {
                scheduledFuture.cancel(true);
                return true;
            });
        }
        if (this.jsonRulesBuilder != null) {
            this.jsonRulesBuilder.stop(facts);
        }
        return true;
    }

    public void onAssetStatesChanged(RulesFacts facts, RulesEngine.AssetStateChangeEvent event) {
        if (this.jsonRulesBuilder != null) {
            this.jsonRulesBuilder.onAssetStatesChanged(facts, event);
        }
    }

    protected void scheduleRuleAction(Runnable action, long delayMillis) {
        ScheduledFuture<?> future = this.scheduledExecutorService.schedule(() -> {
            this.scheduledRuleActions.removeIf(Future::isDone);
            action.run();
        }, delayMillis, TimeUnit.MILLISECONDS);
        this.scheduledRuleActions.add(future);
    }

    protected boolean compileRulesJson(Ruleset ruleset) {
        try {
            this.jsonRulesBuilder = new JsonRulesBuilder(this.LOG, ruleset, this.rulesEngine, this.timerService, this.assetStorageService, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.webhooksFacade, this.alarmsFacade, this.historicDatapointsFacade, this.predictedDatapointsFacade, this::scheduleRuleAction);
            for (Rule rule : this.jsonRulesBuilder.build()) {
                this.LOG.finest("Registering JSON rule: " + rule.getName());
                this.rules.register(new Object[]{rule});
            }
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    protected boolean compileRulesJavascript(Ruleset ruleset, Assets assetsFacade, Users usersFacade, Notifications notificationsFacade, HistoricDatapoints historicDatapointsFacade, PredictedDatapoints predictedDatapointsFacade) {
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("nashorn");
        SimpleScriptContext newContext = new SimpleScriptContext();
        newContext.setBindings(scriptEngine.createBindings(), 100);
        Bindings engineScope = newContext.getBindings(100);
        engineScope.put("LOG", (Object)this.LOG);
        engineScope.put("assets", (Object)assetsFacade);
        engineScope.put("users", (Object)usersFacade);
        engineScope.put("notifications", (Object)notificationsFacade);
        engineScope.put("historicDatapoints", (Object)historicDatapointsFacade);
        engineScope.put("predictedDatapoints", (Object)predictedDatapointsFacade);
        Object script = ruleset.getRules();
        script = "load(\"nashorn:mozilla_compat.js\");\n\nimportPackage(\n    \"java.util.stream\",\n    \"org.openremote.model.asset\",\n    \"org.openremote.model.attribute\",\n    \"org.openremote.model.value\",\n    \"org.openremote.model.rules\",\n    \"org.openremote.model.query\"\n);\nvar Match = Java.type(\"org.openremote.model.query.AssetQuery$Match\");\nvar Operator = Java.type(\"org.openremote.model.query.AssetQuery$Operator\");\nvar NumberType = Java.type(\"org.openremote.model.query.AssetQuery$NumberType\");\nvar StringPredicate = Java.type(\"org.openremote.model.query.filter.StringPredicate\");\nvar BooleanPredicate = Java.type(\"org.openremote.model.query.filter.BooleanPredicate\");\nvar StringArrayPredicate = Java.type(\"org.openremote.model.query.filter.StringArrayPredicate\");\nvar DateTimePredicate = Java.type(\"org.openremote.model.query.filter.DateTimePredicate\");\nvar NumberPredicate = Java.type(\"org.openremote.model.query.filter.NumberPredicate\");\nvar ParentPredicate = Java.type(\"org.openremote.model.query.filter.ParentPredicate\");\nvar PathPredicate = Java.type(\"org.openremote.model.query.filter.PathPredicate\");\nvar RealmPredicate = Java.type(\"org.openremote.model.query.filter.RealmPredicate\");\nvar AttributePredicate = Java.type(\"org.openremote.model.query.filter.AttributePredicate\");\nvar AttributeExecuteStatus = Java.type(\"org.openremote.model.attribute.AttributeExecuteStatus\");\nvar EXACT = Match.EXACT;\nvar BEGIN = Match.BEGIN;\nvar END = Match.END;\nvar CONTAINS = Match.CONTAINS;\nvar EQUALS = Operator.EQUALS;\nvar GREATER_THAN = Operator.GREATER_THAN;\nvar GREATER_EQUALS = Operator.GREATER_EQUALS;\nvar LESS_THAN = Operator.LESS_THAN;\nvar LESS_EQUALS = Operator.LESS_EQUALS;\nvar BETWEEN = Operator.BETWEEN;\nvar REQUEST_START = AttributeExecuteStatus.REQUEST_START;\nvar REQUEST_REPEATING = AttributeExecuteStatus.REQUEST_REPEATING;\nvar REQUEST_CANCEL = AttributeExecuteStatus.REQUEST_CANCEL;\nvar READY = AttributeExecuteStatus.READY;\nvar COMPLETED = AttributeExecuteStatus.COMPLETED;\nvar RUNNING = AttributeExecuteStatus.RUNNING;\nvar CANCELLED = AttributeExecuteStatus.CANCELLED;\nvar ERROR = AttributeExecuteStatus.ERROR;\nvar DISABLED = AttributeExecuteStatus.DISABLED;\n\n" + (String)script;
        try {
            scriptEngine.eval((String)script, engineScope);
            this.compileRulesJavascript((ScriptObjectMirror)engineScope.get("rules"));
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            engineScope.clear();
            return false;
        }
    }

    protected void compileRulesJavascript(ScriptObjectMirror scriptRules) {
        if (scriptRules == null || !scriptRules.isArray()) {
            throw new IllegalArgumentException("No 'rules' array defined in ruleset");
        }
        Collection rulesObjects = scriptRules.values();
        for (Object rulesObject : rulesObjects) {
            Action then;
            Condition when;
            int priority;
            String description;
            String name;
            ScriptObjectMirror rule = (ScriptObjectMirror)rulesObject;
            if (!rule.containsKey((Object)"name")) {
                throw new IllegalArgumentException("Missing 'name' in rule definition");
            }
            try {
                name = (String)rule.getMember("name");
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Defined 'name' of rule is not a string");
            }
            try {
                description = rule.containsKey((Object)"description") ? (String)rule.getMember("description") : null;
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Defined 'description' is not a string in rule: " + name);
            }
            try {
                priority = rule.containsKey((Object)"priority") ? (Integer)rule.getMember("priority") : 1000;
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Defined 'priority' is not a number in rule: " + name);
            }
            if (!rule.containsKey((Object)"when")) {
                throw new IllegalArgumentException("Missing 'when' function in rule: " + name);
            }
            try {
                ScriptObjectMirror whenMirror = (ScriptObjectMirror)rule.getMember("when");
                if (!whenMirror.isFunction()) {
                    throw new IllegalArgumentException("Defined 'when' is not a function in rule: " + name);
                }
                when = (Condition)whenMirror.to(Condition.class);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Defined 'when' is not a function in rule: " + name);
            }
            try {
                ScriptObjectMirror thenMirror = (ScriptObjectMirror)rule.getMember("then");
                if (!thenMirror.isFunction()) {
                    throw new IllegalArgumentException("Defined 'then' is not a function in rule: " + name);
                }
                then = (Action)thenMirror.to(Action.class);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Defined 'then' is not a function in rule: " + name);
            }
            this.LOG.finest("Registering javascript rule: " + name);
            this.rules.register(new Object[]{new RuleBuilder().name(name).description(description).priority(priority).when(when).then(then).build()});
        }
    }

    protected boolean compileRulesGroovy(Ruleset ruleset, Assets assetsFacade, Users usersFacade, Notifications notificationFacade, HistoricDatapoints historicDatapointsFacade, PredictedDatapoints predictedDatapointsFacade) {
        try {
            Script script = groovyShell.parse(ruleset.getRules());
            Binding binding = new Binding();
            RulesBuilder rulesBuilder = new RulesBuilder();
            binding.setVariable("LOG", (Object)this.LOG);
            binding.setVariable("rules", (Object)rulesBuilder);
            binding.setVariable("assets", (Object)assetsFacade);
            binding.setVariable("users", (Object)usersFacade);
            binding.setVariable("notifications", (Object)notificationFacade);
            binding.setVariable("historicDatapoints", (Object)historicDatapointsFacade);
            binding.setVariable("predictedDatapoints", (Object)predictedDatapointsFacade);
            if (ruleset instanceof RealmRuleset) {
                binding.setVariable("realm", (Object)((RealmRuleset)ruleset).getRealm());
            }
            if (ruleset instanceof AssetRuleset) {
                binding.setVariable("assetId", (Object)((AssetRuleset)ruleset).getAssetId());
            }
            script.setBinding(binding);
            script.run();
            for (Rule rule : rulesBuilder.build()) {
                this.LOG.finest("Registering groovy rule: " + rule.getName());
                this.rules.register(new Object[]{rule});
            }
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    protected boolean compileRulesFlow(Ruleset ruleset, Assets assetsFacade, Users usersFacade, Notifications notificationsFacade, HistoricDatapoints historicDatapointsFacade, PredictedDatapoints predictedDatapointsFacade) {
        try {
            this.flowRulesBuilder = new FlowRulesBuilder(this.LOG, this.timerService, this.assetStorageService, assetsFacade, usersFacade, notificationsFacade, historicDatapointsFacade, predictedDatapointsFacade);
            NodeCollection nodeCollection = (NodeCollection)ValueUtil.JSON.readValue(ruleset.getRules(), NodeCollection.class);
            this.flowRulesBuilder.add(nodeCollection);
            for (Rule rule : this.flowRulesBuilder.build()) {
                this.LOG.info("Compiling flow rule: " + rule.getName());
                this.rules.register(new Object[]{rule});
            }
            return true;
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error evaluating flow rule ruleset: " + String.valueOf(ruleset), e);
            this.setError(e);
            return false;
        }
    }

    public RulesetStatus getStatus() {
        if (this.isError() || this.status == RulesetStatus.DISABLED) {
            return this.status;
        }
        Pair<Long, Long> validity = this.getNextOrActiveFromTo();
        if (validity == EXPIRED) {
            return RulesetStatus.EXPIRED;
        }
        if (validity != ALWAYS_ACTIVE && (Long)validity.key > this.timerService.getCurrentTimeMillis()) {
            return RulesetStatus.PAUSED;
        }
        if (this.running) {
            return RulesetStatus.DEPLOYED;
        }
        return this.status;
    }

    public void setStatus(RulesetStatus status) {
        this.status = status;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.getError() != null ? this.getError().getMessage() : null;
    }

    public boolean isError() {
        return this.status == RulesetStatus.LOOP_ERROR || this.status == RulesetStatus.VALIDITY_PERIOD_ERROR || (this.status == RulesetStatus.EXECUTION_ERROR || this.status == RulesetStatus.COMPILATION_ERROR) && !this.isContinueOnError();
    }

    public boolean isContinueOnError() {
        return this.ruleset.isContinueOnError();
    }

    public boolean isTriggerOnPredictedData() {
        return this.ruleset.isTriggerOnPredictedData();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.getId() + ", name='" + this.getName() + "', version=" + this.getVersion() + ", status=" + String.valueOf(this.getStatus()) + "}";
    }

    static class GroovyDenyAllFilter
    extends GroovyValueFilter {
        GroovyDenyAllFilter() {
        }

        public Object filterReceiver(Object receiver) {
            throw new SecurityException("Not allowed: " + String.valueOf(receiver));
        }
    }
}

