/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.alarm.AlarmService;
import org.openremote.manager.asset.AssetProcessingException;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetDatapointService;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.notification.NotificationService;
import org.openremote.manager.rules.AssetLocationPredicateProcessor;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.manager.rules.RulesetDeployment;
import org.openremote.manager.rules.RulesetStorageService;
import org.openremote.manager.rules.flow.FlowResourceImpl;
import org.openremote.manager.rules.geofence.GeofenceAssetAdapter;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.manager.webhook.WebhookService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetInfo;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.RulesetQuery;
import org.openremote.model.query.filter.GeofencePredicate;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.RulesEngineStatusEvent;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.rules.RulesetChangedEvent;
import org.openremote.model.rules.geofence.GeofenceDefinition;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Realm;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.TimeUtil;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.MetaHolder;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.NameHolder;

public class RulesService
extends RouteBuilder
implements ContainerService {
    public static final int PRIORITY = 2147482647;
    public static final String OR_RULE_EVENT_EXPIRES = "OR_RULE_EVENT_EXPIRES";
    public static final String OR_RULE_EVENT_EXPIRES_DEFAULT = "PT1H";
    public static final String OR_RULES_MIN_TEMP_FACT_EXPIRATION_MILLIS = "OR_RULES_MIN_TEMP_FACT_EXPIRATION_MILLIS";
    public static final int OR_RULES_MIN_TEMP_FACT_EXPIRATION_MILLIS_DEFAULT = 50000;
    public static final String OR_RULES_QUICK_FIRE_MILLIS = "OR_RULES_QUICK_FIRE_MILLIS";
    public static final int OR_RULES_QUICK_FIRE_MILLIS_DEFAULT = 3000;
    private static final Logger LOG = Logger.getLogger(RulesService.class.getName());
    protected final AtomicReference<RulesEngine<GlobalRuleset>> globalEngine = new AtomicReference();
    protected final Map<String, RulesEngine<RealmRuleset>> realmEngines = new ConcurrentHashMap<String, RulesEngine<RealmRuleset>>();
    protected final Map<String, RulesEngine<AssetRuleset>> assetEngines = new ConcurrentHashMap<String, RulesEngine<AssetRuleset>>();
    protected static final Object ENGINE_LOCK = new Object();
    protected List<GeofenceAssetAdapter> geofenceAssetAdapters = new ArrayList<GeofenceAssetAdapter>();
    protected TimerService timerService;
    protected ExecutorService executorService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected PersistenceService persistenceService;
    protected RulesetStorageService rulesetStorageService;
    protected ManagerIdentityService identityService;
    protected AssetStorageService assetStorageService;
    protected NotificationService notificationService;
    protected WebhookService webhookService;
    protected AlarmService alarmService;
    protected AssetProcessingService assetProcessingService;
    protected AssetDatapointService assetDatapointService;
    protected AssetPredictedDatapointService assetPredictedDatapointService;
    protected ClientEventService clientEventService;
    protected GatewayService gatewayService;
    protected Realm[] realms;
    protected AssetLocationPredicateProcessor locationPredicateRulesConsumer;
    protected final Map<RulesEngine<?>, List<RulesEngine.AssetLocationPredicates>> engineAssetLocationPredicateMap = new ConcurrentHashMap();
    protected final Set<String> assetsWithModifiedLocationPredicates = new HashSet<String>();
    protected final Set<AttributeEvent> attributeEvents = ConcurrentHashMap.newKeySet();
    protected final Set<AttributeEvent> preInitAttributeEvents = new HashSet<AttributeEvent>();
    protected long defaultEventExpiresMillis = 3600000L;
    protected long tempFactExpirationMillis;
    protected long quickFireMillis;
    protected boolean initDone;
    protected boolean startDone;
    protected Timer rulesFiringTimer;

    public int getPriority() {
        return 2147482647;
    }

    public void init(Container container) throws Exception {
        this.executorService = container.getExecutor();
        this.scheduledExecutorService = container.getScheduledExecutor();
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.rulesetStorageService = (RulesetStorageService)container.getService(RulesetStorageService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.notificationService = (NotificationService)container.getService(NotificationService.class);
        this.webhookService = (WebhookService)container.getService(WebhookService.class);
        this.alarmService = (AlarmService)container.getService(AlarmService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.assetDatapointService = (AssetDatapointService)container.getService(AssetDatapointService.class);
        this.assetPredictedDatapointService = (AssetPredictedDatapointService)container.getService(AssetPredictedDatapointService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        this.tempFactExpirationMillis = MapAccess.getInteger((Map)container.getConfig(), (String)OR_RULES_MIN_TEMP_FACT_EXPIRATION_MILLIS, (int)50000);
        this.quickFireMillis = MapAccess.getInteger((Map)container.getConfig(), (String)OR_RULES_QUICK_FIRE_MILLIS, (int)3000);
        if (this.initDone) {
            return;
        }
        this.clientEventService.addSubscriptionAuthorizer((realm, auth, subscription) -> {
            if (subscription.isEventType(RulesEngineStatusEvent.class) || subscription.isEventType(RulesetChangedEvent.class)) {
                if (auth == null) {
                    return false;
                }
                if (auth.isSuperUser()) {
                    return true;
                }
                if (!auth.hasResourceRole(ClientRole.READ_ASSETS.getValue(), "openremote")) {
                    return false;
                }
                boolean isRestrictedUser = this.identityService.getIdentityProvider().isRestrictedUser(auth);
                return !isRestrictedUser;
            }
            return false;
        });
        this.clientEventService.addSubscription(AttributeEvent.class, null, this::onAttributeEvent);
        ServiceLoader.load(GeofenceAssetAdapter.class).forEach(geofenceAssetAdapter -> {
            LOG.fine("Adding GeofenceAssetAdapter: " + geofenceAssetAdapter.getClass().getName());
            this.geofenceAssetAdapters.add((GeofenceAssetAdapter)geofenceAssetAdapter);
        });
        this.geofenceAssetAdapters.addAll(container.getServices(GeofenceAssetAdapter.class));
        this.geofenceAssetAdapters.sort(Comparator.comparingInt(ContainerService::getPriority));
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
        String defaultEventExpires = MapAccess.getString((Map)container.getConfig(), (String)OR_RULE_EVENT_EXPIRES, (String)OR_RULE_EVENT_EXPIRES_DEFAULT);
        if (!TextUtil.isNullOrEmpty((String)defaultEventExpires)) {
            try {
                this.defaultEventExpiresMillis = TimeUtil.parseTimeDuration((String)defaultEventExpires);
            }
            catch (RuntimeException exception) {
                LOG.log(Level.WARNING, "Failed to parse OR_RULE_EVENT_EXPIRES", exception);
            }
        }
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new FlowResourceImpl((TimerService)container.getService(TimerService.class), (ManagerIdentityService)container.getService(ManagerIdentityService.class)));
        if (container.getMeterRegistry() != null) {
            this.rulesFiringTimer = container.getMeterRegistry().timer("or.rules", (Iterable)Tags.empty());
        }
        this.initDone = true;
    }

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-Ruleset").filter(PersistenceService.isPersistenceEventForEntityType(Ruleset.class)).filter(GatewayService.isNotForGateway(this.gatewayService)).process(exchange -> {
            PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
            this.processRulesetChange((Ruleset)persistenceEvent.getEntity(), persistenceEvent.getCause());
        });
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-RulesRealm").filter(PersistenceService.isPersistenceEventForEntityType(Realm.class)).filter(GatewayService.isNotForGateway(this.gatewayService)).process(exchange -> {
            PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
            Realm realm = (Realm)persistenceEvent.getEntity();
            this.processRealmChange(realm, persistenceEvent.getCause());
        });
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-RulesAsset").filter(PersistenceService.isPersistenceEventForEntityType(Asset.class)).process(exchange -> {
            PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
            Asset eventAsset = (Asset)persistenceEvent.getEntity();
            this.processAssetChange(eventAsset, persistenceEvent);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Container container) throws Exception {
        this.startDone = false;
        if (!this.geofenceAssetAdapters.isEmpty()) {
            LOG.fine("GeofenceAssetAdapters found: " + this.geofenceAssetAdapters.size());
            this.locationPredicateRulesConsumer = this::onEngineLocationRulesChanged;
            for (GeofenceAssetAdapter geofenceAssetAdapter : this.geofenceAssetAdapters) {
                geofenceAssetAdapter.start(container);
            }
        }
        LOG.fine("Deploying global rulesets");
        this.rulesetStorageService.findAll(GlobalRuleset.class, new RulesetQuery().setEnabledOnly(true).setFullyPopulate(true)).forEach(this::deployGlobalRuleset);
        LOG.fine("Deploying realm rulesets");
        this.realms = (Realm[])Arrays.stream(this.identityService.getIdentityProvider().getRealms()).filter(Realm::getEnabled).toArray(Realm[]::new);
        this.rulesetStorageService.findAll(RealmRuleset.class, new RulesetQuery().setEnabledOnly(true).setFullyPopulate(true)).stream().filter(rd -> Arrays.stream(this.realms).anyMatch(realm -> rd.getRealm().equals(realm.getName()))).forEach(this::deployRealmRuleset);
        LOG.fine("Deploying asset rulesets");
        this.deployAssetRulesets(this.rulesetStorageService.findAll(AssetRuleset.class, new RulesetQuery().setEnabledOnly(true).setFullyPopulate(true))).count();
        LOG.fine("Loading all assets with fact attributes to initialize state of rules engines");
        Stream<Pair<Asset<?>, Stream<Attribute<?>>>> stateAttributes = this.findRuleStateAttributes();
        stateAttributes.forEach(pair -> {
            Asset asset = (Asset)pair.key;
            ((Stream)pair.value).forEach(ruleAttribute -> {
                AttributeEvent attributeEvent = new AttributeEvent((AssetInfo)asset, ruleAttribute, null, ruleAttribute.getValue().orElse(null), ruleAttribute.getTimestamp().orElse(0L), ruleAttribute.getValue().orElse(null), ruleAttribute.getTimestamp().orElse(0L));
                this.insertOrUpdateAttributeInfo(attributeEvent);
            });
        });
        Object object = ENGINE_LOCK;
        synchronized (object) {
            RulesEngine<GlobalRuleset> globalRulesEngine = this.globalEngine.get();
            if (globalRulesEngine != null) {
                globalRulesEngine.start();
            }
            this.realmEngines.values().forEach(RulesEngine::start);
            this.assetEngines.values().forEach(RulesEngine::start);
            this.startDone = true;
            this.preInitAttributeEvents.forEach(this::doProcessAttributeUpdate);
            this.preInitAttributeEvents.clear();
        }
    }

    public void stop(Container container) throws Exception {
        for (GeofenceAssetAdapter geofenceAssetAdapter : this.geofenceAssetAdapters) {
            try {
                geofenceAssetAdapter.stop(container);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception thrown whilst stopping geofence adapter", e);
            }
        }
        this.assetEngines.forEach((assetId, rulesEngine) -> rulesEngine.stop());
        this.assetEngines.clear();
        this.realmEngines.forEach((realm, rulesEngine) -> rulesEngine.stop());
        this.realmEngines.clear();
        RulesEngine<GlobalRuleset> globalRulesEngine = this.globalEngine.get();
        if (globalRulesEngine != null) {
            globalRulesEngine.stop();
            this.globalEngine.set(null);
        }
        this.attributeEvents.clear();
        for (GeofenceAssetAdapter geofenceAssetAdapter : this.geofenceAssetAdapters) {
            geofenceAssetAdapter.stop(container);
        }
    }

    protected static boolean isRuleState(MetaHolder metaHolder) {
        if (metaHolder.getMeta() == null) {
            return false;
        }
        return metaHolder.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.RULE_STATE).orElse(metaHolder.getMeta().has((NameHolder)MetaItemType.AGENT_LINK));
    }

    public void onAttributeEvent(AttributeEvent event) throws AssetProcessingException {
        if (!this.startDone) {
            this.preInitAttributeEvents.add(event);
        } else {
            this.doProcessAttributeUpdate(event);
        }
    }

    protected void doProcessAttributeUpdate(AttributeEvent attributeEvent) {
        if (RulesService.isRuleState((MetaHolder)attributeEvent) && !attributeEvent.isDeleted()) {
            this.insertOrUpdateAttributeInfo(attributeEvent);
        } else {
            this.retractAttributeInfo(attributeEvent);
        }
    }

    public boolean isRulesetKnown(Ruleset ruleset) {
        if (ruleset instanceof GlobalRuleset) {
            RulesEngine<GlobalRuleset> globalRulesEngine = this.globalEngine.get();
            return globalRulesEngine != null && globalRulesEngine.deployments.containsKey(ruleset.getId()) && globalRulesEngine.deployments.get((Object)ruleset.getId()).ruleset.getRules().equals(ruleset.getRules());
        }
        if (ruleset instanceof RealmRuleset) {
            RealmRuleset realmRuleset = (RealmRuleset)ruleset;
            return this.realmEngines.get(realmRuleset.getRealm()) != null && this.realmEngines.get((Object)realmRuleset.getRealm()).deployments.containsKey(ruleset.getId()) && this.realmEngines.get((Object)realmRuleset.getRealm()).deployments.get((Object)ruleset.getId()).ruleset.getRules().equals(ruleset.getRules());
        }
        if (ruleset instanceof AssetRuleset) {
            AssetRuleset assetRuleset = (AssetRuleset)ruleset;
            return this.assetEngines.get(assetRuleset.getAssetId()) != null && this.assetEngines.get((Object)assetRuleset.getAssetId()).deployments.containsKey(ruleset.getId()) && this.assetEngines.get((Object)assetRuleset.getAssetId()).deployments.get((Object)ruleset.getId()).ruleset.getRules().equals(ruleset.getRules());
        }
        return false;
    }

    public GeofenceDefinition[] getAssetGeofences(String assetId) {
        LOG.finest("Requesting geofences for asset: " + assetId);
        for (GeofenceAssetAdapter geofenceAdapter : this.geofenceAssetAdapters) {
            GeofenceDefinition[] geofences = geofenceAdapter.getAssetGeofences(assetId);
            if (geofences == null) continue;
            LOG.finest("Retrieved geofences from geofence adapter '" + geofenceAdapter.getName() + "' for asset: " + assetId);
            return geofences;
        }
        return new GeofenceDefinition[0];
    }

    protected void processRealmChange(Realm realm, PersistenceEvent.Cause cause) {
        boolean wasEnabled = Arrays.stream(this.realms).anyMatch(t -> realm.getName().equals(t.getName()) && realm.getId().equals(t.getId()));
        boolean isEnabled = realm.getEnabled() != false && cause != PersistenceEvent.Cause.DELETE;
        this.realms = (Realm[])Arrays.stream(this.identityService.getIdentityProvider().getRealms()).filter(Realm::getEnabled).toArray(Realm[]::new);
        if (wasEnabled == isEnabled) {
            return;
        }
        if (wasEnabled) {
            RulesEngine<RealmRuleset> realmRulesEngine = this.realmEngines.get(realm.getName());
            if (realmRulesEngine != null) {
                realmRulesEngine.stop();
                this.realmEngines.remove(realm.getName());
            }
            this.assetEngines.values().removeIf(engine -> {
                boolean remove = engine.getId().getRealm().map(r -> r.equals(realm.getName())).orElse(false);
                if (remove) {
                    engine.stop();
                }
                return remove;
            });
        } else {
            this.rulesetStorageService.findAll(RealmRuleset.class, new RulesetQuery().setRealm(realm.getName()).setFullyPopulate(true).setEnabledOnly(true)).stream().map(this::deployRealmRuleset).filter(Objects::nonNull).forEach(RulesEngine::start);
            this.deployAssetRulesets(this.rulesetStorageService.findAll(AssetRuleset.class, new RulesetQuery().setRealm(realm.getName()).setEnabledOnly(true).setFullyPopulate(true))).forEach(RulesEngine::start);
        }
    }

    protected void processAssetChange(Asset<?> asset, PersistenceEvent<Asset<?>> persistenceEvent) {
        switch (persistenceEvent.getCause()) {
            case DELETE: {
                this.assetEngines.values().removeIf(re -> {
                    if (re.getId().getAssetId().map(aId -> aId.equals(asset.getId())).orElse(false).booleanValue()) {
                        re.stop();
                        return true;
                    }
                    return false;
                });
                break;
            }
        }
    }

    protected void processRulesetChange(Ruleset ruleset, PersistenceEvent.Cause cause) {
        if (cause == PersistenceEvent.Cause.DELETE || !ruleset.isEnabled()) {
            if (ruleset instanceof GlobalRuleset) {
                this.undeployGlobalRuleset((GlobalRuleset)ruleset);
            } else if (ruleset instanceof RealmRuleset) {
                this.undeployRealmRuleset((RealmRuleset)ruleset);
            } else if (ruleset instanceof AssetRuleset) {
                this.undeployAssetRuleset((AssetRuleset)ruleset);
            }
        } else if (ruleset instanceof GlobalRuleset) {
            RulesEngine<GlobalRuleset> engine = this.deployGlobalRuleset((GlobalRuleset)ruleset);
            engine.start();
        } else if (ruleset instanceof RealmRuleset) {
            RulesEngine<RealmRuleset> engine = this.deployRealmRuleset((RealmRuleset)ruleset);
            engine.start();
        } else if (ruleset instanceof AssetRuleset) {
            AssetRuleset assetRuleset = this.rulesetStorageService.find(AssetRuleset.class, ruleset.getId());
            RulesEngine<AssetRuleset> engine = this.deployAssetRuleset(assetRuleset);
            engine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RulesEngine<GlobalRuleset> deployGlobalRuleset(GlobalRuleset ruleset) {
        Object object = ENGINE_LOCK;
        synchronized (object) {
            boolean isNewEngine;
            RulesEngine<Object> engine = this.globalEngine.get();
            boolean bl = isNewEngine = engine == null;
            if (isNewEngine) {
                engine = new RulesEngine(this.timerService, this, this.identityService, this.executorService, this.scheduledExecutorService, this.assetStorageService, this.assetProcessingService, this.notificationService, this.webhookService, this.alarmService, this.clientEventService, this.assetDatapointService, this.assetPredictedDatapointService, new RulesEngineId(), this.locationPredicateRulesConsumer, this.rulesFiringTimer);
                this.globalEngine.set(engine);
            }
            if (isNewEngine) {
                RulesEngine<GlobalRuleset> finalEngine = engine;
                this.attributeEvents.forEach(assetState -> finalEngine.insertOrUpdateAttributeInfo((AttributeInfo)assetState, true));
            }
            engine.addRuleset(ruleset);
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployGlobalRuleset(GlobalRuleset ruleset) {
        Object object = ENGINE_LOCK;
        synchronized (object) {
            RulesEngine<GlobalRuleset> engine = this.globalEngine.get();
            if (engine == null) {
                return;
            }
            if (engine.removeRuleset((Ruleset)ruleset)) {
                this.globalEngine.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RulesEngine<RealmRuleset> deployRealmRuleset(RealmRuleset ruleset) {
        Object object = ENGINE_LOCK;
        synchronized (object) {
            boolean isNewEngine;
            RulesEngine<Object> realmRulesEngine = this.realmEngines.get(ruleset.getRealm());
            boolean bl = isNewEngine = realmRulesEngine == null;
            if (isNewEngine) {
                realmRulesEngine = new RulesEngine(this.timerService, this, this.identityService, this.executorService, this.scheduledExecutorService, this.assetStorageService, this.assetProcessingService, this.notificationService, this.webhookService, this.alarmService, this.clientEventService, this.assetDatapointService, this.assetPredictedDatapointService, new RulesEngineId(ruleset.getRealm()), this.locationPredicateRulesConsumer, this.rulesFiringTimer);
                this.realmEngines.put(ruleset.getRealm(), realmRulesEngine);
                RulesEngine<Object> finalRealmRulesEngine = realmRulesEngine;
                this.attributeEvents.forEach(assetState -> {
                    if (assetState.getRealm().equals(ruleset.getRealm())) {
                        finalRealmRulesEngine.insertOrUpdateAttributeInfo((AttributeInfo)assetState, true);
                    }
                });
            }
            realmRulesEngine.addRuleset(ruleset);
            return realmRulesEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployRealmRuleset(RealmRuleset ruleset) {
        Object object = ENGINE_LOCK;
        synchronized (object) {
            RulesEngine<RealmRuleset> realmRulesEngine = this.realmEngines.get(ruleset.getRealm());
            if (realmRulesEngine == null) {
                return;
            }
            if (realmRulesEngine.removeRuleset((Ruleset)ruleset)) {
                this.realmEngines.remove(ruleset.getRealm());
            }
        }
    }

    protected Stream<RulesEngine<AssetRuleset>> deployAssetRulesets(List<AssetRuleset> rulesets) {
        return rulesets.stream().collect(Collectors.groupingBy(AssetRuleset::getAssetId)).entrySet().stream().map(es -> new Pair(this.assetStorageService.find((String)es.getKey(), true), (Object)((List)es.getValue()))).filter(assetAndRules -> assetAndRules.key != null).collect(Collectors.groupingBy(assetAndRules -> ((Asset)assetAndRules.key).getRealm())).entrySet().stream().filter(es -> Arrays.stream(this.realms).anyMatch(at -> ((String)es.getKey()).equals(at.getName()))).flatMap(es -> {
            List realmAssetAndRules = (List)es.getValue();
            return realmAssetAndRules.stream().flatMap(assetAndRules -> ((List)assetAndRules.value).stream()).map(this::deployAssetRuleset);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RulesEngine<AssetRuleset> deployAssetRuleset(AssetRuleset ruleset) {
        Object object = ENGINE_LOCK;
        synchronized (object) {
            boolean isNewEngine;
            RulesEngine<Object> assetRulesEngine = this.assetEngines.get(ruleset.getAssetId());
            boolean bl = isNewEngine = assetRulesEngine == null;
            if (isNewEngine) {
                assetRulesEngine = new RulesEngine(this.timerService, this, this.identityService, this.executorService, this.scheduledExecutorService, this.assetStorageService, this.assetProcessingService, this.notificationService, this.webhookService, this.alarmService, this.clientEventService, this.assetDatapointService, this.assetPredictedDatapointService, new RulesEngineId(ruleset.getRealm(), ruleset.getAssetId()), this.locationPredicateRulesConsumer, this.rulesFiringTimer);
                this.assetEngines.put(ruleset.getAssetId(), assetRulesEngine);
                RulesEngine<Object> finalAssetRulesEngine = assetRulesEngine;
                this.getAssetStatesInScope(ruleset.getAssetId()).forEach(assetState -> finalAssetRulesEngine.insertOrUpdateAttributeInfo((AttributeInfo)assetState, true));
            }
            assetRulesEngine.addRuleset(ruleset);
            return assetRulesEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployAssetRuleset(AssetRuleset ruleset) {
        Object object = ENGINE_LOCK;
        synchronized (object) {
            RulesEngine<AssetRuleset> rulesEngine = this.assetEngines.get(ruleset.getAssetId());
            if (rulesEngine == null) {
                return;
            }
            if (rulesEngine.removeRuleset((Ruleset)ruleset)) {
                this.assetEngines.remove(ruleset.getAssetId());
            }
        }
    }

    protected void insertOrUpdateAttributeInfo(AttributeEvent attributeEvent) {
        if (attributeEvent.isOutdated()) {
            return;
        }
        LOG.log(Level.FINEST, () -> "Inserting attribute event: " + String.valueOf(attributeEvent));
        boolean inserted = !this.attributeEvents.remove(attributeEvent);
        this.attributeEvents.add(attributeEvent);
        List<RulesEngine<?>> rulesEngines = this.getEnginesInScope(attributeEvent.getRealm(), attributeEvent.getPath());
        for (RulesEngine<?> rulesEngine : rulesEngines) {
            rulesEngine.insertOrUpdateAttributeInfo((AttributeInfo)attributeEvent, inserted);
        }
    }

    protected void retractAttributeInfo(AttributeEvent attributeEvent) {
        LOG.log(Level.FINEST, () -> "Retracting attribute event: " + String.valueOf(attributeEvent));
        this.attributeEvents.remove(attributeEvent);
        List<RulesEngine<?>> rulesEngines = this.getEnginesInScope(attributeEvent.getRealm(), attributeEvent.getPath());
        for (RulesEngine<?> rulesEngine : rulesEngines) {
            rulesEngine.retractAttributeInfo((AttributeInfo)attributeEvent);
        }
    }

    protected List<AttributeInfo> getAssetStatesInScope(String assetId) {
        return this.attributeEvents.stream().filter(assetState -> Arrays.asList(assetState.getPath()).contains(assetId)).collect(Collectors.toList());
    }

    protected List<RulesEngine<?>> getEnginesInScope(String realm, String[] assetPath) {
        RulesEngine<RealmRuleset> realmRulesEngine;
        ArrayList rulesEngines = new ArrayList();
        RulesEngine<GlobalRuleset> globalRulesEngine = this.globalEngine.get();
        if (globalRulesEngine != null) {
            rulesEngines.add(globalRulesEngine);
        }
        if ((realmRulesEngine = this.realmEngines.get(realm)) != null) {
            rulesEngines.add(realmRulesEngine);
        }
        for (String assetId : assetPath) {
            RulesEngine<AssetRuleset> assetRulesEngine = this.assetEngines.get(assetId);
            if (assetRulesEngine == null) continue;
            rulesEngines.add(assetRulesEngine);
        }
        return rulesEngines;
    }

    protected Stream<Pair<Asset<?>, Stream<Attribute<?>>>> findRuleStateAttributes() {
        List<Asset<?>> assets = this.assetStorageService.findAll(new AssetQuery());
        return assets.stream().map(asset -> new Pair(asset, asset.getAttributes().stream().filter(RulesService::isRuleState)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEngineLocationRulesChanged(RulesEngine<?> rulesEngine, List<RulesEngine.AssetLocationPredicates> newEngineAssetStateLocationPredicates) {
        Set<String> set = this.assetsWithModifiedLocationPredicates;
        synchronized (set) {
            int initialModifiedCount = this.assetsWithModifiedLocationPredicates.size();
            if (newEngineAssetStateLocationPredicates == null) {
                this.engineAssetLocationPredicateMap.computeIfPresent(rulesEngine, (re, existingAssetStateLocationPredicates) -> {
                    this.assetsWithModifiedLocationPredicates.addAll(existingAssetStateLocationPredicates.stream().map(RulesEngine.AssetLocationPredicates::getAssetId).toList());
                    return null;
                });
            } else {
                this.engineAssetLocationPredicateMap.compute(rulesEngine, (re, existingEngineAssetStateLocationPredicates) -> {
                    if (existingEngineAssetStateLocationPredicates == null) {
                        this.assetsWithModifiedLocationPredicates.addAll(newEngineAssetStateLocationPredicates.stream().map(RulesEngine.AssetLocationPredicates::getAssetId).toList());
                    } else {
                        existingEngineAssetStateLocationPredicates.forEach(existingAssetStateLocationPredicates -> {
                            Optional<RulesEngine.AssetLocationPredicates> newAssetStateLocationPredicates = newEngineAssetStateLocationPredicates.stream().filter(assetStateLocationPredicates -> assetStateLocationPredicates.getAssetId().equals(existingAssetStateLocationPredicates.getAssetId())).findFirst();
                            if (newAssetStateLocationPredicates.isPresent()) {
                                if (!newAssetStateLocationPredicates.get().getLocationPredicates().equals(existingAssetStateLocationPredicates.getLocationPredicates())) {
                                    this.assetsWithModifiedLocationPredicates.add(existingAssetStateLocationPredicates.getAssetId());
                                }
                            } else {
                                this.assetsWithModifiedLocationPredicates.add(existingAssetStateLocationPredicates.getAssetId());
                            }
                        });
                        newEngineAssetStateLocationPredicates.forEach(newAssetStateLocationPredicates -> {
                            boolean isNewAssetState = existingEngineAssetStateLocationPredicates.stream().noneMatch(assetStateLocationPredicates -> assetStateLocationPredicates.getAssetId().equals(newAssetStateLocationPredicates.getAssetId()));
                            if (isNewAssetState) {
                                this.assetsWithModifiedLocationPredicates.add(newAssetStateLocationPredicates.getAssetId());
                            }
                        });
                    }
                    return newEngineAssetStateLocationPredicates;
                });
            }
            if (this.assetsWithModifiedLocationPredicates.size() != initialModifiedCount) {
                this.processModifiedGeofences();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processModifiedGeofences() {
        Set<String> set = this.assetsWithModifiedLocationPredicates;
        synchronized (set) {
            LOG.finest("Processing geofence modifications: modified asset geofence count=" + this.assetsWithModifiedLocationPredicates.size());
            try {
                ArrayList<RulesEngine.AssetLocationPredicates> assetLocationPredicates = new ArrayList<RulesEngine.AssetLocationPredicates>(this.assetsWithModifiedLocationPredicates.size());
                this.assetsWithModifiedLocationPredicates.forEach(assetId -> {
                    RulesEngine.AssetLocationPredicates locationPredicates = new RulesEngine.AssetLocationPredicates((String)assetId, (Set<GeofencePredicate>)new HashSet<GeofencePredicate>());
                    this.engineAssetLocationPredicateMap.forEach((rulesEngine, engineAssetStateLocationPredicates) -> engineAssetStateLocationPredicates.stream().filter(assetStateLocationPredicates -> assetStateLocationPredicates.getAssetId().equals(assetId)).findFirst().ifPresent(assetStateLocationPredicate -> locationPredicates.getLocationPredicates().addAll(assetStateLocationPredicate.getLocationPredicates())));
                    assetLocationPredicates.add(locationPredicates);
                });
                for (GeofenceAssetAdapter geofenceAssetAdapter : this.geofenceAssetAdapters) {
                    LOG.finest("Passing modified geofences to adapter: " + geofenceAssetAdapter.getName());
                    geofenceAssetAdapter.processLocationPredicates(assetLocationPredicates);
                    if (!assetLocationPredicates.isEmpty()) continue;
                    LOG.finest("All modified geofences handled");
                    break;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception thrown by geofence adapter whilst processing location predicates", e);
            }
            finally {
                this.assetsWithModifiedLocationPredicates.clear();
            }
        }
    }

    protected Optional<RulesetDeployment> getRulesetDeployment(Long rulesetId) {
        RulesEngine<GlobalRuleset> globalRulesEngine = this.globalEngine.get();
        if (globalRulesEngine != null && globalRulesEngine.deployments.containsKey(rulesetId)) {
            return Optional.of(globalRulesEngine.deployments.get(rulesetId));
        }
        for (Map.Entry<String, RulesEngine<RealmRuleset>> entry : this.realmEngines.entrySet()) {
            if (!entry.getValue().deployments.containsKey(rulesetId)) continue;
            return Optional.of(entry.getValue().deployments.get(rulesetId));
        }
        for (Map.Entry<String, RulesEngine<RealmRuleset>> entry : this.assetEngines.entrySet()) {
            if (!entry.getValue().deployments.containsKey(rulesetId)) continue;
            return Optional.of(entry.getValue().deployments.get(rulesetId));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDeploymentsWithPredictedDataForAsset(String assetId) {
        List<AttributeInfo> assetStates = this.getAssetStatesInScope(assetId);
        if (!assetStates.isEmpty()) {
            String realm = assetStates.get(0).getRealm();
            String[] assetPaths = (String[])assetStates.stream().flatMap(assetState -> Arrays.stream(assetState.getPath())).toArray(String[]::new);
            Object object = ENGINE_LOCK;
            synchronized (object) {
                for (RulesEngine<?> rulesEngine : this.getEnginesInScope(realm, assetPaths)) {
                    rulesEngine.scheduleFire(false);
                }
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{}";
    }
}

