/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.RulesService;
import org.openremote.manager.rules.RulesetStorageService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.http.RequestParams;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.RulesetQuery;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.RulesEngineInfo;
import org.openremote.model.rules.RulesResource;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.rules.geofence.GeofenceDefinition;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.Realm;

public class RulesResourceImpl
extends ManagerWebResource
implements RulesResource {
    private static final Logger LOG = Logger.getLogger(RulesResourceImpl.class.getName());
    protected final RulesetStorageService rulesetStorageService;
    protected final AssetStorageService assetStorageService;
    protected final RulesService rulesService;

    public RulesResourceImpl(TimerService timerService, ManagerIdentityService identityService, RulesetStorageService rulesetStorageService, AssetStorageService assetStorageService, RulesService rulesService) {
        super(timerService, identityService);
        this.rulesetStorageService = rulesetStorageService;
        this.assetStorageService = assetStorageService;
        this.rulesService = rulesService;
    }

    public RulesEngineInfo getGlobalEngineInfo(RequestParams requestParams) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.getEngineInfo(this.rulesService.globalEngine.get());
    }

    public RulesEngineInfo getRealmEngineInfo(RequestParams requestParams, String realm) {
        if (!this.isRealmAccessibleByUser(realm) || this.isRestrictedUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        RulesEngine<RealmRuleset> engine = this.rulesService.realmEngines.get(realm);
        return this.getEngineInfo(engine);
    }

    public RulesEngineInfo getAssetEngineInfo(RequestParams requestParams, String assetId) {
        Asset<?> asset = this.assetStorageService.find(assetId, false);
        if (asset == null) {
            return null;
        }
        if (!this.isRealmAccessibleByUser(asset.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        RulesEngine<AssetRuleset> engine = this.rulesService.assetEngines.get(assetId);
        return this.getEngineInfo(engine);
    }

    protected RulesEngineInfo getEngineInfo(RulesEngine engine) {
        if (engine == null) {
            return null;
        }
        int compilationErrorCount = engine.getCompilationErrorDeploymentCount();
        int executionErrorCount = engine.getExecutionErrorDeploymentCount();
        return new RulesEngineInfo(engine.getStatus(), compilationErrorCount, executionErrorCount);
    }

    public GlobalRuleset[] getGlobalRulesets(@BeanParam RequestParams requestParams, List<Ruleset.Lang> languages, boolean fullyPopulate) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        List<GlobalRuleset> result = this.rulesetStorageService.findAll(GlobalRuleset.class, new RulesetQuery().setLanguages(languages.toArray(new Ruleset.Lang[0])).setFullyPopulate(fullyPopulate));
        result.forEach(ruleset -> this.rulesService.getRulesetDeployment(ruleset.getId()).ifPresent(rulesetDeployment -> {
            ruleset.setStatus(rulesetDeployment.getStatus());
            ruleset.setError(rulesetDeployment.getErrorMessage());
        }));
        return result.toArray(new GlobalRuleset[0]);
    }

    public RealmRuleset[] getRealmRulesets(@BeanParam RequestParams requestParams, String realm, List<Ruleset.Lang> languages, boolean fullyPopulate) {
        if (this.isAuthenticated() && !this.isRealmAccessibleByUser(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        boolean publicOnly = !this.isAuthenticated() || this.isRestrictedUser() | !this.hasResourceRole(ClientRole.READ_RULES.getValue(), "openremote");
        List<RealmRuleset> result = this.rulesetStorageService.findAll(RealmRuleset.class, new RulesetQuery().setRealm(realm).setLanguages(languages.toArray(new Ruleset.Lang[0])).setFullyPopulate(fullyPopulate).setPublicOnly(publicOnly));
        result.forEach(ruleset -> this.rulesService.getRulesetDeployment(ruleset.getId()).ifPresent(rulesetDeployment -> {
            ruleset.setStatus(rulesetDeployment.getStatus());
            ruleset.setError(rulesetDeployment.getErrorMessage());
        }));
        return result.toArray(new RealmRuleset[0]);
    }

    public AssetRuleset[] getAssetRulesets(@BeanParam RequestParams requestParams, String assetId, List<Ruleset.Lang> languages, boolean fullyPopulate) {
        Asset<?> asset = this.assetStorageService.find(assetId, false);
        if (asset == null) {
            return new AssetRuleset[0];
        }
        if (this.isAuthenticated() && !this.isRealmAccessibleByUser(asset.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        boolean publicOnly = !this.isAuthenticated() || this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), assetId) || !this.hasResourceRole(ClientRole.READ_RULES.getValue(), "openremote");
        List<AssetRuleset> result = this.rulesetStorageService.findAll(AssetRuleset.class, new RulesetQuery().setRealm(asset.getRealm()).setAssetIds(new String[]{assetId}).setPublicOnly(publicOnly).setLanguages(languages.toArray(new Ruleset.Lang[0])).setFullyPopulate(fullyPopulate));
        result.forEach(ruleset -> this.rulesService.getRulesetDeployment(ruleset.getId()).ifPresent(rulesetDeployment -> {
            ruleset.setStatus(rulesetDeployment.getStatus());
            ruleset.setError(rulesetDeployment.getErrorMessage());
        }));
        return result.toArray(new AssetRuleset[0]);
    }

    public long createGlobalRuleset(@BeanParam RequestParams requestParams, GlobalRuleset ruleset) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ruleset = this.rulesetStorageService.merge(ruleset);
        return ruleset.getId();
    }

    public GlobalRuleset getGlobalRuleset(@BeanParam RequestParams requestParams, Long id) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        GlobalRuleset ruleset = this.rulesetStorageService.find(GlobalRuleset.class, id);
        if (ruleset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return ruleset;
    }

    public void updateGlobalRuleset(@BeanParam RequestParams requestParams, Long id, GlobalRuleset ruleset) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        GlobalRuleset existingRuleset = this.rulesetStorageService.find(GlobalRuleset.class, id);
        if (existingRuleset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.rulesetStorageService.merge(ruleset);
    }

    public void deleteGlobalRuleset(@BeanParam RequestParams requestParams, Long id) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.rulesetStorageService.delete(GlobalRuleset.class, id);
    }

    public long createRealmRuleset(@BeanParam RequestParams requestParams, RealmRuleset ruleset) {
        Realm realm = this.identityService.getIdentityProvider().getRealm(ruleset.getRealm());
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm) || this.isRestrictedUser()) {
            LOG.fine("Realm '" + String.valueOf(realm) + "' is nonexistent, inactive or inaccessible: username=" + this.getUsername());
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (ruleset.getLang() == Ruleset.Lang.GROOVY && !this.isSuperUser()) {
            throw new ForbiddenException("Only super users can create/modify groovy rules for security reasons");
        }
        ruleset = this.rulesetStorageService.merge(ruleset);
        return ruleset.getId();
    }

    public RealmRuleset getRealmRuleset(@BeanParam RequestParams requestParams, Long id) {
        RealmRuleset ruleset = this.rulesetStorageService.find(RealmRuleset.class, id);
        if (ruleset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Realm realm = this.identityService.getIdentityProvider().getRealm(ruleset.getRealm());
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm) || this.isRestrictedUser()) {
            LOG.fine("Forbidden access for user '" + this.getUsername() + "': " + String.valueOf(realm));
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return ruleset;
    }

    public void updateRealmRuleset(@BeanParam RequestParams requestParams, Long id, RealmRuleset ruleset) {
        RealmRuleset existingRuleset = this.rulesetStorageService.find(RealmRuleset.class, id);
        if (existingRuleset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Realm realm = this.identityService.getIdentityProvider().getRealm(existingRuleset.getRealm());
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm) || this.isRestrictedUser()) {
            LOG.fine("Forbidden access for user '" + this.getUsername() + "': " + String.valueOf(realm));
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!id.equals(ruleset.getId())) {
            throw new WebApplicationException("Requested ID and ruleset ID don't match", Response.Status.BAD_REQUEST);
        }
        if (!existingRuleset.getRealm().equals(ruleset.getRealm())) {
            throw new WebApplicationException("Requested realm and existing ruleset realm must match", Response.Status.BAD_REQUEST);
        }
        if (ruleset.getLang() == Ruleset.Lang.GROOVY && !this.isSuperUser()) {
            throw new ForbiddenException("Only super users can create/modify groovy rules for security reasons");
        }
        this.rulesetStorageService.merge(ruleset);
    }

    public void deleteRealmRuleset(@BeanParam RequestParams requestParams, Long id) {
        RealmRuleset ruleset = this.rulesetStorageService.find(RealmRuleset.class, id);
        if (ruleset == null) {
            return;
        }
        Realm realm = this.identityService.getIdentityProvider().getRealm(ruleset.getRealm());
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm) || this.isRestrictedUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (ruleset.getLang() == Ruleset.Lang.GROOVY && !this.isSuperUser()) {
            throw new ForbiddenException("Only super users can create/modify groovy rules for security reasons");
        }
        this.rulesetStorageService.delete(RealmRuleset.class, id);
    }

    public long createAssetRuleset(@BeanParam RequestParams requestParams, AssetRuleset ruleset) {
        String assetId = ruleset.getAssetId();
        if (assetId == null || assetId.length() == 0) {
            throw new WebApplicationException("Missing asset identifier value", Response.Status.BAD_REQUEST);
        }
        Asset<?> asset = this.assetStorageService.find(assetId, false);
        if (asset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.isRealmAccessibleByUser(asset.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), asset.getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (ruleset.getLang() == Ruleset.Lang.GROOVY && !this.isSuperUser()) {
            throw new ForbiddenException("Only super users can create/modify groovy rules for security reasons");
        }
        ruleset = this.rulesetStorageService.merge(ruleset);
        return ruleset.getId();
    }

    public AssetRuleset getAssetRuleset(@BeanParam RequestParams requestParams, Long id) {
        AssetRuleset ruleset = this.rulesetStorageService.find(AssetRuleset.class, id);
        if (ruleset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Asset<?> asset = this.assetStorageService.find(ruleset.getAssetId(), false);
        if (asset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.isRealmAccessibleByUser(asset.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), asset.getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return ruleset;
    }

    public void updateAssetRuleset(@BeanParam RequestParams requestParams, Long id, AssetRuleset ruleset) {
        AssetRuleset existingRuleset = this.rulesetStorageService.find(AssetRuleset.class, id);
        if (existingRuleset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Asset<?> asset = this.assetStorageService.find(existingRuleset.getAssetId(), false);
        if (asset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.isRealmAccessibleByUser(asset.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), asset.getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!id.equals(ruleset.getId())) {
            throw new WebApplicationException("Requested ID and ruleset ID don't match", Response.Status.BAD_REQUEST);
        }
        if (!existingRuleset.getAssetId().equals(ruleset.getAssetId())) {
            throw new WebApplicationException("Can't update asset ID, delete and create the ruleset to reassign", Response.Status.BAD_REQUEST);
        }
        if (ruleset.getLang() == Ruleset.Lang.GROOVY && !this.isSuperUser()) {
            throw new ForbiddenException("Only super users can create/modify groovy rules for security reasons");
        }
        this.rulesetStorageService.merge(ruleset);
    }

    public void deleteAssetRuleset(@BeanParam RequestParams requestParams, Long id) {
        AssetRuleset ruleset = this.rulesetStorageService.find(AssetRuleset.class, id);
        if (ruleset == null) {
            return;
        }
        Asset<?> asset = this.assetStorageService.find(ruleset.getAssetId(), false);
        if (asset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.isRealmAccessibleByUser(asset.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), asset.getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (ruleset.getLang() == Ruleset.Lang.GROOVY && !this.isSuperUser()) {
            throw new ForbiddenException("Only super users can create/modify groovy rules for security reasons");
        }
        this.rulesetStorageService.delete(AssetRuleset.class, id);
    }

    public GeofenceDefinition[] getAssetGeofences(@BeanParam RequestParams requestParams, String assetId) {
        List<UserAssetLink> userAssetLinks;
        Asset<?> asset = this.assetStorageService.find(new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).ids(new String[]{assetId}));
        if (asset == null) {
            return new GeofenceDefinition[0];
        }
        if (!(asset.isAccessPublicRead() || (userAssetLinks = this.assetStorageService.findUserAssetLinks(asset.getRealm(), null, assetId)).isEmpty() || this.isAuthenticated() && !userAssetLinks.stream().noneMatch(userAssetLink -> userAssetLink.getId().getUserId().equals(this.getUserId())))) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.rulesService.getAssetGeofences(assetId);
    }
}

