/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.util.HashMap;
import java.util.Map;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.RulesService;
import org.openremote.manager.rules.RulesetDeployment;
import org.openremote.model.Container;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.system.HealthStatusProvider;

public class RulesHealthStatusProvider
implements HealthStatusProvider {
    public static final String NAME = "rules";
    protected RulesService rulesService;

    public void init(Container container) throws Exception {
        this.rulesService = (RulesService)container.getService(RulesService.class);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public Object getHealthStatus() {
        int totalEngines = this.rulesService.realmEngines.size() + this.rulesService.assetEngines.size();
        int stoppedEngines = 0;
        int errorEngines = 0;
        RulesEngine<GlobalRuleset> globalEngine = this.rulesService.globalEngine.get();
        if (globalEngine != null) {
            ++totalEngines;
            if (!globalEngine.isRunning()) {
                ++stoppedEngines;
            }
            if (globalEngine.isError()) {
                ++errorEngines;
            }
        }
        HashMap<String, Map<String, Object>> realmEngines = new HashMap<String, Map<String, Object>>();
        for (RulesEngine<RealmRuleset> realmEngine : this.rulesService.realmEngines.values()) {
            if (!realmEngine.isRunning()) {
                ++stoppedEngines;
            }
            if (realmEngine.isError()) {
                ++errorEngines;
            }
            realmEngines.put(realmEngine.getId().getRealm().orElse(""), this.getEngineHealthStatus(realmEngine));
        }
        HashMap<String, Map<String, Object>> assetEngines = new HashMap<String, Map<String, Object>>();
        for (RulesEngine rulesEngine : this.rulesService.assetEngines.values()) {
            if (!rulesEngine.isRunning()) {
                ++stoppedEngines;
            }
            if (rulesEngine.isError()) {
                ++errorEngines;
            }
            assetEngines.put(rulesEngine.getId().getAssetId().orElse(""), this.getEngineHealthStatus(rulesEngine));
        }
        HashMap<String, Object> objectValue = new HashMap<String, Object>();
        objectValue.put("totalEngines", totalEngines);
        objectValue.put("stoppedEngines", stoppedEngines);
        objectValue.put("errorEngines", errorEngines);
        if (globalEngine != null) {
            objectValue.put("global", this.getEngineHealthStatus(globalEngine));
        }
        objectValue.put("realm", realmEngines);
        objectValue.put("asset", assetEngines);
        return objectValue;
    }

    protected Map<String, Object> getEngineHealthStatus(RulesEngine<?> rulesEngine) {
        boolean isError = rulesEngine.isError();
        int totalDeployments = rulesEngine.deployments.size();
        int executionErrorDeployments = rulesEngine.getExecutionErrorDeploymentCount();
        int compilationErrorDeployments = rulesEngine.getExecutionErrorDeploymentCount();
        HashMap<String, Object> val = new HashMap<String, Object>();
        val.put("isRunning", rulesEngine.isRunning());
        val.put("isError", isError);
        val.put("totalDeployments", totalDeployments);
        val.put("executionErrorDeployments", executionErrorDeployments);
        val.put("compilationErrorDeployments", compilationErrorDeployments);
        HashMap deployments = new HashMap();
        for (RulesetDeployment deployment : rulesEngine.deployments.values()) {
            HashMap<String, String> dVal = new HashMap<String, String>();
            dVal.put("name", deployment.getName());
            dVal.put("status", deployment.getStatus().name());
            dVal.put("error", deployment.getError() != null ? deployment.getError().getMessage() : null);
            deployments.put(Long.toString(deployment.getId()), dVal);
        }
        val.put("deployments", deployments);
        return val;
    }
}

