/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jeasy.rules.api.Fact;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.AssetQueryPredicate;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.RulesLoopException;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetInfo;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.LogicGroup;
import org.openremote.model.query.filter.GeofencePredicate;
import org.openremote.model.query.filter.LocationAttributePredicate;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.RulesClock;
import org.openremote.model.rules.TemporaryFact;
import org.openremote.model.util.TimeUtil;

public class RulesFacts
extends Facts
implements RuleListener {
    public static final int MAX_RULES_TRIGGERED_PER_EXECUTION = 100;
    public static final int INITIAL_CAPACITY = 100000;
    public static final String ASSET_STATES = "INTERNAL_ASSET_STATES";
    public static final String EXECUTION_VARS = "INTERNAL_EXECUTION_VAR";
    public static final String ANONYMOUS_FACTS = "ANONYMOUS_FACTS";
    protected final TimerService timerService;
    protected final AssetStorageService assetStorageService;
    protected final Assets assetsFacade;
    protected final Object loggingContext;
    protected final Logger LOG;
    protected int triggerCount;
    protected boolean trackLocationRules;
    protected Map<String, Set<GeofencePredicate>> assetStateLocationPredicateMap = null;

    public RulesFacts(TimerService timerService, AssetStorageService assetStorageService, Assets assetsFacade, Object loggingContext, Logger logger) {
        this.timerService = timerService;
        this.assetStorageService = assetStorageService;
        this.assetsFacade = assetsFacade;
        this.loggingContext = loggingContext;
        this.LOG = logger;
        super.put(ASSET_STATES, new ArrayDeque(100000));
        super.put(EXECUTION_VARS, new HashMap());
        super.put(ANONYMOUS_FACTS, new ArrayDeque(100000));
    }

    protected void startTrackingLocationRules() {
        this.LOG.finest("Tracking location predicate rules: started");
        this.trackLocationRules = true;
    }

    protected List<RulesEngine.AssetLocationPredicates> stopTrackingLocationRules() {
        this.LOG.finest("Tracking location predicate rules: stopping");
        this.trackLocationRules = false;
        Map<String, Set<GeofencePredicate>> assetStateLocationPredicateMap = this.assetStateLocationPredicateMap;
        this.assetStateLocationPredicateMap = null;
        return assetStateLocationPredicateMap == null ? null : assetStateLocationPredicateMap.entrySet().stream().map(assetStateSetEntry -> new RulesEngine.AssetLocationPredicates((String)assetStateSetEntry.getKey(), (Set)assetStateSetEntry.getValue())).collect(Collectors.toList());
    }

    public Collection<AttributeInfo> getAssetStates() {
        return (Collection)this.get(ASSET_STATES);
    }

    public Collection<Object> getAnonymousFacts() {
        return (Collection)this.get(ANONYMOUS_FACTS);
    }

    public Map<String, Object> getNamedFacts() {
        return this.asMap().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(ASSET_STATES) && !((String)entry.getKey()).equals(EXECUTION_VARS) && !((String)entry.getKey()).equals(ANONYMOUS_FACTS)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Stream<Object> getAllFacts() {
        return (Stream)Stream.concat((Stream)this.getNamedFacts().values().stream().parallel(), Stream.concat((Stream)this.getAnonymousFacts().stream().parallel(), (Stream)this.getAssetStates().stream().parallel())).parallel();
    }

    public long getFactCount() {
        return this.getNamedFacts().size() + this.getAnonymousFacts().size() + this.getAssetStates().size();
    }

    public Map<String, Object> getVars() {
        return (Map)this.get(EXECUTION_VARS);
    }

    public RulesFacts bind(String var, Object value) {
        this.getVars().put(var, value);
        return this;
    }

    public <T> T bound(String var) {
        return (T)this.getVars().get(var);
    }

    public <T> T get(String name) {
        Object fact = super.get(name);
        if (fact != null && fact instanceof TemporaryFact) {
            TemporaryFact temporaryFact = (TemporaryFact)fact;
            fact = temporaryFact.getFact();
        }
        return (T)fact;
    }

    public <T> Optional<T> getOptional(String name) {
        return Optional.ofNullable(this.get(name));
    }

    public <T> void put(String name, T fact) {
        switch (name) {
            case "ANONYMOUS_FACTS": 
            case "INTERNAL_ASSET_STATES": 
            case "INTERNAL_EXECUTION_VAR": {
                throw new IllegalArgumentException("Reserved internal fact name: " + name);
            }
        }
        if (this.LOG.isLoggable(Level.FINEST)) {
            this.LOG.finest("Fact change (UPDATE): " + name + " => " + String.valueOf(fact) + " - on: " + String.valueOf(this.loggingContext));
        }
        super.put(name, fact);
    }

    public RulesFacts put(Object o) {
        if (this.LOG.isLoggable(Level.FINEST)) {
            this.LOG.finest("Fact change (UPDATE): " + String.valueOf(o) + " - on: " + String.valueOf(this.loggingContext));
        }
        this.getAnonymousFacts().remove(o);
        this.getAnonymousFacts().add(o);
        return this;
    }

    public RulesFacts putAssetState(AttributeInfo assetState) {
        if (this.LOG.isLoggable(Level.FINEST)) {
            this.LOG.finest("Fact change (UPDATE): " + String.valueOf(assetState) + " - on: " + String.valueOf(this.loggingContext));
        }
        this.getAssetStates().remove(assetState);
        this.getAssetStates().add(assetState);
        return this;
    }

    public RulesFacts removeAssetState(AttributeInfo assetState) {
        if (this.LOG.isLoggable(Level.FINEST)) {
            this.LOG.finest("Fact change (DELETE): " + String.valueOf(assetState) + " - on: " + String.valueOf(this.loggingContext));
        }
        this.getAssetStates().remove(assetState);
        return this;
    }

    public RulesFacts putTemporary(String expires, Object value) {
        return this.putTemporary(TimeUtil.parseTimeDuration((String)expires), value);
    }

    public RulesFacts putTemporary(Duration expires, Object value) {
        return this.putTemporary(expires.toMillis(), value);
    }

    public RulesFacts putTemporary(double expires, Object value) {
        return this.putTemporary((long)expires, value);
    }

    public RulesFacts putTemporary(long expires, Object value) {
        this.getAnonymousFacts().add(new TemporaryFact(this.timerService.getCurrentTimeMillis(), expires, value));
        return this;
    }

    public RulesFacts putTemporary(String name, String expires, Object value) {
        return this.putTemporary(name, TimeUtil.parseTimeDuration((String)expires), value);
    }

    public RulesFacts putTemporary(String name, double expires, Object value) {
        return this.putTemporary(name, (long)expires, value);
    }

    public RulesFacts putTemporary(String name, long expires, Object value) {
        this.put(name, new TemporaryFact(this.timerService.getCurrentTimeMillis(), expires, value));
        return this;
    }

    public boolean hasTemporaryFacts() {
        return this.getTemporaryFacts().findAny().isPresent();
    }

    public Stream<TemporaryFact<?>> getTemporaryFacts() {
        return (Stream)Stream.concat(((Stream)this.getNamedFacts().values().stream().parallel()).filter(fact -> fact instanceof TemporaryFact).map(fact -> (TemporaryFact)fact), ((Stream)this.getAnonymousFacts().stream().parallel()).filter(fact -> fact instanceof TemporaryFact).map(fact -> (TemporaryFact)fact)).parallel();
    }

    public void remove(String name) {
        super.remove(name);
    }

    public RulesFacts remove(Object fact) {
        this.getAnonymousFacts().removeIf(anonFact -> {
            if (anonFact instanceof TemporaryFact) {
                anonFact = ((TemporaryFact)anonFact).getFact();
            }
            return anonFact.equals(fact);
        });
        return this;
    }

    public void reset() {
        this.triggerCount = 0;
    }

    public boolean beforeEvaluate(Rule rule, Facts facts) {
        this.getVars().clear();
        this.logRule(rule, "Rule candidate", true, false);
        return true;
    }

    public void afterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        if (evaluationResult) {
            ++this.triggerCount;
            if (this.triggerCount >= 100) {
                throw new RulesLoopException(100, rule.getName());
            }
        }
    }

    public void beforeExecute(Rule rule, Facts facts) {
        this.logRule(rule, "Rule triggered", false, true);
    }

    public void onSuccess(Rule rule, Facts facts) {
        this.logRule(rule, "Rule executed", true, false);
    }

    public void onFailure(Rule rule, Facts facts, Exception exception) {
        throw new RuntimeException("Error executing action of rule '" + rule.getName() + "': " + exception.getMessage(), exception);
    }

    protected <T> Optional<T> matchFact(Object fact, Class<T> factType, Predicate<T> predicate) {
        if (fact == null) {
            return Optional.empty();
        }
        if (fact instanceof TemporaryFact) {
            TemporaryFact temporaryFact = (TemporaryFact)fact;
            fact = temporaryFact.getFact();
        }
        return Optional.ofNullable(factType.isAssignableFrom(fact.getClass()) && predicate.test(fact) ? fact : null);
    }

    public <T> Optional<T> matchFirst(String name) {
        return this.matchFirst(name, (T fact) -> true);
    }

    public <T> Optional<T> matchFirst(String name, Predicate<T> predicate) {
        return this.matchFirst(name, Object.class, predicate);
    }

    public <T> Optional<T> matchFirst(String name, Class<T> factType, Predicate<T> predicate) {
        return this.matchFact(this.get(name), factType, predicate);
    }

    public <T> Optional<T> matchFirst(Predicate<T> predicate) {
        return this.match(predicate).findFirst();
    }

    public <T> Optional<T> matchFirst(Class<T> factType) {
        return this.match(factType).findFirst();
    }

    public <T> Optional<T> matchFirst(Class<T> factType, Predicate<T> predicate) {
        return this.match(factType, predicate).findFirst();
    }

    public <T> Stream<T> match(Predicate<T> predicate) {
        return this.match(Object.class, predicate);
    }

    public <T> Stream<T> match(Class<T> factType) {
        return this.match(factType, fact -> true);
    }

    public <T> Stream<T> match(Class<T> factType, Predicate<T> predicate) {
        return this.getAllFacts().filter(fact -> this.matchFact(fact, factType, predicate).isPresent()).map(fact -> {
            if (fact instanceof TemporaryFact) {
                return ((TemporaryFact)fact).getFact();
            }
            return fact;
        }).map(fact -> fact);
    }

    public Optional<AttributeInfo> matchFirstAssetState(AssetQuery assetQuery) {
        return this.matchAssetState(assetQuery).findFirst();
    }

    public Stream<AttributeInfo> matchAssetState(AssetQuery assetQuery) {
        if (this.trackLocationRules && assetQuery.attributes != null) {
            this.storeLocationPredicates(LocationAttributePredicate.getLocationPredicates((LogicGroup)assetQuery.attributes));
        }
        AssetQueryPredicate p = new AssetQueryPredicate(this.timerService, this.assetStorageService, assetQuery);
        return this.matchAssetState(p);
    }

    public Stream<AttributeInfo> matchAssetState(Predicate<AttributeInfo> p) {
        Stream<AttributeInfo> assetStates = this.getAssetStates().stream();
        return ((Stream)assetStates.parallel()).filter(p);
    }

    @Deprecated
    public RulesFacts updateAssetState(String assetId, String attributeName, Object value) {
        AttributeEvent attributeEvent = new AttributeEvent(assetId, attributeName, value);
        this.LOG.finest("Dispatching " + String.valueOf(attributeEvent) + " - on: " + String.valueOf(this.loggingContext));
        this.assetsFacade.dispatch(new AttributeEvent[]{attributeEvent});
        return this;
    }

    @Deprecated
    public RulesFacts updateAssetState(String assetId, String attributeName) {
        AttributeEvent attributeEvent = new AttributeEvent(assetId, attributeName, null);
        this.LOG.finest("Dispatching " + String.valueOf(attributeEvent) + " - on: " + String.valueOf(this.loggingContext));
        this.assetsFacade.dispatch(new AttributeEvent[]{attributeEvent});
        return this;
    }

    public void removeExpiredTemporaryFacts() {
        long currentTimestamp = this.timerService.getCurrentTimeMillis();
        List<Fact> expiredFacts = StreamSupport.stream(super.spliterator(), false).filter(fact -> {
            if (fact.getName().equals(ASSET_STATES) || fact.getName().equals(EXECUTION_VARS) || fact.getName().equals(ANONYMOUS_FACTS) || !(fact.getValue() instanceof TemporaryFact)) {
                return false;
            }
            boolean result = ((TemporaryFact)fact.getValue()).isExpired(currentTimestamp);
            if (result && this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.finest("Fact change (DELETE EXPIRED): " + String.valueOf(fact.getValue()) + " - on: " + String.valueOf(this.loggingContext));
            }
            return result;
        }).toList();
        expiredFacts.forEach(arg_0 -> ((RulesFacts)this).remove(arg_0));
        this.getAnonymousFacts().removeIf(fact -> {
            boolean result = false;
            if (fact instanceof TemporaryFact) {
                TemporaryFact temporaryFact = (TemporaryFact)fact;
                result = temporaryFact.isExpired(this.timerService.getCurrentTimeMillis());
            }
            if (result && this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.finest("Fact change (DELETE EXPIRED): " + String.valueOf(fact) + " - on: " + String.valueOf(this.loggingContext));
            }
            return result;
        });
    }

    public boolean logFacts(Logger logger, Level level) {
        if (!logger.isLoggable(level)) {
            return false;
        }
        boolean haveLog = false;
        if (this.getAllFacts().findAny().isPresent()) {
            logger.log(level, "--------------------------------- CLOCK ---------------------------------");
            logger.log(level, Instant.ofEpochMilli(this.timerService.getCurrentTimeMillis()).toString());
            haveLog = true;
        }
        ArrayList<AttributeInfo> sortedAssetStates = new ArrayList<AttributeInfo>(this.getAssetStates());
        sortedAssetStates.sort(Comparator.naturalOrder());
        if (!sortedAssetStates.isEmpty()) {
            logger.log(level, "--------------------------------- ASSET STATES (" + sortedAssetStates.size() + ") ---------------------------------");
            for (AttributeInfo assetState : sortedAssetStates) {
                logger.log(level, assetState.toString());
            }
            haveLog = true;
        }
        Map<String, Object> namedFacts = this.getNamedFacts();
        ArrayList<String> names = new ArrayList<String>(namedFacts.keySet());
        names.sort(Comparator.naturalOrder());
        if (!names.isEmpty()) {
            logger.log(level, "--------------------------------- NAMED FACTS (" + names.size() + ") ---------------------------------");
            for (String name : names) {
                logger.log(level, String.format("%s => %s", name, namedFacts.get(name)));
            }
            haveLog = true;
        }
        if (!this.getAnonymousFacts().isEmpty()) {
            logger.log(level, "--------------------------------- ANONYMOUS FACTS (" + this.getAnonymousFacts().size() + ") ---------------------------------");
            for (Object o : this.getAnonymousFacts()) {
                logger.log(level, String.format("%s", o));
            }
            haveLog = true;
        }
        return haveLog;
    }

    public boolean logVars(Logger logger) {
        boolean haveLog = false;
        ArrayList<String> sortedVars = new ArrayList<String>(this.getVars().keySet());
        sortedVars.sort(Comparator.naturalOrder());
        if (!sortedVars.isEmpty()) {
            logger.info("--------------------------------- BOUND VARIABLES (" + sortedVars.size() + ") ---------------------------------");
            for (String var : sortedVars) {
                logger.info(String.format("%s => %s", var, this.getVars().get(var)));
            }
            haveLog = true;
        }
        return haveLog;
    }

    public RulesClock getClock() {
        return this.timerService;
    }

    public static Comparator<AttributeInfo> asComparator(AssetQuery.OrderBy orderBy) {
        Function<AttributeInfo, String> keyExtractor = AssetInfo::getAssetName;
        boolean reverse = orderBy.descending;
        keyExtractor = switch (orderBy.property) {
            case AssetQuery.OrderBy.Property.CREATED_ON -> assetState -> Long.toString(assetState.getCreatedOn().getTime());
            case AssetQuery.OrderBy.Property.ASSET_TYPE -> AssetInfo::getAssetType;
            case AssetQuery.OrderBy.Property.PARENT_ID -> AssetInfo::getParentId;
            case AssetQuery.OrderBy.Property.REALM -> AssetInfo::getRealm;
            default -> keyExtractor;
        };
        Comparator<AttributeInfo> comparator = Comparator.comparing(keyExtractor);
        if (reverse) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    protected void storeLocationPredicates(List<GeofencePredicate> foundLocationPredicates) {
        if (foundLocationPredicates != null && !foundLocationPredicates.isEmpty()) {
            this.LOG.finest("Location predicate found");
            Collection locationAssetStates = this.getAssetStates().stream().filter(assetState -> assetState.getName().equalsIgnoreCase(Asset.LOCATION.getName())).collect(Collectors.toSet());
            if (this.assetStateLocationPredicateMap == null) {
                this.assetStateLocationPredicateMap = new HashMap<String, Set<GeofencePredicate>>(locationAssetStates.size());
            }
            locationAssetStates.forEach(assetState -> {
                if (!this.assetStateLocationPredicateMap.containsKey(assetState.getId())) {
                    this.assetStateLocationPredicateMap.put(assetState.getId(), new HashSet());
                }
            });
            this.assetStateLocationPredicateMap.forEach((assetState, locationPredicates) -> locationPredicates.addAll(foundLocationPredicates));
        }
    }

    protected void logRule(Rule rule, String msg, boolean logFacts, boolean logVars) {
        String ruleName = rule.getName();
        if (ruleName.startsWith("-") && this.LOG.isLoggable(Level.INFO)) {
            this.LOG.log(Level.INFO, String.format("*** %s: %s - on %s", msg, ruleName, this.loggingContext));
        }
        if (ruleName.startsWith("--") && this.LOG.isLoggable(Level.INFO)) {
            boolean haveLog = false;
            if (logFacts) {
                haveLog = this.logFacts(this.LOG, Level.INFO);
            }
            if (logVars) {
                boolean bl = haveLog = haveLog || this.logVars(this.LOG);
            }
            if (haveLog) {
                this.LOG.info("------------------------------------------------------------------------------");
            }
        }
    }
}

