/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.util.Objects;
import java.util.Optional;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;

public class RulesEngineId<T extends Ruleset> {
    protected final Class<T> scope;
    protected final String realm;
    protected final String assetId;

    public RulesEngineId() {
        this(GlobalRuleset.class, null, null);
    }

    public RulesEngineId(String realm) {
        this(RealmRuleset.class, realm, null);
    }

    public RulesEngineId(String realm, String assetId) {
        this(AssetRuleset.class, realm, assetId);
    }

    protected RulesEngineId(Class<T> scope, String realm, String assetId) {
        this.scope = scope;
        this.realm = realm;
        this.assetId = assetId;
    }

    public Class<T> getScope() {
        return this.scope;
    }

    public Optional<String> getRealm() {
        return Optional.ofNullable(this.realm);
    }

    public Optional<String> getAssetId() {
        return Optional.ofNullable(this.assetId);
    }

    public Optional<String> getId() {
        return this.scope == RealmRuleset.class ? this.getRealm() : (this.scope == AssetRuleset.class ? this.getAssetId() : Optional.empty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RulesEngineId that = (RulesEngineId)o;
        return this.scope == that.scope && Objects.equals(this.realm, that.realm) && Objects.equals(this.assetId, that.assetId);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.realm, this.assetId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{scope=" + this.scope.getSimpleName() + ", realm='" + this.realm + "', assetId='" + this.assetId + "'}";
    }
}

