/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.RulesEngineParameters;
import org.jeasy.rules.core.AbstractRulesEngine;
import org.jeasy.rules.core.DefaultRulesEngine;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.alarm.AlarmService;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetDatapointService;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.notification.NotificationService;
import org.openremote.manager.rules.AssetLocationPredicateProcessor;
import org.openremote.manager.rules.RulesEngineId;
import org.openremote.manager.rules.RulesFacts;
import org.openremote.manager.rules.RulesLoopException;
import org.openremote.manager.rules.RulesService;
import org.openremote.manager.rules.RulesetDeployment;
import org.openremote.manager.rules.facade.AlarmFacade;
import org.openremote.manager.rules.facade.AssetsFacade;
import org.openremote.manager.rules.facade.HistoricFacade;
import org.openremote.manager.rules.facade.NotificationsFacade;
import org.openremote.manager.rules.facade.PredictedFacade;
import org.openremote.manager.rules.facade.UsersFacade;
import org.openremote.manager.rules.facade.WebhooksFacade;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.webhook.WebhookService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.query.filter.GeofencePredicate;
import org.openremote.model.rules.Alarms;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.HistoricDatapoints;
import org.openremote.model.rules.Notifications;
import org.openremote.model.rules.PredictedDatapoints;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.RulesEngineInfo;
import org.openremote.model.rules.RulesEngineStatus;
import org.openremote.model.rules.RulesEngineStatusEvent;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.rules.RulesetChangedEvent;
import org.openremote.model.rules.RulesetStatus;
import org.openremote.model.rules.Users;
import org.openremote.model.rules.Webhooks;
import org.openremote.model.syslog.SyslogCategory;

public class RulesEngine<T extends Ruleset> {
    protected final Logger LOG;
    public static final Logger STATS_LOG = Logger.getLogger("org.openremote.rules.RulesEngineStats");
    protected final TimerService timerService;
    protected final RulesService rulesService;
    protected final ExecutorService executorService;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final AssetStorageService assetStorageService;
    protected final ClientEventService clientEventService;
    protected final RulesEngineId<T> id;
    protected final Assets assetsFacade;
    protected final Users usersFacade;
    protected final Notifications notificationFacade;
    protected final Webhooks webhooksFacade;
    protected final Alarms alarmsFacade;
    protected final PredictedDatapoints predictedFacade;
    protected final HistoricDatapoints historicFacade;
    protected final AssetLocationPredicateProcessor assetLocationPredicatesConsumer;
    protected final Map<Long, RulesetDeployment> deployments = new ConcurrentHashMap<Long, RulesetDeployment>();
    protected final Map<Long, RulesetStatus> deploymentStatusMap = new ConcurrentHashMap<Long, RulesetStatus>();
    protected final RulesFacts facts;
    protected final AbstractRulesEngine engine;
    protected boolean running;
    protected boolean previouslyFired;
    protected long lastFireTimestamp;
    protected boolean trackLocationPredicates;
    protected ScheduledFuture<?> fireTimer;
    protected ScheduledFuture<?> statsTimer;
    protected final Set<AttributeInfo> updateInfos = new HashSet<AttributeInfo>();
    protected final Set<AttributeInfo> insertInfos = new HashSet<AttributeInfo>();
    protected final Set<AttributeInfo> retractInfos = new HashSet<AttributeInfo>();
    protected String deploymentInfo;
    protected Timer rulesFiringTimer;

    public RulesEngine(TimerService timerService, RulesService rulesService, ManagerIdentityService identityService, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, AssetStorageService assetStorageService, AssetProcessingService assetProcessingService, NotificationService notificationService, WebhookService webhookService, AlarmService alarmService, ClientEventService clientEventService, AssetDatapointService assetDatapointService, AssetPredictedDatapointService assetPredictedDatapointService, RulesEngineId<T> id, AssetLocationPredicateProcessor assetLocationPredicatesConsumer, Timer rulesFiringTimer) {
        AssetsFacade<T> assetsFacade;
        this.timerService = timerService;
        this.rulesService = rulesService;
        this.previouslyFired = rulesService.startDone;
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.assetStorageService = assetStorageService;
        this.clientEventService = clientEventService;
        this.rulesFiringTimer = rulesFiringTimer;
        this.id = id;
        String ruleEngineCategory = id.scope.getSimpleName().replace("Ruleset", "Engine-") + id.getId().orElse("");
        this.LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.RULES, (String)(RulesEngine.class.getName() + "." + ruleEngineCategory));
        this.assetsFacade = assetsFacade = new AssetsFacade<T>(id, assetStorageService, attributeEvent -> {
            try {
                assetProcessingService.sendAttributeEvent((AttributeEvent)attributeEvent, this.getClass().getSimpleName());
            }
            catch (Exception e) {
                this.LOG.log(Level.SEVERE, "Failed to dispatch attribute event");
            }
        });
        this.usersFacade = new UsersFacade<T>(id, assetStorageService, notificationService, identityService);
        this.notificationFacade = new NotificationsFacade<T>(id, notificationService);
        this.webhooksFacade = new WebhooksFacade<T>(id, webhookService);
        this.alarmsFacade = new AlarmFacade<T>(id, alarmService);
        this.historicFacade = new HistoricFacade<T>(id, assetDatapointService);
        this.predictedFacade = new PredictedFacade<T>(id, assetPredictedDatapointService);
        this.assetLocationPredicatesConsumer = assetLocationPredicatesConsumer;
        this.facts = new RulesFacts(timerService, assetStorageService, assetsFacade, this, this.LOG);
        this.engine = new DefaultRulesEngine(new RulesEngineParameters(false, true, false, Integer.MAX_VALUE));
        this.engine.registerRuleListener((RuleListener)this.facts);
        this.engine.registerRuleListener(new RuleListener(this){

            public void onEvaluationError(Rule rule, Facts facts, Exception exception) {
                RuntimeException ex = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
                throw ex;
            }

            public void onFailure(Rule rule, Facts facts, Exception exception) {
                RuntimeException ex = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
                throw ex;
            }
        });
    }

    public RulesEngineId<T> getId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isError() {
        for (RulesetDeployment deployment : this.deployments.values()) {
            if (!deployment.isError()) continue;
            return true;
        }
        return false;
    }

    public int getExecutionErrorDeploymentCount() {
        return (int)this.deployments.values().stream().filter(deployment -> deployment.getStatus() == RulesetStatus.EXECUTION_ERROR || deployment.getStatus() == RulesetStatus.LOOP_ERROR).count();
    }

    public int getCompilationErrorDeploymentCount() {
        return (int)this.deployments.values().stream().filter(deployment -> deployment.getStatus() == RulesetStatus.COMPILATION_ERROR).count();
    }

    public RuntimeException getError() {
        long executionErrorCount = this.getExecutionErrorDeploymentCount();
        long compilationErrorCount = this.getCompilationErrorDeploymentCount();
        if (executionErrorCount > 0L || compilationErrorCount > 0L) {
            return new RuntimeException("Ruleset deployments have errors, failed compilation: " + compilationErrorCount + ", failed execution: " + executionErrorCount + " - on: " + String.valueOf(this));
        }
        return null;
    }

    public void addRuleset(T ruleset) {
        RulesetDeployment deployment = this.deployments.get(ruleset.getId());
        boolean wasRunning = this.running;
        this.stop();
        if (deployment != null) {
            this.removeRuleset(deployment.ruleset);
        }
        deployment = new RulesetDeployment((Ruleset)ruleset, this, this.timerService, this.assetStorageService, this.executorService, this.scheduledExecutorService, this.assetsFacade, this.usersFacade, this.notificationFacade, this.webhooksFacade, this.alarmsFacade, this.historicFacade, this.predictedFacade);
        deployment.init();
        this.deployments.put(ruleset.getId(), deployment);
        this.publishRulesetStatus(deployment);
        this.updateDeploymentInfo();
        if (wasRunning) {
            this.start();
        }
    }

    public boolean removeRuleset(Ruleset ruleset) {
        RulesetDeployment deployment = this.deployments.get(ruleset.getId());
        if (deployment == null) {
            this.LOG.fine("Ruleset cannot be retracted as it was never deployed: " + String.valueOf(ruleset));
        } else {
            boolean wasRunning = this.running;
            this.stop();
            this.stopRuleset(deployment);
            this.deployments.values().remove(deployment);
            this.updateDeploymentInfo();
            if (wasRunning && !this.deployments.isEmpty()) {
                this.start();
            }
        }
        return this.deployments.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RulesEngine rulesEngine = this;
        synchronized (rulesEngine) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        if (this.deployments.isEmpty()) {
            this.LOG.finest("No rulesets so nothing to start");
            return;
        }
        boolean canAnyStart = this.deployments.values().stream().noneMatch(RulesetDeployment::canStart);
        if (canAnyStart) {
            this.LOG.info("Cannot start rules engine as no rulesets are able to be started");
            return;
        }
        this.LOG.info("Starting: " + String.valueOf(this.id));
        this.trackLocationPredicates(true);
        this.deployments.values().forEach(this::startRuleset);
        this.updateDeploymentInfo();
        this.publishRulesEngineStatus();
        this.scheduleFire(true);
        if (STATS_LOG.isLoggable(Level.FINE) || STATS_LOG.isLoggable(Level.FINEST)) {
            if (STATS_LOG.isLoggable(Level.FINEST)) {
                this.LOG.info("Enabling periodic statistics output at FINEST level every 30 seconds on category: " + STATS_LOG.getName());
            } else {
                this.LOG.info("Enabling periodic full memory dump at FINE level every 30 seconds on category: " + STATS_LOG.getName());
            }
            this.statsTimer = this.scheduledExecutorService.scheduleAtFixedRate(this::printSessionStats, 3L, 30L, TimeUnit.SECONDS);
        }
    }

    protected void trackLocationPredicates(boolean track) {
        if (this.trackLocationPredicates == track) {
            return;
        }
        this.trackLocationPredicates = track;
        if (track) {
            this.facts.startTrackingLocationRules();
        } else if (this.assetLocationPredicatesConsumer != null) {
            this.processLocationRules(this.facts.stopTrackingLocationRules());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RulesEngine rulesEngine = this;
        synchronized (rulesEngine) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        this.LOG.info("Stopping: " + String.valueOf(this.id));
        if (this.fireTimer != null) {
            this.fireTimer.cancel(true);
            this.fireTimer = null;
        }
        if (this.statsTimer != null) {
            this.statsTimer.cancel(true);
            this.statsTimer = null;
        }
        new HashSet<RulesetDeployment>(this.deployments.values()).forEach(this::stopRuleset);
        if (this.assetLocationPredicatesConsumer != null) {
            this.assetLocationPredicatesConsumer.accept(this, null);
        }
        this.publishRulesEngineStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRuleset(RulesetDeployment deployment) {
        if (!this.running) {
            return;
        }
        RulesEngine rulesEngine = this;
        synchronized (rulesEngine) {
            if (deployment.start(this.facts)) {
                this.publishRulesetStatus(deployment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRuleset(RulesetDeployment deployment) {
        RulesEngine rulesEngine = this;
        synchronized (rulesEngine) {
            if (deployment.stop(this.facts)) {
                this.publishRulesetStatus(deployment);
            }
        }
    }

    protected synchronized void scheduleFire(boolean quickFire) {
        boolean timerRunning;
        boolean bl = timerRunning = this.fireTimer != null && !this.fireTimer.isDone();
        if (timerRunning) {
            if (!quickFire) {
                return;
            }
            if (this.fireTimer.getDelay(TimeUnit.MILLISECONDS) <= this.rulesService.quickFireMillis) {
                return;
            }
            this.fireTimer.cancel(false);
        }
        long fireTimeMillis = quickFire ? this.rulesService.quickFireMillis : this.rulesService.tempFactExpirationMillis;
        this.LOG.finest("Scheduling rules firing in " + fireTimeMillis + "ms");
        this.fireTimer = this.scheduledExecutorService.schedule(() -> {
            this.fireTimer = null;
            if (!this.running) {
                return;
            }
            this.fireAllDeployments();
            this.scheduleFire(false);
        }, fireTimeMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAllDeployments() {
        if (!this.running) {
            return;
        }
        Set<AttributeInfo> set = this.insertInfos;
        synchronized (set) {
            this.retractInfos.forEach(attributeInfo -> {
                this.facts.removeAssetState((AttributeInfo)attributeInfo);
                this.trackLocationPredicates(this.trackLocationPredicates || attributeInfo.getName().equals(Asset.LOCATION.getName()));
                this.notifyAssetStatesChanged(new AssetStateChangeEvent(PersistenceEvent.Cause.DELETE, (AttributeInfo)attributeInfo));
            });
            this.insertInfos.forEach(attributeInfo -> {
                this.facts.putAssetState((AttributeInfo)attributeInfo);
                this.trackLocationPredicates(this.trackLocationPredicates || attributeInfo.getName().equals(Asset.LOCATION.getName()));
                this.notifyAssetStatesChanged(new AssetStateChangeEvent(PersistenceEvent.Cause.CREATE, (AttributeInfo)attributeInfo));
            });
            this.updateInfos.forEach(attributeInfo -> {
                this.facts.putAssetState((AttributeInfo)attributeInfo);
                this.notifyAssetStatesChanged(new AssetStateChangeEvent(PersistenceEvent.Cause.UPDATE, (AttributeInfo)attributeInfo));
            });
            this.insertInfos.clear();
            this.updateInfos.clear();
            this.retractInfos.clear();
        }
        if (this.trackLocationPredicates && this.assetLocationPredicatesConsumer != null) {
            this.facts.startTrackingLocationRules();
        }
        this.facts.removeExpiredTemporaryFacts();
        long executionTotalMillis = this.timerService.getCurrentTimeMillis();
        if (this.rulesFiringTimer != null) {
            this.rulesFiringTimer.record(this::doFire);
        } else {
            this.doFire();
        }
        this.trackLocationPredicates(false);
        executionTotalMillis = this.timerService.getCurrentTimeMillis() - executionTotalMillis;
        if (executionTotalMillis > 500L) {
            this.LOG.warning("Rules firing took " + executionTotalMillis + "ms");
        } else {
            this.LOG.fine("Rules firing took " + executionTotalMillis + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFire() {
        for (RulesetDeployment deployment : this.deployments.values()) {
            try {
                RulesetStatus status = deployment.getStatus();
                this.publishRulesetStatus(deployment);
                if (status == RulesetStatus.DEPLOYED) {
                    this.LOG.finest("Executing rules of: " + String.valueOf(deployment));
                    this.facts.logFacts(this.LOG, Level.FINEST);
                    this.facts.reset();
                    long startTimestamp = this.timerService.getCurrentTimeMillis();
                    this.engine.fire(deployment.getRules(), (Facts)this.facts);
                    long executionMillis = this.timerService.getCurrentTimeMillis() - startTimestamp;
                    this.LOG.fine("Rules deployment '" + deployment.getName() + "' executed in: " + executionMillis + "ms");
                    continue;
                }
                this.LOG.fine("Rules deployment '" + deployment.getName() + "' skipped as status is: " + String.valueOf(status));
            }
            catch (Exception ex) {
                this.LOG.log(Level.SEVERE, "Error executing rules of: " + String.valueOf(deployment), ex);
                deployment.setStatus(ex instanceof RulesLoopException ? RulesetStatus.LOOP_ERROR : RulesetStatus.EXECUTION_ERROR);
                deployment.setError(ex);
                this.publishRulesetStatus(deployment);
                if (!(ex instanceof RulesLoopException) && deployment.ruleset.isContinueOnError()) continue;
                this.stop();
                break;
            }
            finally {
                this.facts.reset();
                this.lastFireTimestamp = this.timerService.getCurrentTimeMillis();
            }
        }
        this.previouslyFired = true;
    }

    protected String getEngineId() {
        if (this.id.scope == GlobalRuleset.class) {
            return "";
        }
        if (this.id.scope == RealmRuleset.class) {
            return this.id.realm;
        }
        return this.id.realm + ":" + this.id.assetId;
    }

    protected void notifyAssetStatesChanged(AssetStateChangeEvent event) {
        for (RulesetDeployment deployment : this.deployments.values()) {
            if (deployment.isError()) continue;
            deployment.onAssetStatesChanged(this.facts, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateAttributeInfo(AttributeInfo attributeInfo, boolean insert) {
        Set<AttributeInfo> set = this.insertInfos;
        synchronized (set) {
            insert = insert || this.insertInfos.remove(attributeInfo);
            this.updateInfos.remove(attributeInfo);
            this.retractInfos.remove(attributeInfo);
            if (insert) {
                this.insertInfos.add(attributeInfo);
            } else {
                this.updateInfos.add(attributeInfo);
            }
        }
        if (this.running) {
            this.scheduleFire(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractAttributeInfo(AttributeInfo attributeInfo) {
        Set<AttributeInfo> set = this.insertInfos;
        synchronized (set) {
            this.insertInfos.remove(attributeInfo);
            this.updateInfos.remove(attributeInfo);
            this.retractInfos.remove(attributeInfo);
            this.retractInfos.add(attributeInfo);
        }
        if (this.running) {
            this.scheduleFire(true);
        }
    }

    protected void updateDeploymentInfo() {
        this.deploymentInfo = Arrays.toString(this.deployments.values().stream().map(RulesetDeployment::toString).toArray(String[]::new));
    }

    protected synchronized void printSessionStats() {
        Collection<AttributeInfo> assetStateFacts = this.facts.getAssetStates();
        Map<String, Object> namedFacts = this.facts.getNamedFacts();
        Collection<Object> anonFacts = this.facts.getAnonymousFacts();
        long temporaryFactsCount = this.facts.getTemporaryFacts().count();
        long total = assetStateFacts.size() + namedFacts.size() + anonFacts.size();
        STATS_LOG.fine("Engine stats for '" + String.valueOf(this) + "', in memory facts are Total: " + total + ", AssetState: " + assetStateFacts.size() + ", Named: " + namedFacts.size() + ", Anonymous: " + anonFacts.size() + ", Temporary: " + temporaryFactsCount);
        this.facts.logFacts(STATS_LOG, Level.FINEST);
    }

    protected void processLocationRules(List<AssetLocationPredicates> assetStateLocationPredicates) {
        if (this.assetLocationPredicatesConsumer != null) {
            this.assetLocationPredicatesConsumer.accept(this, assetStateLocationPredicates);
        }
    }

    public boolean hasPreviouslyFired() {
        return this.previouslyFired;
    }

    protected RulesEngineStatus getStatus() {
        if (this.isRunning()) {
            return RulesEngineStatus.RUNNING;
        }
        return this.deployments.values().stream().anyMatch(RulesetDeployment::isError) ? RulesEngineStatus.ERROR : RulesEngineStatus.STOPPED;
    }

    protected void publishRulesEngineStatus() {
        String engineId = this.id == null ? null : this.id.getRealm().orElse(this.id.getAssetId().orElse(null));
        int compilationErrors = this.getCompilationErrorDeploymentCount();
        int executionErrors = this.getExecutionErrorDeploymentCount();
        RulesEngineInfo engineInfo = new RulesEngineInfo(this.getStatus(), compilationErrors, executionErrors);
        RulesEngineStatusEvent event = new RulesEngineStatusEvent(this.timerService.getCurrentTimeMillis(), engineId, engineInfo);
        this.LOG.finest("Publishing rules engine status event: " + String.valueOf(event));
        this.clientEventService.publishEvent(event);
    }

    protected void publishRulesetStatus(RulesetDeployment deployment) {
        if (!this.running) {
            return;
        }
        Ruleset ruleset = deployment.ruleset;
        RulesetStatus previousStatus = this.deploymentStatusMap.get(ruleset.getId());
        String engineId = this.id == null ? null : this.id.getRealm().orElse(this.id.getAssetId().orElse(null));
        RulesetStatus currentStatus = deployment.getStatus();
        if (currentStatus != previousStatus) {
            this.deploymentStatusMap.put(ruleset.getId(), currentStatus);
            ruleset.setStatus(deployment.getStatus());
            ruleset.setError(deployment.getErrorMessage());
            RulesetChangedEvent event = new RulesetChangedEvent(this.timerService.getCurrentTimeMillis(), engineId, ruleset);
            this.LOG.finest("Ruleset '" + deployment.getName() + "': status=" + String.valueOf(currentStatus));
            this.clientEventService.publishEvent(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + String.valueOf(this.id) + "', running='" + this.isRunning() + "', deployments='" + this.deploymentInfo + "'}";
    }

    public static final class AssetStateChangeEvent {
        public PersistenceEvent.Cause cause;
        public AttributeInfo assetState;

        public AssetStateChangeEvent(PersistenceEvent.Cause cause, AttributeInfo assetState) {
            this.cause = cause;
            this.assetState = assetState;
        }
    }

    public static final class AssetLocationPredicates {
        final String assetId;
        final Set<GeofencePredicate> locationPredicates;

        public AssetLocationPredicates(String assetId, Set<GeofencePredicate> locationPredicates) {
            this.assetId = assetId;
            this.locationPredicates = locationPredicates;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public Set<GeofencePredicate> getLocationPredicates() {
            return this.locationPredicates;
        }
    }
}

