/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.util.ArrayList;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.core.RuleBuilder;
import org.openremote.manager.rules.RulesFacts;

public class RulesBuilder {
    protected final List<Builder> builders = new ArrayList<Builder>();

    public Builder add() {
        Builder builder = new Builder();
        this.builders.add(builder);
        return builder;
    }

    public Rule[] build() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        int i = 1;
        for (Builder builder : this.builders) {
            int priority = builder.priority < 0x7FFFFFFE ? builder.priority : 2147473647 + i;
            ++i;
            Rule rule = new RuleBuilder().name(builder.name).description(builder.description).priority(priority).when(facts -> {
                Object result;
                try {
                    result = builder.condition.evaluate((RulesFacts)facts);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error evaluating condition of rule '" + builder.name + "': " + ex.getMessage());
                }
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new IllegalArgumentException("Error evaluating condition of rule '" + builder.name + "': result is not boolean but " + String.valueOf(result));
            }).then(facts -> builder.action.execute((RulesFacts)facts)).build();
            rules.add(rule);
        }
        return rules.toArray(new Rule[rules.size()]);
    }

    public static class Builder {
        protected String name = "rule";
        protected String description = "description";
        protected int priority = 0x7FFFFFFE;
        protected Condition condition = facts -> false;
        protected Action action = facts -> {};

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder when(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder then(Action action) {
            this.action = action;
            return this;
        }
    }

    public static interface Action {
        public void execute(RulesFacts var1);
    }

    @FunctionalInterface
    public static interface Condition {
        public Object evaluate(RulesFacts var1);
    }
}

