/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RulePersistence {
    private static final Logger LOG = Logger.getLogger(RulePersistence.class.getName());
    protected final Map<String, String> data = new HashMap<String, String>();

    public void writeData(String key, Object value) {
        LOG.fine("Writing '" + key + "': " + String.valueOf(value));
        this.data.put(key, value != null ? value.toString() : null);
    }

    public String readData(String key) {
        LOG.fine("Reading '" + key + "'");
        return this.data.get(key);
    }

    public String readData(String key, String defaultValue) {
        LOG.fine("Reading '" + key + "', default: " + defaultValue);
        return this.data.getOrDefault(key, defaultValue);
    }

    public void deleteData(String key) {
        LOG.fine("Deleting '" + key + "'");
        this.data.remove(key);
    }
}

