/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import jakarta.ws.rs.core.MediaType;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.AssetQueryPredicate;
import org.openremote.manager.rules.RulesBuilder;
import org.openremote.manager.rules.RulesEngine;
import org.openremote.manager.rules.RulesFacts;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.alarm.Alarm;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.MetaMap;
import org.openremote.model.geo.GeoJSONPoint;
import org.openremote.model.notification.AbstractNotificationMessage;
import org.openremote.model.notification.EmailNotificationMessage;
import org.openremote.model.notification.LocalizedNotificationMessage;
import org.openremote.model.notification.Notification;
import org.openremote.model.notification.PushNotificationAction;
import org.openremote.model.notification.PushNotificationMessage;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.LogicGroup;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.AttributePredicate;
import org.openremote.model.query.filter.LocationAttributePredicate;
import org.openremote.model.query.filter.NameValuePredicate;
import org.openremote.model.rules.Alarms;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.HistoricDatapoints;
import org.openremote.model.rules.Notifications;
import org.openremote.model.rules.PredictedDatapoints;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.rules.SunPositionTrigger;
import org.openremote.model.rules.Users;
import org.openremote.model.rules.Webhooks;
import org.openremote.model.rules.json.JsonRule;
import org.openremote.model.rules.json.JsonRulesetDefinition;
import org.openremote.model.rules.json.RuleAction;
import org.openremote.model.rules.json.RuleActionAlarm;
import org.openremote.model.rules.json.RuleActionNotification;
import org.openremote.model.rules.json.RuleActionTarget;
import org.openremote.model.rules.json.RuleActionUpdateAttribute;
import org.openremote.model.rules.json.RuleActionWait;
import org.openremote.model.rules.json.RuleActionWebhook;
import org.openremote.model.rules.json.RuleActionWriteAttribute;
import org.openremote.model.rules.json.RuleCondition;
import org.openremote.model.rules.json.RuleRecurrence;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.TimeUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.NameValueHolder;
import org.openremote.model.webhook.Webhook;
import org.quartz.CronExpression;
import org.shredzone.commons.suncalc.SunTimes;

public class JsonRulesBuilder
extends RulesBuilder {
    public static final String PLACEHOLDER_RULESET_ID = "%RULESET_ID%";
    public static final String PLACEHOLDER_RULESET_NAME = "%RULESET_NAME%";
    public static final String PLACEHOLDER_TRIGGER_ASSETS = "%TRIGGER_ASSETS%";
    public static final String PLACEHOLDER_ASSET_ID = "%ASSET_ID%";
    static final String TIMER_TEMPORAL_FACT_NAME_PREFIX = "TimerTemporalFact-";
    static final String LOG_PREFIX = "JSON Rule '";
    protected final AssetStorageService assetStorageService;
    protected final RulesEngine<?> rulesEngine;
    protected final TimerService timerService;
    protected final Assets assetsFacade;
    protected final Users usersFacade;
    protected final Notifications notificationsFacade;
    protected final Webhooks webhooksFacade;
    protected final Alarms alarmsFacade;
    protected final HistoricDatapoints historicDatapointsFacade;
    protected final PredictedDatapoints predictedDatapointsFacade;
    protected final BiConsumer<Runnable, Long> scheduledActionConsumer;
    protected final Map<String, RuleState> ruleStateMap = new ConcurrentHashMap<String, RuleState>();
    protected final JsonRule[] jsonRules;
    protected final Ruleset jsonRuleset;
    protected static Logger LOG;

    public JsonRulesBuilder(Logger logger, Ruleset ruleset, RulesEngine<?> rulesEngine, TimerService timerService, AssetStorageService assetStorageService, Assets assetsFacade, Users usersFacade, Notifications notificationsFacade, Webhooks webhooksFacade, Alarms alarmsFacade, HistoricDatapoints historicDatapoints, PredictedDatapoints predictedDatapoints, BiConsumer<Runnable, Long> scheduledActionConsumer) throws Exception {
        this.rulesEngine = rulesEngine;
        this.timerService = timerService;
        this.assetStorageService = assetStorageService;
        this.assetsFacade = assetsFacade;
        this.usersFacade = usersFacade;
        this.notificationsFacade = notificationsFacade;
        this.webhooksFacade = webhooksFacade;
        this.alarmsFacade = alarmsFacade;
        this.historicDatapointsFacade = historicDatapoints;
        this.predictedDatapointsFacade = predictedDatapoints;
        this.scheduledActionConsumer = scheduledActionConsumer;
        LOG = logger;
        this.jsonRuleset = ruleset;
        String rulesStr = ruleset.getRules();
        rulesStr = rulesStr.replace(PLACEHOLDER_RULESET_ID, Long.toString(ruleset.getId()));
        rulesStr = rulesStr.replace(PLACEHOLDER_RULESET_NAME, ruleset.getName());
        JsonRulesetDefinition jsonRulesetDefinition = ValueUtil.parse((String)rulesStr, JsonRulesetDefinition.class).orElse(null);
        if (jsonRulesetDefinition == null || jsonRulesetDefinition.rules == null || jsonRulesetDefinition.rules.length == 0) {
            throw new IllegalArgumentException("No rules within ruleset so nothing to start: " + String.valueOf(ruleset));
        }
        for (JsonRule jsonRule : this.jsonRules = jsonRulesetDefinition.rules) {
            this.add(jsonRule);
        }
    }

    public void stop(RulesFacts facts) {
        Arrays.stream(this.jsonRules).forEach(jsonRule -> this.executeRuleActions((JsonRule)jsonRule, jsonRule.onStop, "onStop", false, facts, null, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.webhooksFacade, this.alarmsFacade, this.predictedDatapointsFacade, this.scheduledActionConsumer));
        String tempFactName = TIMER_TEMPORAL_FACT_NAME_PREFIX + this.jsonRuleset.getId();
        facts.remove(tempFactName);
    }

    public void start(RulesFacts facts) {
        Arrays.stream(this.jsonRules).forEach(jsonRule -> this.executeRuleActions((JsonRule)jsonRule, jsonRule.onStart, "onStart", false, facts, null, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.webhooksFacade, this.alarmsFacade, this.predictedDatapointsFacade, this.scheduledActionConsumer));
        this.onAssetStatesChanged(facts, null);
    }

    public void onAssetStatesChanged(RulesFacts facts, RulesEngine.AssetStateChangeEvent event) {
        this.ruleStateMap.values().forEach(triggerStateMap -> triggerStateMap.conditionStateMap.values().forEach(ruleConditionState -> ruleConditionState.updateUnfilteredAssetStates(facts, event)));
    }

    protected JsonRulesBuilder add(JsonRule rule) throws Exception {
        if (this.ruleStateMap.containsKey(rule.name)) {
            throw new IllegalArgumentException("Rules must have a unique name within a ruleset, rule name '" + rule.name + "' already used");
        }
        RuleState ruleState = new RuleState(rule);
        this.ruleStateMap.put(rule.name, ruleState);
        this.addRuleConditionStates((LogicGroup<RuleCondition>)rule.when, rule.otherwise != null, new AtomicInteger(0), ruleState.conditionStateMap);
        RulesBuilder.Condition condition = this.buildLhsCondition(rule, ruleState);
        RulesBuilder.Action action = this.buildRhsAction(rule, ruleState);
        if (condition == null || action == null) {
            throw new IllegalArgumentException("Error building JSON rule when or then is not defined: " + rule.name);
        }
        this.add().name(rule.name).description(rule.description).priority(rule.priority).when(condition).then(action);
        return this;
    }

    protected void addRuleConditionStates(LogicGroup<RuleCondition> ruleConditionGroup, boolean trackUnmatched, AtomicInteger index, Map<String, RuleConditionState> triggerStateMap) throws Exception {
        if (ruleConditionGroup != null) {
            if (!ruleConditionGroup.getItems().isEmpty()) {
                for (RuleCondition ruleCondition : ruleConditionGroup.getItems()) {
                    if (TextUtil.isNullOrEmpty((String)ruleCondition.tag)) {
                        ruleCondition.tag = index.toString();
                    }
                    triggerStateMap.put(ruleCondition.tag, new RuleConditionState(ruleCondition, trackUnmatched, this.timerService));
                    index.incrementAndGet();
                }
            }
            if (ruleConditionGroup.groups != null && !ruleConditionGroup.groups.isEmpty()) {
                for (LogicGroup childRuleTriggerCondition : ruleConditionGroup.groups) {
                    this.addRuleConditionStates((LogicGroup<RuleCondition>)childRuleTriggerCondition, trackUnmatched, index, triggerStateMap);
                }
            }
        }
    }

    protected RulesBuilder.Condition buildLhsCondition(JsonRule rule, RuleState ruleState) {
        if (rule.when == null) {
            return null;
        }
        return facts -> {
            ruleState.update(() -> ((TimerService)this.timerService).getCurrentTimeMillis());
            return ruleState.matched;
        };
    }

    protected RulesBuilder.Action buildRhsAction(JsonRule rule, RuleState ruleState) {
        if (rule.then == null) {
            return null;
        }
        return facts -> {
            long nextRecur;
            boolean recurPerAsset;
            try {
                if (this.rulesEngine.hasPreviouslyFired()) {
                    if (ruleState.thenMatched()) {
                        this.log(Level.FINE, "Triggered rule so executing 'then' actions for rule: " + rule.name);
                        this.executeRuleActions(rule, rule.then, "then", false, facts, ruleState, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.webhooksFacade, this.alarmsFacade, this.predictedDatapointsFacade, this.scheduledActionConsumer);
                    }
                    if (rule.otherwise != null && ruleState.otherwiseMatched()) {
                        this.log(Level.FINE, "Triggered rule so executing 'otherwise' actions for rule: " + rule.name);
                        this.executeRuleActions(rule, rule.otherwise, "otherwise", true, facts, ruleState, this.assetsFacade, this.usersFacade, this.notificationsFacade, this.webhooksFacade, this.alarmsFacade, this.predictedDatapointsFacade, this.scheduledActionConsumer);
                    }
                }
                recurPerAsset = rule.recurrence == null || rule.recurrence.scope != RuleRecurrence.Scope.GLOBAL;
            }
            catch (Exception e) {
                try {
                    this.log(Level.SEVERE, "Exception thrown during rule RHS execution", e);
                    throw e;
                }
                catch (Throwable throwable) {
                    long nextRecur2;
                    boolean recurPerAsset2 = rule.recurrence == null || rule.recurrence.scope != RuleRecurrence.Scope.GLOBAL;
                    long currentTime = this.timerService.getCurrentTimeMillis();
                    long l = nextRecur2 = rule.recurrence == null || rule.recurrence.mins == null ? Long.MAX_VALUE : currentTime + rule.recurrence.mins * 60000L;
                    if (nextRecur2 > currentTime) {
                        if (recurPerAsset2) {
                            ruleState.thenMatchedAssetIds.forEach(assetId -> ruleState.nextRecurAssetIdMap.put((String)assetId, nextRecur2));
                        } else {
                            ruleState.nextRecur = nextRecur2;
                        }
                    }
                    ruleState.conditionStateMap.values().forEach(ruleConditionState -> {
                        if (ruleConditionState.lastEvaluationResult != null) {
                            ruleConditionState.previouslyMatchedAssetStates.addAll(ruleConditionState.lastEvaluationResult.matchedAssetStates);
                            if (ruleConditionState.trackUnmatched) {
                                ruleConditionState.previouslyUnmatchedAssetStates.addAll(ruleConditionState.lastEvaluationResult.unmatchedAssetStates);
                            }
                        }
                        ruleConditionState.lastEvaluationResult = null;
                    });
                    throw throwable;
                }
            }
            long currentTime = this.timerService.getCurrentTimeMillis();
            long l = nextRecur = rule.recurrence == null || rule.recurrence.mins == null ? Long.MAX_VALUE : currentTime + rule.recurrence.mins * 60000L;
            if (nextRecur > currentTime) {
                if (recurPerAsset) {
                    ruleState.thenMatchedAssetIds.forEach(assetId -> ruleState.nextRecurAssetIdMap.put((String)assetId, nextRecur2));
                } else {
                    ruleState.nextRecur = nextRecur;
                }
            }
            ruleState.conditionStateMap.values().forEach(ruleConditionState -> {
                if (ruleConditionState.lastEvaluationResult != null) {
                    ruleConditionState.previouslyMatchedAssetStates.addAll(ruleConditionState.lastEvaluationResult.matchedAssetStates);
                    if (ruleConditionState.trackUnmatched) {
                        ruleConditionState.previouslyUnmatchedAssetStates.addAll(ruleConditionState.lastEvaluationResult.unmatchedAssetStates);
                    }
                }
                ruleConditionState.lastEvaluationResult = null;
            });
        };
    }

    public void executeRuleActions(JsonRule rule, RuleAction[] ruleActions, String actionsName, boolean useUnmatched, RulesFacts facts, RuleState ruleState, Assets assetsFacade, Users usersFacade, Notifications notificationsFacade, Webhooks webhooksFacade, Alarms alarmsFacade, PredictedDatapoints predictedDatapointsFacade, BiConsumer<Runnable, Long> scheduledActionConsumer) {
        if (ruleActions != null && ruleActions.length > 0) {
            long delay = 0L;
            for (int i = 0; i < ruleActions.length; ++i) {
                RuleAction ruleAction = ruleActions[i];
                RuleActionExecution actionExecution = this.buildRuleActionExecution(rule, ruleAction, actionsName, i, useUnmatched, facts, ruleState, assetsFacade, usersFacade, notificationsFacade, webhooksFacade, alarmsFacade, predictedDatapointsFacade);
                if (actionExecution == null) continue;
                if ((delay += actionExecution.delay) > 0L) {
                    this.log(Level.FINE, "Delaying rule action for " + delay + "ms for rule action: " + rule.name + " '" + actionsName + "' action index " + i);
                    scheduledActionConsumer.accept(actionExecution.runnable, delay);
                    continue;
                }
                actionExecution.runnable.run();
            }
        }
    }

    protected static Collection<String> getUserIds(Users users, UserQuery userQuery) {
        return users.getResults(userQuery).collect(Collectors.toList());
    }

    protected static Collection<String> getAssetIds(Assets assets, AssetQuery assetQuery) {
        return assets.getResults(assetQuery).map(Asset::getId).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected RuleActionExecution buildRuleActionExecution(JsonRule rule, RuleAction ruleAction, String actionsName, int index, boolean useUnmatched, RulesFacts facts, RuleState ruleState, Assets assetsFacade, Users usersFacade, Notifications notificationsFacade, Webhooks webhooksFacade, Alarms alarmsFacade, PredictedDatapoints predictedDatapointsFacade) {
        List matchingAssetIds;
        if (ruleAction instanceof RuleActionNotification) {
            Collection<String> targetIds;
            boolean bodyContainsTriggeredAssetInfo;
            String body;
            boolean isHtml;
            RuleActionNotification notificationAction = (RuleActionNotification)ruleAction;
            if (notificationAction.notification == null || notificationAction.notification.getMessage() == null) {
                LOG.info("Notification action has no notification and/or message set so cannot complete action: " + String.valueOf(this.jsonRuleset));
                return null;
            }
            Notification notification = (Notification)ValueUtil.clone((Object)notificationAction.notification);
            boolean linkedUsersTarget = ruleAction.target != null && Boolean.TRUE.equals(ruleAction.target.linkedUsers);
            boolean isLocalized = Objects.equals(notification.getMessage().getType(), "localized");
            boolean isEmail = Objects.equals(notification.getMessage().getType(), "email");
            boolean isPush = Objects.equals(notification.getMessage().getType(), "push");
            if (isLocalized) {
                LocalizedNotificationMessage localizedMsg = (LocalizedNotificationMessage)notification.getMessage();
                isHtml = false;
                localizedMsg.getMessages().forEach((lang, msg) -> {
                    if (msg instanceof PushNotificationMessage) {
                        PushNotificationMessage pushMsg = (PushNotificationMessage)msg;
                        PushNotificationAction action = pushMsg.getAction();
                        if (action != null && action.getUrl() != null) {
                            String newUrl = this.replaceAssetIdPlaceholder(action.getUrl(), ruleState, useUnmatched, "notification URL", true);
                            action.setUrl(newUrl);
                            pushMsg.setAction(action);
                        }
                        if (pushMsg.getBody() != null) {
                            String newBody = this.replaceAssetIdPlaceholder(pushMsg.getBody(), ruleState, useUnmatched, "notification body", false);
                            pushMsg.setBody(newBody);
                        }
                    }
                });
                body = null;
            } else if (isEmail) {
                EmailNotificationMessage email = (EmailNotificationMessage)notification.getMessage();
                isHtml = !TextUtil.isNullOrEmpty((String)email.getHtml());
                body = isHtml ? email.getHtml() : email.getText();
            } else {
                isHtml = false;
                if (isPush) {
                    PushNotificationMessage pushMsg = (PushNotificationMessage)notification.getMessage();
                    body = pushMsg.getBody();
                    PushNotificationAction action = pushMsg.getAction();
                    if (action != null && action.getUrl() != null) {
                        String newUrl = this.replaceAssetIdPlaceholder(action.getUrl(), ruleState, useUnmatched, "notification URL", true);
                        action.setUrl(newUrl);
                        pushMsg.setAction(action);
                    }
                    if (body != null) {
                        String newBody = this.replaceAssetIdPlaceholder(body, ruleState, useUnmatched, "notification body", false);
                        pushMsg.setBody(newBody);
                    }
                } else {
                    body = null;
                }
            }
            Notification.TargetType targetType = Notification.TargetType.ASSET;
            if (ruleAction.target != null) {
                if ((ruleAction.target.users != null || Boolean.TRUE.equals(ruleAction.target.linkedUsers)) && ruleAction.target.conditionAssets == null && ruleAction.target.assets == null && ruleAction.target.matchedAssets == null) {
                    targetType = Notification.TargetType.USER;
                } else if (ruleAction.target.custom != null && ruleAction.target.conditionAssets == null && ruleAction.target.assets == null && ruleAction.target.matchedAssets == null) {
                    targetType = Notification.TargetType.CUSTOM;
                }
            }
            HashMap localizedBodies = new HashMap();
            HashMap localizedIsHtml = new HashMap();
            if (isLocalized) {
                ((LocalizedNotificationMessage)notification.getMessage()).getMessages().forEach((lang, msg) -> {
                    if (msg instanceof PushNotificationMessage) {
                        PushNotificationMessage pushMsg = (PushNotificationMessage)msg;
                        localizedBodies.put(lang, pushMsg.getBody());
                        localizedIsHtml.put(lang, false);
                    } else if (msg instanceof EmailNotificationMessage) {
                        EmailNotificationMessage emailMsg = (EmailNotificationMessage)msg;
                        boolean isMsgHtml = !TextUtil.isNullOrEmpty((String)emailMsg.getHtml());
                        localizedBodies.put(lang, isMsgHtml ? emailMsg.getHtml() : emailMsg.getText());
                        localizedIsHtml.put(lang, true);
                    }
                });
            }
            if (isLocalized) {
                bodyContainsTriggeredAssetInfo = localizedBodies.values().stream().anyMatch(text -> !TextUtil.isNullOrEmpty((String)text) && text.contains(PLACEHOLDER_TRIGGER_ASSETS));
            } else {
                boolean bl = bodyContainsTriggeredAssetInfo = !TextUtil.isNullOrEmpty((String)body) && body.contains(PLACEHOLDER_TRIGGER_ASSETS);
            }
            if (linkedUsersTarget) {
                List<String> userIds;
                Set<String> assetIds = useUnmatched ? ruleState.otherwiseMatchedAssetIds : ruleState.thenMatchedAssetIds;
                UserQuery userQuery = ruleAction.target.users != null ? ruleAction.target.users : new UserQuery();
                List<String> list = userIds = assetIds == null || assetIds.isEmpty() ? Collections.emptyList() : usersFacade.getResults(userQuery.assets((String[])assetIds.toArray(String[]::new))).toList();
                if (userIds.isEmpty()) {
                    LOG.info("No users linked to matched assets for triggered rule so nothing to do: " + String.valueOf(this.jsonRuleset));
                    return null;
                }
                if (bodyContainsTriggeredAssetInfo) {
                    LOG.finer(() -> "Mapped target user IDs: " + String.join((CharSequence)",", userIds));
                    String realm = this.getRealm();
                    List<UserAssetLink> userAssetLinks = this.assetStorageService.findUserAssetLinks(realm, userIds, assetIds);
                    String finalBody = body;
                    List<Notification> customNotifications = userIds.stream().map(userId -> {
                        Map<String, Set<AttributeInfo>> assetStates = this.getMatchedAssetStates(ruleState, useUnmatched, (Collection<UserAssetLink>)userAssetLinks, (String)userId);
                        Notification customNotification = (Notification)ValueUtil.clone((Object)notification);
                        if (isLocalized) {
                            LocalizedNotificationMessage localizedMsg = (LocalizedNotificationMessage)customNotification.getMessage();
                            localizedMsg.getMessages().forEach((lang, msg) -> {
                                String newBody = this.insertTriggeredAssetInfo((String)localizedBodies.get(lang), assetStates, (Boolean)localizedIsHtml.get(lang), false);
                                localizedMsg.setMessage(lang, this.insertBodyInMessage((AbstractNotificationMessage)msg, (Boolean)localizedIsHtml.get(lang), newBody));
                            });
                        } else {
                            String newBody = this.insertTriggeredAssetInfo(finalBody, assetStates, isHtml, false);
                            customNotification.setMessage(this.insertBodyInMessage(customNotification.getMessage(), isHtml, newBody));
                        }
                        customNotification.setTargets(new Notification.Target[]{new Notification.Target(Notification.TargetType.USER, userId)});
                        return customNotification;
                    }).toList();
                    return new RuleActionExecution(() -> customNotifications.forEach(customNotification -> {
                        this.log(Level.FINE, "Sending custom user notification for rule action: " + rule.name + " '" + actionsName + "' action index " + index + " [Targets=" + (customNotification.getTargets() != null ? customNotification.getTargets().stream().map(Object::toString).collect(Collectors.joining(",")) : "null") + "]");
                        notificationsFacade.send(customNotification);
                    }), 0L);
                }
                targetIds = userIds;
            } else {
                targetIds = JsonRulesBuilder.getRuleActionTargetIds(ruleAction.target, useUnmatched, ruleState, assetsFacade, usersFacade, facts);
            }
            if (targetIds == null) {
                notification.setTargets((List)null);
            } else {
                Notification.TargetType finalTargetType = targetType;
                notification.setTargets(targetIds.stream().map(id -> new Notification.Target(finalTargetType, id)).collect(Collectors.toList()));
            }
            if (bodyContainsTriggeredAssetInfo) {
                Map<String, Set<AttributeInfo>> assetStates = this.getMatchedAssetStates(ruleState, useUnmatched, null, null);
                if (isLocalized) {
                    LocalizedNotificationMessage localizedMsg = (LocalizedNotificationMessage)notification.getMessage();
                    localizedMsg.getMessages().forEach((lang, msg) -> {
                        String newBody = this.insertTriggeredAssetInfo((String)localizedBodies.get(lang), assetStates, (Boolean)localizedIsHtml.get(lang), false);
                        localizedMsg.setMessage(lang, this.insertBodyInMessage((AbstractNotificationMessage)msg, (Boolean)localizedIsHtml.get(lang), newBody));
                    });
                } else {
                    String newBody = this.insertTriggeredAssetInfo(body, assetStates, isHtml, false);
                    notification.setMessage(this.insertBodyInMessage(notification.getMessage(), isHtml, newBody));
                }
            }
            this.log(Level.FINE, "Sending notification for rule action: " + rule.name + " '" + actionsName + "' action index " + index + " [Targets=" + (notification.getTargets() != null ? notification.getTargets().stream().map(Object::toString).collect(Collectors.joining(",")) : "null") + "]");
            return new RuleActionExecution(() -> notificationsFacade.send(notification), 0L);
        }
        if (ruleAction instanceof RuleActionWebhook) {
            RuleActionWebhook webhookAction = (RuleActionWebhook)ruleAction;
            if (webhookAction.webhook.getUrl() == null || webhookAction.webhook.getHttpMethod() == null) {
                LOG.info("Webhook action has no URL and/or HTTP method set so cannot complete action: " + String.valueOf(this.jsonRuleset));
                return null;
            }
            Webhook webhook = (Webhook)ValueUtil.clone((Object)webhookAction.webhook);
            if (!TextUtil.isNullOrEmpty((String)webhook.getPayload()) && webhook.getPayload().contains(PLACEHOLDER_TRIGGER_ASSETS)) {
                Map<String, Set<AttributeInfo>> assetStates = this.getMatchedAssetStates(ruleState, useUnmatched, null, null);
                String triggeredAssetInfoPayload = this.insertTriggeredAssetInfo(webhook.getPayload(), assetStates, false, true);
                webhook.setPayload(triggeredAssetInfoPayload);
            }
            if (webhookAction.mediaType == null) {
                Optional<Map.Entry> contentTypeHeader = webhook.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("content-type")).findFirst();
                String contentType = contentTypeHeader.isPresent() ? (String)((List)contentTypeHeader.get().getValue()).get(0) : "application/json";
                webhookAction.mediaType = MediaType.valueOf((String)contentType);
            }
            if (webhookAction.target == null) {
                webhookAction.target = webhooksFacade.buildTarget(webhook);
            }
            return new RuleActionExecution(() -> webhooksFacade.send(webhook, webhookAction.mediaType, webhookAction.target), 0L);
        }
        if (ruleAction instanceof RuleActionAlarm) {
            RuleActionAlarm alarmAction = (RuleActionAlarm)ruleAction;
            if (alarmAction.alarm != null) {
                Alarm alarm = alarmAction.alarm;
                ArrayList<String> assetIds = new ArrayList<String>(JsonRulesBuilder.getRuleActionTargetIds(ruleAction.target, useUnmatched, ruleState, assetsFacade, usersFacade, facts));
                if (alarm.getContent() == null) {
                    this.log(Level.WARNING, "Alarm content is missing for rule action: " + rule.name + " '" + actionsName + "' action index " + index);
                    return null;
                }
                String content = alarm.getContent();
                if (!TextUtil.isNullOrEmpty((String)content) && content.contains(PLACEHOLDER_TRIGGER_ASSETS)) {
                    alarm = (Alarm)ValueUtil.clone((Object)alarm);
                    Map<String, Set<AttributeInfo>> assetStates = this.getMatchedAssetStates(ruleState, useUnmatched, null, null);
                    alarm.setContent(this.getAlarmContent(content, assetStates));
                }
                if (alarm.getSeverity() == null) {
                    this.log(Level.WARNING, "Alarm severity is missing for rule action: " + rule.name + " '" + actionsName + "' action index " + index);
                    return null;
                }
                if (alarm.getTitle() == null) {
                    this.log(Level.WARNING, "Alarm title is missing for rule action: " + rule.name + " '" + actionsName + "' action index " + index);
                    return null;
                }
                alarm.setAssigneeId(alarmAction.assigneeId);
                alarm.setSourceId(Long.toString(this.jsonRuleset.getId()));
                Alarm finalAlarm = alarm;
                return new RuleActionExecution(() -> alarmsFacade.create(finalAlarm, assetIds), 0L);
            }
        }
        if (ruleAction instanceof RuleActionWriteAttribute) {
            RuleActionWriteAttribute attributeAction = (RuleActionWriteAttribute)ruleAction;
            if (JsonRulesBuilder.targetIsNotAssets(ruleAction.target)) {
                return null;
            }
            if (TextUtil.isNullOrEmpty((String)attributeAction.attributeName)) {
                this.log(Level.WARNING, "Attribute name is missing for rule action: " + rule.name + " '" + actionsName + "' action index " + index);
                return null;
            }
            Collection<String> ids = JsonRulesBuilder.getRuleActionTargetIds(ruleAction.target, useUnmatched, ruleState, assetsFacade, usersFacade, facts);
            if (ids != null && !ids.isEmpty()) {
                this.log(Level.FINE, "Writing attribute '" + attributeAction.attributeName + "' for " + ids.size() + " asset(s) for rule action: " + rule.name + " '" + actionsName + "' action index " + index);
                return new RuleActionExecution(() -> ids.forEach(id -> assetsFacade.dispatch(id, attributeAction.attributeName, attributeAction.value)), 0L);
            }
            this.log(Level.INFO, "No targets for write attribute rule action so skipping: " + rule.name + " '" + actionsName + "' action index " + index);
            return null;
        }
        if (ruleAction instanceof RuleActionWait) {
            long millis = ((RuleActionWait)ruleAction).millis;
            if (millis > 0L) {
                return new RuleActionExecution(null, millis);
            }
            this.log(Level.FINEST, "Invalid delay for wait rule action so skipping: " + rule.name + " '" + actionsName + "' action index " + index);
        }
        if (!(ruleAction instanceof RuleActionUpdateAttribute)) {
            this.log(Level.FINE, "Unsupported rule action: " + rule.name + " '" + actionsName + "' action index " + index);
            return null;
        }
        RuleActionUpdateAttribute attributeUpdateAction = (RuleActionUpdateAttribute)ruleAction;
        if (JsonRulesBuilder.targetIsNotAssets(ruleAction.target)) {
            this.log(Level.FINEST, "Invalid target update attribute rule action so skipping: " + rule.name + " '" + actionsName + "' action index " + index);
            return null;
        }
        if (TextUtil.isNullOrEmpty((String)attributeUpdateAction.attributeName)) {
            this.log(Level.WARNING, "Attribute name is missing for rule action: " + rule.name + " '" + actionsName + "' action index " + index);
            return null;
        }
        if (ruleAction.target == null || ruleAction.target.assets == null) {
            if (JsonRulesBuilder.targetIsNotAssets(ruleAction.target)) {
                throw new IllegalStateException("Cannot use action type '" + RuleActionUpdateAttribute.class.getSimpleName() + "' with user target");
            }
            matchingAssetIds = new ArrayList<String>(JsonRulesBuilder.getRuleActionTargetIds(ruleAction.target, useUnmatched, ruleState, assetsFacade, usersFacade, facts));
        } else {
            matchingAssetIds = facts.matchAssetState(ruleAction.target.assets).map(AttributeInfo::getId).distinct().collect(Collectors.toList());
        }
        if (matchingAssetIds.isEmpty()) {
            this.log(Level.INFO, "No targets for update attribute rule action so skipping: " + rule.name + " '" + actionsName + "' action index " + index);
            return null;
        }
        List matchingAssetStates = matchingAssetIds.stream().map(assetId -> facts.getAssetStates().stream().filter(state -> state.getId().equals(assetId) && state.getName().equals(attributeUpdateAction.attributeName)).findFirst().orElseGet(() -> {
            this.log(Level.WARNING, "Failed to find attribute in rule states for attribute update: " + String.valueOf(new AttributeRef(assetId, attributeUpdateAction.attributeName)));
            return null;
        })).filter(Objects::nonNull).collect(Collectors.toList());
        if (matchingAssetStates.isEmpty()) {
            this.log(Level.WARNING, "No asset states matched to apply update attribute action to");
            return null;
        }
        return new RuleActionExecution(() -> matchingAssetStates.forEach(assetState -> {
            Object value = assetState.getValue().orElse(null);
            Class valueType = assetState.getTypeClass();
            boolean isArray = ValueUtil.isArray((Class)valueType);
            if (!isArray && !ValueUtil.isMap((Class)valueType)) {
                this.log(Level.WARNING, "Rule action target asset cannot determine value type or incompatible value type for attribute: " + String.valueOf(assetState));
            } else {
                if (isArray) {
                    ArrayList list = new ArrayList();
                    if (value != null) {
                        Collections.addAll(list, value);
                    }
                    switch (attributeUpdateAction.updateAction) {
                        case ADD: {
                            list.add(attributeUpdateAction.value);
                            break;
                        }
                        case ADD_OR_REPLACE: 
                        case REPLACE: {
                            if (attributeUpdateAction.index != null && list.size() >= attributeUpdateAction.index) {
                                list.set(attributeUpdateAction.index, attributeUpdateAction.value);
                                break;
                            }
                            list.add(attributeUpdateAction.value);
                            break;
                        }
                        case DELETE: {
                            if (attributeUpdateAction.index == null || list.size() < attributeUpdateAction.index) break;
                            list.remove(attributeUpdateAction.index);
                            break;
                        }
                        case CLEAR: {
                            value = Collections.emptyList();
                        }
                    }
                    value = list;
                } else {
                    Map<String, Object> map = new HashMap<String, Object>();
                    if (value != null) {
                        map.putAll((Map)value);
                    }
                    switch (attributeUpdateAction.updateAction) {
                        case ADD: {
                            map.put(attributeUpdateAction.key, attributeUpdateAction.value);
                            break;
                        }
                        case ADD_OR_REPLACE: 
                        case REPLACE: {
                            if (!TextUtil.isNullOrEmpty((String)attributeUpdateAction.key)) {
                                map.put(attributeUpdateAction.key, attributeUpdateAction.value);
                                break;
                            }
                            this.log(Level.WARNING, "JSON Rule: Rule action missing required 'key': " + String.valueOf(ValueUtil.asJSON((Object)attributeUpdateAction)));
                            break;
                        }
                        case DELETE: {
                            map.remove(attributeUpdateAction.key);
                            break;
                        }
                        case CLEAR: {
                            map = Collections.emptyMap();
                        }
                    }
                    value = map;
                }
                this.log(Level.FINE, "Updating attribute for rule action: " + rule.name + " '" + actionsName + "' action index " + index + ": " + String.valueOf(assetState));
                assetsFacade.dispatch(assetState.getId(), attributeUpdateAction.attributeName, value);
            }
        }), 0L);
    }

    protected Map<String, Set<AttributeInfo>> getMatchedAssetStates(RuleState ruleState, boolean useUnmatched, Collection<UserAssetLink> userAssetLinks, String userId) {
        Set<String> assetIds = useUnmatched ? ruleState.otherwiseMatchedAssetIds : ruleState.thenMatchedAssetIds;
        return assetIds == null || assetIds.isEmpty() ? null : ruleState.conditionStateMap.values().stream().filter(conditionState -> conditionState.lastEvaluationResult.matches).flatMap(conditionState -> {
            Collection<AttributeInfo> as = useUnmatched ? conditionState.lastEvaluationResult.unmatchedAssetStates : conditionState.lastEvaluationResult.matchedAssetStates;
            return as.stream();
        }).filter(assetState -> assetIds.contains(assetState.getId()) && (userAssetLinks == null || userAssetLinks.stream().anyMatch(ual -> ual.getId().getAssetId().equals(assetState.getId()) && ual.getId().getUserId().equals(userId)))).collect(Collectors.groupingBy(AttributeInfo::getId, Collectors.toSet()));
    }

    protected String getRealm() {
        String realm = null;
        Ruleset ruleset = this.jsonRuleset;
        if (ruleset instanceof RealmRuleset) {
            RealmRuleset realmRuleset = (RealmRuleset)ruleset;
            realm = realmRuleset.getRealm();
        } else {
            ruleset = this.jsonRuleset;
            if (ruleset instanceof AssetRuleset) {
                AssetRuleset assetRuleset = (AssetRuleset)ruleset;
                realm = assetRuleset.getRealm();
            }
        }
        return realm;
    }

    protected String getAlarmContent(String sourceText, Map<String, Set<AttributeInfo>> assetStates) {
        StringBuilder sb = new StringBuilder();
        assetStates.forEach((key, value) -> value.forEach(assetState -> {
            sb.append("ID: ").append(assetState.getId()).append("\n");
            sb.append("Asset name: ").append(assetState.getAssetName()).append("\n");
            sb.append("Attribute name: ").append(assetState.getName()).append("\n");
            sb.append("Value: ").append(assetState.getValue().flatMap(ValueUtil::asJSON).orElse("")).append("\n");
        }));
        return sourceText.replace(PLACEHOLDER_TRIGGER_ASSETS, sb.toString());
    }

    protected String replaceAssetIdPlaceholder(String text, RuleState ruleState, boolean useUnmatched, String context, boolean firstOnly) {
        Set<String> matchedIds;
        if (TextUtil.isNullOrEmpty((String)text) || !text.contains(PLACEHOLDER_ASSET_ID)) {
            return text;
        }
        Set<String> set = matchedIds = useUnmatched ? ruleState.otherwiseMatchedAssetIds : ruleState.thenMatchedAssetIds;
        if (matchedIds != null && !matchedIds.isEmpty()) {
            String replacement = firstOnly ? matchedIds.iterator().next() : String.join((CharSequence)",", matchedIds);
            String result = text.replace(PLACEHOLDER_ASSET_ID, replacement);
            this.log(Level.FINEST, "Replaced asset ID(s) in " + context + ": " + result);
            return result;
        }
        this.log(Level.WARNING, "Asset ID placeholder used but no matched assets found for " + context);
        return text;
    }

    protected String insertTriggeredAssetInfo(String sourceText, Map<String, Set<AttributeInfo>> assetStates, boolean isHtml, boolean isJson) {
        StringBuilder sb = new StringBuilder();
        if (isHtml) {
            sb.append("<table cellpadding=\"30\">");
            sb.append("<tr><th>Asset ID</th><th>Asset Name</th><th>Attribute</th><th>Value</th></tr>");
            assetStates.forEach((key, value) -> value.forEach(assetState -> {
                sb.append("<tr><td>");
                sb.append(assetState.getId());
                sb.append("</td><td>");
                sb.append(assetState.getAssetName());
                sb.append("</td><td>");
                sb.append(assetState.getName());
                sb.append("</td><td>");
                sb.append(assetState.getValue().flatMap(ValueUtil::asJSON).orElse(""));
                sb.append("</td></tr>");
            }));
            sb.append("</table>");
        } else if (isJson) {
            try {
                return ValueUtil.JSON.writerWithView(AttributeEvent.Enhanced.class).writeValueAsString(assetStates);
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
            }
        } else {
            sb.append("Asset ID\t\tAsset Name\t\tAttribute\t\tValue");
            assetStates.forEach((key, value) -> value.forEach(assetState -> {
                sb.append(assetState.getId());
                sb.append("\t\t");
                sb.append(assetState.getAssetName());
                sb.append("\t\t");
                sb.append(assetState.getName());
                sb.append("\t\t");
                sb.append(assetState.getValue().map(v -> (String)ValueUtil.convert((Object)v, String.class)).orElse(""));
            }));
        }
        return sourceText.replace(PLACEHOLDER_TRIGGER_ASSETS, sb.toString());
    }

    protected AbstractNotificationMessage insertBodyInMessage(AbstractNotificationMessage sourceMessage, boolean isHtml, String body) {
        if (sourceMessage instanceof EmailNotificationMessage) {
            EmailNotificationMessage emailMsg = (EmailNotificationMessage)sourceMessage;
            if (isHtml) {
                emailMsg.setHtml(body);
            } else {
                emailMsg.setText(body);
            }
        } else if (sourceMessage instanceof PushNotificationMessage) {
            PushNotificationMessage pushMsg = (PushNotificationMessage)sourceMessage;
            pushMsg.setBody(body);
        }
        return sourceMessage;
    }

    protected static Collection<String> getRuleActionTargetIds(RuleActionTarget target, boolean useUnmatched, RuleState ruleState, Assets assetsFacade, Users usersFacade, RulesFacts facts) {
        Map<String, RuleConditionState> conditionStateMap = ruleState.conditionStateMap;
        if (target != null) {
            if (!TextUtil.isNullOrEmpty((String)target.conditionAssets) && conditionStateMap != null) {
                RuleConditionState triggerState2 = conditionStateMap.get(target.conditionAssets);
                if (!useUnmatched) {
                    return triggerState2 != null ? triggerState2.getMatchedAssetIds() : Collections.emptyList();
                }
                return triggerState2 != null ? triggerState2.getUnmatchedAssetIds() : Collections.emptyList();
            }
            if (conditionStateMap != null && target.matchedAssets != null) {
                List compareAssetIds = conditionStateMap.values().stream().flatMap(triggerState -> useUnmatched ? triggerState.getUnmatchedAssetIds().stream() : triggerState.getMatchedAssetIds().stream()).toList();
                if (target.matchedAssets != null) {
                    return facts.matchAssetState(target.matchedAssets).map(AttributeInfo::getId).distinct().filter(compareAssetIds::contains).collect(Collectors.toList());
                }
            }
            if (target.assets != null) {
                return JsonRulesBuilder.getAssetIds(assetsFacade, target.assets);
            }
            if (target.users != null) {
                return JsonRulesBuilder.getUserIds(usersFacade, target.users);
            }
            if (target.custom != null) {
                return Collections.singleton(target.custom);
            }
        }
        if (conditionStateMap != null) {
            if (!useUnmatched) {
                return conditionStateMap.values().stream().flatMap(triggerState -> triggerState != null ? triggerState.getMatchedAssetIds().stream() : Stream.empty()).distinct().collect(Collectors.toList());
            }
            return conditionStateMap.values().stream().flatMap(triggerState -> triggerState != null ? triggerState.getUnmatchedAssetIds().stream() : Stream.empty()).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected static boolean targetIsNotAssets(RuleActionTarget target) {
        return target != null && (target.users != null || target.linkedUsers != null && target.linkedUsers != false);
    }

    protected void log(Level level, String message) {
        LOG.log(level, LOG_PREFIX + this.jsonRuleset.getName() + "': " + message);
    }

    protected void log(Level level, String message, Throwable t) {
        LOG.log(level, LOG_PREFIX + this.jsonRuleset.getName() + "': " + message, t);
    }

    protected static SunTimes.Parameters getSunCalculator(Ruleset ruleset, SunPositionTrigger sunPositionTrigger, TimerService timerService) throws IllegalStateException {
        SunPositionTrigger.Position position = sunPositionTrigger.getPosition();
        GeoJSONPoint location = sunPositionTrigger.getLocation();
        if (position == null) {
            throw new IllegalStateException(LOG_PREFIX + ruleset.getName() + "': Rule condition sun requires a position value");
        }
        if (location == null) {
            throw new IllegalStateException(LOG_PREFIX + ruleset.getName() + "': Rule condition sun requires a location value");
        }
        SunTimes.Twilight twilight = null;
        if (position.name().startsWith("TWILIGHT_")) {
            String lookupValue = position.name().replace("TWILIGHT_MORNING_", "").replace("TWILIGHT_EVENING_", "").replace("TWILIGHT_", "");
            twilight = (SunTimes.Twilight)EnumUtil.enumFromString(SunTimes.Twilight.class, (String)lookupValue).orElseThrow(() -> {
                throw new IllegalStateException(LOG_PREFIX + ruleset.getName() + "': Rule condition un-supported twilight position value '" + lookupValue + "'");
            });
        }
        SunTimes.Parameters sunCalculator = (SunTimes.Parameters)((SunTimes.Parameters)((SunTimes.Parameters)SunTimes.compute().on(timerService.getNow())).utc()).at(location.getX(), location.getY());
        if (twilight != null) {
            sunCalculator.twilight(twilight);
        }
        return sunCalculator;
    }

    protected static Function<Collection<AttributeInfo>, Set<AttributeInfo>> asAttributeMatcher(Supplier<Long> currentMillisProducer, List<AttributePredicate> attributePredicates, Map<Integer, String> predicateDurationStrings, Map<Pair<AttributeInfo, Integer>, Long> durationMatchTimes) {
        if (attributePredicates == null || attributePredicates.isEmpty()) {
            return as -> Collections.EMPTY_SET;
        }
        List<Pair> attributePredicatesAndDurations = IntStream.range(0, attributePredicates.size()).mapToObj(i -> {
            AttributePredicate p = (AttributePredicate)attributePredicates.get(i);
            Long predicateDuration = null;
            if (predicateDurationStrings != null && predicateDurationStrings.get(i) != null) {
                String durationStr = (String)predicateDurationStrings.get(i);
                predicateDuration = TimeUtil.parseTimeDuration((String)durationStr);
            }
            Predicate<NameValueHolder<?>> predicate = AssetQueryPredicate.asPredicate(currentMillisProducer, (NameValuePredicate)p);
            if (p.meta != null) {
                Predicate innerMetaPredicate = Arrays.stream(p.meta).map(arg_0 -> JsonRulesBuilder.lambda$asAttributeMatcher$46((Supplier)currentMillisProducer, arg_0)).reduce(x -> true, Predicate::and);
                predicate = predicate.and(assetState -> {
                    MetaMap metaItems = assetState.getMeta();
                    return metaItems.stream().anyMatch(metaItem -> innerMetaPredicate.test(assetState));
                });
            }
            if (p.previousValue != null) {
                Predicate innerOldValuePredicate = p.previousValue.asPredicate(currentMillisProducer);
                predicate = predicate.and(nameValueHolder -> innerOldValuePredicate.test(nameValueHolder.getOldValue()));
            }
            return new Pair(predicate, (Object)predicateDuration);
        }).toList();
        return assetStates -> {
            HashSet matchedAssetStates = new HashSet();
            boolean allPredicatesMatch = IntStream.range(0, attributePredicatesAndDurations.size()).mapToObj(arg_0 -> JsonRulesBuilder.lambda$asAttributeMatcher$54(attributePredicatesAndDurations, assetStates, matchedAssetStates, durationMatchTimes, (Supplier)currentMillisProducer, arg_0)).filter(predicateMatches -> predicateMatches.equals(true)).count() == (long)attributePredicatesAndDurations.size();
            return allPredicatesMatch ? matchedAssetStates : null;
        };
    }

    private static /* synthetic */ Boolean lambda$asAttributeMatcher$54(List attributePredicatesAndDurations, Collection assetStates, Set matchedAssetStates, Map durationMatchTimes, Supplier currentMillisProducer, int i) {
        Pair predicateAndDuration = (Pair)attributePredicatesAndDurations.get(i);
        Long duration = (Long)predicateAndDuration.getValue();
        if (duration == null) {
            return assetStates.stream().filter((Predicate)predicateAndDuration.getKey()).findFirst().map(matchedAssetState -> {
                matchedAssetStates.add(matchedAssetState);
                return true;
            }).orElse(false);
        }
        AtomicBoolean matchFound = new AtomicBoolean();
        assetStates.forEach(arg_0 -> JsonRulesBuilder.lambda$asAttributeMatcher$53(predicateAndDuration, i, durationMatchTimes, duration, (Supplier)currentMillisProducer, matchFound, matchedAssetStates, arg_0));
        return matchFound.get();
    }

    private static /* synthetic */ void lambda$asAttributeMatcher$53(Pair predicateAndDuration, int i, Map durationMatchTimes, Long duration, Supplier currentMillisProducer, AtomicBoolean matchFound, Set matchedAssetStates, AttributeInfo assetState) {
        if (((Predicate)predicateAndDuration.getKey()).test(assetState)) {
            boolean durationMatches = false;
            Pair assetStatePredicateIndex = new Pair((Object)assetState, (Object)i);
            Long previousMatchTime = (Long)durationMatchTimes.get(assetStatePredicateIndex);
            if (previousMatchTime != null) {
                durationMatches = previousMatchTime + duration <= (Long)currentMillisProducer.get();
            } else {
                durationMatchTimes.put(assetStatePredicateIndex, (Long)currentMillisProducer.get());
            }
            if (durationMatches && !matchFound.get()) {
                matchFound.set(true);
                matchedAssetStates.add(assetState);
            }
        } else {
            durationMatchTimes.remove(new Pair((Object)assetState, (Object)i));
        }
    }

    private static /* synthetic */ Predicate lambda$asAttributeMatcher$46(Supplier currentMillisProducer, NameValuePredicate metaPred) {
        return AssetQueryPredicate.asPredicate(currentMillisProducer, metaPred);
    }

    class RuleState {
        protected JsonRule rule;
        protected Map<String, RuleConditionState> conditionStateMap = new HashMap<String, RuleConditionState>();
        protected Set<String> thenMatchedAssetIds;
        protected Set<String> otherwiseMatchedAssetIds;
        protected long nextRecur;
        protected boolean matched;
        protected Map<String, Long> nextRecurAssetIdMap = new HashMap<String, Long>();

        public RuleState(JsonRule rule) {
            this.rule = rule;
        }

        public void update(Supplier<Long> currentMillisSupplier) {
            this.matched = false;
            if (this.nextRecur > currentMillisSupplier.get()) {
                return;
            }
            this.nextRecurAssetIdMap.entrySet().removeIf(entry -> (Long)entry.getValue() <= (Long)currentMillisSupplier.get());
            JsonRulesBuilder.this.log(Level.FINEST, "Updating rule condition states for rule: " + this.rule.name);
            this.conditionStateMap.values().forEach(ruleConditionState -> ruleConditionState.update(this.nextRecurAssetIdMap));
            this.thenMatchedAssetIds = new HashSet<String>();
            this.otherwiseMatchedAssetIds = this.rule.otherwise != null ? new HashSet() : null;
            this.matched = this.updateMatches((LogicGroup<RuleCondition>)this.rule.when, this.thenMatchedAssetIds, this.otherwiseMatchedAssetIds);
            if (!this.matched) {
                this.thenMatchedAssetIds.clear();
                if (this.otherwiseMatchedAssetIds != null) {
                    this.otherwiseMatchedAssetIds.clear();
                }
            }
        }

        public boolean thenMatched() {
            return this.thenMatchedAssetIds != null && !this.thenMatchedAssetIds.isEmpty() || !this.otherwiseMatched();
        }

        public boolean otherwiseMatched() {
            return this.otherwiseMatchedAssetIds != null && !this.otherwiseMatchedAssetIds.isEmpty();
        }

        protected boolean updateMatches(LogicGroup<RuleCondition> ruleConditionGroup, Set<String> thenMatchedAssetIds, Set<String> otherwiseMatchedAssetIds) {
            if (AssetQueryPredicate.groupIsEmpty(ruleConditionGroup)) {
                return false;
            }
            LogicGroup.Operator operator = ruleConditionGroup.operator == null ? LogicGroup.Operator.AND : ruleConditionGroup.operator;
            boolean groupMatches = false;
            if (!ruleConditionGroup.getItems().isEmpty()) {
                if (operator == LogicGroup.Operator.AND) {
                    boolean anyConditionHasNoPreviousMatches;
                    groupMatches = ruleConditionGroup.getItems().stream().map(ruleCondition -> this.conditionStateMap.get(ruleCondition.tag)).allMatch(ruleConditionState -> ruleConditionState.lastEvaluationResult != null && ruleConditionState.lastEvaluationResult.matches);
                    if (!groupMatches && ruleConditionGroup.getItems().size() > 1 && (anyConditionHasNoPreviousMatches = ruleConditionGroup.getItems().stream().map(ruleCondition -> this.conditionStateMap.get(ruleCondition.tag)).anyMatch(ruleConditionState -> ruleConditionState.previouslyMatchedAssetStates.isEmpty()))) {
                        ruleConditionGroup.getItems().forEach(ruleCondition -> {
                            RuleConditionState conditionState = this.conditionStateMap.get(ruleCondition.tag);
                            if (conditionState != null && !conditionState.previouslyMatchedAssetStates.isEmpty()) {
                                conditionState.previouslyMatchedAssetStates.clear();
                            }
                        });
                    }
                } else {
                    groupMatches = ruleConditionGroup.getItems().stream().map(ruleCondition -> this.conditionStateMap.get(ruleCondition.tag)).anyMatch(ruleConditionState -> ruleConditionState.lastEvaluationResult != null && ruleConditionState.lastEvaluationResult.matches);
                }
                thenMatchedAssetIds.addAll(ruleConditionGroup.getItems().stream().map(ruleCondition -> this.conditionStateMap.get(ruleCondition.tag)).filter(ruleConditionState -> ruleConditionState.lastEvaluationResult != null && ruleConditionState.lastEvaluationResult.matches).map(RuleConditionState::getMatchedAssetIds).flatMap(Collection::stream).collect(Collectors.toSet()));
                if (otherwiseMatchedAssetIds != null) {
                    otherwiseMatchedAssetIds.addAll(ruleConditionGroup.getItems().stream().map(ruleCondition -> this.conditionStateMap.get(ruleCondition.tag)).filter(ruleConditionState -> ruleConditionState.trackUnmatched && ruleConditionState.lastEvaluationResult != null && ruleConditionState.lastEvaluationResult.matches).map(RuleConditionState::getUnmatchedAssetIds).flatMap(Collection::stream).collect(Collectors.toSet()));
                }
            }
            if (ruleConditionGroup.groups != null) {
                if (operator == LogicGroup.Operator.AND) {
                    if (!ruleConditionGroup.items.isEmpty() && !groupMatches) {
                        return false;
                    }
                    groupMatches = ruleConditionGroup.groups.stream().allMatch(group -> this.updateMatches((LogicGroup<RuleCondition>)group, thenMatchedAssetIds, otherwiseMatchedAssetIds));
                } else {
                    groupMatches = ruleConditionGroup.groups.stream().filter(group -> this.updateMatches((LogicGroup<RuleCondition>)group, thenMatchedAssetIds, otherwiseMatchedAssetIds)).count() > 0L;
                }
            }
            return groupMatches;
        }
    }

    class RuleConditionState {
        RuleCondition ruleCondition;
        final TimerService timerService;
        boolean trackUnmatched;
        AssetQuery.OrderBy orderBy;
        int limit;
        LogicGroup<AttributePredicate> attributePredicates = null;
        Function<Collection<AttributeInfo>, Set<AttributeInfo>> assetPredicate = null;
        Map<Pair<AttributeInfo, Integer>, Long> durationMatchTimes = new HashMap<Pair<AttributeInfo, Integer>, Long>();
        Set<AttributeInfo> unfilteredAssetStates = new HashSet<AttributeInfo>();
        Set<AttributeInfo> previouslyMatchedAssetStates = new HashSet<AttributeInfo>();
        Set<AttributeInfo> previouslyUnmatchedAssetStates;
        Predicate<Long> timePredicate;
        RuleConditionEvaluationResult lastEvaluationResult;

        public RuleConditionState(RuleCondition ruleCondition, boolean trackUnmatched, TimerService timerService) throws Exception {
            this.timerService = timerService;
            this.ruleCondition = ruleCondition;
            this.trackUnmatched = trackUnmatched;
            if (trackUnmatched) {
                this.previouslyUnmatchedAssetStates = new HashSet<AttributeInfo>();
            }
            if (!TextUtil.isNullOrEmpty((String)ruleCondition.cron)) {
                try {
                    CronExpression timerExpression = new CronExpression(ruleCondition.cron);
                    timerExpression.setTimeZone(TimeZone.getTimeZone("UTC"));
                    AtomicLong nextExecuteMillis = new AtomicLong(timerExpression.getNextValidTimeAfter(new Date(timerService.getCurrentTimeMillis())).getTime());
                    this.timePredicate = time -> {
                        long nextExecute = nextExecuteMillis.get();
                        if (time >= nextExecute) {
                            nextExecuteMillis.set(timerExpression.getNextValidTimeAfter(timerExpression.getNextInvalidTimeAfter(new Date(nextExecute))).getTime());
                            return true;
                        }
                        return false;
                    };
                }
                catch (Exception e) {
                    JsonRulesBuilder.this.log(Level.SEVERE, "Failed to parse rule condition cron expression: " + ruleCondition.cron, e);
                    throw e;
                }
            } else if (ruleCondition.sun != null) {
                SunTimes.Parameters sunCalculator = JsonRulesBuilder.getSunCalculator(JsonRulesBuilder.this.jsonRuleset, ruleCondition.sun, timerService);
                long offsetMillis = ruleCondition.sun.getOffsetMins() != null ? (long)(ruleCondition.sun.getOffsetMins() * 60000) : 0L;
                boolean useRiseTime = ruleCondition.sun.getPosition() == SunPositionTrigger.Position.SUNRISE || ruleCondition.sun.getPosition().toString().startsWith("TWILIGHT_MORNING_");
                AtomicReference<SunTimes> sunTimes = new AtomicReference<SunTimes>((SunTimes)sunCalculator.execute());
                Function<Long, Long> nextExecuteMillisCalculator = time -> {
                    ZonedDateTime occurrence;
                    ZonedDateTime zonedDateTime = occurrence = useRiseTime ? ((SunTimes)sunTimes.get()).getRise() : ((SunTimes)sunTimes.get()).getSet();
                    if (occurrence == null) {
                        JsonRulesBuilder.this.log(Level.WARNING, "Rule condition requested sun position never occurs at the specified location: " + String.valueOf(ruleCondition.sun));
                        return Long.MAX_VALUE;
                    }
                    long nextMillis = occurrence.toInstant().toEpochMilli() + offsetMillis;
                    if (nextMillis < time) {
                        ZonedDateTime resetOccurrence = ((SunTimes)sunTimes.get()).getSet().isBefore(((SunTimes)sunTimes.get()).getRise()) ? ((SunTimes)sunTimes.get()).getSet() : ((SunTimes)sunTimes.get()).getRise();
                        resetOccurrence = resetOccurrence.truncatedTo(ChronoUnit.DAYS).plusDays(1L);
                        sunTimes.set((SunTimes)((SunTimes.Parameters)sunCalculator.on(new Date(Math.max(resetOccurrence.toInstant().toEpochMilli(), time - 300000L)))).execute());
                    }
                    return nextMillis;
                };
                this.timePredicate = time -> {
                    long nextExecute = (Long)nextExecuteMillisCalculator.apply((Long)time);
                    if (time >= nextExecute && time - nextExecute < 60000L) {
                        JsonRulesBuilder.this.log(Level.INFO, "Rule condition sun position has triggered at: " + timerService.getCurrentTimeMillis());
                        return true;
                    }
                    return false;
                };
            } else if (ruleCondition.assets != null) {
                boolean attributePredicateHasDurationCondition;
                this.orderBy = ruleCondition.assets.orderBy;
                this.limit = ruleCondition.assets.limit;
                this.attributePredicates = ruleCondition.assets.attributes;
                boolean bl = attributePredicateHasDurationCondition = ruleCondition.duration != null && !ruleCondition.duration.isEmpty();
                if (this.attributePredicates != null && this.attributePredicates.items != null) {
                    this.attributePredicates.groups = null;
                    this.assetPredicate = attributePredicateHasDurationCondition ? JsonRulesBuilder.asAttributeMatcher(() -> ((TimerService)timerService).getCurrentTimeMillis(), this.attributePredicates.getItems(), ruleCondition.duration, this.durationMatchTimes) : AssetQueryPredicate.asAttributeMatcher(() -> ((TimerService)timerService).getCurrentTimeMillis(), this.attributePredicates);
                }
                ruleCondition.assets.orderBy = null;
                ruleCondition.assets.limit = 0;
                ruleCondition.assets.attributes = null;
            } else {
                throw new IllegalStateException("Invalid rule condition either timer or asset query must be set");
            }
        }

        void updateUnfilteredAssetStates(RulesFacts facts, RulesEngine.AssetStateChangeEvent event) {
            if (this.ruleCondition.assets != null) {
                this.lastEvaluationResult = null;
                if (event == null || event.cause == PersistenceEvent.Cause.CREATE) {
                    this.unfilteredAssetStates = facts.matchAssetState(this.ruleCondition.assets).collect(Collectors.toSet());
                } else {
                    switch (event.cause) {
                        case UPDATE: {
                            if (!this.unfilteredAssetStates.remove(event.assetState)) break;
                            this.unfilteredAssetStates.add(event.assetState);
                            break;
                        }
                        case DELETE: {
                            this.unfilteredAssetStates.remove(event.assetState);
                            if (this.durationMatchTimes == null) break;
                            this.durationMatchTimes.keySet().removeIf(attributeRefPredicateIndex -> ((AttributeInfo)attributeRefPredicateIndex.getKey()).getRef().equals((Object)event.assetState.getRef()));
                        }
                    }
                }
                if (event != null && this.previouslyMatchedAssetStates.remove(event.assetState)) {
                    this.previouslyMatchedAssetStates.add(event.assetState);
                }
                if (facts.trackLocationRules) {
                    facts.storeLocationPredicates(LocationAttributePredicate.getLocationPredicates(this.attributePredicates));
                }
            }
        }

        void update(Map<String, Long> nextRecurAssetIdMap) {
            List<Object> matchedAssetStates;
            if (this.lastEvaluationResult != null && this.lastEvaluationResult.matches) {
                return;
            }
            if (this.timePredicate != null) {
                this.lastEvaluationResult = null;
                if (this.timePredicate.test(this.timerService.getCurrentTimeMillis())) {
                    this.lastEvaluationResult = new RuleConditionEvaluationResult(true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                }
                return;
            }
            if (this.unfilteredAssetStates.isEmpty()) {
                this.previouslyMatchedAssetStates.clear();
                if (this.trackUnmatched) {
                    this.previouslyUnmatchedAssetStates.clear();
                }
                JsonRulesBuilder.this.log(Level.FINEST, "Rule trigger has no unfiltered asset states so no match");
                this.lastEvaluationResult = new RuleConditionEvaluationResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                return;
            }
            List<AttributeInfo> unmatchedAssetStates = Collections.emptyList();
            Collection<String> unmatchedAssetIds = Collections.emptyList();
            if (this.attributePredicates == null) {
                matchedAssetStates = new ArrayList<AttributeInfo>(this.unfilteredAssetStates);
            } else {
                HashMap<Boolean, List<Object>> results = new HashMap<Boolean, List<Object>>();
                ArrayList matched = new ArrayList();
                ArrayList unmatched = new ArrayList();
                results.put(true, matched);
                results.put(false, unmatched);
                this.unfilteredAssetStates.stream().collect(Collectors.groupingBy(AttributeInfo::getId)).forEach((id, states) -> {
                    Set<AttributeInfo> matches = this.assetPredicate.apply((Collection<AttributeInfo>)states);
                    if (matches != null) {
                        matched.addAll(matches);
                        unmatched.addAll(states.stream().filter(state -> !matches.contains(state)).collect(Collectors.toSet()));
                    } else {
                        unmatched.addAll(states);
                    }
                });
                matchedAssetStates = results.getOrDefault(true, Collections.emptyList());
                unmatchedAssetStates = results.getOrDefault(false, Collections.emptyList());
                if (this.trackUnmatched) {
                    this.previouslyUnmatchedAssetStates.removeIf(matchedAssetStates::contains);
                    unmatchedAssetStates.removeIf(this.previouslyUnmatchedAssetStates::contains);
                }
            }
            this.previouslyMatchedAssetStates.removeIf(previousAssetState -> {
                Optional<AttributeInfo> matched = matchedAssetStates.stream().filter(matchedAssetState -> Objects.equals(previousAssetState, matchedAssetState)).findFirst();
                boolean noLongerMatches = matched.isEmpty();
                if (!noLongerMatches) {
                    noLongerMatches = matched.map(matchedAssetState -> {
                        boolean resetImmediately = matchedAssetState.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.RULE_RESET_IMMEDIATE).orElse(false);
                        return resetImmediately && matchedAssetState.getTimestamp() > previousAssetState.getTimestamp();
                    }).orElse(false);
                }
                if (noLongerMatches) {
                    JsonRulesBuilder.this.log(Level.FINEST, "Rule trigger previously matched asset state no longer matches so resetting: " + String.valueOf(previousAssetState));
                }
                return noLongerMatches;
            });
            matchedAssetStates.removeIf(matchedAssetState -> nextRecurAssetIdMap.containsKey(matchedAssetState.getId()) && (Long)nextRecurAssetIdMap.get(matchedAssetState.getId()) > this.timerService.getCurrentTimeMillis());
            matchedAssetStates.removeIf(this.previouslyMatchedAssetStates::contains);
            Stream<Object> matchedAssetStateStream = matchedAssetStates.stream().filter(ValueUtil.distinctByKey(AttributeInfo::getId));
            if (this.orderBy != null) {
                matchedAssetStateStream = matchedAssetStateStream.sorted(RulesFacts.asComparator(this.orderBy));
            }
            if (this.limit > 0) {
                matchedAssetStateStream = matchedAssetStateStream.limit(this.limit);
            }
            Collection matchedAssetIds = matchedAssetStateStream.map(AttributeInfo::getId).collect(Collectors.toList());
            if (this.trackUnmatched) {
                Stream unmatchedAssetStateStream = unmatchedAssetStates.stream().filter(ValueUtil.distinctByKey(AttributeInfo::getId));
                unmatchedAssetIds = unmatchedAssetStateStream.map(AttributeInfo::getId).filter(id -> !matchedAssetIds.contains(id)).collect(Collectors.toList());
            }
            this.lastEvaluationResult = new RuleConditionEvaluationResult(!matchedAssetIds.isEmpty() || this.trackUnmatched && !unmatchedAssetIds.isEmpty(), matchedAssetStates, matchedAssetIds, unmatchedAssetStates, unmatchedAssetIds);
            JsonRulesBuilder.this.log(Level.FINEST, "Rule evaluation result: " + String.valueOf(this.lastEvaluationResult));
        }

        Collection<String> getMatchedAssetIds() {
            if (this.lastEvaluationResult == null) {
                return Collections.emptyList();
            }
            return this.lastEvaluationResult.matchedAssetIds;
        }

        Collection<String> getUnmatchedAssetIds() {
            if (this.lastEvaluationResult == null) {
                return Collections.emptyList();
            }
            return this.lastEvaluationResult.unmatchedAssetIds;
        }
    }

    static class RuleActionExecution {
        Runnable runnable;
        long delay;

        public RuleActionExecution(Runnable runnable, long delay) {
            this.runnable = runnable;
            this.delay = delay;
        }
    }

    static class RuleConditionEvaluationResult {
        boolean matches;
        Collection<AttributeInfo> matchedAssetStates;
        Collection<AttributeInfo> unmatchedAssetStates;
        Collection<String> matchedAssetIds;
        Collection<String> unmatchedAssetIds;

        public RuleConditionEvaluationResult(boolean matches, Collection<AttributeInfo> matchedAssetStates, Collection<String> matchedAssetIds, Collection<AttributeInfo> unmatchedAssetStates, Collection<String> unmatchedAssetIds) {
            this.matches = matches;
            this.matchedAssetStates = matchedAssetStates;
            this.matchedAssetIds = matchedAssetIds;
            this.unmatchedAssetStates = unmatchedAssetStates;
            this.unmatchedAssetIds = unmatchedAssetIds;
        }

        public String toString() {
            return RuleConditionEvaluationResult.class.getSimpleName() + "{matches=" + this.matches + ", matchedAssetStates=" + this.matchedAssetStates.size() + ", unmatchedAssetStates=" + this.unmatchedAssetStates.size() + ", matchedAssetIds=" + this.matchedAssetIds.size() + ", unmatchedAssetIds=" + this.unmatchedAssetIds.size() + "}";
        }
    }
}

