/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.core.RuleBuilder;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.rules.RulesBuilder;
import org.openremote.manager.rules.RulesFacts;
import org.openremote.manager.rules.flow.NodeExecutionRequestInfo;
import org.openremote.manager.rules.flow.NodeModel;
import org.openremote.manager.rules.flow.NodeTriggerFunction;
import org.openremote.manager.rules.flow.NodeTriggerParameters;
import org.openremote.model.rules.Assets;
import org.openremote.model.rules.HistoricDatapoints;
import org.openremote.model.rules.Notifications;
import org.openremote.model.rules.PredictedDatapoints;
import org.openremote.model.rules.Users;
import org.openremote.model.rules.flow.Node;
import org.openremote.model.rules.flow.NodeCollection;
import org.openremote.model.rules.flow.NodeSocket;
import org.openremote.model.rules.flow.NodeType;

public class FlowRulesBuilder {
    protected final Logger LOG;
    protected final AssetStorageService assetStorageService;
    protected final Map<String, Long> triggerMap = new HashMap<String, Long>();
    protected final List<NodeCollection> nodeCollections = new ArrayList<NodeCollection>();
    protected final Assets assetsFacade;
    protected final Users usersFacade;
    protected final Notifications notificationFacade;
    protected final HistoricDatapoints historicDatapointsFacade;
    protected final PredictedDatapoints predictedDatapointsFacade;
    protected final TimerService timerService;

    public FlowRulesBuilder(Logger logger, TimerService timerService, AssetStorageService assetStorageService, Assets assetsFacade, Users usersFacade, Notifications notificationFacade, HistoricDatapoints historicDatapointsFacade, PredictedDatapoints predictedDatapointsFacade) {
        this.timerService = timerService;
        this.assetStorageService = assetStorageService;
        this.assetsFacade = assetsFacade;
        this.usersFacade = usersFacade;
        this.notificationFacade = notificationFacade;
        this.historicDatapointsFacade = historicDatapointsFacade;
        this.predictedDatapointsFacade = predictedDatapointsFacade;
        this.LOG = logger;
    }

    public void add(NodeCollection nodeCollection) {
        this.nodeCollections.add(nodeCollection);
    }

    public Rule[] build() {
        int count = 0;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (NodeCollection collection : this.nodeCollections) {
            for (Node node : collection.getNodes()) {
                if (node.getType() != NodeType.OUTPUT) continue;
                try {
                    this.LOG.fine("Flow rule created");
                    rules.add(this.createRule(collection.getName() + " - " + count, collection, node));
                    ++count;
                }
                catch (Exception e) {
                    this.LOG.severe("Flow rule error: " + e.getMessage());
                }
            }
        }
        return rules.toArray(new Rule[0]);
    }

    private Rule createRule(String name, NodeCollection collection, Node outputNode) throws Exception {
        Object implementationResult = NodeModel.getImplementationFor(outputNode.getName()).execute(new NodeExecutionRequestInfo(collection, outputNode, null, null, this.assetsFacade, this.usersFacade, this.notificationFacade, this.historicDatapointsFacade, this.predictedDatapointsFacade, this.LOG));
        if (!(implementationResult instanceof RulesBuilder.Action)) {
            throw new Exception(outputNode.getName() + " node does not return an action");
        }
        RulesBuilder.Action action = (RulesBuilder.Action)implementationResult;
        RulesBuilder.Condition condition = facts -> {
            List<Node> connectedTree = this.backtrackFrom(collection, outputNode);
            return connectedTree.stream().anyMatch(node -> {
                NodeTriggerFunction function = NodeModel.getTriggerFunctionFor(node.getName());
                return function.satisfies(new NodeTriggerParameters(name, facts, this, collection, (Node)node));
            });
        };
        this.triggerMap.put(name, -1L);
        return new RuleBuilder().name(name).description(collection.getDescription()).when(facts -> {
            Object result = condition.evaluate((RulesFacts)facts);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            String msg = "Error evaluating condition of rule, expected boolean but got " + String.valueOf(result != null ? result.getClass() : "null");
            this.LOG.warning(msg);
            throw new IllegalArgumentException(msg);
        }).then(facts -> {
            action.execute((RulesFacts)facts);
            this.triggerMap.put(name, this.timerService.getCurrentTimeMillis());
        }).build();
    }

    private List<Node> backtrackFrom(NodeCollection collection, Node node) {
        ArrayList<Node> total = new ArrayList<Node>();
        ArrayList<Node> children = new ArrayList<Node>();
        for (NodeSocket s : node.getInputs()) {
            children.addAll(Arrays.stream(collection.getConnections()).filter(c -> c.getTo().equals(s.getId())).map(c -> collection.getNodeById(collection.getSocketById(c.getFrom()).getNodeId())).toList());
        }
        for (Node child : children) {
            total.add(child);
            total.addAll(this.backtrackFrom(collection, child));
        }
        return total;
    }

    public Map<String, Long> getTriggerMap() {
        return this.triggerMap;
    }
}

