/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.rules;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.attribute.MetaMap;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.LogicGroup;
import org.openremote.model.query.filter.AttributePredicate;
import org.openremote.model.query.filter.NameValuePredicate;
import org.openremote.model.query.filter.ParentPredicate;
import org.openremote.model.query.filter.PathPredicate;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.util.TimeUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.NameValueHolder;

public class AssetQueryPredicate
implements Predicate<AttributeInfo> {
    protected final AssetQuery query;
    protected final TimerService timerService;
    protected final AssetStorageService assetStorageService;
    protected final List<String> resolvedAssetTypes;

    public AssetQueryPredicate(TimerService timerService, AssetStorageService assetStorageService, AssetQuery query) {
        this.timerService = timerService;
        this.assetStorageService = assetStorageService;
        this.query = query;
        this.resolvedAssetTypes = query.types != null && query.types.length > 0 ? Arrays.asList(AssetQuery.getResolvedAssetTypes((String[])query.types)) : null;
    }

    @Override
    public boolean test(AttributeInfo assetState) {
        if (this.query.ids != null && this.query.ids.length > 0 && Arrays.stream(this.query.ids).noneMatch(id -> assetState.getId().equals(id))) {
            return false;
        }
        if (this.query.names != null && this.query.names.length > 0 && Arrays.stream(this.query.names).map(stringPredicate -> stringPredicate.asPredicate(() -> ((TimerService)this.timerService).getCurrentTimeMillis())).noneMatch(np -> np.test(assetState.getAssetName()))) {
            return false;
        }
        if (this.query.parents != null && this.query.parents.length > 0 && Arrays.stream(this.query.parents).map(AssetQueryPredicate::asPredicate).noneMatch(np -> np.test(assetState))) {
            return false;
        }
        if (this.resolvedAssetTypes != null && !this.resolvedAssetTypes.contains(assetState.getAssetType())) {
            return false;
        }
        if (this.query.paths != null && this.query.paths.length > 0 && Arrays.stream(this.query.paths).map(AssetQueryPredicate::asPredicate).noneMatch(np -> np.test(assetState.getPath()))) {
            return false;
        }
        if (this.query.realm != null && !AssetQueryPredicate.asPredicate(this.query.realm).test(assetState)) {
            return false;
        }
        if (this.query.attributes != null) {
            Set<AttributeInfo> matches = AssetQueryPredicate.asAttributeMatcher(() -> ((TimerService)this.timerService).getCurrentTimeMillis(), (LogicGroup<AttributePredicate>)this.query.attributes).apply(Collections.singleton(assetState));
            if (matches == null) {
                return false;
            }
        }
        if (this.query.userIds != null && this.query.userIds.length > 0) {
            return this.assetStorageService.isUserAsset(Arrays.asList(this.query.userIds), assetState.getId());
        }
        return true;
    }

    public static Predicate<AttributeInfo> asPredicate(ParentPredicate predicate) {
        return assetState -> Objects.equals(predicate.id, assetState.getParentId());
    }

    public static Predicate<String[]> asPredicate(PathPredicate predicate) {
        return givenPath -> Arrays.equals(predicate.path, givenPath);
    }

    public static Predicate<AttributeInfo> asPredicate(RealmPredicate predicate) {
        return assetState -> predicate == null || predicate.name != null && predicate.name.equals(assetState.getRealm());
    }

    public static Predicate<NameValueHolder<?>> asPredicate(Supplier<Long> currentMillisSupplier, NameValuePredicate predicate) {
        Predicate namePredicate = predicate.name != null ? predicate.name.asPredicate(currentMillisSupplier) : str -> true;
        Predicate<Object> valuePredicate = value -> {
            if (predicate.value == null) {
                return true;
            }
            return predicate.value.asPredicate(currentMillisSupplier).test(value);
        };
        AtomicReference<Function<NameValueHolder, Object>> valueExtractor = new AtomicReference<Function<NameValueHolder, Object>>(nameValueHolder -> nameValueHolder.getValue().orElse(null));
        if (predicate.path != null && predicate.path.getPaths().length > 0) {
            valueExtractor.set(nameValueHolder -> {
                if (!nameValueHolder.getValue().isPresent()) {
                    return null;
                }
                Object rawValue = nameValueHolder.getValue().get();
                if (!ValueUtil.isArray(rawValue.getClass()) && !ValueUtil.isObject(rawValue.getClass())) {
                    return null;
                }
                JsonNode jsonNode = (JsonNode)ValueUtil.convert((Object)nameValueHolder.getValue(), JsonNode.class);
                for (Object path : predicate.path.getPaths()) {
                    if (path == null) {
                        return null;
                    }
                    if (path instanceof Integer) {
                        jsonNode = jsonNode.get(((Integer)path).intValue());
                    } else if (path instanceof String) {
                        jsonNode = jsonNode.get((String)path);
                    }
                    if (jsonNode == null) break;
                }
                return jsonNode;
            });
        }
        return nameValueHolder -> namePredicate.test(nameValueHolder.getName()) && valuePredicate.test(((Function)valueExtractor.get()).apply(nameValueHolder));
    }

    public static Function<Collection<AttributeInfo>, Set<AttributeInfo>> asAttributeMatcher(Supplier<Long> currentMillisProducer, LogicGroup<AttributePredicate> condition) {
        if (AssetQueryPredicate.groupIsEmpty(condition)) {
            return as -> Collections.EMPTY_SET;
        }
        LogicGroup.Operator operator = condition.operator == null ? LogicGroup.Operator.AND : condition.operator;
        ArrayList<Function> assetStateMatchers = new ArrayList<Function>();
        ArrayList attributePredicates = new ArrayList();
        if (condition.getItems().size() > 0) {
            condition.getItems().stream().forEach(p -> {
                Predicate<AttributeInfo> wrappedPredicate = arg_0 -> AssetQueryPredicate.lambda$asAttributeMatcher$14(p, (Supplier)currentMillisProducer, arg_0);
                attributePredicates.add(wrappedPredicate);
                AtomicReference<Predicate<AttributeInfo>> metaPredicate = new AtomicReference<Predicate<AttributeInfo>>(nameValueHolder -> true);
                AtomicReference<Predicate<AttributeInfo>> oldValuePredicate = new AtomicReference<Predicate<AttributeInfo>>(value -> true);
                if (p.meta != null) {
                    Predicate innerMetaPredicate = Arrays.stream(p.meta).map(arg_0 -> AssetQueryPredicate.lambda$asAttributeMatcher$17((Supplier)currentMillisProducer, arg_0)).reduce(x -> true, Predicate::and);
                    metaPredicate.set(assetState -> {
                        MetaMap metaItems = assetState.getMeta();
                        return metaItems.stream().anyMatch(metaItem -> innerMetaPredicate.test(assetState));
                    });
                    attributePredicates.add(metaPredicate.get());
                }
                if (p.previousValue != null) {
                    Predicate innerOldValuePredicate = p.previousValue.asPredicate(currentMillisProducer);
                    oldValuePredicate.set(nameValueHolder -> innerOldValuePredicate.test(nameValueHolder.getOldValue()));
                    attributePredicates.add(oldValuePredicate.get());
                }
            });
        }
        if (operator == LogicGroup.Operator.AND) {
            assetStateMatchers.add(assetStates -> {
                HashSet matchedAssetStates = new HashSet();
                boolean allPredicatesMatch = attributePredicates.stream().allMatch(attributePredicate -> assetStates.stream().filter(attributePredicate).findFirst().map(matchedAssetState -> {
                    matchedAssetStates.add(matchedAssetState);
                    return true;
                }).orElse(false));
                return allPredicatesMatch ? matchedAssetStates : null;
            });
        } else {
            assetStateMatchers.add(assetStates -> {
                AtomicReference firstMatch = new AtomicReference();
                boolean anyPredicateMatch = attributePredicates.stream().anyMatch(attributePredicate -> assetStates.stream().filter(attributePredicate).findFirst().map(matchedAssetState -> {
                    firstMatch.set(matchedAssetState);
                    return true;
                }).orElse(false));
                return anyPredicateMatch ? Collections.singleton((AttributeInfo)firstMatch.get()) : null;
            });
        }
        if (condition.groups != null && condition.groups.size() > 0) {
            assetStateMatchers.addAll(condition.groups.stream().map(c -> AssetQueryPredicate.asAttributeMatcher(currentMillisProducer, (LogicGroup<AttributePredicate>)c)).toList());
        }
        return assetStates -> {
            HashSet matchedStates = new HashSet();
            for (Function matcher : assetStateMatchers) {
                Set matcherMatchedStates = (Set)matcher.apply(assetStates);
                if (matcherMatchedStates != null) {
                    if (operator == LogicGroup.Operator.OR) {
                        return matcherMatchedStates;
                    }
                    matchedStates.addAll(matcherMatchedStates);
                    continue;
                }
                if (operator != LogicGroup.Operator.AND) continue;
                return null;
            }
            return operator == LogicGroup.Operator.OR ? null : matchedStates;
        };
    }

    protected static boolean groupIsEmpty(LogicGroup<?> condition) {
        return condition.getItems().size() == 0 && (condition.groups == null || condition.groups.isEmpty());
    }

    private static /* synthetic */ Predicate lambda$asAttributeMatcher$17(Supplier currentMillisProducer, NameValuePredicate metaPred) {
        return AssetQueryPredicate.asPredicate(currentMillisProducer, metaPred);
    }

    private static /* synthetic */ boolean lambda$asAttributeMatcher$14(AttributePredicate p, Supplier currentMillisProducer, AttributeInfo attributeInfo) {
        if (p.timestampOlderThan != null) {
            long currentTime = (Long)currentMillisProducer.get();
            long durationMillis = TimeUtil.parseTimeDuration((String)p.timestampOlderThan);
            if (attributeInfo.getTimestamp() > currentTime - durationMillis) {
                return false;
            }
        }
        Predicate<NameValueHolder<?>> basePredicates = AssetQueryPredicate.asPredicate(currentMillisProducer, (NameValuePredicate)p);
        return basePredicates.test((NameValueHolder<?>)attributeInfo);
    }
}

