/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.provisioning;

import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.provisioning.ProvisioningResourceImpl;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.provisioning.ProvisioningConfig;
import org.openremote.model.util.ValueUtil;

public class ProvisioningService
extends RouteBuilder
implements ContainerService {
    protected static final Logger LOG = Logger.getLogger(ProvisioningService.class.getName());
    protected PersistenceService persistenceService;
    protected ManagerIdentityService identityService;
    protected List<ProvisioningConfig> provisioningConfigs;

    public int getPriority() {
        return 0;
    }

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-MonitorProvisioningConfigs").filter(PersistenceService.isPersistenceEventForEntityType(ProvisioningConfig.class)).process(exchange -> {
            ProvisioningService provisioningService = this;
            synchronized (provisioningService) {
                this.provisioningConfigs = null;
            }
        });
    }

    public void init(Container container) throws Exception {
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        TimerService timerService = (TimerService)container.getService(TimerService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new ProvisioningResourceImpl(this, timerService, this.identityService));
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public <T extends ProvisioningConfig<?, ?>> T merge(T provisioningConfig) {
        return (T)((ProvisioningConfig)this.persistenceService.doReturningTransaction(entityManager -> {
            Set validationFailures = ValueUtil.validate((Object)provisioningConfig, (Class[])new Class[0]);
            if (!validationFailures.isEmpty()) {
                String msg = "Provisioning config merge failed as failed constraint validation: config=" + String.valueOf(provisioningConfig);
                ConstraintViolationException ex = new ConstraintViolationException(validationFailures);
                LOG.log(Level.WARNING, msg + ", exception=" + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            ProvisioningConfig mergedConfig = (ProvisioningConfig)entityManager.merge((Object)provisioningConfig);
            if (provisioningConfig.getId() != null) {
                LOG.fine("Provisioning config updated: " + String.valueOf(provisioningConfig));
            } else {
                LOG.fine("Provisioning config created: " + String.valueOf(provisioningConfig));
            }
            return mergedConfig;
        }));
    }

    public void delete(Long id) {
        this.persistenceService.doTransaction(entityManager -> {
            ProvisioningConfig provisioningConfig = (ProvisioningConfig)entityManager.find(ProvisioningConfig.class, (Object)id);
            if (provisioningConfig != null) {
                entityManager.remove((Object)provisioningConfig);
            }
        });
    }

    public synchronized List<ProvisioningConfig> getProvisioningConfigs() {
        if (this.provisioningConfigs == null) {
            this.updateProvisioningConfigs();
        }
        return this.provisioningConfigs;
    }

    protected void updateProvisioningConfigs() {
        this.provisioningConfigs = (List)this.persistenceService.doReturningTransaction(entityManager -> entityManager.createQuery("select pc from " + ProvisioningConfig.class.getSimpleName() + " pc order by pc.name desc", ProvisioningConfig.class).getResultList());
    }
}

