/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.provisioning;

import jakarta.ws.rs.ForbiddenException;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.provisioning.ProvisioningService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.http.RequestParams;
import org.openremote.model.provisioning.ProvisioningConfig;
import org.openremote.model.provisioning.ProvisioningResource;

public class ProvisioningResourceImpl
extends ManagerWebResource
implements ProvisioningResource {
    protected final ProvisioningService provisioningService;
    protected final ManagerIdentityService identityService;

    public ProvisioningResourceImpl(ProvisioningService provisioningService, TimerService timerService, ManagerIdentityService identityService) {
        super(timerService, identityService);
        this.provisioningService = provisioningService;
        this.identityService = identityService;
    }

    public ProvisioningConfig<?, ?>[] getProvisioningConfigs() {
        if (!this.isSuperUser()) {
            throw new ForbiddenException("Only super admin can get provisioning configurations");
        }
        return this.provisioningService.getProvisioningConfigs().toArray(new ProvisioningConfig[0]);
    }

    public long createProvisioningConfig(ProvisioningConfig<?, ?> provisioningConfig) {
        if (!this.isSuperUser()) {
            throw new ForbiddenException("Only super admin can create provisioning configurations");
        }
        provisioningConfig = this.provisioningService.merge(provisioningConfig);
        return provisioningConfig.getId();
    }

    public void updateProvisioningConfig(RequestParams requestParams, Long id, ProvisioningConfig<?, ?> provisioningConfig) {
        if (!this.isSuperUser()) {
            throw new ForbiddenException("Only super admin can modify provisioning configurations");
        }
        this.provisioningService.merge(provisioningConfig);
    }

    public void deleteProvisioningConfig(RequestParams requestParams, Long id) {
        if (!this.isSuperUser()) {
            throw new ForbiddenException("Only super admin can delete provisioning configurations");
        }
        this.provisioningService.delete(id);
    }
}

