/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.notification;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.ApsAlert;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.WebpushConfig;
import com.google.firebase.messaging.WebpushNotification;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.notification.NotificationHandler;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.impl.ConsoleAsset;
import org.openremote.model.console.ConsoleProvider;
import org.openremote.model.notification.AbstractNotificationMessage;
import org.openremote.model.notification.Notification;
import org.openremote.model.notification.PushNotificationMessage;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.AttributePredicate;
import org.openremote.model.query.filter.NameValuePredicate;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.query.filter.ValueEmptyPredicate;
import org.openremote.model.query.filter.ValuePredicate;
import org.openremote.model.security.User;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.NameHolder;

public class PushNotificationHandler
extends RouteBuilder
implements NotificationHandler {
    private static final Logger LOG = Logger.getLogger(PushNotificationHandler.class.getName());
    public static final String OR_FIREBASE_CONFIG_FILE = "OR_FIREBASE_CONFIG_FILE";
    public static final int CONNECT_TIMEOUT_MILLIS = 3000;
    public static final int READ_TIMEOUT_MILLIS = 3000;
    public static final String FCM_PROVIDER_NAME = "fcm";
    protected ManagerIdentityService managerIdentityService;
    protected AssetStorageService assetStorageService;
    protected GatewayService gatewayService;
    protected boolean valid;
    protected Map<String, String> consoleFCMTokenMap = new ConcurrentHashMap<String, String>();
    protected Set<String> fcmTokenBlacklist = Collections.synchronizedSet(new HashSet());

    public int getPriority() {
        return 1000;
    }

    public void init(Container container) throws Exception {
        this.managerIdentityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
        String firebaseConfigFilePath = (String)container.getConfig().get(OR_FIREBASE_CONFIG_FILE);
        if (TextUtil.isNullOrEmpty((String)firebaseConfigFilePath)) {
            LOG.warning("OR_FIREBASE_CONFIG_FILE not defined, can not send FCM notifications");
            return;
        }
        if (!Files.isReadable(Paths.get(firebaseConfigFilePath, new String[0]))) {
            LOG.warning("OR_FIREBASE_CONFIG_FILE invalid path or file not readable: " + firebaseConfigFilePath);
            return;
        }
        try (InputStream is = Files.newInputStream(Paths.get(firebaseConfigFilePath, new String[0]), new OpenOption[0]);){
            FirebaseOptions options = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.fromStream((InputStream)is)).setConnectTimeout(3000).setReadTimeout(3000).build();
            FirebaseApp.initializeApp((FirebaseOptions)options);
            this.valid = true;
        }
        catch (Exception ex) {
            LOG.severe("Exception occurred whilst initialising FCM");
        }
    }

    public void start(Container container) throws Exception {
        if (!this.isValid()) {
            LOG.warning("FCM configuration invalid so cannot start");
            return;
        }
        this.consoleFCMTokenMap = new HashMap<String, String>();
        this.assetStorageService.findAll(new AssetQuery().select(new AssetQuery.Select().attributes(new String[]{ConsoleAsset.CONSOLE_PROVIDERS.getName()})).types(ConsoleAsset.class).attributes(new AttributePredicate[]{new AttributePredicate((NameHolder)ConsoleAsset.CONSOLE_PROVIDERS, (ValuePredicate)new ValueEmptyPredicate().negate(true), false, new NameValuePredicate.Path(new String[]{"push", "data", "token"}))})).stream().map(asset -> (ConsoleAsset)asset).filter(PushNotificationHandler::isLinkedToFcmProvider).forEach(asset -> this.consoleFCMTokenMap.put(asset.getId(), PushNotificationHandler.getFcmToken(asset).orElse(null)));
    }

    public void stop(Container container) throws Exception {
    }

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-PushNotificationConsoleAsset").filter(PersistenceService.isPersistenceEventForEntityType(ConsoleAsset.class)).filter(GatewayService.isNotForGateway(this.gatewayService)).process(exchange -> {
            PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
            ConsoleAsset asset = (ConsoleAsset)persistenceEvent.getEntity();
            this.processConsoleAssetChange(asset, (PersistenceEvent<ConsoleAsset>)persistenceEvent);
        });
    }

    @Override
    public String getTypeName() {
        return "push";
    }

    @Override
    public boolean isMessageValid(AbstractNotificationMessage message) {
        if (!(message instanceof PushNotificationMessage)) {
            LOG.warning("Invalid message: '" + message.getClass().getSimpleName() + "' is not an instance of PushNotificationMessage");
            return false;
        }
        PushNotificationMessage pushMessage = (PushNotificationMessage)message;
        if (TextUtil.isNullOrEmpty((String)pushMessage.getTitle()) && pushMessage.getData() == null) {
            LOG.warning("Invalid message: must either contain a title and/or data");
            return false;
        }
        return true;
    }

    @Override
    public List<Notification.Target> getTargets(Notification.Source source, String sourceId, List<Notification.Target> targets, AbstractNotificationMessage message) {
        PushNotificationMessage pushMessage = (PushNotificationMessage)message;
        ArrayList<Notification.Target> mappedTargets = new ArrayList<Notification.Target>();
        if (pushMessage.getTargetType() == PushNotificationMessage.TargetType.TOPIC || pushMessage.getTargetType() == PushNotificationMessage.TargetType.CONDITION) {
            mappedTargets.add(new Notification.Target(Notification.TargetType.CUSTOM, String.valueOf(pushMessage.getTargetType()) + ": " + pushMessage.getTarget()));
            return mappedTargets;
        }
        if (targets != null) {
            List<String> consoleAssets;
            String[] assetTargets = (String[])targets.stream().filter(target -> target.getType() == Notification.TargetType.ASSET).map(Notification.Target::getId).toArray(String[]::new);
            if (assetTargets.length > 0 && !(consoleAssets = this.assetStorageService.findAll(new AssetQuery().ids(assetTargets).select(new AssetQuery.Select().excludeAttributes()).types(ConsoleAsset.class)).stream().map(Asset::getId).toList()).isEmpty()) {
                targets = targets.stream().filter(target -> {
                    boolean isConsoleAsset = consoleAssets.contains(target.getId());
                    if (isConsoleAsset) {
                        mappedTargets.add(new Notification.Target(Notification.TargetType.ASSET, target.getId()));
                    }
                    return !isConsoleAsset;
                }).collect(Collectors.toList());
            }
            targets.forEach(target -> {
                Notification.TargetType targetType = target.getType();
                String targetId = target.getId();
                AssetQuery assetQuery = new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).types(ConsoleAsset.class).attributes(new AttributePredicate[]{new AttributePredicate((NameHolder)ConsoleAsset.CONSOLE_PROVIDERS, (ValuePredicate)new ValueEmptyPredicate().negate(true), false, new NameValuePredicate.Path(new String[]{"push", "data", "token"}))});
                switch (targetType) {
                    case REALM: {
                        assetQuery.realm(new RealmPredicate(targetId));
                        break;
                    }
                    case USER: {
                        assetQuery.userIds(new String[]{targetId});
                        break;
                    }
                    case ASSET: {
                        assetQuery.userIds((String[])this.assetStorageService.findUserAssetLinks(null, null, targetId).stream().map(ual -> ual.getId().getUserId()).collect(Collectors.toSet()).toArray(String[]::new));
                    }
                }
                List<String> consoleAssetIds = this.assetStorageService.findAll(assetQuery).stream().map(Asset::getId).distinct().toList();
                if (!consoleAssetIds.isEmpty()) {
                    if (targetType == Notification.TargetType.USER) {
                        if (Arrays.stream(this.managerIdentityService.getIdentityProvider().queryUsers(new UserQuery().ids(new String[]{targetId}).serviceUsers(Boolean.valueOf(false)).attributes(new UserQuery.AttributeValuePredicate[]{new UserQuery.AttributeValuePredicate(true, new StringPredicate("systemAccount")), new UserQuery.AttributeValuePredicate(true, new StringPredicate("pushNotificationsDisabled"), new StringPredicate("true"))}))).allMatch(User::isSystemAccount)) {
                            consoleAssetIds = Collections.emptyList();
                        }
                    } else {
                        consoleAssetIds = consoleAssetIds.stream().filter(consoleId -> {
                            long count = Arrays.stream(this.managerIdentityService.getIdentityProvider().queryUsers(new UserQuery().assets(new String[]{consoleId}).serviceUsers(Boolean.valueOf(false)).attributes(new UserQuery.AttributeValuePredicate[]{new UserQuery.AttributeValuePredicate(true, new StringPredicate("systemAccount")), new UserQuery.AttributeValuePredicate(false, new StringPredicate("pushNotificationsDisabled"), new StringPredicate("true"))}))).count();
                            return count == 0L;
                        }).collect(Collectors.toList());
                    }
                }
                if (consoleAssetIds.isEmpty()) {
                    LOG.fine("No console asset targets have been mapped");
                } else {
                    mappedTargets.addAll(consoleAssetIds.stream().filter(id -> mappedTargets.stream().noneMatch(t -> t.getId().equals(id))).map(id -> new Notification.Target(Notification.TargetType.ASSET, id)).toList());
                }
            });
        }
        return mappedTargets;
    }

    @Override
    public void sendMessage(long id, Notification.Source source, String sourceId, Notification.Target target, AbstractNotificationMessage message) throws Exception {
        Notification.TargetType targetType = target.getType();
        String targetId = target.getId();
        if (targetType != Notification.TargetType.ASSET && targetType != Notification.TargetType.CUSTOM) {
            String msg = "Target type not supported: " + String.valueOf(targetType);
            LOG.warning(msg);
            throw new Exception(msg);
        }
        String fcmToken = this.consoleFCMTokenMap.get(targetId);
        if (TextUtil.isNullOrEmpty((String)fcmToken)) {
            String msg = "No FCM token found for console: " + targetId;
            LOG.finer(msg);
            throw new Exception(msg);
        }
        PushNotificationMessage pushMessage = (PushNotificationMessage)message;
        if (pushMessage.getTargetType() == null) {
            pushMessage.setTargetType(PushNotificationMessage.TargetType.DEVICE);
        }
        switch (pushMessage.getTargetType()) {
            case DEVICE: {
                pushMessage.setTarget(fcmToken);
                break;
            }
            case TOPIC: {
                break;
            }
        }
        this.sendMessage(PushNotificationHandler.buildFCMMessage(id, pushMessage));
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void sendMessage(Message message) throws Exception {
        FirebaseMessaging.getInstance().send(message);
    }

    protected boolean isConsoleSubscribedToTopic(ConsoleAsset consoleAsset, String topic) {
        return consoleAsset.getConsoleProviders().flatMap(consoleProviders -> Optional.ofNullable((ConsoleProvider)consoleProviders.get((Object)"push")).map(ConsoleProvider::getData).map(data -> data.get("topics")).map(arrayValue -> {
            int length = Array.getLength(arrayValue);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(arrayValue, i);
                if (!(arrayElement instanceof String) || !arrayElement.equals(topic)) continue;
                return true;
            }
            return false;
        })).orElse(false);
    }

    protected static Message buildFCMMessage(long id, PushNotificationMessage pushMessage) {
        Message.Builder builder = Message.builder();
        boolean dataOnly = TextUtil.isNullOrEmpty((String)pushMessage.getTitle());
        switch (pushMessage.getTargetType()) {
            case DEVICE: {
                builder.setToken(pushMessage.getTarget());
                break;
            }
            case TOPIC: {
                builder.setTopic(pushMessage.getTarget());
                break;
            }
            case CONDITION: {
                builder.setCondition(pushMessage.getTarget());
            }
        }
        AndroidConfig.Builder androidConfigBuilder = AndroidConfig.builder();
        ApnsConfig.Builder apnsConfigBuilder = ApnsConfig.builder();
        Aps.Builder apsBuilder = Aps.builder();
        WebpushConfig.Builder webpushConfigBuilder = WebpushConfig.builder();
        if (!dataOnly) {
            if (pushMessage.getData() != null || pushMessage.getAction() != null || pushMessage.getButtons() != null) {
                androidConfigBuilder.putData("or-title", pushMessage.getTitle());
                if (pushMessage.getBody() != null) {
                    androidConfigBuilder.putData("or-body", pushMessage.getBody());
                }
            }
            apsBuilder.setAlert(ApsAlert.builder().setTitle(pushMessage.getTitle()).setBody(pushMessage.getBody()).build()).setSound("default").setCategory("openremoteNotification");
            webpushConfigBuilder.setNotification(new WebpushNotification(pushMessage.getTitle(), pushMessage.getBody()));
        }
        if (pushMessage.getData() != null) {
            builder.putAllData((Map)ValueUtil.JSON.convertValue((Object)pushMessage.getData(), (TypeReference)new TypeReference<Map<String, String>>(){}));
            if (dataOnly) {
                apsBuilder.setContentAvailable(true);
            }
        }
        builder.putData("notification-id", Long.toString(id));
        try {
            if (pushMessage.getAction() != null) {
                builder.putData("action", ValueUtil.asJSONOrThrow((Object)pushMessage.getAction()));
            }
            if (pushMessage.getButtons() != null) {
                builder.putData("buttons", ValueUtil.asJSONOrThrow((Object)pushMessage.getButtons()));
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        androidConfigBuilder.setPriority(pushMessage.getPriority() == PushNotificationMessage.MessagePriority.HIGH ? AndroidConfig.Priority.HIGH : AndroidConfig.Priority.NORMAL);
        apnsConfigBuilder.putHeader("apns-priority", !dataOnly ? "10" : "5");
        apsBuilder.setMutableContent(true);
        if (pushMessage.getTtlSeconds() != null) {
            long timeToLiveSeconds = Math.max(pushMessage.getTtlSeconds(), 0L);
            long timeToLiveMillis = timeToLiveSeconds * 1000L;
            Date expirationDate = new Date(new Date().getTime() + timeToLiveMillis);
            long epochSeconds = Math.round((float)expirationDate.getTime() / 1000.0f);
            apnsConfigBuilder.putHeader("apns-expiration", Long.toString(epochSeconds));
            androidConfigBuilder.setTtl(timeToLiveMillis);
            webpushConfigBuilder.putHeader("TTL", Long.toString(timeToLiveSeconds));
        }
        apnsConfigBuilder.setAps(apsBuilder.build());
        builder.setAndroidConfig(androidConfigBuilder.build());
        builder.setApnsConfig(apnsConfigBuilder.build());
        builder.setWebpushConfig(webpushConfigBuilder.build());
        return builder.build();
    }

    protected static boolean isLinkedToFcmProvider(ConsoleAsset asset) {
        return asset.getConsoleProviders().flatMap(consoleProviders -> Optional.ofNullable((ConsoleProvider)consoleProviders.get((Object)"push")).map(ConsoleProvider::getVersion).map(FCM_PROVIDER_NAME::equals)).orElse(false);
    }

    protected static Optional<String> getFcmToken(ConsoleAsset asset) {
        return asset.getConsoleProviders().flatMap(consoleProviders -> Optional.ofNullable((ConsoleProvider)consoleProviders.get((Object)"push")).map(ConsoleProvider::getData).map(data -> {
            Object token = data.get("token");
            return token instanceof String ? (String)token : null;
        }));
    }

    protected void processConsoleAssetChange(ConsoleAsset asset, PersistenceEvent<ConsoleAsset> persistenceEvent) {
        String fcmToken = this.consoleFCMTokenMap.remove(asset.getId());
        if (!TextUtil.isNullOrEmpty((String)fcmToken)) {
            this.fcmTokenBlacklist.remove(fcmToken);
        }
        switch (persistenceEvent.getCause()) {
            case CREATE: 
            case UPDATE: {
                PushNotificationHandler.getFcmToken(asset).ifPresent(token -> this.consoleFCMTokenMap.put(asset.getId(), (String)token));
            }
        }
    }
}

