/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.notification;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.web.WebResource;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.notification.NotificationService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.asset.Asset;
import org.openremote.model.http.RequestParams;
import org.openremote.model.notification.Notification;
import org.openremote.model.notification.NotificationResource;
import org.openremote.model.notification.SentNotification;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.util.ValueUtil;

public class NotificationResourceImpl
extends WebResource
implements NotificationResource {
    private static final Logger LOG = Logger.getLogger(NotificationResourceImpl.class.getName());
    protected final NotificationService notificationService;
    protected final MessageBrokerService messageBrokerService;
    protected final AssetStorageService assetStorageService;
    protected final ManagerIdentityService managerIdentityService;

    public NotificationResourceImpl(NotificationService notificationService, MessageBrokerService messageBrokerService, AssetStorageService assetStorageService, ManagerIdentityService managerIdentityService) {
        this.notificationService = notificationService;
        this.messageBrokerService = messageBrokerService;
        this.assetStorageService = assetStorageService;
        this.managerIdentityService = managerIdentityService;
    }

    public SentNotification[] getNotifications(RequestParams requestParams, Long id, String type, Long fromTimestamp, Long toTimestamp, String realmId, String userId, String assetId) {
        try {
            return this.notificationService.getNotifications(id != null ? Collections.singletonList(id) : null, type != null ? Collections.singletonList(type) : null, fromTimestamp, toTimestamp, realmId != null ? Collections.singletonList(realmId) : null, userId != null ? Collections.singletonList(userId) : null, assetId != null ? Collections.singletonList(assetId) : null).toArray(new SentNotification[0]);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException("Invalid criteria set", Response.Status.BAD_REQUEST);
        }
    }

    public void removeNotifications(RequestParams requestParams, Long id, String type, Long fromTimestamp, Long toTimestamp, String realmId, String userId, String assetId) {
        try {
            this.notificationService.removeNotifications(id != null ? Collections.singletonList(id) : null, type != null ? Collections.singletonList(type) : null, fromTimestamp, toTimestamp, realmId != null ? Collections.singletonList(realmId) : null, userId != null ? Collections.singletonList(userId) : null, assetId != null ? Collections.singletonList(assetId) : null);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException("Invalid criteria set", Response.Status.BAD_REQUEST);
        }
    }

    public void removeNotification(RequestParams requestParams, Long notificationId) {
        if (notificationId == null) {
            throw new WebApplicationException("Missing notification ID", Response.Status.BAD_REQUEST);
        }
        this.notificationService.removeNotification(notificationId);
    }

    public void sendNotification(RequestParams requestParams, Notification notification) {
        boolean success;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(Notification.HEADER_SOURCE, Notification.Source.CLIENT);
        if (this.isAuthenticated()) {
            headers.put("AUTH_CONTEXT", this.getAuthContext());
        }
        if (!(success = ((Boolean)this.messageBrokerService.getFluentProducerTemplate().withBody((Object)notification).withHeaders(headers).to("direct://NotificationQueue").request(Boolean.class)).booleanValue())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public void notificationDelivered(RequestParams requestParams, String targetId, Long notificationId) {
        if (notificationId == null) {
            throw new WebApplicationException("Missing notification ID", Response.Status.BAD_REQUEST);
        }
        SentNotification sentNotification = this.notificationService.getSentNotification(notificationId);
        this.verifyAccess(sentNotification, targetId);
        this.notificationService.setNotificationDelivered(notificationId);
    }

    public void notificationAcknowledged(RequestParams requestParams, String targetId, Long notificationId, JsonNode acknowledgement) {
        if (notificationId == null) {
            throw new WebApplicationException("Missing notification ID", Response.Status.BAD_REQUEST);
        }
        SentNotification sentNotification = this.notificationService.getSentNotification(notificationId);
        this.verifyAccess(sentNotification, targetId);
        this.notificationService.setNotificationAcknowledged(notificationId, acknowledgement == null ? null : (String)ValueUtil.asJSON((Object)acknowledgement).orElse(null));
    }

    protected void verifyAccess(SentNotification sentNotification, String targetId) {
        if (sentNotification == null) {
            LOG.fine("DENIED: Notification not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (sentNotification.getTargetId() == null || !sentNotification.getTargetId().equals(targetId)) {
            LOG.fine("DENIED: Notification target ID doesn't match supplied target ID");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (this.isSuperUser()) {
            LOG.finest("ALLOWED: Request from super user so allowing");
            return;
        }
        if (!this.isAuthenticated()) {
            if (sentNotification.getTarget() != Notification.TargetType.ASSET) {
                LOG.fine("DENIED: Anonymous request to update a notification not sent to a public asset");
                throw new WebApplicationException("Anonymous request can only update public assets", Response.Status.FORBIDDEN);
            }
            Asset<?> asset = this.assetStorageService.find(sentNotification.getTargetId(), false, AssetQuery.Access.PUBLIC);
            if (asset == null) {
                LOG.fine("DENIED: Anonymous request to update a notification sent to an asset that doesn't exist or isn't public");
                throw new WebApplicationException("Anonymous request can only update public assets not linked to a user", Response.Status.FORBIDDEN);
            }
        } else {
            boolean isRestrictedUser = this.managerIdentityService.getIdentityProvider().isRestrictedUser(this.getAuthContext());
            switch (sentNotification.getTarget()) {
                case REALM: {
                    if (!isRestrictedUser) break;
                    LOG.fine("DENIED: Restricted user request to update a notification sent to a realm");
                    throw new WebApplicationException("Restricted users cannot update a realm notification", Response.Status.FORBIDDEN);
                }
                case USER: {
                    if (sentNotification.getTargetId().equals(this.getUserId())) break;
                    LOG.fine("DENIED: User request to update a notification sent to a different user");
                    throw new WebApplicationException("Regular and restricted users can only update user notifications sent to themselves", Response.Status.FORBIDDEN);
                }
                case ASSET: {
                    Asset<?> asset = this.assetStorageService.find(sentNotification.getTargetId(), false);
                    if (asset == null) {
                        LOG.fine("DENIED: User request to update a notification sent to an asset that doesn't exist");
                        throw new WebApplicationException("Asset not found", Response.Status.NOT_FOUND);
                    }
                    if (!asset.getRealm().equals(this.getAuthenticatedRealmName())) {
                        LOG.fine("DENIED: User request to update a notification sent to an asset that is in another realm");
                        throw new WebApplicationException("Asset not in users realm", Response.Status.FORBIDDEN);
                    }
                    if (!isRestrictedUser || this.assetStorageService.isUserAsset(this.getUserId(), asset.getId())) break;
                    LOG.fine("DENIED: Restricted user request to update a notification sent to an asset that isn't linked to themselves");
                    throw new WebApplicationException("Asset not linked to restricted user", Response.Status.FORBIDDEN);
                }
            }
        }
    }
}

