/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.notification.NotificationHandler;
import org.openremote.manager.notification.NotificationProcessingException;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.notification.AbstractNotificationMessage;
import org.openremote.model.notification.LocalizedNotificationMessage;
import org.openremote.model.notification.Notification;
import org.openremote.model.security.User;
import org.openremote.model.util.TextUtil;

public class LocalizedNotificationHandler
extends RouteBuilder
implements NotificationHandler {
    private static final Logger LOG = Logger.getLogger(LocalizedNotificationHandler.class.getName());
    private ManagerIdentityService identityService;
    private AssetStorageService assetStorageService;
    protected Map<String, NotificationHandler> notificationHandlerMap = new HashMap<String, NotificationHandler>();
    protected boolean valid;

    public void init(Container container) throws Exception {
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        container.getServices(NotificationHandler.class).forEach(notificationHandler -> {
            if (!notificationHandler.getTypeName().equals(this.getTypeName())) {
                this.notificationHandlerMap.put(notificationHandler.getTypeName(), (NotificationHandler)notificationHandler);
            }
        });
        this.valid = true;
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public void configure() throws Exception {
    }

    @Override
    public String getTypeName() {
        return "localized";
    }

    @Override
    public boolean isMessageValid(AbstractNotificationMessage message) {
        if (!(message instanceof LocalizedNotificationMessage)) {
            LOG.warning("Invalid message: '" + message.getClass().getSimpleName() + "' is not an instance of LocalizedNotificationMessage");
            return false;
        }
        LocalizedNotificationMessage localizedMessage = (LocalizedNotificationMessage)message;
        if (localizedMessage.getMessages().isEmpty()) {
            LOG.warning("Invalid message: must either contain at least one localized message.");
            return false;
        }
        return localizedMessage.getMessages().values().stream().allMatch(msg -> {
            if (this.notificationHandlerMap.containsKey(msg.getType())) {
                return this.notificationHandlerMap.get(msg.getType()).isMessageValid((AbstractNotificationMessage)msg);
            }
            return false;
        });
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public List<Notification.Target> getTargets(Notification.Source source, String sourceId, List<Notification.Target> requestedTargets, AbstractNotificationMessage message) {
        LocalizedNotificationMessage localizedMessage = (LocalizedNotificationMessage)message;
        try {
            Map<String, List> targetsMap = localizedMessage.getMessages().entrySet().stream().map(entry -> {
                if (!this.notificationHandlerMap.containsKey(((AbstractNotificationMessage)entry.getValue()).getType())) {
                    return Map.entry((String)entry.getKey(), Collections.emptyList());
                }
                return Map.entry((String)entry.getKey(), this.notificationHandlerMap.get(((AbstractNotificationMessage)entry.getValue()).getType()).getTargets(source, sourceId, requestedTargets, (AbstractNotificationMessage)entry.getValue()));
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap mergedTargetsMap = new HashMap();
            targetsMap.forEach((language, targets) -> {
                for (Notification.Target target : targets) {
                    mergedTargetsMap.computeIfAbsent(target.getId(), k -> target).addAllowedLocales(new HashSet<String>(Collections.singletonList(language)));
                }
            });
            return new ArrayList<Notification.Target>(mergedTargetsMap.values());
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public void sendMessage(long id, Notification.Source source, String sourceId, Notification.Target target, AbstractNotificationMessage message) throws Exception {
        if (!(message instanceof LocalizedNotificationMessage)) {
            throw new NotificationProcessingException(NotificationProcessingException.Reason.SEND_FAILURE, "Invalid message: '" + message.getClass().getSimpleName() + "' is not an instance of LocalizedNotificationMessage");
        }
        LocalizedNotificationMessage localizedMessage = (LocalizedNotificationMessage)message;
        if (target.getAllowedLocales() == null || target.getAllowedLocales().isEmpty()) {
            throw new NotificationProcessingException(NotificationProcessingException.Reason.SEND_FAILURE, "No localized message could not be sent to target " + target.getId());
        }
        String targetLocale = target.getLocale();
        if (TextUtil.isNullOrEmpty((String)targetLocale)) {
            List<UserAssetLink> links;
            User user = null;
            if (target.getType().equals((Object)Notification.TargetType.USER)) {
                user = this.identityService.getIdentityProvider().getUser(target.getId());
            } else if (target.getType().equals((Object)Notification.TargetType.ASSET) && !(links = this.assetStorageService.findUserAssetLinks(null, null, target.getId())).isEmpty()) {
                user = this.identityService.getIdentityProvider().getUser(links.get(0).getId().getUserId());
            }
            if (user != null && user.getAttributeMap() != null && user.getAttributeMap().containsKey("locale")) {
                targetLocale = (String)((List)user.getAttributeMap().get("locale")).get(0);
            }
        }
        if (TextUtil.isNullOrEmpty((String)targetLocale) || !localizedMessage.getMessages().containsKey(targetLocale)) {
            targetLocale = localizedMessage.getDefaultLanguage();
        }
        if (!target.getAllowedLocales().contains(targetLocale)) {
            throw new NotificationProcessingException(NotificationProcessingException.Reason.SEND_FAILURE, "The localized message could not be sent to target '" + target.getId() + "' (" + targetLocale + "), because only " + String.valueOf(target.getAllowedLocales()) + " were allowed.");
        }
        AbstractNotificationMessage targetMsg = localizedMessage.getMessage(targetLocale);
        if (targetMsg == null) {
            throw new NotificationProcessingException(NotificationProcessingException.Reason.SEND_FAILURE, "Could not get message for the '" + targetLocale + "' language of target " + target.getId());
        }
        if (!this.notificationHandlerMap.containsKey(targetMsg.getType())) {
            throw new NotificationProcessingException(NotificationProcessingException.Reason.SEND_FAILURE, "Could not find the handler of type '" + targetMsg.getType() + "' for the message of target " + target.getId());
        }
        this.notificationHandlerMap.get(targetMsg.getType()).sendMessage(id, source, sourceId, target, targetMsg);
    }
}

