/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.notification;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openremote.agent.protocol.mail.MailClientBuilder;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.notification.NotificationHandler;
import org.openremote.manager.notification.NotificationProcessingException;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.asset.Asset;
import org.openremote.model.auth.OAuthClientCredentialsGrant;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.auth.UsernamePassword;
import org.openremote.model.notification.AbstractNotificationMessage;
import org.openremote.model.notification.EmailNotificationMessage;
import org.openremote.model.notification.Notification;
import org.openremote.model.query.UserQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.util.TextUtil;

public class EmailNotificationHandler
implements NotificationHandler {
    private static final Logger LOG = Logger.getLogger(EmailNotificationHandler.class.getName());
    protected String defaultFrom;
    protected Session mailSession;
    protected Transport mailTransport;
    protected Map<String, String> headers;
    protected ManagerIdentityService managerIdentityService;
    protected AssetStorageService assetStorageService;

    public int getPriority() {
        return 1000;
    }

    public void init(Container container) throws Exception {
        this.managerIdentityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        String host = container.getConfig().getOrDefault("OR_EMAIL_HOST", null);
        int port = MapAccess.getInteger((Map)container.getConfig(), (String)"OR_EMAIL_PORT", (int)587);
        String user = container.getConfig().getOrDefault("OR_EMAIL_USER", null);
        String password = container.getConfig().getOrDefault("OR_EMAIL_PASSWORD", null);
        String clientId = container.getConfig().getOrDefault("OR_EMAIL_OAUTH2_CLIENT_ID", null);
        String clientSecret = container.getConfig().getOrDefault("OR_EMAIL_OAUTH2_CLIENT_SECRET", null);
        boolean useOAuth = !TextUtil.isNullOrEmpty((String)clientId) && !TextUtil.isNullOrEmpty((String)clientSecret);
        String headersStr = container.getConfig().getOrDefault("OR_EMAIL_X_HEADERS", null);
        if (!TextUtil.isNullOrEmpty((String)headersStr)) {
            this.headers = Arrays.stream(headersStr.split("\\R")).map(s -> s.split(":", 2)).collect(Collectors.toMap(arr -> arr[0].trim(), arr -> ((String[])arr).length == 2 ? arr[1].trim() : ""));
        }
        this.defaultFrom = container.getConfig().getOrDefault("OR_EMAIL_FROM", "no-reply@localhost");
        if (!TextUtil.isNullOrEmpty((String)host) && (useOAuth || !TextUtil.isNullOrEmpty((String)user) && !TextUtil.isNullOrEmpty((String)password))) {
            boolean valid;
            boolean startTls = MapAccess.getBoolean((Map)container.getConfig(), (String)"OR_EMAIL_TLS", (boolean)true);
            String protocol = startTls ? "smtp" : MapAccess.getString((Map)container.getConfig(), (String)"OR_EMAIL_PROTOCOL", (String)"smtp");
            MailClientBuilder mailClientBuilder = new MailClientBuilder(container.getExecutor(), container.getScheduledExecutor(), protocol, host, port);
            if (useOAuth) {
                String oAuthUrl = container.getConfig().getOrDefault("OR_EMAIL_OAUTH2_URL", null);
                String oAuthScopes = container.getConfig().getOrDefault("OR_EMAIL_OAUTH2_SCOPES", "");
                if (TextUtil.isNullOrEmpty((String)clientId) || TextUtil.isNullOrEmpty((String)clientSecret)) {
                    LOG.info("Tried to configure oAuth2, but no client id and/or client secret is present. Falling back to basic auth.");
                    mailClientBuilder.setBasicAuth(user, password);
                } else if (TextUtil.isNullOrEmpty((String)oAuthUrl)) {
                    LOG.info("oAuth2 is enabled, but no oAuth2 token URL is configured. Falling back to basic auth.");
                    mailClientBuilder.setBasicAuth(user, password);
                } else {
                    mailClientBuilder.setOAuth(user, (OAuthGrant)new OAuthClientCredentialsGrant(oAuthUrl, clientId, clientSecret, oAuthScopes));
                }
            } else {
                mailClientBuilder.setBasicAuth(user, password);
            }
            if (startTls) {
                mailClientBuilder.setStartTls(true);
            }
            this.mailSession = Session.getInstance((Properties)mailClientBuilder.getProperties());
            if (container.isDevMode()) {
                this.mailSession.setDebug(true);
            }
            try {
                this.mailTransport = this.mailSession.getTransport(protocol);
                UsernamePassword usernamePassword = mailClientBuilder.getAuth();
                this.mailTransport.connect(usernamePassword.getUsername(), usernamePassword.getPassword());
                valid = this.mailTransport.isConnected();
                try {
                    this.mailTransport.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                valid = false;
                LOG.log(Level.SEVERE, "Failed to connect to SMTP server so disabling email notifications", e);
            }
            if (!valid) {
                this.mailTransport = null;
                this.mailSession = null;
                LOG.log(Level.INFO, "SMTP credentials are not valid so email notifications will not function");
            }
        }
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
        if (this.mailTransport != null) {
            try {
                this.mailTransport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mailSession = null;
    }

    @Override
    public boolean isValid() {
        return this.mailTransport != null;
    }

    @Override
    public String getTypeName() {
        return "email";
    }

    @Override
    public boolean isMessageValid(AbstractNotificationMessage message) {
        return message instanceof EmailNotificationMessage;
    }

    @Override
    public List<Notification.Target> getTargets(Notification.Source source, String sourceId, List<Notification.Target> targets, AbstractNotificationMessage message) {
        ArrayList<Notification.Target> mappedTargets = new ArrayList<Notification.Target>();
        if (targets != null) {
            targets.forEach(target -> {
                Notification.TargetType targetType = target.getType();
                String targetId = target.getId();
                UserQuery userQuery = null;
                switch (targetType) {
                    case REALM: {
                        userQuery = new UserQuery().realm(new RealmPredicate(targetId));
                        break;
                    }
                    case USER: {
                        userQuery = new UserQuery().ids(new String[]{targetId});
                        break;
                    }
                    case CUSTOM: {
                        mappedTargets.add(new Notification.Target(targetType, targetId));
                        break;
                    }
                    case ASSET: {
                        Asset<?> asset = this.assetStorageService.find(targetId);
                        if (asset != null) {
                            asset.getEmail().map(email -> {
                                Notification.Target assetTarget = new Notification.Target(Notification.TargetType.ASSET, asset.getId());
                                assetTarget.setData((Object)new EmailNotificationMessage.Recipient(asset.getName(), email));
                                return assetTarget;
                            }).ifPresent(mappedTargets::add);
                        }
                        userQuery = new UserQuery().assets(new String[]{targetId});
                    }
                }
                if (userQuery != null) {
                    userQuery.serviceUsers(Boolean.valueOf(false)).attributes(new UserQuery.AttributeValuePredicate[]{new UserQuery.AttributeValuePredicate(true, new StringPredicate("systemAccount")), new UserQuery.AttributeValuePredicate(true, new StringPredicate("emailNotificationsDisabled"), new StringPredicate("true"))});
                    List<Notification.Target> userTargets = Arrays.stream(this.managerIdentityService.getIdentityProvider().queryUsers(userQuery)).filter(user -> !user.isSystemAccount() && !TextUtil.isNullOrEmpty((String)user.getEmail())).map(user -> {
                        Notification.Target emailTarget = new Notification.Target(Notification.TargetType.USER, user.getId());
                        emailTarget.setData((Object)new EmailNotificationMessage.Recipient(user.getFullName(), user.getEmail()));
                        return emailTarget;
                    }).toList();
                    if (userTargets.isEmpty()) {
                        LOG.fine("No email targets have been mapped");
                    } else {
                        mappedTargets.addAll(userTargets.stream().filter(userTarget -> mappedTargets.stream().noneMatch(t -> t.getId().equals(userTarget.getId()))).toList());
                    }
                }
            });
        }
        EmailNotificationMessage email = (EmailNotificationMessage)message;
        ArrayList<String> addresses = new ArrayList<String>();
        if (email.getTo() != null) {
            addresses.addAll(email.getTo().stream().map(EmailNotificationMessage.Recipient::getAddress).map(address -> "to:" + address).toList());
            email.setTo((List)null);
        }
        if (email.getCc() != null) {
            addresses.addAll(email.getCc().stream().map(EmailNotificationMessage.Recipient::getAddress).map(address -> "cc:" + address).toList());
            email.setCc((List)null);
        }
        if (email.getBcc() != null) {
            addresses.addAll(email.getBcc().stream().map(EmailNotificationMessage.Recipient::getAddress).map(address -> "bcc:" + address).toList());
            email.setBcc((List)null);
        }
        if (!addresses.isEmpty()) {
            mappedTargets.add(new Notification.Target(Notification.TargetType.CUSTOM, String.join((CharSequence)";", addresses)));
        }
        return mappedTargets;
    }

    @Override
    public void sendMessage(long id, Notification.Source source, String sourceId, Notification.Target target, AbstractNotificationMessage message) throws Exception {
        ArrayList<EmailNotificationMessage.Recipient> toRecipients = new ArrayList<EmailNotificationMessage.Recipient>();
        ArrayList ccRecipients = new ArrayList();
        ArrayList bccRecipients = new ArrayList();
        Notification.TargetType targetType = target.getType();
        String targetId = target.getId();
        switch (targetType) {
            case USER: 
            case ASSET: {
                EmailNotificationMessage.Recipient recipient = (EmailNotificationMessage.Recipient)target.getData();
                if (recipient == null) {
                    LOG.warning("User or asset recipient missing: id=" + targetId);
                    break;
                }
                LOG.finest("Adding to recipient: " + String.valueOf(recipient));
                toRecipients.add(recipient);
                break;
            }
            case CUSTOM: {
                Arrays.stream(targetId.split(";")).forEach(customRecipient -> {
                    if (customRecipient.startsWith("to:")) {
                        String email = customRecipient.substring(3);
                        LOG.finest("Adding to recipient: " + email);
                        toRecipients.add(new EmailNotificationMessage.Recipient(email));
                    } else if (customRecipient.startsWith("cc:")) {
                        String email = customRecipient.substring(3);
                        LOG.finest("Adding cc recipient: " + email);
                        ccRecipients.add(new EmailNotificationMessage.Recipient(email));
                    } else if (customRecipient.startsWith("bcc:")) {
                        String email = customRecipient.substring(4);
                        LOG.finest("Adding bcc recipient: " + email);
                        bccRecipients.add(new EmailNotificationMessage.Recipient(email));
                    } else {
                        LOG.finest("Adding to recipient: " + customRecipient);
                        toRecipients.add(new EmailNotificationMessage.Recipient(customRecipient));
                    }
                });
                break;
            }
            default: {
                LOG.warning("Target type not supported: " + String.valueOf(targetType));
            }
        }
        MimeMessage email = new MimeMessage(this.mailSession);
        if (!toRecipients.isEmpty()) {
            for (EmailNotificationMessage.Recipient recipient : toRecipients) {
                if (TextUtil.isNullOrEmpty((String)recipient.getAddress())) continue;
                email.addRecipient(Message.RecipientType.TO, (Address)this.convertRecipient(recipient));
            }
        }
        if (!ccRecipients.isEmpty()) {
            for (EmailNotificationMessage.Recipient recipient : ccRecipients) {
                if (TextUtil.isNullOrEmpty((String)recipient.getAddress())) continue;
                email.addRecipient(Message.RecipientType.CC, (Address)this.convertRecipient(recipient));
            }
        }
        if (!bccRecipients.isEmpty()) {
            for (EmailNotificationMessage.Recipient recipient : bccRecipients) {
                if (TextUtil.isNullOrEmpty((String)recipient.getAddress())) continue;
                email.addRecipient(Message.RecipientType.BCC, (Address)this.convertRecipient(recipient));
            }
        }
        this.buildEmail(id, (EmailNotificationMessage)message, email);
        Address[] recipients = email.getAllRecipients();
        if (recipients == null || recipients.length == 0) {
            throw new NotificationProcessingException(NotificationProcessingException.Reason.INVALID_MESSAGE, "No recipients set for " + targetType.name().toLowerCase() + ": " + targetId);
        }
        if (email.getFrom() == null || email.getFrom().length == 0) {
            email.setFrom((Address)new InternetAddress(this.defaultFrom));
        }
        this.sendMessage((Message)email);
    }

    protected void sendMessage(Message email) throws Exception {
        if (!this.mailTransport.isConnected()) {
            this.mailTransport.connect();
        }
        this.mailTransport.sendMessage(email, email.getAllRecipients());
    }

    protected void buildEmail(long id, EmailNotificationMessage emailNotificationMessage, MimeMessage email) throws Exception {
        if (emailNotificationMessage.getReplyTo() != null) {
            email.setReplyTo(new Address[]{this.convertRecipient(emailNotificationMessage.getReplyTo())});
        }
        if (emailNotificationMessage.getFrom() != null) {
            email.setFrom((Address)this.convertRecipient(emailNotificationMessage.getFrom()));
        }
        if (emailNotificationMessage.getSubject() != null) {
            email.setSubject(emailNotificationMessage.getSubject());
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                email.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (emailNotificationMessage.getTo() != null) {
            for (EmailNotificationMessage.Recipient recipient : emailNotificationMessage.getTo()) {
                if (TextUtil.isNullOrEmpty((String)recipient.getAddress())) continue;
                email.addRecipient(Message.RecipientType.TO, (Address)this.convertRecipient(recipient));
            }
        }
        if (emailNotificationMessage.getCc() != null) {
            for (EmailNotificationMessage.Recipient recipient : emailNotificationMessage.getCc()) {
                if (TextUtil.isNullOrEmpty((String)recipient.getAddress())) continue;
                email.addRecipient(Message.RecipientType.CC, (Address)this.convertRecipient(recipient));
            }
        }
        if (emailNotificationMessage.getBcc() != null) {
            for (EmailNotificationMessage.Recipient recipient : emailNotificationMessage.getBcc()) {
                if (TextUtil.isNullOrEmpty((String)recipient.getAddress())) continue;
                email.addRecipient(Message.RecipientType.BCC, (Address)this.convertRecipient(recipient));
            }
        }
        if (emailNotificationMessage.getText() != null) {
            email.setText(emailNotificationMessage.getText());
        } else if (emailNotificationMessage.getHtml() != null) {
            email.setContent((Object)emailNotificationMessage.getHtml(), "text/html");
        }
    }

    protected InternetAddress convertRecipient(EmailNotificationMessage.Recipient recipient) {
        try {
            return recipient == null ? null : new InternetAddress(recipient.getAddress(), recipient.getName());
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.WARNING, "Failed to process email recipient: " + recipient.getAddress(), e);
            return null;
        }
    }
}

