/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.mqtt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.openremote.model.util.TextUtil;

public class Topic {
    public static final String SEPARATOR = "/";
    public static final String SINGLE_LEVEL_TOKEN = "+";
    public static final String MULTI_LEVEL_TOKEN = "#";
    public static final Topic EMPTY_TOPIC = new Topic("/", Collections.emptyList());
    protected String topic;
    protected List<String> tokens;

    public static Topic fromAddress(String address, WildcardConfiguration wildcardConfiguration) throws IllegalArgumentException {
        return Topic.parse(MQTTUtil.getMqttTopicFromCoreAddress((String)address, (WildcardConfiguration)wildcardConfiguration));
    }

    public static Topic parse(String topic) throws IllegalArgumentException {
        if (TextUtil.isNullOrEmpty((String)topic) || SEPARATOR.equals(topic)) {
            return EMPTY_TOPIC;
        }
        int multiLevelPos = topic.indexOf(MULTI_LEVEL_TOKEN);
        if (multiLevelPos >= 0 && multiLevelPos < topic.length() - 1) {
            throw new IllegalArgumentException("Multilevel wildcard token must be at the end of the topic");
        }
        List<String> tokens = Arrays.asList(topic.split(SEPARATOR));
        return new Topic(topic, tokens);
    }

    protected Topic(String topic, List<String> tokens) {
        this.topic = topic;
        this.tokens = tokens;
    }

    public String getString() {
        return this.topic;
    }

    public boolean hasWildcard() {
        return this.topic.contains(SINGLE_LEVEL_TOKEN) || this.topic.contains(MULTI_LEVEL_TOKEN);
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public String toString() {
        return this.topic;
    }
}

