/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.mqtt;

import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.openremote.container.security.keycloak.KeycloakIdentityProvider;
import org.openremote.manager.mqtt.MQTTBrokerService;
import org.openremote.manager.mqtt.MQTTHandler;
import org.openremote.manager.mqtt.Topic;
import org.openremote.manager.security.AuthorisationService;
import org.openremote.manager.security.MultiTenantJaasCallbackHandler;
import org.openremote.manager.security.RemotingConnectionPrincipal;
import org.openremote.model.syslog.SyslogCategory;

public class ActiveMQORSecurityManager
extends ActiveMQJAASSecurityManager {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.API, ActiveMQORSecurityManager.class);
    protected AuthorisationService authorisationService;
    protected MQTTBrokerService brokerService;
    protected Function<String, KeycloakDeployment> deploymentResolver;
    protected String certificateConfigName;
    protected String configName;
    protected SecurityConfiguration config;
    protected SecurityConfiguration certificateConfig;
    protected ActiveMQServer server;

    public ActiveMQORSecurityManager(AuthorisationService authorisationService, MQTTBrokerService brokerService, Function<String, KeycloakDeployment> deploymentResolver, String configurationName, SecurityConfiguration configuration) {
        super(configurationName, configuration);
        this.authorisationService = authorisationService;
        this.brokerService = brokerService;
        this.deploymentResolver = deploymentResolver;
        this.configName = configurationName;
        this.config = configuration;
    }

    public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) {
        try {
            return remotingConnection.getSubject() != null ? remotingConnection.getSubject() : this.getAuthenticatedSubject(user, password, remotingConnection, securityDomain);
        }
        catch (LoginException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject getAuthenticatedSubject(String user, String password, RemotingConnection remotingConnection, String securityDomain) throws LoginException {
        String[] realmAndUsername;
        String realm = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader thisLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (user != null && (realmAndUsername = user.split(":")).length == 2) {
            realm = realmAndUsername[0];
            user = realmAndUsername[1];
        }
        try {
            if (thisLoader != currentLoader) {
                Thread.currentThread().setContextClassLoader(thisLoader);
            }
            LoginContext lc = securityDomain != null ? new LoginContext(securityDomain, null, new MultiTenantJaasCallbackHandler(this.deploymentResolver, realm, user, password, remotingConnection), null) : (this.certificateConfigName != null && this.certificateConfigName.length() > 0 && CertificateUtil.getCertsFromConnection((RemotingConnection)remotingConnection) != null ? new LoginContext(this.certificateConfigName, null, new MultiTenantJaasCallbackHandler(this.deploymentResolver, realm, user, password, remotingConnection), (Configuration)this.certificateConfig) : new LoginContext(this.configName, null, new MultiTenantJaasCallbackHandler(this.deploymentResolver, realm, user, password, remotingConnection), (Configuration)this.config));
            lc.login();
            Subject subject = lc.getSubject();
            if (subject != null) {
                remotingConnection.setSubject(subject);
                subject.getPrincipals().add(new RemotingConnectionPrincipal(remotingConnection));
            }
            Subject subject2 = subject;
            return subject2;
        }
        finally {
            if (thisLoader != currentLoader) {
                Thread.currentThread().setContextClassLoader(currentLoader);
            }
        }
    }

    public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
        return switch (checkType) {
            default -> throw new MatchException(null, null);
            case CheckType.SEND -> this.verifyRights(subject, address, true);
            case CheckType.CONSUME -> {
                int index = address.indexOf("::");
                address = address.substring(0, index);
                yield this.verifyRights(subject, address, false);
            }
            case CheckType.CREATE_ADDRESS, CheckType.DELETE_ADDRESS, CheckType.CREATE_DURABLE_QUEUE, CheckType.DELETE_DURABLE_QUEUE, CheckType.CREATE_NON_DURABLE_QUEUE, CheckType.DELETE_NON_DURABLE_QUEUE -> true;
            case CheckType.MANAGE, CheckType.BROWSE, CheckType.VIEW, CheckType.EDIT -> false;
        };
    }

    protected boolean verifyRights(Subject subject, String address, boolean isWrite) {
        Topic topic;
        try {
            topic = Topic.fromAddress(address, this.brokerService.getWildcardConfiguration());
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.FINE, "Invalid topic provided by client '" + address, e);
            return false;
        }
        KeycloakSecurityContext securityContext = KeycloakIdentityProvider.getSecurityContext((Subject)subject);
        String topicClientID = MQTTHandler.topicClientID(topic);
        if (topicClientID == null) {
            LOG.fine("Client ID not found but it must be included as the second token in the topic: topic=" + String.valueOf(topic));
            return false;
        }
        RemotingConnection connection = RemotingConnectionPrincipal.getRemotingConnectionFromSubject(subject);
        if (connection == null) {
            LOG.info("Failed to find connection for the specified client ID: clientID=" + topicClientID);
            return false;
        }
        if (isWrite && topic.hasWildcard()) {
            return false;
        }
        for (MQTTHandler handler : this.brokerService.getCustomHandlers()) {
            if (!handler.handlesTopic(topic)) continue;
            LOG.finest("Passing topic to handler for " + (isWrite ? "pub" : "sub") + ": handler=" + handler.getName() + ", topic=" + String.valueOf(topic) + ", " + MQTTBrokerService.connectionToString(connection));
            boolean result = isWrite ? handler.checkCanPublish(connection, securityContext, topic) : handler.checkCanSubscribe(connection, securityContext, topic);
            if (result) {
                LOG.finest("Handler '" + handler.getName() + "' has authorised " + (isWrite ? "pub" : "sub") + ": topic=" + String.valueOf(topic) + ", " + MQTTBrokerService.connectionToString(connection));
            } else {
                LOG.finest("Handler '" + handler.getName() + "' has not authorised " + (isWrite ? "pub" : "sub") + ": topic=" + String.valueOf(topic) + ", " + MQTTBrokerService.connectionToString(connection));
            }
            return result;
        }
        LOG.info("Un-supported request " + (isWrite ? "pub" : "sub") + ": topic=" + String.valueOf(topic) + ", " + MQTTBrokerService.connectionToString(connection));
        return false;
    }
}

